/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorAreaTrimToolBar;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.ViewStackTrimToolBar;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.PresentationFactoryUtil;
import org.eclipse.ui.internal.presentations.PresentationSerializer;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class PartStack
extends LayoutPart
implements ILayoutContainer {
    public static final int PROP_SELECTION = 66;
    private List children = new ArrayList(3);
    private boolean isActive = true;
    private ArrayList presentableParts = new ArrayList();
    private Map properties = new HashMap();
    protected int appearance = 2;
    private LayoutPart requestedCurrent;
    private LayoutPart current;
    private PresentablePart presentationCurrent;
    private boolean ignoreSelectionChanges = false;
    protected IMemento savedPresentationState = null;
    protected DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        @Override
        public void close(IPresentablePart iPresentablePart) {
            PartStack.this.close(iPresentablePart);
        }

        @Override
        public void close(IPresentablePart[] iPresentablePartArray) {
            PartStack.this.close(iPresentablePartArray);
        }

        @Override
        public void dragStart(IPresentablePart iPresentablePart, Point point, boolean bl) {
            PartStack.this.dragStart(iPresentablePart, point, bl);
        }

        @Override
        public void dragStart(Point point, boolean bl) {
            PartStack.this.dragStart(null, point, bl);
        }

        @Override
        public boolean isPartMoveable(IPresentablePart iPresentablePart) {
            return PartStack.this.isMoveable(iPresentablePart);
        }

        @Override
        public void selectPart(IPresentablePart iPresentablePart) {
            PartStack.this.presentationSelectionChanged(iPresentablePart);
        }

        @Override
        public boolean supportsState(int n) {
            return PartStack.this.supportsState(n);
        }

        @Override
        public void setState(int n) {
            PartStack.this.setState(n);
        }

        @Override
        public IPresentablePart getSelectedPart() {
            return PartStack.this.getSelectedPart();
        }

        @Override
        public void addSystemActions(IMenuManager iMenuManager) {
            PartStack.this.addSystemActions(iMenuManager);
        }

        @Override
        public boolean isStackMoveable() {
            return PartStack.this.canMoveFolder();
        }

        @Override
        public void flushLayout() {
            PartStack.this.flushLayout();
        }

        @Override
        public IPresentablePart[] getPartList() {
            List list = PartStack.this.getPresentableParts();
            return list.toArray(new IPresentablePart[list.size()]);
        }

        @Override
        public String getProperty(String string) {
            return PartStack.this.getProperty(string);
        }
    };
    private static final PartStackDropResult dropResult = new PartStackDropResult();
    protected boolean isMinimized;
    private ListenerList listeners = new ListenerList();
    private AbstractPresentationFactory factory;
    private boolean smartZoomed = false;
    private boolean doingUnzoom = false;

    protected abstract boolean isMoveable(IPresentablePart var1);

    protected abstract void addSystemActions(IMenuManager var1);

    protected abstract boolean supportsState(int var1);

    protected abstract boolean canMoveFolder();

    protected abstract void derefPart(LayoutPart var1);

    protected abstract boolean allowsDrop(PartPane var1);

    protected static void appendToGroupIfPossible(IMenuManager iMenuManager, String string, ContributionItem contributionItem) {
        try {
            iMenuManager.appendToGroup(string, (IContributionItem)contributionItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iMenuManager.add((IContributionItem)contributionItem);
        }
    }

    public PartStack(int n) {
        this(n, null);
    }

    public PartStack(int n, AbstractPresentationFactory abstractPresentationFactory) {
        super("PartStack");
        this.appearance = n;
        this.factory = abstractPresentationFactory;
    }

    public void addListener(IPropertyListener iPropertyListener) {
        this.listeners.add((Object)iPropertyListener);
    }

    public void removeListener(IPropertyListener iPropertyListener) {
        this.listeners.remove((Object)iPropertyListener);
    }

    protected final boolean isStandalone() {
        return this.appearance == 3 || this.appearance == 4;
    }

    protected IPresentablePart getSelectedPart() {
        return this.presentationCurrent;
    }

    protected IStackPresentationSite getPresentationSite() {
        return this.presentationSite;
    }

    @Override
    public void testInvariants() {
        Control control = Display.getCurrent().getFocusControl();
        boolean bl = false;
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            Assert.isNotNull((Object)layoutPart, (String)"null children are not allowed in PartStack");
            Assert.isTrue((layoutPart instanceof PartPlaceholder || layoutPart instanceof PartPane ? 1 : 0) != 0, (String)"PartStack can only contain PartPlaceholders or PartPanes");
            PresentablePart presentablePart = this.getPresentablePart(layoutPart);
            if (layoutPart instanceof PartPane) {
                Assert.isNotNull((Object)presentablePart, (String)"All PartPanes must have a non-null IPresentablePart");
            }
            ILayoutContainer iLayoutContainer = layoutPart.getContainer();
            if (!(layoutPart instanceof PartPlaceholder)) {
                if (this.isDisposed()) {
                    if (iLayoutContainer != null) {
                        Assert.isTrue((iLayoutContainer == this ? 1 : 0) != 0, (String)"PartStack has a child that thinks it has a different parent");
                    }
                } else {
                    Assert.isTrue((iLayoutContainer == this ? 1 : 0) != 0, (String)"PartStack has a child that thinks it has a different parent");
                    if (SwtUtil.isChild(layoutPart.getControl(), control)) {
                        Assert.isTrue((layoutPart == this.current ? 1 : 0) != 0, (String)"The part with focus is not the selected part");
                    }
                }
            }
            if (layoutPart == this.current) {
                bl = true;
            }
            layoutPart.testInvariants();
            ++n;
        }
        if (!this.isDisposed() && this.getPresentableParts().size() > 0) {
            StackPresentation stackPresentation;
            Assert.isTrue((boolean)bl);
            if (!this.isDisposed() && SwtUtil.isChild((stackPresentation = this.getPresentation()).getControl(), control)) {
                Assert.isTrue((this.getActive() == 1 ? 1 : 0) != 0, (String)"The presentation has focus but does not have the active appearance");
            }
        }
        Assert.isTrue((this.getState() == 1 == (this.getContainer() != null && this.getContainer().childIsZoomed(this)) ? 1 : 0) != 0);
    }

    @Override
    public void describeLayout(StringBuffer stringBuffer) {
        int n = this.getActive();
        if (n == 1) {
            stringBuffer.append("active ");
        } else if (n == 2) {
            stringBuffer.append("active_nofocus ");
        }
        stringBuffer.append("(");
        LayoutPart[] layoutPartArray = this.getChildren();
        int n2 = 0;
        while (n2 < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n2];
            if (!(layoutPart instanceof PartPlaceholder)) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                if (layoutPart == this.requestedCurrent) {
                    stringBuffer.append("*");
                }
                layoutPart.describeLayout(stringBuffer);
            }
            ++n2;
        }
        stringBuffer.append(")");
    }

    @Override
    public void add(LayoutPart layoutPart) {
        this.add(layoutPart, null);
    }

    protected void add(LayoutPart layoutPart, Object object) {
        this.children.add(layoutPart);
        if (!(layoutPart.getContainer() instanceof ContainerPlaceholder)) {
            layoutPart.setContainer(this);
        }
        this.showPart(layoutPart, object);
    }

    @Override
    public boolean allowsAdd(LayoutPart layoutPart) {
        return !this.isStandalone();
    }

    @Override
    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        return super.allowsAutoFocus();
    }

    protected void close(IPresentablePart[] iPresentablePartArray) {
        int n = 0;
        while (n < iPresentablePartArray.length) {
            IPresentablePart iPresentablePart = iPresentablePartArray[n];
            this.close(iPresentablePart);
            ++n;
        }
    }

    protected void close(IPresentablePart iPresentablePart) {
        if (!this.presentationSite.isCloseable(iPresentablePart)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(iPresentablePart);
        if (layoutPart != null && layoutPart instanceof PartPane) {
            PartPane partPane = (PartPane)layoutPart;
            partPane.doHide();
        }
    }

    public boolean isDisposed() {
        return this.getPresentation() == null;
    }

    protected AbstractPresentationFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return ((WorkbenchWindow)this.getPage().getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
    }

    @Override
    public void createControl(Composite composite) {
        if (!this.isDisposed()) {
            return;
        }
        AbstractPresentationFactory abstractPresentationFactory = this.getFactory();
        PresentationSerializer presentationSerializer = new PresentationSerializer(this.getPresentableParts());
        StackPresentation stackPresentation = PresentationFactoryUtil.createPresentation(abstractPresentationFactory, this.appearance, composite, this.presentationSite, presentationSerializer, this.savedPresentationState);
        this.createControl(composite, stackPresentation);
        this.getControl().moveBelow(null);
    }

    @Override
    public IDropTarget getDropTarget(Object object, Point point) {
        boolean bl;
        if (!(object instanceof PartPane)) {
            return null;
        }
        PartPane partPane = (PartPane)object;
        if (this.isStandalone() || !this.allowsDrop(partPane)) {
            return null;
        }
        boolean bl2 = partPane.getWorkbenchWindow() != this.getWorkbenchWindow();
        boolean bl3 = bl = partPane instanceof EditorPane && partPane.getWorkbenchWindow().getWorkbench() == this.getWorkbenchWindow().getWorkbench();
        if (bl2 && !bl) {
            return null;
        }
        StackDropResult stackDropResult = this.getPresentation().dragOver(this.getControl(), point);
        if (stackDropResult == null) {
            return null;
        }
        return this.createDropTarget(partPane, stackDropResult);
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        for (Object object : this.children) {
            ((LayoutPart)object).setContainer(bl ? this : null);
        }
        for (PresentablePart presentablePart : this.presentableParts) {
            presentablePart.enableInputs(bl);
            presentablePart.enableOutputs(bl);
        }
    }

    public void createControl(Composite composite, StackPresentation stackPresentation) {
        Assert.isTrue((boolean)this.isDisposed());
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        this.presentationSite.setPresentation(stackPresentation);
        LayoutPart[] layoutPartArray = this.children.toArray(new LayoutPart[this.children.size()]);
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            this.showPart(layoutPart, null);
            ++n;
        }
        if (this.savedPresentationState != null) {
            PresentationSerializer presentationSerializer = new PresentationSerializer(this.getPresentableParts());
            stackPresentation.restoreState(presentationSerializer, this.savedPresentationState);
        }
        Control control = this.getPresentation().getControl();
        control.setData((Object)this);
        if (this.requestedCurrent instanceof PartPlaceholder) {
            this.requestedCurrent = null;
            this.updateContainerVisibleTab();
        }
        this.refreshPresentationSelection();
    }

    public IDropTarget createDropTarget(PartPane partPane, StackDropResult stackDropResult) {
        dropResult.setTarget(this, partPane, stackDropResult);
        return dropResult;
    }

    protected void savePresentationState() {
        if (this.isDisposed()) {
            return;
        }
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("presentation");
        xMLMemento.putString("id", this.getFactory().getId());
        PresentationSerializer presentationSerializer = new PresentationSerializer(this.getPresentableParts());
        this.getPresentation().saveState(presentationSerializer, xMLMemento);
        this.savedPresentationState = xMLMemento;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.savePresentationState();
        this.presentationSite.dispose();
        for (PresentablePart presentablePart : this.presentableParts) {
            presentablePart.dispose();
        }
        this.presentableParts.clear();
        this.presentationCurrent = null;
        this.current = null;
        this.fireInternalPropertyChange(66);
    }

    @Override
    public void findSashes(LayoutPart layoutPart, PartPane.Sashes sashes) {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.findSashes(this, sashes);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    @Override
    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    @Override
    public Control getControl() {
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation == null) {
            return null;
        }
        return stackPresentation.getControl();
    }

    public int getItemCount() {
        if (this.isDisposed()) {
            return this.children.size();
        }
        return this.getPresentableParts().size();
    }

    protected LayoutPart getPaneFor(IPresentablePart iPresentablePart) {
        if (iPresentablePart == null || !(iPresentablePart instanceof PresentablePart)) {
            return null;
        }
        return ((PresentablePart)iPresentablePart).getPane();
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    public List getPresentableParts() {
        return this.presentableParts;
    }

    private PresentablePart getPresentablePart(LayoutPart layoutPart) {
        for (PresentablePart presentablePart : this.presentableParts) {
            if (presentablePart.getPane() != layoutPart) continue;
            return presentablePart;
        }
        return null;
    }

    protected StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public PartPane getSelection() {
        if (this.current instanceof PartPane) {
            return (PartPane)this.current;
        }
        return null;
    }

    private void presentationSelectionChanged(IPresentablePart iPresentablePart) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(iPresentablePart);
        Assert.isNotNull((Object)layoutPart);
        if (layoutPart != this.requestedCurrent) {
            this.setSelection(layoutPart);
        }
    }

    @Override
    public void remove(LayoutPart layoutPart) {
        PresentablePart presentablePart = this.getPresentablePart(layoutPart);
        this.children.remove(layoutPart);
        StackPresentation stackPresentation = this.getPresentation();
        if (presentablePart != null && stackPresentation != null) {
            this.ignoreSelectionChanges = true;
            this.presentableParts.remove(presentablePart);
            stackPresentation.removePart(presentablePart);
            presentablePart.dispose();
            this.ignoreSelectionChanges = false;
        }
        if (!this.isDisposed()) {
            layoutPart.setContainer(null);
        }
        if (layoutPart == this.requestedCurrent) {
            this.updateContainerVisibleTab();
        }
    }

    @Override
    public void reparent(Composite composite) {
        Control control = this.getControl();
        if (control == null || control.getParent() == composite || !control.isReparentable()) {
            return;
        }
        super.reparent(composite);
        for (LayoutPart layoutPart : this.children) {
            layoutPart.reparent(composite);
        }
    }

    @Override
    public void replace(LayoutPart layoutPart, LayoutPart layoutPart2) {
        int n = this.children.indexOf(layoutPart);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.children.get(n3) instanceof PartPlaceholder) {
                ++n2;
            }
            ++n3;
        }
        Integer n4 = new Integer(n - n2);
        this.children.add(n, layoutPart2);
        this.showPart(layoutPart2, n4);
        if (layoutPart == this.requestedCurrent && !(layoutPart2 instanceof PartPlaceholder)) {
            this.setSelection(layoutPart2);
        }
        this.remove(layoutPart);
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return this.getPresentation().computePreferredSize(bl, n, n2, n3);
    }

    @Override
    public int getSizeFlags(boolean bl) {
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            return stackPresentation.getSizeFlags(bl);
        }
        return 0;
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento[] iMementoArray;
        Object object;
        Object object2;
        String string = iMemento.getString("activePageID");
        IMemento[] iMementoArray2 = iMemento.getChildren("page");
        if (iMementoArray2 != null) {
            int n = 0;
            while (n < iMementoArray2.length) {
                IMemento iMemento2 = iMementoArray2[n];
                object2 = iMemento2.getString("content");
                object = new PartPlaceholder((String)object2);
                ((LayoutPart)object).setContainer(this);
                this.add((LayoutPart)object);
                if (((String)object2).equals(string)) {
                    this.setSelection((LayoutPart)object);
                }
                ++n;
            }
        }
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("ENABLE_MIN_MAX");
        object2 = iMemento.getInteger("expanded");
        if (bl && object2 != null) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((Integer)object2){
                private final /* synthetic */ Integer val$expanded;
                {
                    this.val$expanded = n;
                }

                @Override
                public void runWithException() throws Throwable {
                    PartStack.this.setState(this.val$expanded == null || this.val$expanded != 0 ? 2 : 0);
                }
            });
        } else {
            this.setState(object2 == null || (Integer)object2 != 0 ? 2 : 0);
        }
        object = iMemento.getInteger("appearance");
        if (object != null) {
            this.appearance = (Integer)object;
        }
        this.savedPresentationState = null;
        IMemento[] iMementoArray3 = iMemento.getChildren("presentation");
        int n = 0;
        while (n < iMementoArray3.length) {
            iMementoArray = iMementoArray3[n];
            String string2 = iMementoArray.getString("id");
            if (Util.equals(string2, this.getFactory().getId())) {
                this.savedPresentationState = iMementoArray;
                break;
            }
            ++n;
        }
        IMemento iMemento3 = iMemento.getChild("properties");
        if (iMemento3 != null) {
            iMementoArray = iMemento3.getChildren("property");
            int n2 = 0;
            while (n2 < iMementoArray.length) {
                this.properties.put(iMementoArray[n2].getID(), iMementoArray[n2].getTextData());
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2;
        Control control = this.getControl();
        boolean bl3 = bl2 = bl || !this.isActive;
        if (!SwtUtil.isDisposed(control) && bl2 && bl == control.getVisible()) {
            return;
        }
        if (bl) {
            for (Object object : this.presentableParts) {
                ((PresentablePart)object).enableInputs(this.isActive);
                ((PresentablePart)object).enableOutputs(this.isActive);
            }
        }
        super.setVisible(bl);
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            stackPresentation.setVisible(bl);
        }
        if (!bl) {
            for (PresentablePart presentablePart : this.presentableParts) {
                presentablePart.enableInputs(false);
            }
        }
    }

    public IStatus saveState(IMemento iMemento) {
        Object object;
        Object object2;
        PartPane partPane;
        Object object32;
        if (this.requestedCurrent != null) {
            iMemento.putString("activePageID", this.requestedCurrent.getCompoundId());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object4 : this.getPresentableParts()) {
            object32 = iMemento.createChild("page");
            partPane = ((PresentablePart)object4).getPane();
            object2 = partPane.getPartReference().getPartName();
            object32.putString("label", (String)object2);
            object32.putString("content", ((PresentablePart)object4).getPane().getPlaceHolderId());
            hashSet.add(((PresentablePart)object4).getPane().getPlaceHolderId());
        }
        for (Object object32 : this.children) {
            partPane = null;
            if (object32 instanceof PartPane) {
                if (hashSet.contains(((PartPane)object32).getPlaceHolderId())) continue;
                partPane = (PartPane)object32;
            }
            object2 = iMemento.createChild("page");
            object = "LabelNotFound";
            if (partPane != null) {
                object = partPane.getPartReference().getPartName();
            }
            object2.putString("label", (String)object);
            object2.putString("content", ((LayoutPart)object32).getCompoundId());
        }
        object32 = PrefUtil.getAPIPreferenceStore();
        boolean bl = object32.getBoolean("ENABLE_MIN_MAX");
        if (bl) {
            iMemento.putInteger("expanded", this.presentationSite.getState());
        } else {
            iMemento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        }
        iMemento.putInteger("appearance", this.appearance);
        this.savePresentationState();
        if (this.savedPresentationState != null) {
            object2 = iMemento.createChild("presentation");
            object2.putMemento(this.savedPresentationState);
        }
        if (!this.properties.isEmpty()) {
            object2 = iMemento.createChild("properties");
            object = this.properties.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.properties.get(string) == null) continue;
                IMemento iMemento2 = object2.createChild("property", string);
                iMemento2.putTextData((String)this.properties.get(string));
            }
        }
        return Status.OK_STATUS;
    }

    protected WorkbenchPage getPage() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        return (WorkbenchPage)workbenchWindow.getActivePage();
    }

    public void setActive(int n) {
        if (n == 1 && this.isMinimized) {
            this.setMinimized(false);
        }
        this.presentationSite.setActive(n);
    }

    public int getActive() {
        return this.presentationSite.getActive();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(rectangle);
        }
    }

    public void setSelection(LayoutPart layoutPart) {
        if (layoutPart == this.requestedCurrent) {
            return;
        }
        this.requestedCurrent = layoutPart;
        this.refreshPresentationSelection();
    }

    protected abstract void updateActions(PresentablePart var1);

    @Override
    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        this.refreshPresentationSelection();
    }

    private void refreshPresentationSelection() {
        if (this.isDeferred()) {
            return;
        }
        if (this.current == this.requestedCurrent) {
            return;
        }
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            this.presentationCurrent = this.getPresentablePart(this.requestedCurrent);
            if (!this.isDisposed()) {
                this.updateActions(this.presentationCurrent);
            }
            if (this.presentationCurrent != null && stackPresentation != null) {
                this.requestedCurrent.createControl(this.getParent());
                if (this.requestedCurrent.getControl().getParent() != this.getControl().getParent()) {
                    this.requestedCurrent.reparent(this.getControl().getParent());
                }
                stackPresentation.selectPart(this.presentationCurrent);
            }
            this.current = this.requestedCurrent;
            this.fireInternalPropertyChange(66);
        }
    }

    public int getState() {
        return this.presentationSite.getState();
    }

    public void setMinimized(boolean bl) {
        if (bl != this.isMinimized) {
            this.isMinimized = bl;
            this.refreshPresentationState();
        }
    }

    @Override
    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        return this.isObscuredByZoom();
    }

    @Override
    public void childRequestZoomIn(LayoutPart layoutPart) {
        super.childRequestZoomIn(layoutPart);
        this.requestZoomIn();
    }

    @Override
    public void childRequestZoomOut() {
        super.childRequestZoomOut();
        this.requestZoomOut();
    }

    @Override
    public boolean childIsZoomed(LayoutPart layoutPart) {
        return this.isZoomed();
    }

    private boolean isIntroInStack() {
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            ViewPane viewPane;
            if (layoutPartArray[n] instanceof ViewPane && (viewPane = (ViewPane)layoutPartArray[n]).getID().equals("org.eclipse.ui.internal.introview")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void smartZoom() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        if (workbenchWindow == null || workbenchWindow.getShell() == null) {
            return;
        }
        Perspective perspective = this.getPage().getActivePerspective();
        FastViewManager fastViewManager = perspective.getFastViewManager();
        fastViewManager.deferUpdates(true);
        perspective.getPresentation().updateBoundsMap();
        LayoutPart[] layoutPartArray = perspective.getPresentation().getLayout().getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            if (layoutPartArray[n] != this) {
                if (layoutPartArray[n] instanceof ViewStack) {
                    ((ViewStack)layoutPartArray[n]).setMinimized(true);
                    ViewStackTrimToolBar viewStackTrimToolBar = fastViewManager.getViewStackTrimToolbar(layoutPartArray[n].getID());
                    viewStackTrimToolBar.setRestoreOnUnzoom(true);
                } else if (layoutPartArray[n] instanceof EditorSashContainer && !(this instanceof EditorStack)) {
                    perspective.setEditorAreaState(0);
                    perspective.setEditorAreaRestoreOnUnzoom(true);
                }
            }
            ++n;
        }
        if (this instanceof EditorStack) {
            perspective.setEditorAreaState(1);
        }
        perspective.getPresentation().resetBoundsMap();
        fastViewManager.deferUpdates(false);
        perspective.getPresentation().setMaximizedStack(this);
        this.smartZoomed = true;
    }

    protected void smartUnzoom() {
        if (this.doingUnzoom) {
            return;
        }
        this.doingUnzoom = true;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        if (workbenchWindow == null || workbenchWindow.getShell() == null) {
            return;
        }
        ITrimManager iTrimManager = workbenchWindow.getTrimManager();
        Perspective perspective = this.getPage().getActivePerspective();
        FastViewManager fastViewManager = perspective.getFastViewManager();
        ILayoutContainer iLayoutContainer = this.getContainer();
        boolean bl = false;
        if (iLayoutContainer instanceof EditorSashContainer) {
            iLayoutContainer = ((EditorSashContainer)iLayoutContainer).getContainer();
            bl = true;
        }
        fastViewManager.deferUpdates(true);
        LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            IWindowTrim iWindowTrim;
            if (layoutPartArray[n] != this && (iWindowTrim = iTrimManager.getTrim(layoutPartArray[n].getID())) != null) {
                if (iWindowTrim instanceof ViewStackTrimToolBar) {
                    ViewStackTrimToolBar viewStackTrimToolBar = (ViewStackTrimToolBar)iWindowTrim;
                    if (viewStackTrimToolBar.restoreOnUnzoom() && layoutPartArray[n] instanceof ContainerPlaceholder) {
                        ViewStack viewStack = (ViewStack)((ContainerPlaceholder)layoutPartArray[n]).getRealContainer();
                        viewStack.setMinimized(false);
                        viewStackTrimToolBar.setRestoreOnUnzoom(false);
                    }
                } else if (iWindowTrim instanceof EditorAreaTrimToolBar && perspective.getEditorAreaRestoreOnUnzoom()) {
                    perspective.setEditorAreaState(2);
                }
            }
            ++n;
        }
        if (bl) {
            perspective.setEditorAreaState(2);
        }
        perspective.getPresentation().setMaximizedStack(null);
        fastViewManager.deferUpdates(false);
        this.smartZoomed = false;
        this.doingUnzoom = false;
    }

    protected void setState(final int n) {
        final int n2 = this.presentationSite.getState();
        if (!this.supportsState(n) || n == n2) {
            return;
        }
        final WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        if (workbenchWindow == null || workbenchWindow.getShell() == null || workbenchWindow.getActiveWorkbenchPage() == null) {
            return;
        }
        WorkbenchPage workbenchPage = workbenchWindow.getActiveWorkbenchPage();
        if (workbenchPage == null) {
            return;
        }
        boolean bl = Perspective.useNewMinMax(workbenchPage.getActivePerspective());
        if (n == 1) {
            bl = bl && !this.isIntroInStack();
        } else if (n == 2) {
            PartStack partStack = workbenchPage.getActivePerspective().getPresentation().getMaximizedStack();
            boolean bl2 = bl = bl && (partStack == this || partStack instanceof EditorStack);
        }
        if (bl) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    workbenchWindow.getPageComposite().setRedraw(false);
                    try {
                        if (n == 1) {
                            PartStack.this.smartZoom();
                        } else if (n2 == 1) {
                            PartStack.this.smartUnzoom();
                        }
                        if (n == 0) {
                            PartStack.this.setMinimized(true);
                        }
                    }
                    finally {
                        workbenchWindow.getPageComposite().setRedraw(true);
                        workbenchWindow.getShell().redraw();
                    }
                    PartStack.this.setPresentationState(n);
                }
            });
        } else {
            boolean bl3 = n == 0;
            this.setMinimized(bl3);
            if (n == 1) {
                this.requestZoomIn();
            } else if (n2 == 1) {
                this.requestZoomOut();
                if (n == 0) {
                    this.setMinimized(true);
                }
            }
        }
    }

    @Override
    public void setZoomed(boolean bl) {
        super.setZoomed(bl);
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.setZoomed(bl);
            ++n;
        }
        this.refreshPresentationState();
    }

    public boolean isZoomed() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            return iLayoutContainer.childIsZoomed(this);
        }
        return false;
    }

    protected void refreshPresentationState() {
        if (this.isZoomed() || this.smartZoomed) {
            this.presentationSite.setPresentationState(1);
        } else {
            boolean bl;
            boolean bl2 = bl = this.presentationSite.getState() == 0;
            if (this.isMinimized) {
                this.presentationSite.setPresentationState(0);
            } else {
                this.presentationSite.setPresentationState(2);
            }
            if (this.isMinimized != bl) {
                WorkbenchPage workbenchPage;
                this.flushLayout();
                if (this.isMinimized && (workbenchPage = this.getPage()) != null) {
                    workbenchPage.refreshActiveView();
                }
            }
        }
    }

    private void showPart(LayoutPart layoutPart, Object object) {
        if (this.isDisposed()) {
            return;
        }
        if (layoutPart instanceof PartPlaceholder) {
            layoutPart.setContainer(this);
            return;
        }
        if (!(layoutPart instanceof PartPane)) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PartStack_incorrectPartInFolder, (Object)layoutPart.getID()));
            return;
        }
        PartPane partPane = (PartPane)layoutPart;
        PresentablePart presentablePart = new PresentablePart(partPane, this.getControl().getParent());
        this.presentableParts.add(presentablePart);
        if (this.isActive) {
            layoutPart.setContainer(this);
            if (layoutPart.getControl() != null) {
                layoutPart.getControl().setEnabled(true);
            }
        }
        this.presentationSite.getPresentation().addPart(presentablePart, object);
        if (this.requestedCurrent == null) {
            this.setSelection(layoutPart);
        }
        if (this.childObscuredByZoom(layoutPart)) {
            presentablePart.enableInputs(false);
        }
    }

    private void updateContainerVisibleTab() {
        Object object;
        Object object2;
        LayoutPart[] layoutPartArray = this.getChildren();
        if (layoutPartArray.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane partPane = null;
        int n = 0;
        WorkbenchPage workbenchPage = this.getPage();
        if (workbenchPage != null) {
            object2 = workbenchPage.getSortedParts();
            object = Arrays.asList(object2);
            int n2 = 0;
            while (n2 < layoutPartArray.length) {
                IWorkbenchPartReference iWorkbenchPartReference;
                int n3;
                if (layoutPartArray[n2] instanceof PartPane && (n3 = object.indexOf(iWorkbenchPartReference = ((PartPane)layoutPartArray[n2]).getPartReference())) >= n) {
                    n = n3;
                    partPane = (PartPane)layoutPartArray[n2];
                }
                ++n2;
            }
        }
        if (partPane == null && (object2 = this.getPresentableParts()).size() != 0) {
            object = (IPresentablePart)this.getPresentableParts().get(0);
            partPane = (PartPane)this.getPaneFor((IPresentablePart)object);
        }
        this.setSelection(partPane);
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    public void showPartList() {
        this.getPresentation().showPartList();
    }

    public Control[] getTabList(LayoutPart layoutPart) {
        if (layoutPart != null) {
            PresentablePart presentablePart = this.getPresentablePart(layoutPart);
            StackPresentation stackPresentation = this.getPresentation();
            if (presentablePart != null && stackPresentation != null) {
                return stackPresentation.getTabList(presentablePart);
            }
        }
        return new Control[0];
    }

    private void dragStart(IPresentablePart iPresentablePart, Point point, boolean bl) {
        LayoutPart layoutPart;
        if (iPresentablePart == null) {
            this.paneDragStart(null, point, bl);
        } else if (this.presentationSite.isPartMoveable(iPresentablePart) && (layoutPart = this.getPaneFor(iPresentablePart)) != null) {
            this.paneDragStart(layoutPart, point, bl);
        }
    }

    public void paneDragStart(LayoutPart layoutPart, Point point, boolean bl) {
        if (layoutPart == null) {
            if (this.canMoveFolder()) {
                if (this.presentationSite.getState() == 1) {
                    Rectangle rectangle = Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds());
                    float f = (float)(point.x - rectangle.x) / (float)rectangle.width;
                    float f2 = (float)(point.y - rectangle.y) / (float)rectangle.height;
                    if (this instanceof ViewStack) {
                        this.setState(2);
                    }
                    rectangle = Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds());
                    point.x = (int)((float)rectangle.x + f * (float)rectangle.width);
                    point.y = (int)((float)rectangle.y + f2 * (float)rectangle.height);
                }
                DragUtil.performDrag(this, Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), point, !bl);
            }
        } else {
            if (this.presentationSite.getState() == 1) {
                Rectangle rectangle = Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds());
                float f = (float)(point.x - rectangle.x) / (float)rectangle.width;
                float f3 = (float)(point.y - rectangle.y) / (float)rectangle.height;
                if (this instanceof ViewStack) {
                    this.setState(2);
                }
                rectangle = Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds());
                point.x = (int)((float)rectangle.x + f * (float)rectangle.width);
                point.y = (int)((float)rectangle.y + f3 * (float)rectangle.height);
            }
            DragUtil.performDrag(layoutPart, Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), point, !bl);
        }
    }

    public IMemento getSavedPresentationState() {
        return this.savedPresentationState;
    }

    private void fireInternalPropertyChange(int n) {
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPropertyListener)objectArray[n2]).propertyChanged(this, n);
            ++n2;
        }
    }

    public void setPresentationState(int n) {
        this.presentationSite.setPresentationState(n);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, string2);
        }
    }

    public void copyAppearanceProperties(PartStack partStack) {
        partStack.appearance = this.appearance;
        if (!this.properties.isEmpty()) {
            Set set = this.properties.keySet();
            for (String string : set) {
                partStack.setProperty(string, (String)this.properties.get(string));
            }
        }
    }

    private static final class PartStackDropResult
    extends AbstractDropTarget {
        private PartPane pane;
        private StackDropResult dropResult;
        private PartStack stack;

        private PartStackDropResult() {
        }

        public void setTarget(PartStack partStack, PartPane partPane, StackDropResult stackDropResult) {
            this.pane = partPane;
            this.dropResult = stackDropResult;
            this.stack = partStack;
        }

        @Override
        public void drop() {
            Object object = null;
            if (this.dropResult != null) {
                object = this.dropResult.getCookie();
            }
            if (this.pane instanceof EditorPane && this.pane.getWorkbenchWindow() != this.stack.getWorkbenchWindow()) {
                EditorPane editorPane = (EditorPane)this.pane;
                try {
                    IEditorInput iEditorInput = editorPane.getEditorReference().getEditorInput();
                    boolean bl = editorPane.getPage().closeEditor(editorPane.getEditorReference(), true);
                    if (bl) {
                        this.stack.getPage().openEditor(iEditorInput, editorPane.getEditorReference().getId());
                    }
                    return;
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
            }
            if (this.pane.getContainer() != this.stack) {
                this.stack.derefPart(this.pane);
                this.pane.reparent(this.stack.getParent());
                this.stack.add(this.pane, object);
                this.stack.setSelection(this.pane);
                this.pane.setFocus();
            } else if (object != null) {
                this.stack.getPresentation().movePart(this.stack.getPresentablePart(this.pane), object);
            }
        }

        @Override
        public Cursor getCursor() {
            return DragCursors.getCursor(5);
        }

        @Override
        public Rectangle getSnapRectangle() {
            if (this.dropResult == null) {
                return DragUtil.getDisplayBounds(this.stack.getControl());
            }
            return this.dropResult.getSnapRectangle();
        }
    }
}

