/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.WorkbenchSiteProgressService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.testing.WorkbenchPartTestable;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.testing.IWorkbenchPartTestable;

public abstract class PartSite
implements IWorkbenchPartSite {
    private IWorkbenchPartReference partReference;
    private IWorkbenchPart part;
    private IWorkbenchPage page;
    private String extensionID;
    private String pluginID;
    private String extensionName;
    private ISelectionProvider selectionProvider;
    private SubActionBars actionBars;
    private KeyBindingService keyBindingService;
    protected ArrayList menuExtenders;
    private WorkbenchSiteProgressService progressService;
    protected final ServiceLocator serviceLocator;

    public static final void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider, boolean bl, IWorkbenchPart iWorkbenchPart, Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            PopupMenuExtender popupMenuExtender = (PopupMenuExtender)iterator.next();
            if (!popupMenuExtender.matches(menuManager, iSelectionProvider, iWorkbenchPart)) continue;
            popupMenuExtender.addMenuId(string);
            bl2 = true;
            break;
        }
        if (!bl2) {
            collection.add(new PopupMenuExtender(string, menuManager, iSelectionProvider, iWorkbenchPart, bl));
        }
    }

    public PartSite(IWorkbenchPartReference iWorkbenchPartReference, IWorkbenchPart iWorkbenchPart, IWorkbenchPage iWorkbenchPage) {
        this.partReference = iWorkbenchPartReference;
        this.part = iWorkbenchPart;
        this.page = iWorkbenchPage;
        this.extensionID = "org.eclipse.ui.UnknownID";
        this.extensionName = "Unknown Name";
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchPage.getWorkbenchWindow();
        IServiceLocatorCreator iServiceLocatorCreator = (IServiceLocatorCreator)workbenchWindow.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)iServiceLocatorCreator.createServiceLocator(workbenchWindow, null, new IDisposable(){

            @Override
            public void dispose() {
                Control control = PartSite.this.getPane().getControl();
                if (control != null && !control.isDisposed()) {
                    PartSite.this.getPane().doHide();
                }
            }
        });
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.IWorkbenchPartSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this, null, null, 2));
        this.serviceLocator.registerService(IWorkbenchPartSite.class, this);
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            HashSet<MenuManager> hashSet = new HashSet<MenuManager>(this.menuExtenders.size());
            int n = 0;
            while (n < this.menuExtenders.size()) {
                PopupMenuExtender popupMenuExtender = (PopupMenuExtender)this.menuExtenders.get(n);
                hashSet.add(popupMenuExtender.getManager());
                popupMenuExtender.dispose();
                ++n;
            }
            if (hashSet.size() > 0) {
                for (MenuManager menuManager : hashSet) {
                    menuManager.dispose();
                }
            }
            this.menuExtenders = null;
        }
        if (this.keyBindingService != null) {
            this.keyBindingService.dispose();
            this.keyBindingService = null;
        }
        if (this.progressService != null) {
            this.progressService.dispose();
            this.progressService = null;
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
        this.part = null;
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    @Override
    public String getId() {
        return this.extensionID;
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.page;
    }

    public PartPane getPane() {
        return ((WorkbenchPartReference)this.partReference).getPane();
    }

    @Override
    public IWorkbenchPart getPart() {
        return this.part;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    @Override
    public String getPluginId() {
        return this.pluginID;
    }

    @Override
    public String getRegisteredName() {
        return this.extensionName;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public Shell getShell() {
        PartPane partPane = this.getPane();
        Display display = Display.getCurrent();
        if (display == null || display != this.getWorkbenchWindow().getWorkbench().getDisplay()) {
            return this.getWorkbenchWindow().getShell();
        }
        if (partPane == null) {
            return this.getWorkbenchWindow().getShell();
        }
        Shell shell = partPane.getShell();
        if (shell == null) {
            return this.getWorkbenchWindow().getShell();
        }
        return shell;
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.page.getWorkbenchWindow();
    }

    @Override
    public void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(string, menuManager, iSelectionProvider, true, this.getPart(), this.menuExtenders);
    }

    @Override
    public void registerContextMenu(MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        this.registerContextMenu(this.getId(), menuManager, iSelectionProvider);
    }

    public String[] getContextMenuIds() {
        if (this.menuExtenders == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList(this.menuExtenders.size());
        for (PopupMenuExtender popupMenuExtender : this.menuExtenders) {
            arrayList.addAll(popupMenuExtender.getMenuIds());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setActionBars(SubActionBars subActionBars) {
        this.actionBars = subActionBars;
    }

    public void setConfigurationElement(IConfigurationElement iConfigurationElement) {
        this.extensionID = iConfigurationElement.getAttribute("id");
        this.pluginID = iConfigurationElement.getNamespace();
        String string = iConfigurationElement.getAttribute("name");
        if (string != null) {
            this.extensionName = string;
        }
    }

    protected void setPluginId(String string) {
        this.pluginID = string;
    }

    protected void setId(String string) {
        this.extensionID = string;
    }

    public void setPart(IWorkbenchPart iWorkbenchPart) {
        this.part = iWorkbenchPart;
    }

    protected void setRegisteredName(String string) {
        this.extensionName = string;
    }

    @Override
    public void setSelectionProvider(ISelectionProvider iSelectionProvider) {
        this.selectionProvider = iSelectionProvider;
    }

    @Override
    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            this.keyBindingService = new KeyBindingService(this);
        }
        return this.keyBindingService;
    }

    protected String getInitialScopeId() {
        return null;
    }

    public final Object getAdapter(Class clazz) {
        if (IWorkbenchSiteProgressService.class == clazz) {
            return this.getSiteProgressService();
        }
        if (IWorkbenchPartTestable.class == clazz) {
            return new WorkbenchPartTestable(this);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public void activateActionBars(boolean bl) {
        if (this.serviceLocator != null) {
            this.serviceLocator.activate();
        }
        if (this.actionBars != null) {
            this.actionBars.activate(bl);
        }
    }

    public void deactivateActionBars(boolean bl) {
        if (this.actionBars != null) {
            this.actionBars.deactivate(bl);
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.deactivate();
        }
    }

    WorkbenchSiteProgressService getSiteProgressService() {
        if (this.progressService == null) {
            this.progressService = new WorkbenchSiteProgressService(this);
        }
        return this.progressService;
    }

    @Override
    public final Object getService(Class clazz) {
        return this.serviceLocator.getService(clazz);
    }

    @Override
    public final boolean hasService(Class clazz) {
        return this.serviceLocator.hasService(clazz);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PartSite(id=");
        stringBuffer.append(this.getId());
        stringBuffer.append(",pluginId=");
        stringBuffer.append(this.getPluginId());
        stringBuffer.append(",registeredName=");
        stringBuffer.append(this.getRegisteredName());
        stringBuffer.append(",hashCode=");
        stringBuffer.append(this.hashCode());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

