/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.misc.UIListenerLogging;

public class PartService
implements IPartService {
    private static Point ZERO = new Point(0, 0);
    private PartListenerList listeners = new PartListenerList();
    private PartListenerList2 listeners2 = new PartListenerList2();
    private IWorkbenchPartReference activePart = null;
    private String debugListenersKey;
    private String debugListeners2Key;
    private ArrayList activeControlJobs = new ArrayList();
    private PartListener partListener = new PartListener();

    public PartService(String string, String string2) {
        this.debugListeners2Key = string2;
        this.debugListenersKey = string;
    }

    @Override
    public void addPartListener(IPartListener iPartListener) {
        this.listeners.addPartListener(iPartListener);
    }

    @Override
    public void addPartListener(IPartListener2 iPartListener2) {
        this.listeners2.addPartListener(iPartListener2);
    }

    @Override
    public void removePartListener(IPartListener iPartListener) {
        this.listeners.removePartListener(iPartListener);
    }

    @Override
    public void removePartListener(IPartListener2 iPartListener2) {
        this.listeners2.removePartListener(iPartListener2);
    }

    private Control deferControl(IWorkbenchPartReference iWorkbenchPartReference) {
        Control control;
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (!(iWorkbenchPart == null || (control = ((PartSite)iWorkbenchPart.getSite()).getPane().getControl()) == null || control.isDisposed() || control.isVisible() && !control.getSize().equals((Object)ZERO))) {
            return control;
        }
        return null;
    }

    private void addControlListener(Control control, PartJob partJob) {
        control.addListener(11, (Listener)this.partListener);
        control.addListener(26, (Listener)this.partListener);
        control.addListener(12, (Listener)this.partListener);
        this.activeControlJobs.add(partJob);
    }

    void processPartJobs() {
        if (this.activeControlJobs.isEmpty()) {
            return;
        }
        ArrayList<PartJob> arrayList = new ArrayList<PartJob>();
        PartJob[] partJobArray = this.activeControlJobs.toArray(new PartJob[this.activeControlJobs.size()]);
        int n = 0;
        while (n < partJobArray.length) {
            PartJob partJob = partJobArray[n];
            Control control = partJob.control;
            if (!control.isDisposed() && !control.getSize().equals((Object)ZERO) && control.isVisible()) {
                arrayList.add(partJob);
                control.removeListener(11, (Listener)this.partListener);
                control.removeListener(26, (Listener)this.partListener);
                control.removeListener(12, (Listener)this.partListener);
                partJob.fire();
            } else if (control.isDisposed()) {
                arrayList.add(partJob);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.activeControlJobs.removeAll(arrayList);
    }

    private void firePartActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            Control control = this.deferControl(iWorkbenchPartReference);
            if (control != null) {
                this.addControlListener(control, new PartActivated(iWorkbenchPartReference, control));
                return;
            }
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, iWorkbenchPart, "partActivated");
            this.listeners.firePartActivated(iWorkbenchPart);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partActivated");
        this.listeners2.firePartActivated(iWorkbenchPartReference);
    }

    public void firePartBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            Control control = this.deferControl(iWorkbenchPartReference);
            if (control != null) {
                this.addControlListener(control, new PartTop(iWorkbenchPartReference, control));
                return;
            }
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, iWorkbenchPart, "partBroughtToTop");
            this.listeners.firePartBroughtToTop(iWorkbenchPart);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partBroughtToTop");
        this.listeners2.firePartBroughtToTop(iWorkbenchPartReference);
    }

    public void firePartClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, iWorkbenchPart, "partClosed");
            this.listeners.firePartClosed(iWorkbenchPart);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partClosed");
        this.listeners2.firePartClosed(iWorkbenchPartReference);
    }

    private void firePartDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, iWorkbenchPart, "partDeactivated");
            this.listeners.firePartDeactivated(iWorkbenchPart);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partDectivated");
        this.listeners2.firePartDeactivated(iWorkbenchPartReference);
    }

    public void firePartVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        Control control = this.deferControl(iWorkbenchPartReference);
        if (control != null) {
            this.addControlListener(control, new PartVisible(iWorkbenchPartReference, control));
            return;
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partVisible");
        this.listeners2.firePartVisible(iWorkbenchPartReference);
    }

    public void firePartHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partHidden");
        this.listeners2.firePartHidden(iWorkbenchPartReference);
    }

    public void firePartInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partInputChanged");
        this.listeners2.firePartInputChanged(iWorkbenchPartReference);
    }

    public void firePartOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart != null) {
            UIListenerLogging.logPartListenerEvent(this.debugListenersKey, this, iWorkbenchPart, "partOpened");
            this.listeners.firePartOpened(iWorkbenchPart);
        }
        UIListenerLogging.logPartListener2Event(this.debugListeners2Key, this, iWorkbenchPartReference, "partOpened");
        this.listeners2.firePartOpened(iWorkbenchPartReference);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.activePart == null ? null : this.activePart.getPart(false);
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.activePart;
    }

    public void setActivePart(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPartReference iWorkbenchPartReference2 = this.activePart;
        if (iWorkbenchPartReference2 == iWorkbenchPartReference) {
            return;
        }
        if (iWorkbenchPartReference2 != null) {
            this.firePartDeactivated(iWorkbenchPartReference2);
        }
        this.activePart = iWorkbenchPartReference;
        if (iWorkbenchPartReference != null) {
            this.firePartActivated(iWorkbenchPartReference);
        }
    }

    public void firePageChanged(PageChangedEvent pageChangedEvent) {
        this.listeners2.firePageChanged(pageChangedEvent);
    }

    private class PartActivated
    extends PartJob {
        public PartActivated(IWorkbenchPartReference iWorkbenchPartReference, Control control) {
            super(iWorkbenchPartReference, control);
        }

        @Override
        void fire() {
            PartService.this.firePartActivated(this.ref);
        }
    }

    private abstract class PartJob {
        IWorkbenchPartReference ref;
        Control control;

        public PartJob(IWorkbenchPartReference iWorkbenchPartReference, Control control) {
            this.ref = iWorkbenchPartReference;
            this.control = control;
        }

        abstract void fire();
    }

    private class PartListener
    implements Listener {
        private PartListener() {
        }

        public void handleEvent(Event event) {
            PartService.this.processPartJobs();
        }
    }

    private class PartTop
    extends PartJob {
        public PartTop(IWorkbenchPartReference iWorkbenchPartReference, Control control) {
            super(iWorkbenchPartReference, control);
        }

        @Override
        void fire() {
            PartService.this.firePartBroughtToTop(this.ref);
        }
    }

    private class PartVisible
    extends PartJob {
        public PartVisible(IWorkbenchPartReference iWorkbenchPartReference, Control control) {
            super(iWorkbenchPartReference, control);
        }

        @Override
        void fire() {
            PartService.this.firePartVisible(this.ref);
        }
    }
}

