/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;

public abstract class PartSashContainer
extends LayoutPart
implements ILayoutContainer,
IDragOverListener {
    protected Composite parent;
    protected ControlListener resizeListener;
    protected LayoutTree root;
    private Composite parentWidget;
    private LayoutPart zoomedPart;
    protected WorkbenchPage page;
    boolean active = false;
    boolean layoutDirty = false;
    protected ArrayList children = new ArrayList();
    private SashContainerDropTarget dropTarget;

    public PartSashContainer(String string, WorkbenchPage workbenchPage, Composite composite) {
        super(string);
        this.page = workbenchPage;
        this.parentWidget = composite;
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                PartSashContainer.this.resizeSashes();
            }
        };
    }

    @Override
    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        LayoutPart layoutPart2 = this.getZoomedPart();
        if (layoutPart2 != null && layoutPart != layoutPart2) {
            return true;
        }
        return this.isObscuredByZoom();
    }

    private PartPane[] getVisibleParts(LayoutPart layoutPart) {
        if (layoutPart instanceof PartPane) {
            return new PartPane[]{(PartPane)layoutPart};
        }
        if (layoutPart instanceof PartStack) {
            PartStack partStack = (PartStack)layoutPart;
            LayoutPart[] layoutPartArray = partStack.getChildren();
            ArrayList<LayoutPart> arrayList = new ArrayList<LayoutPart>(layoutPartArray.length);
            int n = 0;
            while (n < layoutPartArray.length) {
                LayoutPart layoutPart2 = layoutPartArray[n];
                if (layoutPart2 instanceof PartPane) {
                    arrayList.add(layoutPart2);
                }
                ++n;
            }
            return arrayList.toArray(new PartPane[arrayList.size()]);
        }
        return new PartPane[0];
    }

    @Override
    public void findSashes(LayoutPart layoutPart, PartPane.Sashes sashes) {
        if (this.root == null) {
            return;
        }
        LayoutTree layoutTree = this.root.find(layoutPart);
        if (layoutTree == null) {
            return;
        }
        layoutTree.findSashes(sashes);
    }

    @Override
    public void add(LayoutPart layoutPart) {
        if (layoutPart == null) {
            return;
        }
        this.addEnhanced(layoutPart, 131072, 0.5f, this.findBottomRight());
    }

    void addEnhanced(LayoutPart layoutPart, int n, float f, LayoutPart layoutPart2) {
        int n2 = PageLayout.swtConstantToLayoutPosition(n);
        float f2 = n2 == 2 || n2 == 4 ? 1.0f - f : f;
        this.add(layoutPart, n2, f2, layoutPart2);
    }

    public void add(LayoutPart layoutPart, int n, float f, LayoutPart layoutPart2) {
        Rectangle rectangle;
        boolean bl = n == 1 || n == 2;
        LayoutTree layoutTree = null;
        if (this.root != null && layoutPart2 != null) {
            layoutTree = this.root.find(layoutPart2);
        }
        if (this.getParent() == null) {
            Composite composite = this.getPage().getClientComposite();
            rectangle = composite != null && !composite.isDisposed() ? composite.getBounds() : new Rectangle(0, 0, 800, 600);
            rectangle.x = 0;
            rectangle.y = 0;
        } else {
            rectangle = this.getBounds();
        }
        int n2 = PartSashContainer.measureTree(rectangle, layoutTree, bl);
        int n3 = (int)((float)n2 * f);
        int n4 = n2 - n3;
        this.add(layoutPart, n, n3, n4, layoutPart2);
    }

    static int measureTree(Rectangle rectangle, LayoutTree layoutTree, boolean bl) {
        if (layoutTree == null) {
            return Geometry.getDimension((Rectangle)rectangle, (boolean)bl);
        }
        LayoutTreeNode layoutTreeNode = layoutTree.getParent();
        if (layoutTreeNode == null) {
            return Geometry.getDimension((Rectangle)rectangle, (boolean)bl);
        }
        if (layoutTreeNode.getSash().isHorizontal() == bl) {
            return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl);
        }
        boolean bl2 = layoutTreeNode.isLeftChild(layoutTree);
        LayoutTree layoutTree2 = layoutTreeNode.getChild(!bl2);
        if (layoutTree2.isVisible()) {
            int n = layoutTreeNode.getSash().getLeft();
            int n2 = layoutTreeNode.getSash().getRight();
            int n3 = bl2 ? n : n2;
            int n4 = layoutTreeNode.getCompressionBias();
            if (bl2) {
                n4 = -n4;
            }
            if (n4 == 1) {
                return n3;
            }
            if (n4 == -1) {
                return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl) - (n + n2 - n3);
            }
            if (n + n2 == 0) {
                return 0;
            }
            return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl) * n3 / (n + n2);
        }
        return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl);
    }

    protected void addChild(RelationshipInfo relationshipInfo) {
        LayoutPart layoutPart = relationshipInfo.part;
        this.children.add(layoutPart);
        if (this.root == null) {
            this.root = new LayoutTree(layoutPart);
        } else {
            int n = relationshipInfo.relationship == 1 || relationshipInfo.relationship == 2 ? 512 : 256;
            boolean bl = relationshipInfo.relationship == 1 || relationshipInfo.relationship == 3;
            LayoutPartSash layoutPartSash = new LayoutPartSash(this, n);
            layoutPartSash.setSizes(relationshipInfo.left, relationshipInfo.right);
            if (this.parent != null && !(layoutPart instanceof PartPlaceholder)) {
                layoutPartSash.createControl(this.parent);
            }
            this.root = this.root.insert(layoutPart, bl, layoutPartSash, relationshipInfo.relative);
        }
        this.childAdded(layoutPart);
        if (this.active) {
            layoutPart.createControl(this.parent);
            layoutPart.setVisible(true);
            layoutPart.setContainer(this);
            this.resizeChild(layoutPart);
        }
    }

    void addChildForPlaceholder(LayoutPart layoutPart, LayoutPart layoutPart2) {
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutPart;
        if (this.root != null) {
            relationshipInfo.relationship = 2;
            relationshipInfo.relative = this.root.findBottomRight();
            relationshipInfo.left = 200;
            relationshipInfo.right = 200;
        }
        RelationshipInfo[] relationshipInfoArray = this.computeRelation();
        int n = 0;
        while (n < relationshipInfoArray.length) {
            RelationshipInfo relationshipInfo2 = relationshipInfoArray[n];
            if (relationshipInfo2.part == layoutPart2) {
                relationshipInfo.left = relationshipInfo2.left;
                relationshipInfo.right = relationshipInfo2.right;
                relationshipInfo.relationship = relationshipInfo2.relationship;
                relationshipInfo.relative = relationshipInfo2.relative;
            }
            ++n;
        }
        this.addChild(relationshipInfo);
        this.flushLayout();
    }

    public boolean allowsBorder() {
        return true;
    }

    protected void childAdded(LayoutPart layoutPart) {
        if (this.isDeferred()) {
            layoutPart.deferUpdates(true);
        }
    }

    protected void childRemoved(LayoutPart layoutPart) {
        if (this.isDeferred()) {
            layoutPart.deferUpdates(false);
        }
    }

    public RelationshipInfo[] computeRelation() {
        LayoutTree layoutTree = this.root;
        ArrayList<RelationshipInfo> arrayList = new ArrayList<RelationshipInfo>();
        if (layoutTree == null) {
            return new RelationshipInfo[0];
        }
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutTree.computeRelation(arrayList);
        arrayList.add(0, relationshipInfo);
        RelationshipInfo[] relationshipInfoArray = new RelationshipInfo[arrayList.size()];
        arrayList.toArray(relationshipInfoArray);
        return relationshipInfoArray;
    }

    public void setActive(boolean bl) {
        ISizeProvider iSizeProvider;
        LayoutPart layoutPart;
        if (bl == this.active) {
            return;
        }
        this.active = bl;
        ArrayList arrayList = (ArrayList)this.children.clone();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            layoutPart = (LayoutPart)arrayList.get(n);
            if (layoutPart instanceof PartStack) {
                iSizeProvider = (PartStack)layoutPart;
                ((PartStack)iSizeProvider).setActive(bl);
            }
            ++n;
        }
        if (bl) {
            this.createControl(this.parentWidget);
            this.parent.addControlListener(this.resizeListener);
            DragUtil.addDragTarget((Control)this.parent, this);
            DragUtil.addDragTarget((Control)this.parent.getShell(), this);
            n = 0;
            n2 = arrayList.size();
            while (n < n2) {
                layoutPart = (LayoutPart)arrayList.get(n);
                layoutPart.setContainer(this);
                layoutPart.setVisible(this.zoomedPart == null || layoutPart == this.zoomedPart);
                if (!(layoutPart instanceof PartStack) && this.root != null && (iSizeProvider = this.root.find(layoutPart)) != null) {
                    ((LayoutTree)iSizeProvider).flushCache();
                }
                ++n;
            }
            if (this.root != null && !this.isZoomed()) {
                this.root.createControl(this.parent);
            }
            this.resizeSashes();
        } else {
            DragUtil.removeDragTarget((Control)this.parent, this);
            DragUtil.removeDragTarget((Control)this.parent.getShell(), this);
            if (this.resizeListener != null && this.parent != null) {
                this.parent.removeControlListener(this.resizeListener);
            }
            if (arrayList != null) {
                n = 0;
                n2 = arrayList.size();
                while (n < n2) {
                    layoutPart = (LayoutPart)arrayList.get(n);
                    layoutPart.setContainer(null);
                    if (layoutPart instanceof PartStack) {
                        layoutPart.setVisible(false);
                    }
                    ++n;
                }
            }
            this.disposeSashes();
        }
    }

    @Override
    public void createControl(Composite composite) {
        if (this.parent != null) {
            return;
        }
        this.parent = this.createParent(composite);
        ArrayList arrayList = (ArrayList)this.children.clone();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            LayoutPart layoutPart = (LayoutPart)arrayList.get(n);
            layoutPart.createControl(this.parent);
            ++n;
        }
    }

    protected abstract Composite createParent(Composite var1);

    @Override
    public void dispose() {
        if (this.parent == null) {
            return;
        }
        if (this.children != null) {
            int n = 0;
            int n2 = this.children.size();
            while (n < n2) {
                LayoutPart layoutPart = (LayoutPart)this.children.get(n);
                if (layoutPart instanceof PartStack) {
                    layoutPart.dispose();
                }
                ++n;
            }
        }
        this.disposeParent();
        this.parent = null;
    }

    protected abstract void disposeParent();

    public void disposeSashes() {
        if (this.root != null) {
            this.root.disposeSashes();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.getVisible()) {
            return;
        }
        if (!SwtUtil.isDisposed((Control)this.parent)) {
            this.parent.setEnabled(bl);
        }
        super.setVisible(bl);
        ArrayList arrayList = (ArrayList)this.children.clone();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            LayoutPart layoutPart = (LayoutPart)arrayList.get(n);
            layoutPart.setVisible(bl && (this.zoomedPart == null || layoutPart == this.zoomedPart));
            ++n;
        }
    }

    public LayoutPart findBottomRight() {
        if (this.root == null) {
            return null;
        }
        return this.root.findBottomRight();
    }

    @Override
    public Rectangle getBounds() {
        return this.parent.getBounds();
    }

    @Override
    public LayoutPart[] getChildren() {
        LayoutPart[] layoutPartArray = new LayoutPart[this.children.size()];
        this.children.toArray(layoutPartArray);
        return layoutPartArray;
    }

    @Override
    public Control getControl() {
        return this.parent;
    }

    public LayoutTree getLayoutTree() {
        return this.root;
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    public Composite getParent() {
        return this.parent;
    }

    protected boolean isChild(LayoutPart layoutPart) {
        return this.children.indexOf(layoutPart) >= 0;
    }

    public boolean isZoomed() {
        return this.zoomedPart != null;
    }

    @Override
    public void resizeChild(LayoutPart layoutPart) {
        LayoutTree layoutTree;
        if (this.root != null && (layoutTree = this.root.find(layoutPart)) != null) {
            layoutTree.flushCache();
        }
        this.flushLayout();
    }

    @Override
    public void remove(LayoutPart layoutPart) {
        if (layoutPart == this.getZoomedPart()) {
            this.childRequestZoomOut();
        }
        if (!this.isChild(layoutPart)) {
            return;
        }
        this.children.remove(layoutPart);
        if (this.root != null) {
            this.root = this.root.remove(layoutPart);
        }
        this.childRemoved(layoutPart);
        if (this.active) {
            layoutPart.setVisible(false);
            layoutPart.setContainer(null);
            this.flushLayout();
        }
    }

    @Override
    public void flushLayout() {
        this.layoutDirty = true;
        super.flushLayout();
        if (this.layoutDirty) {
            this.resizeSashes();
        }
    }

    @Override
    public void replace(LayoutPart layoutPart, LayoutPart layoutPart2) {
        if (!this.isChild(layoutPart)) {
            return;
        }
        if (layoutPart == this.getZoomedPart()) {
            if (layoutPart2 instanceof PartPlaceholder) {
                this.childRequestZoomOut();
            } else {
                this.zoomedPart.setZoomed(false);
                this.zoomedPart = layoutPart2;
                this.zoomedPart.setZoomed(true);
            }
        }
        this.children.remove(layoutPart);
        this.children.add(layoutPart2);
        this.childAdded(layoutPart2);
        if (this.root != null) {
            LayoutTree layoutTree = null;
            layoutTree = this.root.find(layoutPart);
            if (layoutTree != null) {
                layoutTree.setPart(layoutPart2);
            }
        }
        this.childRemoved(layoutPart);
        if (this.active) {
            layoutPart.setVisible(false);
            layoutPart.setContainer(null);
            layoutPart2.createControl(this.parent);
            layoutPart2.setContainer(this);
            layoutPart2.setVisible(this.zoomedPart == null || this.zoomedPart == layoutPart2);
            this.resizeChild(layoutPart2);
        }
    }

    private void resizeSashes() {
        this.layoutDirty = false;
        if (!this.active) {
            return;
        }
        if (this.isZoomed()) {
            this.getZoomedPart().setBounds(this.parent.getClientArea());
        } else if (this.root != null) {
            this.root.setBounds(this.parent.getClientArea());
        }
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        if (this.isZoomed()) {
            return this.getZoomedPart().computePreferredSize(bl, n, n2, n3);
        }
        if (this.root != null) {
            return this.root.computePreferredSize(bl, n, n2, n3);
        }
        return n3;
    }

    @Override
    public int getSizeFlags(boolean bl) {
        if (this.isZoomed()) {
            return this.getZoomedPart().getSizeFlags(bl);
        }
        if (this.root != null) {
            return this.root.getSizeFlags(bl);
        }
        return 0;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.parent.setBounds(rectangle);
    }

    private void zoomIn(LayoutPart layoutPart) {
        if (this.isZoomed()) {
            return;
        }
        this.root.disposeSashes();
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart2;
            layoutPart2.setVisible((layoutPart2 = layoutPartArray[n]) == layoutPart);
            ++n;
        }
        this.zoomedPart = layoutPart;
        layoutPart.setZoomed(true);
        this.layoutDirty = true;
    }

    public LayoutPart getZoomedPart() {
        return this.zoomedPart;
    }

    @Override
    public void childRequestZoomIn(LayoutPart layoutPart) {
        if (!SwtUtil.isDisposed((Control)this.parent)) {
            this.parent.setRedraw(false);
        }
        try {
            this.zoomIn(layoutPart);
            this.requestZoomIn();
            if (this.layoutDirty) {
                this.resizeSashes();
            }
        }
        finally {
            if (!SwtUtil.isDisposed((Control)this.parent)) {
                this.parent.setRedraw(true);
            }
        }
    }

    @Override
    public void childRequestZoomOut() {
        if (!SwtUtil.isDisposed((Control)this.parent)) {
            this.parent.setRedraw(false);
        }
        try {
            this.zoomOut();
            this.requestZoomOut();
            if (this.layoutDirty) {
                this.resizeSashes();
            }
        }
        finally {
            if (!SwtUtil.isDisposed((Control)this.parent)) {
                this.parent.setRedraw(true);
            }
        }
    }

    @Override
    public void setZoomed(boolean bl) {
        LayoutPart layoutPart;
        if (!bl) {
            this.zoomOut();
        } else if (!this.isZoomed() && (layoutPart = this.pickPartToZoom()) != null) {
            this.zoomIn(layoutPart);
        }
        super.setZoomed(bl);
    }

    public LayoutPart pickPartToZoom() {
        return this.findBottomRight();
    }

    private void zoomOut() {
        if (!this.isZoomed()) {
            return;
        }
        LayoutPart layoutPart = this.zoomedPart;
        this.zoomedPart = null;
        layoutPart.setZoomed(false);
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart2 = layoutPartArray[n];
            layoutPart2.setVisible(true);
            ++n;
        }
        this.root.createControl(this.getParent());
        LayoutTree layoutTree = this.root.find(layoutPart);
        layoutTree.flushCache();
        this.layoutDirty = true;
    }

    @Override
    public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
        ILayoutContainer iLayoutContainer;
        boolean bl;
        boolean bl2;
        if (!(object instanceof LayoutPart)) {
            return null;
        }
        LayoutPart layoutPart = (LayoutPart)object;
        if (!this.isStackType(layoutPart) && !this.isPaneType(layoutPart)) {
            return null;
        }
        boolean bl3 = bl2 = layoutPart.getWorkbenchWindow() != this.getWorkbenchWindow();
        if (layoutPart instanceof ViewPane) {
            bl2 = ((ViewPane)layoutPart).getPage() != this.getPage();
        }
        boolean bl4 = bl = layoutPart instanceof EditorPane && layoutPart.getWorkbenchWindow().getWorkbench() == this.getWorkbenchWindow().getWorkbench();
        if (bl2 && !bl) {
            return null;
        }
        Rectangle rectangle2 = DragUtil.getDisplayBounds((Control)this.parent);
        LayoutPart layoutPart2 = null;
        ILayoutContainer iLayoutContainer2 = iLayoutContainer = this.isStackType(layoutPart) ? (ILayoutContainer)((Object)layoutPart) : layoutPart.getContainer();
        if (this.getVisibleChildrenCount(this) == 0) {
            return this.createDropTarget(layoutPart, 0x1000000, 0x1000000, null);
        }
        if (rectangle2.contains(point)) {
            if (this.root != null) {
                layoutPart2 = this.root.findPart(this.parent.toControl(point));
            }
            if (layoutPart2 != null) {
                Object object2;
                boolean bl5;
                Control control2 = layoutPart2.getControl();
                Rectangle rectangle3 = DragUtil.getDisplayBounds(control2);
                int n = Geometry.getClosestSide((Rectangle)rectangle3, (Point)point);
                int n2 = Geometry.getDistanceFromEdge((Rectangle)rectangle3, (Point)point, (int)n);
                boolean bl6 = bl5 = this.isStackType(layoutPart) && ((PartStack)layoutPart).isStandalone() || this.isPaneType(layoutPart) && ((PartPane)layoutPart).getStack() != null && ((PartPane)layoutPart).getStack().isStandalone();
                if (bl2 && layoutPart2 instanceof EditorStack) {
                    IDropTarget iDropTarget = layoutPart2.getDropTarget(object, point);
                    return iDropTarget;
                }
                if (n2 >= 5 && !bl5 && (object2 = layoutPart2.getDropTarget(object, point)) != null) {
                    return object2;
                }
                if (n2 > 30 && this.isStackType(layoutPart2) && !bl5 && layoutPart2 instanceof ILayoutContainer && (object2 = (ILayoutContainer)((Object)layoutPart2)).allowsAdd(layoutPart)) {
                    n = 0x1000000;
                }
                boolean bl7 = this.isZoomed();
                if (layoutPart == layoutPart2) {
                    bl7 = true;
                }
                if (iLayoutContainer != null && iLayoutContainer == layoutPart2 && this.getVisibleChildrenCount(iLayoutContainer) <= 1) {
                    bl7 = true;
                }
                if (n == 0x1000000 && layoutPart.getContainer() == layoutPart2) {
                    bl7 = true;
                }
                int n3 = n;
                if (bl7) {
                    n = 0;
                    n3 = 0x1000000;
                }
                return this.createDropTarget(layoutPart, n, n3, layoutPart2);
            }
        } else {
            if (bl2) {
                return null;
            }
            int n = Geometry.getClosestSide((Rectangle)rectangle2, (Point)point);
            boolean bl8 = this.isZoomed();
            if ((this.isStackType(layoutPart) && layoutPart.getContainer() == this || layoutPart.getContainer() != null && this.isPaneType(layoutPart) && this.getVisibleChildrenCount(layoutPart.getContainer()) <= 1 && ((LayoutPart)((Object)layoutPart.getContainer())).getContainer() == this) && (this.root == null || this.getVisibleChildrenCount(this) <= 1)) {
                bl8 = true;
            }
            int n4 = Geometry.getOppositeSide((int)n);
            if (bl8) {
                n = 0;
            }
            return this.createDropTarget(layoutPart, n, n4, null);
        }
        return null;
    }

    private SashContainerDropTarget createDropTarget(LayoutPart layoutPart, int n, int n2, LayoutPart layoutPart2) {
        if (this.dropTarget == null) {
            this.dropTarget = new SashContainerDropTarget(layoutPart, n, n2, layoutPart2);
        } else {
            this.dropTarget.setTarget(layoutPart, n, n2, layoutPart2);
        }
        return this.dropTarget;
    }

    public abstract boolean isStackType(LayoutPart var1);

    public abstract boolean isPaneType(LayoutPart var1);

    protected void dropObject(PartPane[] partPaneArray, LayoutPart layoutPart, LayoutPart layoutPart2, int n) {
        this.getControl().setRedraw(false);
        if (layoutPart2 == null && n == 0x1000000) {
            n = 1024;
        }
        if (n == 0x1000000) {
            if (this.isStackType(layoutPart2)) {
                PartStack partStack = (PartStack)layoutPart2;
                int n2 = 0;
                while (n2 < partPaneArray.length) {
                    PartPane partPane = partPaneArray[n2];
                    this.stack(partPane, partStack);
                    ++n2;
                }
            }
        } else {
            PartStack partStack = this.createStack();
            if (partPaneArray.length == 1 && partPaneArray[0].getStack() != null) {
                partPaneArray[0].getStack().copyAppearanceProperties(partStack);
            }
            int n3 = 0;
            while (n3 < partPaneArray.length) {
                PartPane partPane = partPaneArray[n3];
                this.stack(partPane, partStack);
                ++n3;
            }
            this.addEnhanced(partStack, n, this.getDockingRatio(partStack, layoutPart2), layoutPart2);
        }
        if (layoutPart != null) {
            this.setVisiblePart(layoutPart.getContainer(), layoutPart);
        }
        this.getControl().setRedraw(true);
        if (layoutPart != null) {
            layoutPart.setFocus();
        }
    }

    protected abstract PartStack createStack();

    public void stack(LayoutPart layoutPart, ILayoutContainer iLayoutContainer) {
        PerspectiveHelper perspectiveHelper;
        this.getControl().setRedraw(false);
        Perspective perspective = this.page.getActivePerspective();
        PerspectiveHelper perspectiveHelper2 = perspectiveHelper = perspective != null ? perspective.getPresentation() : null;
        if (perspectiveHelper != null && layoutPart instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)layoutPart;
            IViewReference iViewReference = viewPane.getViewReference();
            LayoutPart layoutPart2 = perspectiveHelper.findPart(iViewReference.getId(), iViewReference.getSecondaryId());
            if (layoutPart2 != null || perspective.isFastView(iViewReference)) {
                this.derefPart(layoutPart);
            }
        } else {
            this.derefPart(layoutPart);
        }
        layoutPart.reparent(this.getParent());
        iLayoutContainer.add(layoutPart);
        this.getControl().setRedraw(true);
    }

    protected abstract void setVisiblePart(ILayoutContainer var1, LayoutPart var2);

    protected abstract LayoutPart getVisiblePart(ILayoutContainer var1);

    protected void derefPart(LayoutPart layoutPart) {
        PartStack partStack;
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.remove(layoutPart);
        }
        if (iLayoutContainer instanceof LayoutPart && this.isStackType((LayoutPart)((Object)iLayoutContainer)) && (partStack = (PartStack)iLayoutContainer).getChildren().length == 0) {
            this.remove(partStack);
            partStack.dispose();
        }
    }

    protected int getVisibleChildrenCount(ILayoutContainer iLayoutContainer) {
        if (iLayoutContainer == null) {
            return 0;
        }
        LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < layoutPartArray.length) {
            if (!(layoutPartArray[n2] instanceof PartPlaceholder)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected float getDockingRatio(LayoutPart layoutPart, LayoutPart layoutPart2) {
        return 0.5f;
    }

    @Override
    public void describeLayout(StringBuffer stringBuffer) {
        if (this.root == null) {
            return;
        }
        if (this.isZoomed()) {
            stringBuffer.append("zoomed ");
            this.root.describeLayout(stringBuffer);
        } else {
            stringBuffer.append("layout ");
            this.root.describeLayout(stringBuffer);
        }
    }

    void add(LayoutPart layoutPart, int n, int n2, int n3, LayoutPart layoutPart2) {
        if (layoutPart == null) {
            return;
        }
        if (layoutPart2 != null && !this.isChild(layoutPart2)) {
            return;
        }
        if (n < 1 || n > 4) {
            n = 1;
        }
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutPart;
        relationshipInfo.relationship = n;
        relationshipInfo.left = n2;
        relationshipInfo.right = n3;
        relationshipInfo.relative = layoutPart2;
        this.addChild(relationshipInfo);
    }

    @Override
    public boolean childIsZoomed(LayoutPart layoutPart) {
        return layoutPart == this.getZoomedPart();
    }

    @Override
    public boolean allowsAutoFocus() {
        return true;
    }

    @Override
    protected void startDeferringEvents() {
        super.startDeferringEvents();
        LayoutPart[] layoutPartArray = this.children.toArray(new LayoutPart[this.children.size()]);
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.deferUpdates(true);
            ++n;
        }
    }

    @Override
    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        LayoutPart[] layoutPartArray = this.children.toArray(new LayoutPart[this.children.size()]);
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.deferUpdates(false);
            ++n;
        }
    }

    @Override
    public void testInvariants() {
        super.testInvariants();
        if (this.getContainer() != null) {
            Assert.isTrue((this.getZoomedPart() != null == this.getContainer().childIsZoomed(this) ? 1 : 0) != 0);
        }
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            layoutPartArray[n].testInvariants();
            ++n;
        }
        if (this.isZoomed()) {
            Assert.isTrue((boolean)this.children.contains(this.zoomedPart));
        }
    }

    protected static class RelationshipInfo {
        protected LayoutPart part;
        protected LayoutPart relative;
        protected int relationship;
        protected int left;
        protected int right;

        protected RelationshipInfo() {
        }

        public float getRatio() {
            int n = this.left + this.right;
            if (n > 0) {
                return (float)this.left / (float)n;
            }
            return 0.5f;
        }
    }

    private class SashContainerDropTarget
    extends AbstractDropTarget {
        private int side;
        private int cursor;
        private LayoutPart targetPart;
        private LayoutPart sourcePart;

        public SashContainerDropTarget(LayoutPart layoutPart, int n, int n2, LayoutPart layoutPart2) {
            this.setTarget(layoutPart, n, n2, layoutPart2);
        }

        public void setTarget(LayoutPart layoutPart, int n, int n2, LayoutPart layoutPart2) {
            this.side = n;
            this.targetPart = layoutPart2;
            this.sourcePart = layoutPart;
            this.cursor = n2;
        }

        @Override
        public void drop() {
            if (this.side != 0) {
                LayoutPart layoutPart = this.sourcePart;
                if (this.sourcePart instanceof PartStack) {
                    layoutPart = PartSashContainer.this.getVisiblePart((PartStack)this.sourcePart);
                }
                PartSashContainer.this.dropObject(PartSashContainer.this.getVisibleParts(this.sourcePart), layoutPart, this.targetPart, this.side);
            }
        }

        @Override
        public Cursor getCursor() {
            return DragCursors.getCursor(DragCursors.positionToDragCursor(this.cursor));
        }

        @Override
        public Rectangle getSnapRectangle() {
            Rectangle rectangle = this.targetPart != null ? DragUtil.getDisplayBounds(this.targetPart.getControl()) : DragUtil.getDisplayBounds((Control)PartSashContainer.this.getParent());
            if (this.side == 0x1000000 || this.side == 0) {
                return rectangle;
            }
            int n = Geometry.getDimension((Rectangle)rectangle, (!Geometry.isHorizontal((int)this.side) ? 1 : 0) != 0);
            return Geometry.getExtrudedEdge((Rectangle)rectangle, (int)((int)((float)n * PartSashContainer.this.getDockingRatio(this.sourcePart, this.targetPart))), (int)this.side);
        }
    }
}

