/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.part.MultiEditor;

public abstract class PartPane
extends LayoutPart
implements IPropertyListener,
Listener,
IPropertyChangeListener {
    public static final String PROP_ZOOMED = "zoomed";
    private boolean isZoomed = false;
    private MenuManager paneMenuManager;
    private ListenerList listeners = new ListenerList();
    private ListenerList partListeners = new ListenerList();
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected Composite control;
    private boolean inLayout = true;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            LayoutPart layoutPart;
            Control control;
            ILayoutContainer iLayoutContainer;
            if ((traverseEvent.detail == 512 || traverseEvent.detail == 256) && (iLayoutContainer = PartPane.this.getContainer()) != null && iLayoutContainer instanceof LayoutPart && (control = (layoutPart = (LayoutPart)((Object)iLayoutContainer)).getControl()) != null && !control.isDisposed()) {
                traverseEvent.doit = control.traverse(traverseEvent.detail);
                if (traverseEvent.doit) {
                    traverseEvent.detail = 0;
                }
            }
        }
    };
    private boolean busy;

    public PartPane(IWorkbenchPartReference iWorkbenchPartReference, WorkbenchPage workbenchPage) {
        super(iWorkbenchPartReference.getId());
        this.partReference = iWorkbenchPartReference;
        this.page = workbenchPage;
    }

    public void addSizeMenuItem(Menu menu, int n) {
        MenuItem menuItem = new MenuItem(menu, 64, n);
        menuItem.setText(WorkbenchMessages.PartPane_size);
        Menu menu2 = new Menu(menu);
        menuItem.setMenu(menu2);
        this.addSizeItems(menu2);
    }

    @Override
    public void createControl(Composite composite) {
        if (this.getControl() != null) {
            return;
        }
        this.partReference.addPropertyListener(this);
        this.partReference.addPartPropertyListener(this);
        this.control = new Composite(composite, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setVisible(false);
        this.control.moveAbove(null);
        this.createTitleBar();
        this.control.addListener(26, (Listener)this);
        this.control.addTraverseListener(this.traverseListener);
    }

    protected abstract void createTitleBar();

    @Override
    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control.removeTraverseListener(this.traverseListener);
            try {
                this.control.dispose();
            }
            catch (RuntimeException runtimeException) {
                StatusUtil.handleStatus(runtimeException, 1);
            }
            this.control = null;
        }
        if (this.paneMenuManager != null) {
            this.paneMenuManager.dispose();
            this.paneMenuManager = null;
        }
        this.partReference.removePropertyListener(this);
        this.partReference.removePartPropertyListener(this);
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.isDocked()) {
            this.page.toggleZoom(this.partReference);
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public void handleEvent(Event event) {
        if (event.type == 26 && this.inLayout) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    @Override
    public void moveAbove(Control control) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(control);
        }
    }

    public void requestActivation() {
        IWorkbenchPart iWorkbenchPart = this.partReference.getPart(true);
        if (iWorkbenchPart instanceof MultiEditor) {
            return;
        }
        this.page.requestActivation(iWorkbenchPart);
    }

    @Override
    public void setContainer(ILayoutContainer iLayoutContainer) {
        LayoutPart layoutPart;
        Control control;
        if (iLayoutContainer instanceof LayoutPart && (control = (layoutPart = (LayoutPart)((Object)iLayoutContainer)).getControl()) != null) {
            Control control2 = this.getControl();
            Composite composite = control.getParent();
            if (control2 != null && composite != control2.getParent()) {
                this.reparent(composite);
            }
        }
        super.setContainer(iLayoutContainer);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.getVisible()) {
            return;
        }
        if (bl) {
            this.partReference.getPart(true);
        }
        super.setVisible(bl);
        ((WorkbenchPartReference)this.partReference).fireVisibilityChange();
    }

    @Override
    public void setFocus() {
        Control control;
        this.requestActivation();
        IWorkbenchPart iWorkbenchPart = this.partReference.getPart(true);
        if (iWorkbenchPart != null && !SwtUtil.isFocusAncestor(control = this.getControl())) {
            iWorkbenchPart.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    @Override
    public void setZoomed(boolean bl) {
        if (this.isZoomed == bl) {
            return;
        }
        super.setZoomed(bl);
        this.isZoomed = bl;
        ((WorkbenchPartReference)this.partReference).fireZoomChange();
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart layoutPart) {
        return this;
    }

    public PartStack getStack() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer instanceof PartStack) {
            return (PartStack)iLayoutContainer;
        }
        return null;
    }

    public void showPaneMenu() {
        PartStack partStack = this.getStack();
        if (partStack != null) {
            partStack.showPaneMenu();
        }
    }

    public void showSystemMenu() {
        PartStack partStack = this.getStack();
        if (partStack != null) {
            partStack.showSystemMenu();
        }
    }

    protected Sashes findSashes() {
        Sashes sashes = new Sashes();
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer == null) {
            return sashes;
        }
        iLayoutContainer.findSashes(this, sashes);
        return sashes;
    }

    protected void moveSash(Sash sash) {
        PartPane.moveSash(sash, this);
    }

    public static void moveSash(final Sash sash, final LayoutPart layoutPart) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.character == '\u001b' || keyEvent.character == '\r') && layoutPart != null) {
                    layoutPart.setFocus();
                }
            }
        };
        sash.addFocusListener((FocusListener)new FocusAdapter((KeyListener)keyAdapter){
            private final /* synthetic */ KeyListener val$listener;
            {
                this.val$listener = keyListener;
            }

            public void focusGained(FocusEvent focusEvent) {
                sash.setBackground(sash.getDisplay().getSystemColor(26));
                sash.addKeyListener(this.val$listener);
            }

            public void focusLost(FocusEvent focusEvent) {
                sash.setBackground(null);
                sash.removeKeyListener(this.val$listener);
            }
        });
        sash.setFocus();
    }

    protected void addSizeItem(Menu menu, String string, final Sash sash) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(string);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PartPane.this.moveSash(sash);
            }
        });
        menuItem.setEnabled(!this.isZoomed() && sash != null);
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void addSizeItems(Menu menu) {
        Sashes sashes = this.findSashes();
        if (Window.getDefaultOrientation() == 0x4000000) {
            this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeLeft, sashes.right);
            this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeRight, sashes.left);
        } else {
            this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeLeft, sashes.left);
            this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeRight, sashes.right);
        }
        this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeTop, sashes.top);
        this.addSizeItem(menu, WorkbenchMessages.PartPane_sizeBottom, sashes.bottom);
    }

    protected void doDock() {
    }

    public void setBusy(boolean bl) {
        if (bl != this.busy) {
            this.busy = bl;
            this.firePropertyChange(146);
        }
    }

    public void showHighlight() {
    }

    public abstract Control getToolBar();

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point point) {
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void describeLayout(StringBuffer stringBuffer) {
        IWorkbenchPartReference iWorkbenchPartReference = this.getPartReference();
        if (iWorkbenchPartReference != null) {
            stringBuffer.append(iWorkbenchPartReference.getPartName());
            return;
        }
    }

    public abstract boolean isCloseable();

    public void setInLayout(boolean bl) {
        this.inLayout = bl;
    }

    public boolean getInLayout() {
        return this.inLayout;
    }

    @Override
    public boolean allowsAutoFocus() {
        if (!this.inLayout) {
            return false;
        }
        return super.allowsAutoFocus();
    }

    public void removeContributions() {
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.listeners.add((Object)iPropertyListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.listeners.remove((Object)iPropertyListener);
    }

    public void firePropertyChange(int n) {
        Object[] objectArray = this.listeners.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((IPropertyListener)objectArray[n2]).propertyChanged(this, n);
            ++n2;
        }
    }

    @Override
    public void propertyChanged(Object object, int n) {
        this.firePropertyChange(n);
    }

    public void addPartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partListeners.add((Object)iPropertyChangeListener);
    }

    public void removePartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partListeners.remove((Object)iPropertyChangeListener);
    }

    public void firePartPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.partListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePartPropertyChange(propertyChangeEvent);
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return ((WorkbenchPartReference)this.partReference).computePreferredSize(bl, n, n2, n3);
    }

    @Override
    public int getSizeFlags(boolean bl) {
        return ((WorkbenchPartReference)this.partReference).getSizeFlags(bl);
    }

    public static class Sashes {
        public Sash left;
        public Sash right;
        public Sash top;
        public Sash bottom;
    }
}

