/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.misc.UIStats;

public class PartListenerList
extends EventManager {
    public void addPartListener(IPartListener iPartListener) {
        this.addListenerObject(iPartListener);
    }

    private void fireEvent(SafeRunnable safeRunnable, IPartListener iPartListener, IWorkbenchPart iWorkbenchPart, String string) {
        String string2 = null;
        if (UIStats.isDebugging(9)) {
            string2 = String.valueOf(string) + iWorkbenchPart.getTitle();
            UIStats.start(9, string2);
        }
        Platform.run((ISafeRunnable)safeRunnable);
        if (UIStats.isDebugging(9)) {
            UIStats.end(9, iPartListener, string2);
        }
    }

    public void firePartActivated(final IWorkbenchPart iWorkbenchPart) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPartListener iPartListener = (IPartListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPartListener.partActivated(iWorkbenchPart);
                }
            }, iPartListener, iWorkbenchPart, "activated::");
            ++n;
        }
    }

    public void firePartBroughtToTop(final IWorkbenchPart iWorkbenchPart) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPartListener iPartListener = (IPartListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPartListener.partBroughtToTop(iWorkbenchPart);
                }
            }, iPartListener, iWorkbenchPart, "broughtToTop::");
            ++n;
        }
    }

    public void firePartClosed(final IWorkbenchPart iWorkbenchPart) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPartListener iPartListener = (IPartListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPartListener.partClosed(iWorkbenchPart);
                }
            }, iPartListener, iWorkbenchPart, "closed::");
            ++n;
        }
    }

    public void firePartDeactivated(final IWorkbenchPart iWorkbenchPart) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPartListener iPartListener = (IPartListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPartListener.partDeactivated(iWorkbenchPart);
                }
            }, iPartListener, iWorkbenchPart, "deactivated::");
            ++n;
        }
    }

    public void firePartOpened(final IWorkbenchPart iWorkbenchPart) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPartListener iPartListener = (IPartListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPartListener.partOpened(iWorkbenchPart);
                }
            }, iPartListener, iWorkbenchPart, "opened::");
            ++n;
        }
    }

    public void removePartListener(IPartListener iPartListener) {
        this.removeListenerObject(iPartListener);
    }
}

