/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.part.AbstractMultiEditor;

public abstract class PartList {
    private IWorkbenchPartReference activePartReference;
    private IEditorReference activeEditorReference;
    private IPropertyListener listener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)object;
            switch (n) {
                case 529: {
                    PartList.this.partOpened(workbenchPartReference);
                    break;
                }
                case 530: {
                    PartList.this.partClosed(workbenchPartReference);
                    break;
                }
                case 532: {
                    if (workbenchPartReference.getVisible()) {
                        PartList.this.partVisible(workbenchPartReference);
                        break;
                    }
                    PartList.this.partHidden(workbenchPartReference);
                    break;
                }
                case 258: {
                    PartList.this.partInputChanged(workbenchPartReference);
                }
            }
        }
    };
    private IPageChangedListener partPageListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            PartList.this.firePageChanged(pageChangedEvent);
        }
    };

    public IWorkbenchPartReference getActivePartReference() {
        return this.activePartReference;
    }

    public IEditorReference getActiveEditorReference() {
        return this.activeEditorReference;
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditorReference == null ? null : this.activeEditorReference.getEditor(false);
    }

    public IWorkbenchPart getActivePart() {
        return this.activePartReference == null ? null : this.activePartReference.getPart(false);
    }

    public void addPart(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        workbenchPartReference.addInternalPropertyListener(this.listener);
        this.firePartAdded(workbenchPartReference);
        if (workbenchPartReference.getPart(false) != null) {
            this.partOpened(workbenchPartReference);
        }
        if (workbenchPartReference.getVisible()) {
            this.partVisible(workbenchPartReference);
        }
    }

    public void setActivePart(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference == this.activePartReference) {
            return;
        }
        IWorkbenchPartReference iWorkbenchPartReference2 = this.activePartReference;
        if (iWorkbenchPartReference != null) {
            IWorkbenchPartSite iWorkbenchPartSite;
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(true);
            Assert.isNotNull((Object)iWorkbenchPart);
            if (iWorkbenchPart instanceof AbstractMultiEditor && (iWorkbenchPartSite = ((AbstractMultiEditor)iWorkbenchPart).getActiveEditor().getSite()) instanceof PartSite) {
                iWorkbenchPartReference = ((PartSite)iWorkbenchPartSite).getPane().getPartReference();
            }
        }
        this.activePartReference = iWorkbenchPartReference;
        this.fireActivePartChanged(iWorkbenchPartReference2, iWorkbenchPartReference);
    }

    public void setActiveEditor(IEditorReference iEditorReference) {
        if (iEditorReference == this.activeEditorReference) {
            return;
        }
        if (iEditorReference != null) {
            IWorkbenchPartSite iWorkbenchPartSite;
            IWorkbenchPart iWorkbenchPart = iEditorReference.getPart(true);
            Assert.isNotNull((Object)iWorkbenchPart);
            if (iWorkbenchPart instanceof AbstractMultiEditor && (iWorkbenchPartSite = ((AbstractMultiEditor)iWorkbenchPart).getActiveEditor().getSite()) instanceof PartSite) {
                iEditorReference = (IEditorReference)((PartSite)iWorkbenchPartSite).getPane().getPartReference();
            }
        }
        this.activeEditorReference = iEditorReference;
        this.fireActiveEditorChanged(iEditorReference);
    }

    public void removePart(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        Assert.isTrue((workbenchPartReference != this.activePartReference ? 1 : 0) != 0);
        Assert.isTrue((workbenchPartReference != this.activeEditorReference ? 1 : 0) != 0);
        if (workbenchPartReference.getVisible()) {
            workbenchPartReference.setVisible(false);
        }
        if (workbenchPartReference.getPart(false) != null) {
            this.partClosed(workbenchPartReference);
        }
        workbenchPartReference.removeInternalPropertyListener(this.listener);
        this.firePartRemoved(workbenchPartReference);
    }

    private void partInputChanged(WorkbenchPartReference workbenchPartReference) {
        this.firePartInputChanged(workbenchPartReference);
    }

    private void partHidden(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        Assert.isTrue((!workbenchPartReference.getVisible() ? 1 : 0) != 0);
        this.firePartHidden(workbenchPartReference);
    }

    private void partOpened(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        IWorkbenchPart iWorkbenchPart = workbenchPartReference.getPart(false);
        Assert.isNotNull((Object)iWorkbenchPart);
        Assert.isTrue((this.activePartReference != workbenchPartReference ? 1 : 0) != 0);
        Assert.isTrue((this.activeEditorReference != workbenchPartReference ? 1 : 0) != 0);
        SaveablesList saveablesList = (SaveablesList)iWorkbenchPart.getSite().getService(ISaveablesLifecycleListener.class);
        saveablesList.postOpen(iWorkbenchPart);
        if (iWorkbenchPart instanceof IPageChangeProvider) {
            ((IPageChangeProvider)iWorkbenchPart).addPageChangedListener(this.partPageListener);
        }
        this.firePartOpened(workbenchPartReference);
    }

    private void partClosed(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        IWorkbenchPart iWorkbenchPart = workbenchPartReference.getPart(false);
        Assert.isNotNull((Object)iWorkbenchPart);
        Assert.isTrue((this.activePartReference != workbenchPartReference ? 1 : 0) != 0);
        Assert.isTrue((this.activeEditorReference != workbenchPartReference ? 1 : 0) != 0);
        if (iWorkbenchPart instanceof IPageChangeProvider) {
            ((IPageChangeProvider)iWorkbenchPart).removePageChangedListener(this.partPageListener);
        }
        this.firePartClosed(workbenchPartReference);
    }

    private void partVisible(WorkbenchPartReference workbenchPartReference) {
        Assert.isNotNull((Object)workbenchPartReference);
        Assert.isTrue((boolean)workbenchPartReference.getVisible());
        Assert.isNotNull((Object)workbenchPartReference.getPart(false));
        this.firePartVisible(workbenchPartReference);
    }

    protected abstract void firePartOpened(IWorkbenchPartReference var1);

    protected abstract void firePartClosed(IWorkbenchPartReference var1);

    protected abstract void firePartAdded(IWorkbenchPartReference var1);

    protected abstract void firePartRemoved(IWorkbenchPartReference var1);

    protected abstract void fireActiveEditorChanged(IWorkbenchPartReference var1);

    protected abstract void fireActivePartChanged(IWorkbenchPartReference var1, IWorkbenchPartReference var2);

    protected abstract void firePartVisible(IWorkbenchPartReference var1);

    protected abstract void firePartHidden(IWorkbenchPartReference var1);

    protected abstract void firePartInputChanged(IWorkbenchPartReference var1);

    protected abstract void firePartBroughtToTop(IWorkbenchPartReference var1);

    protected abstract void firePageChanged(PageChangedEvent var1);
}

