/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.AbstractPartSelectionTracker;

public class PagePartSelectionTracker
extends AbstractPartSelectionTracker
implements IPartListener,
IPerspectiveListener2,
ISelectionChangedListener {
    private IWorkbenchPage fPage;
    private IWorkbenchPart fPart;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PagePartSelectionTracker.this.fireSelection(PagePartSelectionTracker.this.getPart(), selectionChangedEvent.getSelection());
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PagePartSelectionTracker.this.firePostSelection(PagePartSelectionTracker.this.getPart(), selectionChangedEvent.getSelection());
        }
    };

    public PagePartSelectionTracker(IWorkbenchPage iWorkbenchPage, String string) {
        super(string);
        IViewReference iViewReference;
        this.setPage(iWorkbenchPage);
        iWorkbenchPage.addPartListener(this);
        iWorkbenchPage.getWorkbenchWindow().addPerspectiveListener(this);
        String string2 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if ((iViewReference = iWorkbenchPage.findViewReference(string, string2)) != null && iViewReference.getView(false) != null) {
            this.setPart(iViewReference.getView(false), false);
        }
    }

    @Override
    public void dispose() {
        IWorkbenchPage iWorkbenchPage = this.getPage();
        iWorkbenchPage.getWorkbenchWindow().removePerspectiveListener(this);
        iWorkbenchPage.removePartListener(this);
        this.setPart(null, false);
        this.setPage(null);
        super.dispose();
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (this.getPartId(iWorkbenchPart).equals(this.getPartId())) {
            this.setPart(null, true);
        }
    }

    @Override
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        if (this.getPartId(iWorkbenchPart).equals(this.getPartId())) {
            this.setPart(iWorkbenchPart, true);
        }
    }

    private Object getPartId(IWorkbenchPart iWorkbenchPart) {
        String string;
        String string2 = iWorkbenchPart.getSite().getId();
        if (iWorkbenchPart instanceof IViewPart && (string = ((IViewPart)iWorkbenchPart).getViewSite().getSecondaryId()) != null) {
            string2 = String.valueOf(string2) + ':' + string;
        }
        return string2;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelection(this.getPart(), selectionChangedEvent.getSelection());
    }

    private void setPage(IWorkbenchPage iWorkbenchPage) {
        this.fPage = iWorkbenchPage;
    }

    protected IWorkbenchPage getPage() {
        return this.fPage;
    }

    protected IWorkbenchPart getPart() {
        return this.fPart;
    }

    @Override
    public ISelection getSelection() {
        ISelectionProvider iSelectionProvider;
        IWorkbenchPart iWorkbenchPart = this.getPart();
        if (iWorkbenchPart != null && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }

    protected ISelectionProvider getSelectionProvider() {
        IWorkbenchPart iWorkbenchPart = this.getPart();
        if (iWorkbenchPart != null) {
            return iWorkbenchPart.getSite().getSelectionProvider();
        }
        return null;
    }

    private void setPart(IWorkbenchPart iWorkbenchPart, boolean bl) {
        ISelectionProvider iSelectionProvider;
        ISelectionProvider iSelectionProvider2;
        if (this.fPart != null && (iSelectionProvider2 = this.fPart.getSite().getSelectionProvider()) != null) {
            iSelectionProvider2.removeSelectionChangedListener(this.selectionListener);
            if (iSelectionProvider2 instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)iSelectionProvider2).removePostSelectionChangedListener(this.postSelectionListener);
            } else {
                iSelectionProvider2.removeSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.fPart = iWorkbenchPart;
        iSelectionProvider2 = null;
        if (iWorkbenchPart != null && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) != null) {
            iSelectionProvider.addSelectionChangedListener(this.selectionListener);
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.postSelectionListener);
            } else {
                iSelectionProvider.addSelectionChangedListener(this.postSelectionListener);
            }
            if (bl) {
                iSelectionProvider2 = iSelectionProvider.getSelection();
            }
        }
        if (bl) {
            this.fireSelection(iWorkbenchPart, (ISelection)iSelectionProvider2);
            this.firePostSelection(iWorkbenchPart, (ISelection)iSelectionProvider2);
        }
    }

    @Override
    public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
    }

    @Override
    public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
    }

    @Override
    public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        if (iWorkbenchPartReference == null) {
            return;
        }
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        if (iWorkbenchPart == null) {
            return;
        }
        if ("viewShow".equals(string)) {
            if (this.getPart() != null) {
                return;
            }
            if (this.getPartId(iWorkbenchPart).equals(this.getPartId())) {
                this.setPart(iWorkbenchPart, true);
            }
        }
    }
}

