/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.misc.UIStats;

public class PageListenerList
extends EventManager {
    public void addPageListener(IPageListener iPageListener) {
        this.addListenerObject(iPageListener);
    }

    private void fireEvent(SafeRunnable safeRunnable, IPageListener iPageListener, IWorkbenchPage iWorkbenchPage, String string) {
        String string2 = null;
        if (UIStats.isDebugging(11)) {
            string2 = String.valueOf(string) + iWorkbenchPage.getLabel();
            UIStats.start(11, string2);
        }
        Platform.run((ISafeRunnable)safeRunnable);
        if (UIStats.isDebugging(11)) {
            UIStats.end(11, iPageListener, string2);
        }
    }

    public void firePageActivated(final IWorkbenchPage iWorkbenchPage) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageListener iPageListener = (IPageListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPageListener.pageActivated(iWorkbenchPage);
                }
            }, iPageListener, iWorkbenchPage, "activated::");
            ++n;
        }
    }

    public void firePageClosed(final IWorkbenchPage iWorkbenchPage) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageListener iPageListener = (IPageListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPageListener.pageClosed(iWorkbenchPage);
                }
            }, iPageListener, iWorkbenchPage, "closed::");
            ++n;
        }
    }

    public void firePageOpened(final IWorkbenchPage iWorkbenchPage) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageListener iPageListener = (IPageListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPageListener.pageOpened(iWorkbenchPage);
                }
            }, iPageListener, iWorkbenchPage, "opened::");
            ++n;
        }
    }

    public void removePageListener(IPageListener iPageListener) {
        this.removeListenerObject(iPageListener);
    }
}

