/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FolderLayout;
import org.eclipse.ui.internal.LayoutHelper;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PlaceholderFolderLayout;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayout;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class PageLayout
implements IPageLayout {
    private ArrayList actionSets = new ArrayList(3);
    private IPerspectiveDescriptor descriptor;
    private LayoutPart editorFolder;
    private boolean editorVisible = true;
    private boolean fixed;
    private ArrayList fastViews = new ArrayList(3);
    private Map mapIDtoFolder = new HashMap(10);
    private Map mapIDtoPart = new HashMap(10);
    private Map mapIDtoViewLayoutRec = new HashMap(10);
    private Map mapFolderToFolderLayout = new HashMap(10);
    private ArrayList newWizardShortcuts = new ArrayList(3);
    private ArrayList perspectiveShortcuts = new ArrayList(3);
    private ViewSashContainer rootLayoutContainer;
    private ArrayList showInPartIds = new ArrayList(3);
    private ArrayList showViewShortcuts = new ArrayList(3);
    private ViewFactory viewFactory;
    private List minimizedStacks = new ArrayList();
    private Collection hiddenMenuItemIds = new ArrayList();
    private Collection hiddenToolBarItemIds = new ArrayList();

    public PageLayout() {
    }

    public PageLayout(ViewSashContainer viewSashContainer, ViewFactory viewFactory, LayoutPart layoutPart, IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.viewFactory = viewFactory;
        this.rootLayoutContainer = viewSashContainer;
        this.editorFolder = layoutPart;
        this.descriptor = iPerspectiveDescriptor;
        this.prefill();
    }

    private void addEditorArea() {
        try {
            LayoutPart layoutPart = this.createView("org.eclipse.ui.editorss");
            if (layoutPart == null) {
                return;
            }
            this.setRefPart("org.eclipse.ui.editorss", layoutPart);
            this.rootLayoutContainer.add(layoutPart);
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "addEditorArea()", (Throwable)((Object)partInitException));
        }
    }

    @Override
    public void addActionSet(String string) {
        if (!this.actionSets.contains(string)) {
            this.actionSets.add(string);
        }
    }

    @Override
    public void addFastView(String string) {
        this.addFastView(string, -1.0f);
    }

    @Override
    public void addFastView(String string, float f) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        if (string != null) {
            try {
                IViewDescriptor iViewDescriptor = this.viewFactory.getViewRegistry().find(ViewFactory.extractPrimaryId(string));
                if (!WorkbenchActivityHelper.filterItem(iViewDescriptor)) {
                    IViewReference iViewReference = this.viewFactory.createView(ViewFactory.extractPrimaryId(string), ViewFactory.extractSecondaryId(string));
                    this.fastViews.add(iViewReference);
                    ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
                    if (f >= 0.05f && f <= 0.95f) {
                        viewLayoutRec.fastViewWidthRatio = f;
                    }
                }
            }
            catch (PartInitException partInitException) {
                WorkbenchPlugin.log(this.getClass(), "addFastView", (Throwable)((Object)partInitException));
            }
        }
    }

    private boolean isFastViewId(String string) {
        int n = 0;
        while (n < this.fastViews.size()) {
            String string2;
            IViewReference iViewReference = (IViewReference)this.fastViews.get(n);
            String string3 = iViewReference.getSecondaryId();
            String string4 = string2 = string3 == null ? iViewReference.getId() : String.valueOf(iViewReference.getId()) + ":" + string3;
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    ViewLayoutRec getViewLayoutRec(String string, boolean bl) {
        ViewLayoutRec viewLayoutRec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(string);
        if (viewLayoutRec == null && bl) {
            viewLayoutRec = new ViewLayoutRec();
            if (this.isFixed()) {
                viewLayoutRec.isCloseable = false;
                viewLayoutRec.isMoveable = false;
            }
            this.mapIDtoViewLayoutRec.put(string, viewLayoutRec);
        }
        return viewLayoutRec;
    }

    @Override
    public void addNewWizardShortcut(String string) {
        if (!this.newWizardShortcuts.contains(string)) {
            this.newWizardShortcuts.add(string);
        }
    }

    private void addPart(LayoutPart layoutPart, String string, int n, float f, String string2) {
        this.setRefPart(string, layoutPart);
        LayoutPart layoutPart2 = this.getFolderPart(string2);
        if (layoutPart2 == null) {
            layoutPart2 = this.getRefPart(string2);
        }
        if (layoutPart2 != null) {
            f = this.normalizeRatio(f);
            this.rootLayoutContainer.add(layoutPart, this.getPartSashConst(n), f, layoutPart2);
        } else {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_missingRefPart, (Object)string2));
            this.rootLayoutContainer.add(layoutPart);
        }
    }

    @Override
    public void addPerspectiveShortcut(String string) {
        if (!this.perspectiveShortcuts.contains(string)) {
            this.perspectiveShortcuts.add(string);
        }
    }

    @Override
    public void addPlaceholder(String string, int n, float f, String string2) {
        if (!this.checkValidPlaceholderId(string)) {
            return;
        }
        PartPlaceholder partPlaceholder = new PartPlaceholder(string);
        this.addPart(partPlaceholder, string, n, f, string2);
        this.getViewLayoutRec(string, true);
    }

    boolean checkValidPlaceholderId(String string) {
        IViewRegistry iViewRegistry;
        IViewDescriptor iViewDescriptor;
        if (this.checkPartInLayout(string)) {
            return false;
        }
        String string2 = ViewFactory.extractPrimaryId(string);
        if (!ViewFactory.hasWildcard(string2) && (iViewDescriptor = (iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry()).find(string2)) == null) {
            WorkbenchPlugin.log("Unable to find view with id: " + string2 + ", when creating perspective " + this.getDescriptor().getId());
            return false;
        }
        return true;
    }

    @Override
    public void addShowInPart(String string) {
        if (!this.showInPartIds.contains(string)) {
            this.showInPartIds.add(string);
        }
    }

    @Override
    public void addShowViewShortcut(String string) {
        if (!this.showViewShortcuts.contains(string)) {
            this.showViewShortcuts.add(string);
        }
    }

    public void addHiddenMenuItemId(String string) {
        if (!this.hiddenMenuItemIds.contains(string)) {
            this.hiddenMenuItemIds.add(string);
        }
    }

    public void addHiddenToolBarItemId(String string) {
        if (!this.hiddenToolBarItemIds.contains(string)) {
            this.hiddenToolBarItemIds.add(string);
        }
    }

    @Override
    public void addView(String string, int n, float f, String string2) {
        this.addView(string, n, f, string2, false, false, true);
    }

    public void addView(String string, int n, float f, String string2, boolean bl) {
        this.addView(string, n, f, string2, bl, false, true);
    }

    private void addView(String string, int n, float f, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        try {
            LayoutPart layoutPart = this.createView(string);
            if (layoutPart == null) {
                this.addPlaceholder(string, n, f, string2);
                LayoutHelper.addViewActivator(this, string);
            } else {
                int n2 = 2;
                if (bl2) {
                    n2 = bl3 ? 3 : 4;
                }
                ViewStack viewStack = new ViewStack(this.rootLayoutContainer.page, true, n2, null);
                viewStack.add(layoutPart);
                this.setFolderPart(string, viewStack);
                this.addPart(viewStack, string, n, f, string2);
                this.getViewLayoutRec(string, true);
                if (bl) {
                    this.minimizedStacks.add(viewStack);
                }
            }
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "addView", (Throwable)((Object)partInitException));
        }
    }

    public List getMinimizedStacks() {
        return this.minimizedStacks;
    }

    boolean checkPartInLayout(String string) {
        if (this.getRefPart(string) != null || this.isFastViewId(string)) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_duplicateRefPart, (Object)string));
            return true;
        }
        return false;
    }

    @Override
    public IFolderLayout createFolder(String string, int n, float f, String string2) {
        if (this.checkPartInLayout(string)) {
            ViewStack viewStack = (ViewStack)this.getRefPart(string);
            return (IFolderLayout)this.mapFolderToFolderLayout.get(viewStack);
        }
        ViewStack viewStack = new ViewStack(this.rootLayoutContainer.page);
        viewStack.setID(string);
        if (this.getDescriptor() != null && this.viewFactory.getWorkbenchPage().window.getWindowAdvisor().isDurableFolder(this.getDescriptor().getId(), string)) {
            viewStack.setDurable(true);
        }
        this.addPart(viewStack, string, n, f, string2);
        FolderLayout folderLayout = new FolderLayout(this, viewStack, this.viewFactory);
        this.mapFolderToFolderLayout.put(viewStack, folderLayout);
        return folderLayout;
    }

    @Override
    public IPlaceholderFolderLayout createPlaceholderFolder(String string, int n, float f, String string2) {
        if (this.checkPartInLayout(string)) {
            ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)this.getRefPart(string);
            return (IPlaceholderFolderLayout)this.mapFolderToFolderLayout.get(containerPlaceholder);
        }
        ContainerPlaceholder containerPlaceholder = new ContainerPlaceholder(null);
        containerPlaceholder.setContainer(this.rootLayoutContainer);
        containerPlaceholder.setRealContainer(new ViewStack(this.rootLayoutContainer.page));
        containerPlaceholder.setID(string);
        this.addPart(containerPlaceholder, string, n, f, string2);
        PlaceholderFolderLayout placeholderFolderLayout = new PlaceholderFolderLayout(this, containerPlaceholder);
        this.mapFolderToFolderLayout.put(containerPlaceholder, placeholderFolderLayout);
        return placeholderFolderLayout;
    }

    private LayoutPart createView(String string) throws PartInitException {
        if (string.equals("org.eclipse.ui.editorss")) {
            return this.editorFolder;
        }
        IViewDescriptor iViewDescriptor = null;
        IViewRegistry iViewRegistry = this.viewFactory.getViewRegistry();
        String string2 = ViewFactory.extractPrimaryId(string);
        if (iViewRegistry instanceof ViewRegistry) {
            iViewDescriptor = ((ViewRegistry)iViewRegistry).findInternal(string2);
            if (iViewDescriptor != null && WorkbenchActivityHelper.restrictUseOf(iViewDescriptor)) {
                return null;
            }
        } else {
            iViewDescriptor = iViewRegistry.find(string2);
        }
        if (WorkbenchActivityHelper.filterItem(iViewDescriptor)) {
            return null;
        }
        return LayoutHelper.createView(this.getViewFactory(), string);
    }

    public ArrayList getActionSets() {
        return this.actionSets;
    }

    @Override
    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    @Override
    public int getEditorReuseThreshold() {
        return -1;
    }

    public ArrayList getFastViews() {
        return this.fastViews;
    }

    private ViewStack getFolderPart(String string) {
        return (ViewStack)this.mapIDtoFolder.get(string);
    }

    public ArrayList getNewWizardShortcuts() {
        return this.newWizardShortcuts;
    }

    private int getPartSashConst(int n) {
        return n;
    }

    public ArrayList getPerspectiveShortcuts() {
        return this.perspectiveShortcuts;
    }

    LayoutPart getRefPart(String string) {
        return (LayoutPart)this.mapIDtoPart.get(string);
    }

    public ViewSashContainer getRootLayoutContainer() {
        return this.rootLayoutContainer;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public ArrayList getShowViewShortcuts() {
        return this.showViewShortcuts;
    }

    public Collection getHiddenMenuItems() {
        return this.hiddenMenuItemIds;
    }

    public Collection getHiddenToolBarItems() {
        return this.hiddenToolBarItemIds;
    }

    ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    @Override
    public boolean isEditorAreaVisible() {
        return this.editorVisible;
    }

    private float normalizeRatio(float f) {
        if (f < 0.05f) {
            f = 0.05f;
        }
        if (f > 0.95f) {
            f = 0.95f;
        }
        return f;
    }

    private void prefill() {
        this.addEditorArea();
        ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSetRegistry.getActionSets();
        int n = iActionSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray[n2];
            if (iActionSetDescriptor.isInitiallyVisible()) {
                this.addActionSet(iActionSetDescriptor.getId());
            }
            ++n2;
        }
    }

    @Override
    public void setEditorAreaVisible(boolean bl) {
        this.editorVisible = bl;
    }

    @Override
    public void setEditorReuseThreshold(int n) {
    }

    @Override
    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    void setFolderPart(String string, ContainerPlaceholder containerPlaceholder) {
        LayoutPart layoutPart = containerPlaceholder.getRealContainer();
        this.mapIDtoFolder.put(string, layoutPart);
    }

    void setFolderPart(String string, ViewStack viewStack) {
        this.mapIDtoFolder.put(string, viewStack);
    }

    void setRefPart(String string, LayoutPart layoutPart) {
        this.mapIDtoPart.put(string, layoutPart);
    }

    private void stackPart(LayoutPart layoutPart, String string, String string2) {
        this.setRefPart(string, layoutPart);
        this.getViewLayoutRec(string, true);
        ViewStack viewStack = this.getFolderPart(string2);
        if (viewStack != null) {
            viewStack.add(layoutPart);
            this.setFolderPart(string, viewStack);
            return;
        }
        LayoutPart layoutPart2 = this.getRefPart(string2);
        if (layoutPart2 != null && (layoutPart2 instanceof PartPane || layoutPart2 instanceof PartPlaceholder)) {
            ViewStack viewStack2 = new ViewStack(this.rootLayoutContainer.page);
            this.rootLayoutContainer.replace(layoutPart2, viewStack2);
            viewStack2.add(layoutPart2);
            viewStack2.add(layoutPart);
            this.setFolderPart(string2, viewStack2);
            this.setFolderPart(string, viewStack2);
            return;
        }
        WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_missingRefPart, (Object)string2));
        this.rootLayoutContainer.add(layoutPart);
    }

    public void stackPlaceholder(String string, String string2) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        PartPlaceholder partPlaceholder = new PartPlaceholder(string);
        LayoutPart layoutPart = this.getRefPart(string2);
        if (layoutPart != null) {
            partPlaceholder.setContainer(layoutPart.getContainer());
        }
        this.stackPart(partPlaceholder, string, string2);
    }

    public void stackView(String string, String string2) {
        if (this.checkPartInLayout(string)) {
            return;
        }
        try {
            LayoutPart layoutPart = this.createView(string);
            if (layoutPart == null) {
                this.stackPlaceholder(string, string2);
                LayoutHelper.addViewActivator(this, string);
            } else {
                this.stackPart(layoutPart, string, string2);
            }
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "stackView", (Throwable)((Object)partInitException));
        }
    }

    public static int swtConstantToLayoutPosition(int n) {
        switch (n) {
            case 128: {
                return 3;
            }
            case 1024: {
                return 4;
            }
            case 131072: {
                return 2;
            }
            case 16384: {
                return 1;
            }
        }
        return -1;
    }

    @Override
    public void addStandaloneView(String string, boolean bl, int n, float f, String string2) {
        this.addView(string, n, f, string2, false, true, bl);
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
        viewLayoutRec.isStandalone = true;
        viewLayoutRec.showTitle = bl;
    }

    @Override
    public void addStandaloneViewPlaceholder(String string, int n, float f, String string2, boolean bl) {
        String string3 = String.valueOf(string) + ".standalonefolder";
        if (!this.checkValidPlaceholderId(string)) {
            return;
        }
        ContainerPlaceholder containerPlaceholder = new ContainerPlaceholder(null);
        containerPlaceholder.setContainer(this.rootLayoutContainer);
        int n2 = 3;
        if (!bl) {
            n2 = 4;
        }
        containerPlaceholder.setRealContainer(new ViewStack(this.rootLayoutContainer.page, true, n2, null));
        containerPlaceholder.setID(string3);
        this.addPart(containerPlaceholder, string3, n, f, string2);
        PlaceholderFolderLayout placeholderFolderLayout = new PlaceholderFolderLayout(this, containerPlaceholder);
        placeholderFolderLayout.addPlaceholder(string);
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
        viewLayoutRec.isStandalone = true;
        viewLayoutRec.showTitle = bl;
    }

    @Override
    public IViewLayout getViewLayout(String string) {
        ViewLayoutRec viewLayoutRec = this.getViewLayoutRec(string, true);
        if (viewLayoutRec == null) {
            return null;
        }
        return new ViewLayout(this, viewLayoutRec);
    }

    public Map getIDtoViewLayoutRecMap() {
        return this.mapIDtoViewLayoutRec;
    }

    public void removePlaceholder(String string) {
        LayoutPart layoutPart = this.getRefPart(string);
        if (layoutPart instanceof PartPlaceholder) {
            ViewStack viewStack = this.getFolderPart(string);
            if (viewStack != null) {
                viewStack.remove(layoutPart);
            } else {
                this.rootLayoutContainer.remove(layoutPart);
            }
            this.mapIDtoPart.remove(string);
            this.mapIDtoFolder.remove(string);
            this.mapIDtoViewLayoutRec.remove(string);
        }
    }

    @Override
    public IPlaceholderFolderLayout getFolderForView(String string) {
        if (!this.mapIDtoFolder.containsKey(string)) {
            return null;
        }
        ViewStack viewStack = (ViewStack)this.mapIDtoFolder.get(string);
        IPlaceholderFolderLayout iPlaceholderFolderLayout = null;
        if (!this.mapFolderToFolderLayout.containsKey(viewStack)) {
            iPlaceholderFolderLayout = new FolderLayout(this, viewStack, this.viewFactory);
            this.mapFolderToFolderLayout.put(viewStack, iPlaceholderFolderLayout);
        } else {
            iPlaceholderFolderLayout = (IPlaceholderFolderLayout)this.mapFolderToFolderLayout.get(viewStack);
        }
        return iPlaceholderFolderLayout;
    }
}

