/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.util.Util;

public abstract class ObjectContributorManager
implements IExtensionChangeHandler {
    protected Map contributors = new Hashtable(5);
    protected Map objectLookup = null;
    protected Map resourceAdapterLookup = null;
    protected Map adaptableLookup = null;
    protected Set contributorRecordSet = new HashSet(5);

    public ObjectContributorManager() {
        String string = this.getExtensionPointFilter();
        if (string != null) {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", string);
            IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
            iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)iExtensionPoint));
        }
    }

    protected String getExtensionPointFilter() {
        return null;
    }

    private void addContributorsFor(List list, List list2) {
        for (Class clazz : list) {
            List list3 = (List)this.contributors.get(clazz.getName());
            if (list3 == null) continue;
            list2.addAll(list3);
        }
    }

    protected final List computeClassOrder(Class clazz) {
        ArrayList arrayList = new ArrayList(4);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    protected final List computeInterfaceOrder(List list) {
        ArrayList arrayList = new ArrayList(4);
        HashMap hashMap = new HashMap(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class[] classArray = ((Class)iterator.next()).getInterfaces();
            this.internalComputeInterfaceOrder(classArray, arrayList, hashMap);
        }
        return arrayList;
    }

    public void flushLookup() {
        this.objectLookup = null;
        this.resourceAdapterLookup = null;
        this.adaptableLookup = null;
    }

    private void cacheResourceAdapterLookup(Class clazz, List list) {
        if (this.resourceAdapterLookup == null) {
            this.resourceAdapterLookup = new HashMap();
        }
        this.resourceAdapterLookup.put(clazz, list);
    }

    private void cacheAdaptableLookup(String string, List list) {
        if (this.adaptableLookup == null) {
            this.adaptableLookup = new HashMap();
        }
        this.adaptableLookup.put(string, list);
    }

    private void cacheObjectLookup(Class clazz, List list) {
        if (this.objectLookup == null) {
            this.objectLookup = new HashMap();
        }
        this.objectLookup.put(clazz, list);
    }

    public Collection getContributors() {
        return Collections.unmodifiableCollection(this.contributors.values());
    }

    protected List addContributorsFor(Class clazz) {
        List list = this.computeClassOrder(clazz);
        ArrayList arrayList = new ArrayList();
        this.addContributorsFor(list, arrayList);
        list = this.computeInterfaceOrder(list);
        this.addContributorsFor(list, arrayList);
        return arrayList;
    }

    public boolean hasContributorsFor(Object object) {
        List list = this.getContributors(object);
        return list.size() > 0;
    }

    private void internalComputeInterfaceOrder(Class[] classArray, List list, Map map) {
        ArrayList<Class> arrayList = new ArrayList<Class>(map.size());
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (map.get(clazz) == null) {
                list.add(clazz);
                map.put(clazz, clazz);
                arrayList.add(clazz);
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)iterator.next()).getInterfaces(), list, map);
        }
    }

    public boolean isApplicableTo(IStructuredSelection iStructuredSelection, IObjectContributor iObjectContributor) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (iObjectContributor.isApplicableTo(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableTo(List list, IObjectContributor iObjectContributor) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iObjectContributor.isApplicableTo(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void registerContributor(IObjectContributor iObjectContributor, String string) {
        ArrayList<IObjectContributor> arrayList = (ArrayList<IObjectContributor>)this.contributors.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IObjectContributor>(5);
            this.contributors.put(string, arrayList);
        }
        arrayList.add(iObjectContributor);
        this.flushLookup();
        IConfigurationElement iConfigurationElement = (IConfigurationElement)Util.getAdapter(iObjectContributor, IConfigurationElement.class);
        if (iConfigurationElement != null) {
            ContributorRecord contributorRecord = new ContributorRecord(iObjectContributor, string);
            this.contributorRecordSet.add(contributorRecord);
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)contributorRecord, 2);
        }
    }

    public void unregisterAllContributors() {
        this.contributors = new Hashtable(5);
        this.flushLookup();
    }

    public void unregisterContributor(IObjectContributor iObjectContributor, String string) {
        List list = (List)this.contributors.get(string);
        if (list == null) {
            return;
        }
        list.remove(iObjectContributor);
        if (list.isEmpty()) {
            this.contributors.remove(string);
        }
        this.flushLookup();
    }

    public void unregisterContributors(String string) {
        this.contributors.remove(string);
        this.flushLookup();
    }

    protected List getContributors(Object object) {
        Object object2 = LegacyResourceSupport.getAdaptedContributorResource(object);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(object.getClass())));
        this.removeCommonAdapters(arrayList, Arrays.asList(object.getClass()));
        List list = new ArrayList();
        ObjectContributorManager.addAll(list, this.getObjectContributors(object.getClass()));
        if (object2 != null) {
            ObjectContributorManager.addAll(list, this.getResourceContributors(object2.getClass()));
        }
        if (arrayList != null) {
            for (String string : arrayList) {
                ObjectContributorManager.addAll(list, this.getAdaptableContributors(string));
            }
        }
        return (list = ObjectContributorManager.removeDups(list)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList(list);
    }

    protected List getObjectContributors(Class clazz) {
        List<Object> list = null;
        if (this.objectLookup != null) {
            list = (List)this.objectLookup.get(clazz);
        }
        if (list == null) {
            list = this.addContributorsFor(clazz);
            list = list.size() == 0 ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
            this.cacheObjectLookup(clazz, list);
        }
        return list;
    }

    protected List getResourceContributors(Class clazz) {
        List<Object> list = null;
        if (this.resourceAdapterLookup != null) {
            list = (List)this.resourceAdapterLookup.get(clazz);
        }
        if (list == null) {
            list = this.addContributorsFor(clazz);
            list = list.size() == 0 ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.filterOnlyAdaptableContributors(list));
            this.cacheResourceAdapterLookup(clazz, list);
        }
        return list;
    }

    protected List getAdaptableContributors(String string) {
        List<Object> list = null;
        if (this.adaptableLookup != null) {
            list = (List)this.adaptableLookup.get(string);
        }
        if (list == null) {
            list = LegacyResourceSupport.isResourceType(string) || LegacyResourceSupport.isResourceMappingType(string) ? Collections.EMPTY_LIST : ((list = (List)this.contributors.get(string)) == null || list.size() == 0 ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.filterOnlyAdaptableContributors(list)));
            this.cacheAdaptableLookup(string, list);
        }
        return list;
    }

    protected void removeCommonAdapters(List list, List list2) {
        for (Class clazz : list2) {
            List list3 = this.computeCombinedOrder(clazz);
            for (Class clazz2 : list3) {
                list.remove(clazz2.getName());
            }
        }
    }

    protected List computeCombinedOrder(Class clazz) {
        ArrayList arrayList = new ArrayList(4);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            arrayList.add(clazz2);
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                arrayList.add(classArray[n]);
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    private List filterOnlyAdaptableContributors(List list) {
        ArrayList<IObjectContributor> arrayList = null;
        for (IObjectContributor iObjectContributor : list) {
            if (!iObjectContributor.canAdapt()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IObjectContributor>();
            }
            arrayList.add(iObjectContributor);
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ContributorRecord) {
                ContributorRecord contributorRecord = (ContributorRecord)objectArray[n];
                this.unregisterContributor(contributorRecord.contributor, contributorRecord.objectClassName);
                this.contributorRecordSet.remove(contributorRecord);
            }
            ++n;
        }
    }

    public void dispose() {
        if (this.getExtensionPointFilter() != null) {
            PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
        }
    }

    protected List getContributors(List list) {
        ArrayList arrayList = new ArrayList();
        List list2 = this.getCommonClasses(list, arrayList);
        Class clazz = this.getCommonResourceClass(list);
        Class clazz2 = this.getResourceMappingClass(list);
        List list3 = new ArrayList();
        if (clazz != null) {
            ObjectContributorManager.addAll(list3, this.getResourceContributors(clazz));
        }
        if (list2 != null && !list2.isEmpty()) {
            int n = 0;
            while (n < list2.size()) {
                Object object = this.getObjectContributors((Class)list2.get(n));
                ObjectContributorManager.addAll(list3, (List)object);
                ++n;
            }
        }
        if (clazz2 == null) {
            clazz2 = LegacyResourceSupport.getResourceMappingClass();
            if (clazz2 != null && arrayList.contains(clazz2.getName())) {
                ObjectContributorManager.addAll(list3, this.getResourceContributors(clazz2));
            }
        } else {
            list3.addAll(this.getResourceContributors(clazz2));
        }
        if (!arrayList.isEmpty()) {
            for (Object object : arrayList) {
                ObjectContributorManager.addAll(list3, this.getAdaptableContributors((String)object));
            }
        }
        return (list3 = ObjectContributorManager.removeDups(list3)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList(list3);
    }

    private static void addAll(Collection collection, List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            collection.add(list.get(n));
            ++n;
        }
    }

    private static List removeDups(List list) {
        if (list.size() <= 1) {
            return list;
        }
        HashSet hashSet = new HashSet(list);
        if (hashSet.size() == list.size()) {
            return list;
        }
        ArrayList arrayList = new ArrayList(hashSet.size());
        for (Object e : list) {
            if (!hashSet.remove(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private List getCommonClasses(List list, List list2) {
        ArrayList arrayList;
        if (list == null || list.size() == 0) {
            return null;
        }
        if (this.allSameClass(list)) {
            Class<?> clazz = list.get(0).getClass();
            list2.addAll(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(clazz)));
            ArrayList arrayList2 = new ArrayList(1);
            arrayList2.add(clazz);
            return arrayList2;
        }
        List list3 = this.computeClassOrder(list.get(0).getClass());
        List list4 = this.computeAdapterOrder(list3);
        List list5 = this.computeInterfaceOrder(list3);
        ArrayList arrayList3 = new ArrayList();
        boolean bl = list3.isEmpty();
        boolean bl2 = list5.isEmpty();
        int n = 1;
        while (n < list.size()) {
            List list6;
            arrayList = this.computeClassOrder(list.get(n).getClass());
            if (!bl) {
                bl = this.extractCommonClasses(list3, arrayList);
            }
            List list7 = this.computeInterfaceOrder(arrayList);
            if (!bl2) {
                bl2 = this.extractCommonClasses(list5, list7);
            }
            ArrayList arrayList4 = new ArrayList(arrayList);
            if (list7 != null) {
                arrayList4.addAll(list7);
            }
            if ((list6 = this.computeAdapterOrder(arrayList4)).isEmpty() && !list4.isEmpty()) {
                this.removeNonCommonAdapters(list4, arrayList4);
            } else if (list4.isEmpty()) {
                this.removeNonCommonAdapters(list6, arrayList3);
                if (!list6.isEmpty()) {
                    list4.addAll(list6);
                }
            } else {
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (list6.contains(string)) continue;
                    iterator.remove();
                }
            }
            arrayList3.clear();
            arrayList3.addAll(list3);
            arrayList3.addAll(list5);
            if (bl2 && bl && list4.isEmpty()) {
                return null;
            }
            ++n;
        }
        ArrayList arrayList5 = new ArrayList(4);
        arrayList = new ArrayList(4);
        if (!bl) {
            int n2 = 0;
            while (n2 < list3.size()) {
                if (list3.get(n2) != null) {
                    arrayList.add(list3.get(n2));
                }
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                arrayList5.add(arrayList.get(0));
            }
        }
        if (!bl2) {
            this.removeCommonInterfaces(arrayList, list5, arrayList5);
        }
        if (!list4.isEmpty()) {
            this.removeCommonAdapters(list4, arrayList5);
            list2.addAll(list4);
        }
        return arrayList5;
    }

    private boolean allSameClass(List list) {
        int n = list.size();
        if (n <= 1) {
            return true;
        }
        Class<?> clazz = list.get(0).getClass();
        int n2 = 1;
        while (n2 < n) {
            if (!list.get(n2).getClass().equals(clazz)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean extractCommonClasses(List list, List list2) {
        boolean bl = true;
        if (list2.isEmpty()) {
            list.clear();
        } else {
            int n = 0;
            while (n < list.size()) {
                if (list.get(n) != null) {
                    bl = false;
                    if (!list2.contains(list.get(n))) {
                        list.set(n, null);
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    private void removeNonCommonAdapters(List list, List list2) {
        int n = 0;
        while (n < list2.size()) {
            Class clazz;
            String string;
            Object e = list2.get(n);
            if (e != null && list.contains(string = (clazz = (Class)e).getName())) {
                return;
            }
            ++n;
        }
        list.clear();
    }

    private void removeCommonInterfaces(List list, List list2, List list3) {
        List list4 = null;
        if (!list.isEmpty()) {
            list4 = this.computeInterfaceOrder(list);
        }
        int n = 0;
        while (n < list2.size()) {
            if (list2.get(n) != null && list4 != null && !list4.contains(list2.get(n))) {
                list3.add(list2.get(n));
            }
            ++n;
        }
    }

    private List computeAdapterOrder(List list) {
        HashSet<String> hashSet = new HashSet<String>(4);
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        for (Class clazz : list) {
            String[] stringArray = iAdapterManager.computeAdapterTypes(clazz);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (!hashSet.contains(string)) {
                    hashSet.add(string);
                }
                ++n;
            }
        }
        return new ArrayList(hashSet);
    }

    private Class getCommonResourceClass(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Class clazz = LegacyResourceSupport.getResourceClass();
        if (clazz == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof IAdaptable) {
                if (!clazz.isInstance(e)) {
                    Object object = LegacyResourceSupport.getAdaptedContributorResource(e);
                    if (object == null) {
                        return null;
                    }
                    arrayList.add(object);
                }
            } else {
                return null;
            }
            ++n;
        }
        return this.getCommonClass(arrayList);
    }

    private Class getResourceMappingClass(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Class clazz = LegacyResourceSupport.getResourceMappingClass();
        if (clazz == null) {
            return null;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof IAdaptable) {
                Object object;
                if (!clazz.isInstance(e) && (object = LegacyResourceSupport.getAdaptedContributorResourceMapping(e)) == null) {
                    return null;
                }
            } else {
                return null;
            }
            ++n;
        }
        return clazz;
    }

    private Class getCommonClass(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Class clazz = list.get(0).getClass();
        if (list.size() == 1) {
            return clazz;
        }
        int n = 1;
        while (n < list.size()) {
            Object e = list.get(n);
            Class<?> clazz2 = e.getClass();
            if (!clazz2.equals(clazz) && (clazz = this.getCommonClass(clazz, clazz2)) == null) {
                return null;
            }
            ++n;
        }
        return clazz;
    }

    private Class getCommonClass(Class clazz, Class clazz2) {
        List list = this.computeCombinedOrder(clazz);
        List list2 = this.computeCombinedOrder(clazz2);
        int n = 0;
        while (n < list.size()) {
            int n2 = 0;
            while (n2 < list2.size()) {
                Class clazz3;
                Class clazz4 = (Class)list.get(n);
                if (clazz4.equals(clazz3 = (Class)list2.get(n2))) {
                    return clazz4;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private class ContributorRecord {
        String objectClassName;
        IObjectContributor contributor;

        public ContributorRecord(IObjectContributor iObjectContributor, String string) {
            this.contributor = iObjectContributor;
            this.objectClassName = string;
        }
    }
}

