/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.ObjectFilterTest;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ObjectActionContributor
extends PluginActionBuilder
implements IObjectActionContributor,
IAdaptable {
    private static final String P_TRUE = "true";
    private IConfigurationElement config;
    private boolean configRead = false;
    private boolean adaptable = false;
    private String objectClass;

    public ObjectActionContributor(IConfigurationElement iConfigurationElement) {
        this.config = iConfigurationElement;
        this.adaptable = P_TRUE.equalsIgnoreCase(iConfigurationElement.getAttribute("adaptable"));
        this.objectClass = iConfigurationElement.getAttribute("objectClass");
    }

    @Override
    public boolean canAdapt() {
        return this.adaptable;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    @Override
    public void contributeObjectActionIdOverrides(List list) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions != null) {
            int n = 0;
            while (n < this.currentContribution.actions.size()) {
                ActionDescriptor actionDescriptor = (ActionDescriptor)this.currentContribution.actions.get(n);
                String string = actionDescriptor.getAction().getOverrideActionId();
                if (string != null) {
                    list.add(string);
                }
                ++n;
            }
        }
    }

    @Override
    public boolean contributeObjectActions(final IWorkbenchPart iWorkbenchPart, IMenuManager iMenuManager, ISelectionProvider iSelectionProvider, List list) {
        IStructuredSelection iStructuredSelection;
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.actions == null) {
            return false;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection iStructuredSelection2 = (IStructuredSelection)iSelection;
        if (this.canAdapt()) {
            iStructuredSelection = LegacyResourceSupport.adaptSelection(iStructuredSelection2, this.getObjectClass());
            if (iStructuredSelection.size() != iStructuredSelection2.size()) {
                if (Policy.DEBUG_CONTRIBUTIONS) {
                    WorkbenchPlugin.log("Error adapting selection to " + this.getObjectClass() + ". Contribution " + this.getID(this.config) + " is being ignored");
                }
                return false;
            }
            iStructuredSelection2 = iStructuredSelection;
        }
        iStructuredSelection = iStructuredSelection2;
        int n = 0;
        while (n < this.currentContribution.actions.size()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)this.currentContribution.actions.get(n);
            if (!list.contains(actionDescriptor.getId())) {
                this.currentContribution.contributeMenuAction(actionDescriptor, iMenuManager, true);
                if (actionDescriptor.getAction() instanceof ObjectPluginAction) {
                    final ObjectPluginAction objectPluginAction = (ObjectPluginAction)actionDescriptor.getAction();
                    ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                            WorkbenchPlugin.log("Failed to update action " + objectPluginAction.getId(), throwable);
                        }

                        public void run() throws Exception {
                            objectPluginAction.setActivePart(iWorkbenchPart);
                            objectPluginAction.selectionChanged((ISelection)iStructuredSelection);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)iSafeRunnable);
                }
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean contributeObjectMenus(IMenuManager iMenuManager, ISelectionProvider iSelectionProvider) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.currentContribution.menus == null) {
            return false;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return false;
        }
        int n = 0;
        while (n < this.currentContribution.menus.size()) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)this.currentContribution.menus.get(n);
            this.currentContribution.contributeMenu(iConfigurationElement, iMenuManager, true);
            ++n;
        }
        return true;
    }

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement iConfigurationElement) {
        return new ActionDescriptor(iConfigurationElement, 1);
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ObjectContribution();
    }

    @Override
    public boolean isApplicableTo(Object object) {
        if (!this.configRead) {
            this.readConfigElement();
        }
        if (this.canAdapt()) {
            Object object2 = LegacyResourceSupport.getAdapter(object, this.getObjectClass());
            if (object2 == null) {
                if (Policy.DEBUG_CONTRIBUTIONS) {
                    WorkbenchPlugin.log("Error adapting " + object.getClass().getName() + " to " + this.getObjectClass() + ". Contribution " + this.getID(this.config) + " is being ignored");
                }
            } else {
                object = object2;
            }
        }
        if (!this.testName(object)) {
            return false;
        }
        return ((ObjectContribution)this.currentContribution).isApplicableTo(object);
    }

    private void readConfigElement() {
        this.currentContribution = this.createContribution();
        this.readElementChildren(this.config);
        this.configRead = true;
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (string.equals("visibility")) {
            ((ObjectContribution)this.currentContribution).setVisibilityTest(iConfigurationElement);
            return true;
        }
        if (string.equals("filter")) {
            ((ObjectContribution)this.currentContribution).addFilterTest(iConfigurationElement);
            return true;
        }
        if (string.equals("enablement")) {
            ((ObjectContribution)this.currentContribution).setEnablementTest(iConfigurationElement);
            return true;
        }
        return super.readElement(iConfigurationElement);
    }

    private boolean testName(Object object) {
        String string = this.config.getAttribute("nameFilter");
        if (string == null) {
            return true;
        }
        String string2 = null;
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Util.getAdapter(object, IWorkbenchAdapter.class);
        if (iWorkbenchAdapter != null) {
            string2 = iWorkbenchAdapter.getLabel(object);
        }
        if (string2 == null) {
            string2 = object.toString();
        }
        return SelectionEnabler.verifyNameMatch(string2, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IConfigurationElement[] iConfigurationElementArray = this.config.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string = iConfigurationElement.getAttribute("label");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IConfigurationElement.class)) {
            return this.config;
        }
        return null;
    }

    private static class ObjectContribution
    extends PluginActionBuilder.BasicContribution {
        private ObjectFilterTest filterTest;
        private ActionExpression visibilityTest;
        private Expression enablement;

        private ObjectContribution() {
        }

        public void addFilterTest(IConfigurationElement iConfigurationElement) {
            if (this.filterTest == null) {
                this.filterTest = new ObjectFilterTest();
            }
            this.filterTest.addFilterElement(iConfigurationElement);
        }

        public void setVisibilityTest(IConfigurationElement iConfigurationElement) {
            this.visibilityTest = new ActionExpression(iConfigurationElement);
        }

        public void setEnablementTest(IConfigurationElement iConfigurationElement) {
            try {
                this.enablement = ExpressionConverter.getDefault().perform(iConfigurationElement);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log(coreException);
            }
        }

        public boolean isApplicableTo(Object object) {
            boolean bl = true;
            if (this.visibilityTest != null) {
                boolean bl2 = bl = bl && this.visibilityTest.isEnabledFor(object);
                if (!bl) {
                    return bl;
                }
            } else if (this.filterTest != null) {
                boolean bl3 = bl = bl && this.filterTest.matches(object, true);
                if (!bl) {
                    return bl;
                }
            }
            if (this.enablement != null) {
                try {
                    EvaluationContext evaluationContext = new EvaluationContext(null, object);
                    evaluationContext.setAllowPluginActivation(true);
                    evaluationContext.addVariable("selection", object);
                    evaluationContext.addVariable("org.eclipse.core.runtime.Platform", Platform.class);
                    EvaluationResult evaluationResult = this.enablement.evaluate((IEvaluationContext)evaluationContext);
                    if (evaluationResult == EvaluationResult.FALSE) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.enablement = null;
                    WorkbenchPlugin.log(coreException);
                    bl = false;
                }
            }
            return bl;
        }
    }
}

