/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.NavigationHistoryEditorInfo;

public class NavigationHistoryEntry {
    private IWorkbenchPage page;
    NavigationHistoryEditorInfo editorInfo;
    String historyText;
    INavigationLocation location;
    private IMemento locationMemento;

    public NavigationHistoryEntry(NavigationHistoryEditorInfo navigationHistoryEditorInfo, IWorkbenchPage iWorkbenchPage, IEditorPart iEditorPart, INavigationLocation iNavigationLocation) {
        this.editorInfo = navigationHistoryEditorInfo;
        this.page = iWorkbenchPage;
        this.location = iNavigationLocation;
        if (iNavigationLocation != null) {
            this.historyText = iNavigationLocation.getText();
        }
        if ((this.historyText == null || this.historyText.length() == 0) && iEditorPart != null) {
            this.historyText = iEditorPart.getTitle();
        }
    }

    void restoreLocation() {
        if (this.editorInfo.editorInput != null && this.editorInfo.editorID != null) {
            try {
                IEditorPart iEditorPart = this.page.openEditor(this.editorInfo.editorInput, this.editorInfo.editorID, true);
                if (this.location == null && iEditorPart instanceof INavigationLocationProvider) {
                    this.location = ((INavigationLocationProvider)((Object)iEditorPart)).createEmptyNavigationLocation();
                }
                if (this.location != null) {
                    if (this.locationMemento != null) {
                        this.location.setInput(this.editorInfo.editorInput);
                        this.location.restoreState(this.locationMemento);
                        this.locationMemento = null;
                    }
                    this.location.restoreLocation();
                }
            }
            catch (PartInitException partInitException) {}
        }
    }

    String getHistoryText() {
        if (this.location != null) {
            String string = this.location.getText();
            if (string == null || string.equals("")) {
                string = this.historyText;
            } else {
                this.historyText = string;
            }
            return string;
        }
        return this.historyText;
    }

    boolean handlePartClosed() {
        if (!this.editorInfo.isPersistable()) {
            return false;
        }
        if (this.location != null) {
            this.locationMemento = XMLMemento.createWriteRoot("position");
            this.location.saveState(this.locationMemento);
            this.location.releaseState();
        }
        return true;
    }

    void saveState(IMemento iMemento, ArrayList arrayList) {
        iMemento.putString("historyLabel", this.getHistoryText());
        if (this.locationMemento != null) {
            IMemento iMemento2 = iMemento.createChild("position");
            iMemento2.putMemento(this.locationMemento);
        } else if (this.location != null) {
            IMemento iMemento3 = iMemento.createChild("position");
            this.location.saveState(iMemento3);
        }
    }

    void restoreState(IMemento iMemento) {
        this.historyText = iMemento.getString("historyLabel");
        this.locationMemento = iMemento.getChild("position");
    }

    public String toString() {
        return "Input<" + this.editorInfo.editorInput + "> Details<" + this.location + ">";
    }

    void dispose() {
        if (this.location != null) {
            this.location.dispose();
        }
        this.editorInfo = null;
    }

    boolean mergeInto(NavigationHistoryEntry navigationHistoryEntry) {
        if (this.editorInfo.editorInput != null && this.editorInfo.editorInput.equals(navigationHistoryEntry.editorInfo.editorInput)) {
            if (this.location != null) {
                if (navigationHistoryEntry.location == null) {
                    navigationHistoryEntry.location = this.location;
                    this.location = null;
                    return true;
                }
                return this.location.mergeInto(navigationHistoryEntry.location);
            }
            if (navigationHistoryEntry.location == null) {
                return true;
            }
        }
        return false;
    }
}

