/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class NavigationHistoryEditorInfo {
    String editorID;
    IEditorInput editorInput;
    int refCount = 0;
    IMemento memento;

    NavigationHistoryEditorInfo(IEditorPart iEditorPart) {
        this.editorID = iEditorPart.getSite().getId();
        this.editorInput = iEditorPart.getEditorInput();
    }

    NavigationHistoryEditorInfo(IMemento iMemento) {
        this.memento = iMemento;
    }

    boolean isPersistable() {
        if (this.editorInput != null) {
            IPersistableElement iPersistableElement = this.editorInput.getPersistable();
            return iPersistableElement != null;
        }
        return this.memento != null;
    }

    void handlePartClosed() {
        if (!this.isPersistable()) {
            return;
        }
        if (this.memento == null) {
            IPersistableElement iPersistableElement = this.editorInput.getPersistable();
            this.memento = XMLMemento.createWriteRoot("editor");
            this.memento.putString("id", this.editorID);
            this.memento.putString("factoryID", iPersistableElement.getFactoryId());
            iPersistableElement.saveState(this.memento);
        }
        this.editorID = null;
        this.editorInput = null;
    }

    void restoreEditor() {
        IAdaptable iAdaptable;
        if (this.memento == null) {
            return;
        }
        String string = this.memento.getString("factoryID");
        IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(string);
        if (iElementFactory != null && (iAdaptable = iElementFactory.createElement(this.memento)) instanceof IEditorInput) {
            this.editorInput = (IEditorInput)iAdaptable;
            this.editorID = this.memento.getString("id");
        }
        this.memento = null;
    }

    void saveState(IMemento iMemento) {
        if (this.editorInput != null) {
            IPersistableElement iPersistableElement = this.editorInput.getPersistable();
            iMemento.putString("id", this.editorID);
            iMemento.putString("factoryID", iPersistableElement.getFactoryId());
            iPersistableElement.saveState(iMemento);
        } else if (this.memento != null) {
            iMemento.putMemento(this.memento);
        }
    }
}

