/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistoryAction
extends PageEventAction {
    private boolean recreateMenu;
    private boolean forward;
    private Menu historyMenu;
    private int MAX_HISTORY_LENGTH = 9;

    private void setMenu(Menu menu) {
        this.historyMenu = menu;
    }

    private void initMenu() {
        this.historyMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                if (NavigationHistoryAction.this.recreateMenu) {
                    Menu menu = (Menu)menuEvent.widget;
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = 0;
                    while (n < menuItemArray.length) {
                        menuItemArray[n].dispose();
                        ++n;
                    }
                    NavigationHistoryAction.this.fillMenu(menu);
                }
            }
        });
    }

    private void fillMenu(Menu menu) {
        IWorkbenchPage iWorkbenchPage = this.getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        final NavigationHistory navigationHistory = (NavigationHistory)this.getWorkbenchWindow().getActivePage().getNavigationHistory();
        NavigationHistoryEntry[] navigationHistoryEntryArray = this.forward ? navigationHistory.getForwardEntries() : navigationHistory.getBackwardEntries();
        int[] nArray = new int[navigationHistoryEntryArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = 1;
            ++n;
        }
        navigationHistoryEntryArray = this.collapseEntries(navigationHistoryEntryArray, nArray);
        n = 0;
        while (n < navigationHistoryEntryArray.length) {
            if (n > this.MAX_HISTORY_LENGTH) break;
            String string = navigationHistoryEntryArray[n].getHistoryText();
            if (string != null) {
                MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setData((Object)navigationHistoryEntryArray[n]);
                if (nArray[n] > 1) {
                    string = NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_locations, (Object)string, (Object)new Integer(nArray[n]));
                }
                menuItem.setText(string);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        navigationHistory.shiftCurrentEntry((NavigationHistoryEntry)selectionEvent.widget.getData(), NavigationHistoryAction.this.forward);
                    }
                });
            }
            ++n;
        }
        this.recreateMenu = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.historyMenu != null) {
            int n = 0;
            while (n < this.historyMenu.getItemCount()) {
                MenuItem menuItem = this.historyMenu.getItem(n);
                menuItem.dispose();
                ++n;
            }
            this.historyMenu.dispose();
            this.historyMenu = null;
        }
    }

    public NavigationHistoryAction(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super("", iWorkbenchWindow);
        ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
        if (bl) {
            this.setText(WorkbenchMessages.NavigationHistoryAction_forward_text);
            this.setToolTipText(WorkbenchMessages.NavigationHistoryAction_forward_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.navigation_history_forward");
            this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.navigate.forwardHistory");
        } else {
            this.setText(WorkbenchMessages.NavigationHistoryAction_backward_text);
            this.setToolTipText(WorkbenchMessages.NavigationHistoryAction_backward_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.navigation_history_backward");
            this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.navigate.backwardHistory");
        }
        this.setEnabled(false);
        this.forward = bl;
        this.setMenuCreator(new MenuCreator());
    }

    @Override
    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        super.pageClosed(iWorkbenchPage);
        this.setEnabled(false);
    }

    private NavigationHistoryEntry[] collapseEntries(NavigationHistoryEntry[] navigationHistoryEntryArray, int[] nArray) {
        ArrayList<NavigationHistoryEntry> arrayList = new ArrayList<NavigationHistoryEntry>(Arrays.asList(navigationHistoryEntryArray));
        NavigationHistoryEntry navigationHistoryEntry = null;
        int n = -1;
        Iterator<NavigationHistoryEntry> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            NavigationHistoryEntry navigationHistoryEntry2 = iterator.next();
            if (navigationHistoryEntry != null && (string = navigationHistoryEntry.getHistoryText()) != null && string.equals(navigationHistoryEntry2.getHistoryText()) && navigationHistoryEntry.editorInfo == navigationHistoryEntry2.editorInfo) {
                iterator.remove();
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                continue;
            }
            navigationHistoryEntry = navigationHistoryEntry2;
            ++n;
        }
        navigationHistoryEntryArray = new NavigationHistoryEntry[arrayList.size()];
        return arrayList.toArray(navigationHistoryEntryArray);
    }

    @Override
    public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        super.pageActivated(iWorkbenchPage);
        NavigationHistory navigationHistory = (NavigationHistory)iWorkbenchPage.getNavigationHistory();
        if (this.forward) {
            navigationHistory.setForwardAction(this);
        } else {
            navigationHistory.setBackwardAction(this);
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage != null) {
            NavigationHistory navigationHistory = (NavigationHistory)iWorkbenchPage.getNavigationHistory();
            if (this.forward) {
                navigationHistory.forward();
            } else {
                navigationHistory.backward();
            }
            this.recreateMenu = true;
        }
    }

    public void update() {
        WorkbenchPage workbenchPage = (WorkbenchPage)this.getActivePage();
        if (workbenchPage == null) {
            return;
        }
        NavigationHistory navigationHistory = (NavigationHistory)workbenchPage.getNavigationHistory();
        if (this.forward) {
            this.setEnabled(navigationHistory.canForward());
            NavigationHistoryEntry[] navigationHistoryEntryArray = navigationHistory.getForwardEntries();
            if (navigationHistoryEntryArray.length > 0) {
                NavigationHistoryEntry navigationHistoryEntry = navigationHistoryEntryArray[0];
                String string = NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_forward_toolTipName, (Object)navigationHistoryEntry.getHistoryText());
                this.setToolTipText(string);
            } else {
                this.setToolTipText(WorkbenchMessages.NavigationHistoryAction_forward_toolTip);
            }
        } else {
            this.setEnabled(navigationHistory.canBackward());
            NavigationHistoryEntry[] navigationHistoryEntryArray = navigationHistory.getBackwardEntries();
            if (navigationHistoryEntryArray.length > 0) {
                NavigationHistoryEntry navigationHistoryEntry = navigationHistoryEntryArray[0];
                String string = NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_backward_toolTipName, (Object)navigationHistoryEntry.getHistoryText());
                this.setToolTipText(string);
            } else {
                this.setToolTipText(WorkbenchMessages.NavigationHistoryAction_backward_toolTip);
            }
        }
        this.recreateMenu = true;
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Menu menu) {
            NavigationHistoryAction.this.setMenu(new Menu(menu));
            NavigationHistoryAction.this.fillMenu(NavigationHistoryAction.this.historyMenu);
            NavigationHistoryAction.this.initMenu();
            return NavigationHistoryAction.this.historyMenu;
        }

        public Menu getMenu(Control control) {
            NavigationHistoryAction.this.setMenu(new Menu(control));
            NavigationHistoryAction.this.fillMenu(NavigationHistoryAction.this.historyMenu);
            NavigationHistoryAction.this.initMenu();
            return NavigationHistoryAction.this.historyMenu;
        }
    }
}

