/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.NavigationHistoryEditorInfo;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;

public class NavigationHistory
implements INavigationHistory {
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 50;
    private NavigationHistoryAction backwardAction;
    private NavigationHistoryAction forwardAction;
    private int ignoreEntries;
    private ArrayList history = new ArrayList(50);
    Map perTabHistoryMap = new HashMap();
    private ArrayList editors = new ArrayList(50);
    private IWorkbenchPage page;
    private int activeEntry = 0;

    public NavigationHistory(final IWorkbenchPage iWorkbenchPage) {
        this.page = iWorkbenchPage;
        iWorkbenchPage.addPartListener(new IPartListener2(){

            @Override
            public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            }

            @Override
            public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                if (NavigationHistory.this.isPerTabHistoryEnabled() && iWorkbenchPartReference instanceof EditorReference && !((EditorReference)iWorkbenchPartReference).isDisposed()) {
                    PartPane partPane = ((EditorReference)iWorkbenchPartReference).getPane();
                    NavigationHistory.this.disposeHistoryForTab(partPane);
                    NavigationHistory.this.updateActions();
                }
                this.updateNavigationHistory(iWorkbenchPartReference, true);
            }

            @Override
            public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
                this.updateNavigationHistory(iWorkbenchPartReference, false);
            }

            private void updateNavigationHistory(IWorkbenchPartReference iWorkbenchPartReference, boolean bl) {
                if (iWorkbenchPartReference != null && iWorkbenchPartReference.getPart(false) instanceof IEditorPart) {
                    IEditorPart iEditorPart = (IEditorPart)iWorkbenchPartReference.getPart(false);
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    String string = iEditorPart.getSite().getId();
                    Iterator iterator = NavigationHistory.this.editors.iterator();
                    NavigationHistoryEditorInfo navigationHistoryEditorInfo = null;
                    NavigationHistoryEditorInfo navigationHistoryEditorInfo2 = null;
                    NavigationHistoryEntry navigationHistoryEntry = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                    if (navigationHistoryEntry != null) {
                        navigationHistoryEditorInfo2 = navigationHistoryEntry.editorInfo;
                    }
                    while (iterator.hasNext()) {
                        navigationHistoryEditorInfo = (NavigationHistoryEditorInfo)iterator.next();
                        if (string.equals(navigationHistoryEditorInfo.editorID) && iEditorInput.equals(navigationHistoryEditorInfo.editorInput)) {
                            if (!bl || navigationHistoryEditorInfo == navigationHistoryEditorInfo2) break;
                            navigationHistoryEditorInfo.handlePartClosed();
                            break;
                        }
                        navigationHistoryEditorInfo = null;
                    }
                    if (navigationHistoryEditorInfo == null) {
                        return;
                    }
                    boolean bl2 = false;
                    iterator = NavigationHistory.this.history.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        NavigationHistoryEntry navigationHistoryEntry2 = (NavigationHistoryEntry)iterator.next();
                        if (navigationHistoryEntry2.editorInfo != navigationHistoryEditorInfo) continue;
                        if (!navigationHistoryEntry2.handlePartClosed()) {
                            if (n < NavigationHistory.this.activeEntry) {
                                NavigationHistory navigationHistory = NavigationHistory.this;
                                navigationHistory.activeEntry = navigationHistory.activeEntry - 1;
                            } else if (n == NavigationHistory.this.activeEntry) {
                                if (n != 0) {
                                    NavigationHistory navigationHistory = NavigationHistory.this;
                                    navigationHistory.activeEntry = navigationHistory.activeEntry - 1;
                                }
                            } else {
                                ++n;
                            }
                            bl2 = true;
                            iterator.remove();
                            NavigationHistory.this.disposeEntry(navigationHistoryEntry2);
                            continue;
                        }
                        ++n;
                    }
                    if (!bl2 && iWorkbenchPage.getActiveEditor() == null && NavigationHistory.this.activeEntry < NavigationHistory.this.history.size()) {
                        NavigationHistory navigationHistory = NavigationHistory.this;
                        navigationHistory.activeEntry = navigationHistory.activeEntry + 1;
                    }
                    NavigationHistory.this.updateActions();
                }
            }
        });
    }

    private Display getDisplay() {
        return this.page.getWorkbenchWindow().getShell().getDisplay();
    }

    private boolean isPerTabHistoryEnabled() {
        return ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).isPerTabHistoryEnabled();
    }

    public void markEditor(final IEditorPart iEditorPart) {
        if (this.ignoreEntries > 0 || iEditorPart == null) {
            return;
        }
        ++this.ignoreEntries;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NavigationHistory navigationHistory = NavigationHistory.this;
                int n = navigationHistory.ignoreEntries - 1;
                navigationHistory.ignoreEntries = n;
                if (n == 0 && iEditorPart.getEditorSite() instanceof EditorSite) {
                    EditorSite editorSite = (EditorSite)iEditorPart.getEditorSite();
                    Control control = editorSite.getPane().getControl();
                    if (control == null || control.isDisposed()) {
                        return;
                    }
                    NavigationHistoryEntry navigationHistoryEntry = NavigationHistory.this.getEntry(NavigationHistory.this.activeEntry);
                    if (navigationHistoryEntry != null && iEditorPart.getEditorInput() != navigationHistoryEntry.editorInfo.editorInput) {
                        NavigationHistory.this.updateEntry(navigationHistoryEntry);
                    }
                    NavigationHistory.this.addEntry(iEditorPart);
                }
            }
        });
    }

    @Override
    public void markLocation(IEditorPart iEditorPart) {
        this.addEntry(iEditorPart);
    }

    NavigationHistoryEntry[] getBackwardEntries() {
        if (this.isPerTabHistoryEnabled()) {
            return this.getEntriesForTab(false);
        }
        int n = this.activeEntry;
        NavigationHistoryEntry[] navigationHistoryEntryArray = new NavigationHistoryEntry[n];
        int n2 = 0;
        while (n2 < this.activeEntry) {
            navigationHistoryEntryArray[this.activeEntry - 1 - n2] = this.getEntry(n2);
            ++n2;
        }
        return navigationHistoryEntryArray;
    }

    NavigationHistoryEntry[] getForwardEntries() {
        if (this.isPerTabHistoryEnabled()) {
            return this.getEntriesForTab(true);
        }
        int n = this.history.size() - this.activeEntry - 1;
        n = Math.max(0, n);
        NavigationHistoryEntry[] navigationHistoryEntryArray = new NavigationHistoryEntry[n];
        int n2 = this.activeEntry + 1;
        while (n2 < this.history.size()) {
            navigationHistoryEntryArray[n2 - this.activeEntry - 1] = this.getEntry(n2);
            ++n2;
        }
        return navigationHistoryEntryArray;
    }

    @Override
    public INavigationLocation[] getLocations() {
        INavigationLocation[] iNavigationLocationArray = new INavigationLocation[this.history.size()];
        int n = 0;
        while (n < iNavigationLocationArray.length) {
            NavigationHistoryEntry navigationHistoryEntry = (NavigationHistoryEntry)this.history.get(n);
            iNavigationLocationArray[n] = navigationHistoryEntry.location;
            ++n;
        }
        return iNavigationLocationArray;
    }

    @Override
    public INavigationLocation getCurrentLocation() {
        NavigationHistoryEntry navigationHistoryEntry = this.getEntry(this.activeEntry);
        return navigationHistoryEntry == null ? null : navigationHistoryEntry.location;
    }

    public void dispose() {
        this.disposeHistoryForTabs();
        for (NavigationHistoryEntry navigationHistoryEntry : this.history) {
            this.disposeEntry(navigationHistoryEntry);
        }
    }

    void setForwardAction(NavigationHistoryAction navigationHistoryAction) {
        this.forwardAction = navigationHistoryAction;
        this.updateActions();
    }

    void setBackwardAction(NavigationHistoryAction navigationHistoryAction) {
        this.backwardAction = navigationHistoryAction;
        this.updateActions();
    }

    private NavigationHistoryEntry getEntry(int n) {
        if (n >= 0 && n < this.history.size()) {
            return (NavigationHistoryEntry)this.history.get(n);
        }
        return null;
    }

    private void add(NavigationHistoryEntry navigationHistoryEntry) {
        this.removeForwardEntries();
        if (this.history.size() == 50) {
            NavigationHistoryEntry navigationHistoryEntry2 = (NavigationHistoryEntry)this.history.remove(0);
            this.disposeEntry(navigationHistoryEntry2);
        }
        this.history.add(navigationHistoryEntry);
        this.activeEntry = this.history.size() - 1;
    }

    private void removeForwardEntries() {
        int n = this.history.size();
        int n2 = this.activeEntry + 1;
        while (n2 < n) {
            NavigationHistoryEntry navigationHistoryEntry = (NavigationHistoryEntry)this.history.remove(this.activeEntry + 1);
            this.disposeEntry(navigationHistoryEntry);
            ++n2;
        }
    }

    private void addEntry(IEditorPart iEditorPart) {
        NavigationHistoryEntry navigationHistoryEntry;
        if (this.ignoreEntries > 0 || iEditorPart == null) {
            return;
        }
        if (this.isPerTabHistoryEnabled()) {
            this.markLocationForTab(iEditorPart);
        }
        INavigationLocation iNavigationLocation = null;
        if (iEditorPart instanceof INavigationLocationProvider) {
            iNavigationLocation = ((INavigationLocationProvider)((Object)iEditorPart)).createNavigationLocation();
        }
        if ((navigationHistoryEntry = this.getEntry(this.activeEntry)) != null && navigationHistoryEntry.editorInfo.memento != null) {
            navigationHistoryEntry.editorInfo.restoreEditor();
            this.checkDuplicates(navigationHistoryEntry.editorInfo);
        }
        NavigationHistoryEntry navigationHistoryEntry2 = this.createEntry(this.page, iEditorPart, iNavigationLocation);
        if (navigationHistoryEntry == null) {
            this.add(navigationHistoryEntry2);
        } else if (navigationHistoryEntry2.mergeInto(navigationHistoryEntry)) {
            this.disposeEntry(navigationHistoryEntry2);
            this.removeForwardEntries();
        } else {
            this.add(navigationHistoryEntry2);
        }
        this.printEntries("added entry");
        this.updateActions();
    }

    private void printEntries(String string) {
    }

    boolean canForward() {
        if (this.isPerTabHistoryEnabled()) {
            return this.hasEntriesForTab(true);
        }
        return this.activeEntry + 1 >= 0 && this.activeEntry + 1 < this.history.size();
    }

    boolean canBackward() {
        if (this.isPerTabHistoryEnabled()) {
            return this.hasEntriesForTab(false);
        }
        return this.activeEntry - 1 >= 0 && this.activeEntry - 1 < this.history.size();
    }

    private void updateActions() {
        if (this.backwardAction != null) {
            this.backwardAction.update();
        }
        if (this.forwardAction != null) {
            this.forwardAction.update();
        }
    }

    private void gotoEntry(NavigationHistoryEntry navigationHistoryEntry) {
        if (navigationHistoryEntry == null) {
            return;
        }
        try {
            ++this.ignoreEntries;
            if (navigationHistoryEntry.editorInfo.memento != null) {
                navigationHistoryEntry.editorInfo.restoreEditor();
                this.checkDuplicates(navigationHistoryEntry.editorInfo);
            }
            navigationHistoryEntry.restoreLocation();
            this.updateActions();
            this.printEntries("goto entry");
        }
        finally {
            --this.ignoreEntries;
        }
    }

    private void updateEntry(NavigationHistoryEntry navigationHistoryEntry) {
        if (navigationHistoryEntry == null || navigationHistoryEntry.location == null) {
            return;
        }
        navigationHistoryEntry.location.update();
        this.printEntries("updateEntry");
    }

    void forward() {
        if (this.isPerTabHistoryEnabled()) {
            this.forwardForTab();
            return;
        }
        if (this.canForward()) {
            this.shiftEntry(true);
        }
    }

    void backward() {
        if (this.isPerTabHistoryEnabled()) {
            this.backwardForTab();
            return;
        }
        if (this.canBackward()) {
            this.shiftEntry(false);
        }
    }

    private void shiftEntry(boolean bl) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = bl ? ++this.activeEntry : --this.activeEntry;
        NavigationHistoryEntry navigationHistoryEntry = this.getEntry(this.activeEntry);
        if (navigationHistoryEntry != null) {
            this.gotoEntry(navigationHistoryEntry);
        }
    }

    void shiftCurrentEntry(NavigationHistoryEntry navigationHistoryEntry, boolean bl) {
        if (this.isPerTabHistoryEnabled()) {
            this.gotoEntryForTab(navigationHistoryEntry, bl);
            return;
        }
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = this.history.indexOf(navigationHistoryEntry);
        this.gotoEntry(navigationHistoryEntry);
    }

    void saveState(IMemento iMemento) {
        NavigationHistoryEntry navigationHistoryEntry;
        Object object;
        NavigationHistoryEntry navigationHistoryEntry2 = this.getEntry(this.activeEntry);
        if (navigationHistoryEntry2 == null || !navigationHistoryEntry2.editorInfo.isPersistable()) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.editors.clone();
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (NavigationHistoryEditorInfo)object2.next();
            if (((NavigationHistoryEditorInfo)object).isPersistable()) continue;
            object2.remove();
        }
        object2 = iMemento.createChild("editors");
        for (NavigationHistoryEditorInfo navigationHistoryEditorInfo : arrayList) {
            navigationHistoryEditorInfo.saveState(object2.createChild("editor"));
        }
        object = new ArrayList<NavigationHistoryEntry>(this.history.size());
        int n = this.history.size();
        int n2 = 0;
        while (n2 < n) {
            navigationHistoryEntry = (NavigationHistoryEntry)this.history.get(n2);
            if (navigationHistoryEntry.editorInfo.isPersistable()) {
                ((ArrayList)object).add(navigationHistoryEntry);
            }
            ++n2;
        }
        n = ((ArrayList)object).size();
        n2 = 0;
        while (n2 < n) {
            navigationHistoryEntry = (NavigationHistoryEntry)((ArrayList)object).get(n2);
            IMemento iMemento2 = iMemento.createChild("item");
            if (navigationHistoryEntry == navigationHistoryEntry2) {
                iMemento2.putString("active", "true");
            }
            navigationHistoryEntry.saveState(iMemento2, (ArrayList)object);
            iMemento2.putInteger("index", arrayList.indexOf(navigationHistoryEntry.editorInfo));
            ++n2;
        }
    }

    void restoreState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("editors");
        IMemento[] iMementoArray = iMemento.getChildren("item");
        if (iMementoArray.length == 0 || iMemento2 == null) {
            if (this.page.getActiveEditor() != null) {
                this.markLocation(this.page.getActiveEditor());
            }
            return;
        }
        IMemento[] iMementoArray2 = iMemento2.getChildren("editor");
        NavigationHistoryEditorInfo[] navigationHistoryEditorInfoArray = new NavigationHistoryEditorInfo[iMementoArray2.length];
        int n = 0;
        while (n < navigationHistoryEditorInfoArray.length) {
            navigationHistoryEditorInfoArray[n] = new NavigationHistoryEditorInfo(iMementoArray2[n]);
            this.editors.add(navigationHistoryEditorInfoArray[n]);
            ++n;
        }
        n = 0;
        while (n < iMementoArray.length) {
            IMemento iMemento3 = iMementoArray[n];
            int n2 = iMemento3.getInteger("index");
            NavigationHistoryEditorInfo navigationHistoryEditorInfo = navigationHistoryEditorInfoArray[n2];
            ++navigationHistoryEditorInfo.refCount;
            NavigationHistoryEntry navigationHistoryEntry = new NavigationHistoryEntry(navigationHistoryEditorInfo, this.page, null, null);
            this.history.add(navigationHistoryEntry);
            navigationHistoryEntry.restoreState(iMemento3);
            if (iMemento3.getString("active") != null) {
                this.activeEntry = n;
            }
            ++n;
        }
        final NavigationHistoryEntry navigationHistoryEntry = this.getEntry(this.activeEntry);
        if (navigationHistoryEntry != null && navigationHistoryEntry.editorInfo.editorInput != null && this.page.getActiveEditor() == this.page.findEditor(navigationHistoryEntry.editorInfo.editorInput)) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    NavigationHistory.this.gotoEntry(navigationHistoryEntry);
                }
            });
        }
    }

    public NavigationHistoryEntry createEntry(IWorkbenchPage iWorkbenchPage, IEditorPart iEditorPart, INavigationLocation iNavigationLocation) {
        String string = iEditorPart.getSite().getId();
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        NavigationHistoryEditorInfo navigationHistoryEditorInfo2 = null;
        for (NavigationHistoryEditorInfo navigationHistoryEditorInfo2 : this.editors) {
            if (string.equals(navigationHistoryEditorInfo2.editorID) && iEditorInput.equals(navigationHistoryEditorInfo2.editorInput)) {
                ++navigationHistoryEditorInfo2.refCount;
                break;
            }
            navigationHistoryEditorInfo2 = null;
        }
        if (navigationHistoryEditorInfo2 == null) {
            navigationHistoryEditorInfo2 = new NavigationHistoryEditorInfo(iEditorPart);
            ++navigationHistoryEditorInfo2.refCount;
            this.editors.add(navigationHistoryEditorInfo2);
        }
        return new NavigationHistoryEntry(navigationHistoryEditorInfo2, iWorkbenchPage, iEditorPart, iNavigationLocation);
    }

    public void disposeEntry(NavigationHistoryEntry navigationHistoryEntry) {
        if (navigationHistoryEntry.editorInfo == null) {
            return;
        }
        --navigationHistoryEntry.editorInfo.refCount;
        if (navigationHistoryEntry.editorInfo.refCount == 0) {
            this.editors.remove(navigationHistoryEntry.editorInfo);
        }
        navigationHistoryEntry.dispose();
    }

    void checkDuplicates(NavigationHistoryEditorInfo navigationHistoryEditorInfo) {
        NavigationHistoryEditorInfo navigationHistoryEditorInfo22 = null;
        if (navigationHistoryEditorInfo.editorInput == null) {
            return;
        }
        for (NavigationHistoryEditorInfo navigationHistoryEditorInfo22 : this.editors) {
            if (navigationHistoryEditorInfo != navigationHistoryEditorInfo22 && navigationHistoryEditorInfo.editorID.equals(navigationHistoryEditorInfo22.editorID) && navigationHistoryEditorInfo.editorInput.equals(navigationHistoryEditorInfo22.editorInput)) break;
            navigationHistoryEditorInfo22 = null;
        }
        if (navigationHistoryEditorInfo22 == null) {
            return;
        }
        for (NavigationHistoryEntry navigationHistoryEntry : this.history) {
            if (navigationHistoryEntry.editorInfo != navigationHistoryEditorInfo22) continue;
            navigationHistoryEntry.editorInfo = navigationHistoryEditorInfo;
            ++navigationHistoryEditorInfo.refCount;
        }
        this.editors.remove(navigationHistoryEditorInfo22);
    }

    private void setNewCurrentEntryForTab(PerTabHistory perTabHistory, NavigationHistoryEntry navigationHistoryEntry) {
        if (perTabHistory.currentEntry != null) {
            perTabHistory.backwardEntries.addFirst(perTabHistory.currentEntry);
        }
        perTabHistory.currentEntry = navigationHistoryEntry;
        this.removeEntriesForTab(perTabHistory.forwardEntries);
    }

    private Object getCookieForTab(IEditorPart iEditorPart) {
        PartSite partSite;
        WorkbenchPartReference workbenchPartReference;
        IWorkbenchPartSite iWorkbenchPartSite;
        if (iEditorPart != null && (iWorkbenchPartSite = iEditorPart.getSite()) instanceof PartSite && !(workbenchPartReference = (WorkbenchPartReference)(partSite = (PartSite)iWorkbenchPartSite).getPartReference()).isDisposed()) {
            return partSite.getPane();
        }
        return null;
    }

    private void markLocationForTab(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ErrorEditorPart) {
            this.updateActions();
            return;
        }
        Object object = this.getCookieForTab(iEditorPart);
        if (object != null) {
            NavigationHistoryEntry navigationHistoryEntry;
            PerTabHistory perTabHistory;
            INavigationLocation iNavigationLocation = null;
            if (iEditorPart instanceof INavigationLocationProvider) {
                iNavigationLocation = ((INavigationLocationProvider)((Object)iEditorPart)).createNavigationLocation();
            }
            if ((perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) == null) {
                perTabHistory = new PerTabHistory();
                this.perTabHistoryMap.put(object, perTabHistory);
            }
            if ((navigationHistoryEntry = perTabHistory.currentEntry) != null && navigationHistoryEntry.editorInfo.memento != null) {
                navigationHistoryEntry.editorInfo.restoreEditor();
                this.checkDuplicates(navigationHistoryEntry.editorInfo);
            }
            NavigationHistoryEntry navigationHistoryEntry2 = this.createEntry(this.page, iEditorPart, iNavigationLocation);
            if (navigationHistoryEntry != null && navigationHistoryEntry2.mergeInto(navigationHistoryEntry)) {
                this.disposeEntry(navigationHistoryEntry2);
                this.removeEntriesForTab(perTabHistory.forwardEntries);
            } else {
                this.setNewCurrentEntryForTab(perTabHistory, navigationHistoryEntry2);
            }
        }
        this.updateActions();
    }

    public void updateCookieForTab(Object object, Object object2) {
        if (object2.equals(object)) {
            return;
        }
        PerTabHistory perTabHistory = (PerTabHistory)this.perTabHistoryMap.remove(object);
        if (perTabHistory != null) {
            this.perTabHistoryMap.put(object2, perTabHistory);
        }
    }

    private void gotoEntryForTab(NavigationHistoryEntry navigationHistoryEntry, boolean bl) {
        PerTabHistory perTabHistory;
        Object object = this.getCookieForTab(this.page.getActiveEditor());
        if (object != null && (perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) != null) {
            LinkedList linkedList;
            LinkedList linkedList2 = bl ? perTabHistory.forwardEntries : perTabHistory.backwardEntries;
            LinkedList linkedList3 = linkedList = bl ? perTabHistory.backwardEntries : perTabHistory.forwardEntries;
            if (perTabHistory.currentEntry != null) {
                if (perTabHistory.currentEntry.location != null) {
                    perTabHistory.currentEntry.location.update();
                }
                linkedList.addFirst(perTabHistory.currentEntry);
            }
            NavigationHistoryEntry navigationHistoryEntry2 = null;
            while (!linkedList2.isEmpty() && navigationHistoryEntry2 == null) {
                NavigationHistoryEntry navigationHistoryEntry3 = (NavigationHistoryEntry)linkedList2.removeFirst();
                if (navigationHistoryEntry3.equals(navigationHistoryEntry)) {
                    navigationHistoryEntry2 = navigationHistoryEntry3;
                    continue;
                }
                linkedList.addFirst(navigationHistoryEntry3);
            }
            Assert.isTrue((navigationHistoryEntry2 != null ? 1 : 0) != 0);
            perTabHistory.currentEntry = navigationHistoryEntry2;
            try {
                ++this.ignoreEntries;
                if (navigationHistoryEntry2.editorInfo.memento != null) {
                    navigationHistoryEntry2.editorInfo.restoreEditor();
                    this.checkDuplicates(navigationHistoryEntry2.editorInfo);
                }
                navigationHistoryEntry2.restoreLocation();
                this.updateActions();
            }
            finally {
                --this.ignoreEntries;
            }
        }
    }

    private void forwardForTab() {
        PerTabHistory perTabHistory;
        Object object = this.getCookieForTab(this.page.getActiveEditor());
        if (object != null && (perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) != null && !perTabHistory.forwardEntries.isEmpty()) {
            NavigationHistoryEntry navigationHistoryEntry = (NavigationHistoryEntry)perTabHistory.forwardEntries.removeFirst();
            if (perTabHistory.currentEntry != null) {
                INavigationLocation iNavigationLocation = perTabHistory.currentEntry.location;
                if (iNavigationLocation != null) {
                    iNavigationLocation.update();
                }
                perTabHistory.backwardEntries.addFirst(perTabHistory.currentEntry);
            }
            perTabHistory.currentEntry = navigationHistoryEntry;
            try {
                ++this.ignoreEntries;
                if (navigationHistoryEntry.editorInfo.memento != null) {
                    navigationHistoryEntry.editorInfo.restoreEditor();
                    this.checkDuplicates(navigationHistoryEntry.editorInfo);
                }
                navigationHistoryEntry.restoreLocation();
                this.updateActions();
            }
            finally {
                --this.ignoreEntries;
            }
        }
    }

    private void backwardForTab() {
        PerTabHistory perTabHistory;
        Object object = this.getCookieForTab(this.page.getActiveEditor());
        if (object != null && (perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) != null && !perTabHistory.backwardEntries.isEmpty()) {
            NavigationHistoryEntry navigationHistoryEntry = (NavigationHistoryEntry)perTabHistory.backwardEntries.removeFirst();
            if (perTabHistory.currentEntry != null) {
                perTabHistory.currentEntry.location.update();
                perTabHistory.forwardEntries.addFirst(perTabHistory.currentEntry);
            }
            perTabHistory.currentEntry = navigationHistoryEntry;
            try {
                ++this.ignoreEntries;
                if (navigationHistoryEntry.editorInfo.memento != null) {
                    navigationHistoryEntry.editorInfo.restoreEditor();
                    this.checkDuplicates(navigationHistoryEntry.editorInfo);
                }
                navigationHistoryEntry.restoreLocation();
                this.updateActions();
            }
            finally {
                --this.ignoreEntries;
            }
        }
    }

    private boolean hasEntriesForTab(boolean bl) {
        PerTabHistory perTabHistory;
        Object object = this.getCookieForTab(this.page.getActiveEditor());
        if (object != null && (perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) != null) {
            LinkedList linkedList = bl ? perTabHistory.forwardEntries : perTabHistory.backwardEntries;
            return !linkedList.isEmpty();
        }
        return false;
    }

    private NavigationHistoryEntry[] getEntriesForTab(boolean bl) {
        PerTabHistory perTabHistory;
        Object object = this.getCookieForTab(this.page.getActiveEditor());
        if (object != null && (perTabHistory = (PerTabHistory)this.perTabHistoryMap.get(object)) != null) {
            LinkedList linkedList = bl ? perTabHistory.forwardEntries : perTabHistory.backwardEntries;
            return linkedList.toArray(new NavigationHistoryEntry[linkedList.size()]);
        }
        return new NavigationHistoryEntry[0];
    }

    private void disposeHistoryForTabs() {
        Object[] objectArray = this.perTabHistoryMap.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.disposeHistoryForTab(objectArray[n]);
            ++n;
        }
    }

    void disposeHistoryForTab(Object object) {
        PerTabHistory perTabHistory = (PerTabHistory)this.perTabHistoryMap.remove(object);
        if (perTabHistory != null) {
            if (perTabHistory.currentEntry != null) {
                this.disposeEntry(perTabHistory.currentEntry);
                perTabHistory.currentEntry = null;
            }
            this.removeEntriesForTab(perTabHistory.backwardEntries);
            this.removeEntriesForTab(perTabHistory.forwardEntries);
        }
    }

    private void removeEntriesForTab(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NavigationHistoryEntry navigationHistoryEntry = (NavigationHistoryEntry)iterator.next();
            this.disposeEntry(navigationHistoryEntry);
            iterator.remove();
        }
    }

    public boolean updateActive(IEditorPart iEditorPart) {
        NavigationHistoryEntry navigationHistoryEntry = this.getEntry(this.activeEntry);
        if (navigationHistoryEntry == null) {
            return false;
        }
        IWorkbenchPartSite iWorkbenchPartSite = iEditorPart.getSite();
        if (iWorkbenchPartSite == null) {
            return false;
        }
        String string = iWorkbenchPartSite.getId();
        if (string == null) {
            return false;
        }
        if (!string.equals(navigationHistoryEntry.editorInfo.editorID)) {
            return false;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput == null) {
            return false;
        }
        if (!iEditorInput.equals(navigationHistoryEntry.editorInfo.editorInput)) {
            return false;
        }
        this.updateEntry(navigationHistoryEntry);
        return true;
    }

    private static class PerTabHistory {
        LinkedList backwardEntries = new LinkedList();
        NavigationHistoryEntry currentEntry = null;
        LinkedList forwardEntries = new LinkedList();

        private PerTabHistory() {
        }
    }
}

