/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.MultiEditor;

public class MultiEditorInnerPane
extends EditorPane {
    EditorPane parentPane;
    boolean multiEditorCompatibilityMode;

    public MultiEditorInnerPane(EditorPane editorPane, IEditorReference iEditorReference, WorkbenchPage workbenchPage, EditorStack editorStack, boolean bl) {
        super(iEditorReference, workbenchPage, editorStack);
        this.parentPane = editorPane;
        this.multiEditorCompatibilityMode = bl;
    }

    AbstractMultiEditor getMultiEditor() {
        return (AbstractMultiEditor)this.parentPane.getPartReference().getPart(true);
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        if (!this.multiEditorCompatibilityMode) {
            Control control = this.getControl();
            control.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26) {
                        IEditorPart iEditorPart = (IEditorPart)MultiEditorInnerPane.this.getEditorReference().getPart(true);
                        AbstractMultiEditor abstractMultiEditor = MultiEditorInnerPane.this.getMultiEditor();
                        abstractMultiEditor.activateEditor(iEditorPart);
                        abstractMultiEditor.setFocus();
                    }
                }
            });
            control.setVisible(true);
        }
    }

    public EditorPane getParentPane() {
        return this.parentPane;
    }

    private void updateGradient() {
        IEditorPart iEditorPart;
        AbstractMultiEditor abstractMultiEditor = this.getMultiEditor();
        if (abstractMultiEditor != null && this.multiEditorCompatibilityMode && (iEditorPart = (IEditorPart)this.getEditorReference().getPart(true)) != null) {
            ((MultiEditor)abstractMultiEditor).updateGradient(iEditorPart);
        }
    }

    @Override
    public void showFocus(boolean bl) {
        super.showFocus(bl);
        this.updateGradient();
    }

    @Override
    void shellDeactivated() {
        super.shellDeactivated();
        this.updateGradient();
    }

    @Override
    void shellActivated() {
        super.shellActivated();
        this.updateGradient();
    }
}

