/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public final class LegacyResourceSupport {
    private static String[] resourceClassNames = new String[]{"org.eclipse.core.resources.IResource", "org.eclipse.core.resources.IContainer", "org.eclipse.core.resources.IFolder", "org.eclipse.core.resources.IProject", "org.eclipse.core.resources.IFile"};
    private static Class iresourceClass = null;
    private static Class ifileClass;
    private static Class icontributorResourceAdapterClass;
    private static Method getAdaptedResourceMethod;
    private static Method getAdaptedResourceMappingMethod;
    private static Class icontributorResourceAdapter2Class;
    private static Class defaultContributorResourceAdapterClass;
    private static Object defaultContributorResourceAdapter;
    private static Class resourceMappingClass;
    private static boolean resourceAdapterPossible;

    static {
        icontributorResourceAdapterClass = null;
        getAdaptedResourceMethod = null;
        getAdaptedResourceMappingMethod = null;
        icontributorResourceAdapter2Class = null;
        defaultContributorResourceAdapterClass = null;
        defaultContributorResourceAdapter = null;
        resourceMappingClass = null;
        resourceAdapterPossible = true;
    }

    public static Class getFileClass() {
        if (ifileClass != null) {
            return ifileClass;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.core.resources", "org.eclipse.core.resources.IFile");
        if (clazz != null) {
            ifileClass = clazz;
        }
        return clazz;
    }

    public static Class getResourceClass() {
        if (iresourceClass != null) {
            return iresourceClass;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.core.resources", "org.eclipse.core.resources.IResource");
        if (clazz != null) {
            iresourceClass = clazz;
        }
        return clazz;
    }

    public static Class getResourceMappingClass() {
        if (resourceMappingClass != null) {
            return resourceMappingClass;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.core.resources", "org.eclipse.core.resources.mapping.ResourceMapping");
        if (clazz != null) {
            resourceMappingClass = clazz;
        }
        return clazz;
    }

    public static Class getIContributorResourceAdapterClass() {
        if (icontributorResourceAdapterClass != null) {
            return icontributorResourceAdapterClass;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.ui.ide", "org.eclipse.ui.IContributorResourceAdapter");
        if (clazz != null) {
            icontributorResourceAdapterClass = clazz;
        }
        return clazz;
    }

    public static Class getIContributorResourceAdapter2Class() {
        if (icontributorResourceAdapter2Class != null) {
            return icontributorResourceAdapter2Class;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.ui.ide", "org.eclipse.ui.ide.IContributorResourceAdapter2");
        if (clazz != null) {
            icontributorResourceAdapter2Class = clazz;
        }
        return clazz;
    }

    private static Class loadClass(String string, String string2) {
        if (!resourceAdapterPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            resourceAdapterPossible = false;
            return null;
        }
        if (!BundleUtility.isActivated(bundle)) {
            resourceAdapterPossible = true;
            return null;
        }
        try {
            return bundle.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            resourceAdapterPossible = false;
            return null;
        }
    }

    public static Class getDefaultContributorResourceAdapterClass() {
        if (defaultContributorResourceAdapterClass != null) {
            return defaultContributorResourceAdapterClass;
        }
        Class clazz = LegacyResourceSupport.loadClass("org.eclipse.ui.ide", "org.eclipse.ui.internal.ide.DefaultContributorResourceAdapter");
        if (clazz != null) {
            defaultContributorResourceAdapterClass = clazz;
        }
        return clazz;
    }

    private static Object getDefaultContributorResourceAdapter() {
        if (defaultContributorResourceAdapter != null) {
            return defaultContributorResourceAdapter;
        }
        Class clazz = LegacyResourceSupport.getDefaultContributorResourceAdapterClass();
        if (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod("getDefault", new Class[0]);
                defaultContributorResourceAdapter = method.invoke(null, new Object[0]);
                return defaultContributorResourceAdapter;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }

    public static boolean isResourceType(String string) {
        int n = 0;
        while (n < resourceClassNames.length) {
            if (resourceClassNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isResourceMappingType(String string) {
        return string.equals("org.eclipse.core.resources.mapping.ResourceMapping");
    }

    private static boolean isInstanceOf(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && LegacyResourceSupport.isInstanceOf(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (LegacyResourceSupport.isInstanceOf(classArray[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Object getAdaptedContributorResource(Object object) {
        Class clazz = LegacyResourceSupport.getResourceClass();
        if (clazz == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return null;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class clazz2 = LegacyResourceSupport.getIContributorResourceAdapterClass();
            if (clazz2 == null) {
                return iAdaptable.getAdapter(clazz);
            }
            Object object2 = iAdaptable.getAdapter(clazz2);
            if (object2 == null && (object2 = LegacyResourceSupport.getDefaultContributorResourceAdapter()) == null) {
                return null;
            }
            Method method = LegacyResourceSupport.getContributorResourceAdapterGetAdaptedResourceMethod();
            if (method != null) {
                try {
                    return method.invoke(object2, iAdaptable);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        return null;
    }

    private static Method getContributorResourceAdapterGetAdaptedResourceMethod() {
        if (getAdaptedResourceMethod != null) {
            return getAdaptedResourceMethod;
        }
        Class clazz = LegacyResourceSupport.getIContributorResourceAdapterClass();
        if (clazz != null) {
            try {
                getAdaptedResourceMethod = clazz.getDeclaredMethod("getAdaptedResource", IAdaptable.class);
                return getAdaptedResourceMethod;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return null;
    }

    private static Method getContributorResourceAdapter2GetAdaptedResourceMappingMethod() {
        if (getAdaptedResourceMappingMethod != null) {
            return getAdaptedResourceMappingMethod;
        }
        Class clazz = LegacyResourceSupport.getIContributorResourceAdapter2Class();
        if (clazz != null) {
            try {
                getAdaptedResourceMappingMethod = clazz.getDeclaredMethod("getAdaptedResourceMapping", IAdaptable.class);
                return getAdaptedResourceMappingMethod;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return null;
    }

    public static Object getAdaptedContributorResourceMapping(Object object) {
        Class clazz = LegacyResourceSupport.getResourceMappingClass();
        if (clazz == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return null;
        }
        if (object instanceof IAdaptable) {
            Object object2;
            Object object3;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class clazz2 = LegacyResourceSupport.getIContributorResourceAdapterClass();
            if (clazz2 == null) {
                return iAdaptable.getAdapter(clazz);
            }
            Class clazz3 = LegacyResourceSupport.getIContributorResourceAdapter2Class();
            if (clazz3 == null) {
                return iAdaptable.getAdapter(clazz);
            }
            Object object4 = iAdaptable.getAdapter(clazz2);
            if (object4 != null && clazz3.isInstance(object4)) {
                object3 = object4;
            } else {
                object3 = LegacyResourceSupport.getDefaultContributorResourceAdapter();
                if (object3 == null) {
                    return null;
                }
            }
            Method method = LegacyResourceSupport.getContributorResourceAdapter2GetAdaptedResourceMappingMethod();
            if (method != null) {
                try {
                    object2 = method.invoke(object3, iAdaptable);
                    if (object2 != null) {
                        return object2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if ((object2 = LegacyResourceSupport.getAdaptedContributorResource(object)) != null) {
                return Platform.getAdapterManager().getAdapter(object2, clazz);
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter(object, clazz);
    }

    public static IStructuredSelection adaptSelection(IStructuredSelection iStructuredSelection, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        for (Object e : iStructuredSelection) {
            Object object = LegacyResourceSupport.getAdapter(e, string);
            if (object == null) continue;
            arrayList.add(object);
        }
        return new StructuredSelection(arrayList);
    }

    public static Object getAdapter(Object object, String string) {
        Object object2 = null;
        if (LegacyResourceSupport.isInstanceOf(object.getClass(), string)) {
            object2 = object;
        } else if (LegacyResourceSupport.isResourceType(string)) {
            object2 = LegacyResourceSupport.getAdaptedResource(object);
        } else if (LegacyResourceSupport.isResourceMappingType(string)) {
            Object object3;
            object2 = LegacyResourceSupport.getAdaptedResourceMapping(object);
            if (object2 == null && (object3 = LegacyResourceSupport.getAdaptedResource(object)) != null) {
                object2 = ((IAdaptable)object3).getAdapter(LegacyResourceSupport.getResourceMappingClass());
            }
        } else {
            object2 = Platform.getAdapterManager().loadAdapter(object, string);
        }
        return object2;
    }

    public static Object getAdaptedResource(Object object) {
        Class clazz = LegacyResourceSupport.getResourceClass();
        Object object2 = null;
        if (clazz != null) {
            object2 = clazz.isInstance(object) ? object : LegacyResourceSupport.getAdaptedContributorResource(object);
        }
        return object2;
    }

    public static Object getAdaptedResourceMapping(Object object) {
        Class clazz = LegacyResourceSupport.getResourceMappingClass();
        Object object2 = null;
        if (clazz != null) {
            object2 = clazz.isInstance(object) ? object : LegacyResourceSupport.getAdaptedContributorResourceMapping(object);
        }
        return object2;
    }

    private LegacyResourceSupport() {
    }
}

