/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.RectangleAnimationFeedbackBase;

public class LegacyAnimationFeedback
extends RectangleAnimationFeedbackBase {
    private static final int LINE_WIDTH = 1;
    private Region shellRegion;

    public LegacyAnimationFeedback(Shell shell, Rectangle rectangle, Rectangle rectangle2) {
        super(shell, rectangle, rectangle2);
    }

    @Override
    public void renderStep(AnimationEngine animationEngine) {
        if (this.shellRegion != null) {
            this.shellRegion.dispose();
            this.shellRegion = new Region((Device)this.getAnimationShell().getDisplay());
        }
        for (Rectangle rectangle : this.getCurrentRects(animationEngine.amount())) {
            Rectangle rectangle2 = Geometry.toControl((Control)this.getAnimationShell(), (Rectangle)rectangle);
            this.shellRegion.add(rectangle2);
            ++rectangle2.x;
            ++rectangle2.y;
            rectangle2.width = Math.max(0, rectangle2.width - 2);
            rectangle2.height = Math.max(0, rectangle2.height - 2);
            this.shellRegion.subtract(rectangle2);
        }
        this.getAnimationShell().setRegion(this.shellRegion);
        this.getAnimationShell().getDisplay().update();
    }

    @Override
    public void initialize(AnimationEngine animationEngine) {
        Color color = this.getAnimationShell().getDisplay().getSystemColor(17);
        this.getAnimationShell().setBackground(color);
        this.shellRegion = new Region((Device)this.getAnimationShell().getDisplay());
        this.getAnimationShell().setRegion(this.shellRegion);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.shellRegion.isDisposed()) {
            this.shellRegion.dispose();
        }
    }

    @Override
    public boolean jobInit(AnimationEngine animationEngine) {
        if (!super.jobInit(animationEngine)) {
            return false;
        }
        Rectangle rectangle = Geometry.copy((Rectangle)((Rectangle)this.getStartRects().get(0)));
        Iterator iterator = this.getStartRects().iterator();
        Iterator iterator2 = this.getEndRects().iterator();
        while (iterator.hasNext()) {
            rectangle.add((Rectangle)iterator.next());
            rectangle.add((Rectangle)iterator2.next());
        }
        this.getAnimationShell().setBounds(rectangle);
        this.getAnimationShell().setVisible(true);
        return true;
    }
}

