/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSashContainer;

public class LayoutTreeNode
extends LayoutTree {
    private LayoutTree[] children = new LayoutTree[2];

    public LayoutTreeNode(LayoutPartSash layoutPartSash) {
        super(layoutPartSash);
    }

    @Override
    public void flushChildren() {
        super.flushChildren();
        this.children[0].flushChildren();
        this.children[1].flushChildren();
    }

    @Override
    public LayoutPart findPart(Point point) {
        if (!this.children[0].isVisible()) {
            if (!this.children[1].isVisible()) {
                return null;
            }
            return this.children[1].findPart(point);
        }
        if (!this.children[1].isVisible()) {
            return this.children[0].findPart(point);
        }
        LayoutPartSash layoutPartSash = this.getSash();
        Rectangle rectangle = layoutPartSash.getBounds();
        if (layoutPartSash.isVertical()) {
            if (point.x < rectangle.x + rectangle.width / 2) {
                return this.children[0].findPart(point);
            }
            return this.children[1].findPart(point);
        }
        if (point.y < rectangle.y + rectangle.height / 2) {
            return this.children[0].findPart(point);
        }
        return this.children[1].findPart(point);
    }

    @Override
    public LayoutPart computeRelation(ArrayList arrayList) {
        PartSashContainer.RelationshipInfo relationshipInfo = new PartSashContainer.RelationshipInfo();
        relationshipInfo.relative = this.children[0].computeRelation(arrayList);
        relationshipInfo.part = this.children[1].computeRelation(arrayList);
        relationshipInfo.left = this.getSash().getLeft();
        relationshipInfo.right = this.getSash().getRight();
        relationshipInfo.relationship = this.getSash().isVertical() ? 2 : 4;
        arrayList.add(0, relationshipInfo);
        return relationshipInfo.relative;
    }

    @Override
    public void disposeSashes() {
        this.children[0].disposeSashes();
        this.children[1].disposeSashes();
        this.getSash().dispose();
    }

    @Override
    public LayoutTree find(LayoutPart layoutPart) {
        LayoutTree layoutTree = this.children[0].find(layoutPart);
        if (layoutTree != null) {
            return layoutTree;
        }
        layoutTree = this.children[1].find(layoutPart);
        return layoutTree;
    }

    @Override
    public LayoutPart findBottomRight() {
        if (this.children[1].isVisible()) {
            return this.children[1].findBottomRight();
        }
        return this.children[0].findBottomRight();
    }

    public LayoutTreeNode findCommonParent(LayoutPart layoutPart, LayoutPart layoutPart2) {
        return this.findCommonParent(layoutPart, layoutPart2, false, false);
    }

    LayoutTreeNode findCommonParent(LayoutPart layoutPart, LayoutPart layoutPart2, boolean bl, boolean bl2) {
        if (!bl) {
            boolean bl3 = bl = this.find(layoutPart) != null;
        }
        if (!bl2) {
            boolean bl4 = bl2 = this.find(layoutPart2) != null;
        }
        if (bl && bl2) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.findCommonParent(layoutPart, layoutPart2, bl, bl2);
    }

    @Override
    public LayoutTreeNode findSash(LayoutPartSash layoutPartSash) {
        if (this.getSash() == layoutPartSash) {
            return this;
        }
        LayoutTreeNode layoutTreeNode = this.children[0].findSash(layoutPartSash);
        if (layoutTreeNode != null) {
            return layoutTreeNode;
        }
        layoutTreeNode = this.children[1].findSash(layoutPartSash);
        if (layoutTreeNode != null) {
            return layoutTreeNode;
        }
        return null;
    }

    void findSashes(LayoutTree layoutTree, PartPane.Sashes sashes) {
        boolean bl;
        Sash sash = (Sash)this.getSash().getControl();
        boolean bl2 = bl = this.children[0] == layoutTree;
        if (sash != null) {
            LayoutPartSash layoutPartSash = this.getSash();
            if (bl) {
                if (layoutPartSash.isVertical()) {
                    if (sashes.right == null) {
                        sashes.right = sash;
                    }
                } else if (sashes.bottom == null) {
                    sashes.bottom = sash;
                }
            } else if (layoutPartSash.isVertical()) {
                if (sashes.left == null) {
                    sashes.left = sash;
                }
            } else if (sashes.top == null) {
                sashes.top = sash;
            }
        }
        if (this.getParent() != null) {
            this.getParent().findSashes(this, sashes);
        }
    }

    public LayoutPartSash getSash() {
        return (LayoutPartSash)this.part;
    }

    private int getSashSize() {
        return this.getSash().getSashSize();
    }

    @Override
    public boolean isVisible() {
        return this.children[0].isVisible() || this.children[1].isVisible();
    }

    LayoutTree remove(LayoutTree layoutTree) {
        this.getSash().dispose();
        if (this.parent == null) {
            if (this.children[0] == layoutTree) {
                this.children[1].setParent(null);
                return this.children[1];
            }
            this.children[0].setParent(null);
            return this.children[0];
        }
        LayoutTreeNode layoutTreeNode = this.parent;
        if (this.children[0] == layoutTree) {
            layoutTreeNode.replaceChild(this, this.children[1]);
        } else {
            layoutTreeNode.replaceChild(this, this.children[0]);
        }
        return layoutTreeNode;
    }

    void replaceChild(LayoutTree layoutTree, LayoutTree layoutTree2) {
        if (this.children[0] == layoutTree) {
            this.children[0] = layoutTree2;
        } else if (this.children[1] == layoutTree) {
            this.children[1] = layoutTree2;
        }
        layoutTree2.setParent(this);
        if (!this.children[0].isVisible() || !this.children[0].isVisible()) {
            this.getSash().dispose();
        }
        this.flushCache();
    }

    /*
     * Unable to fully structure code
     */
    public boolean sameDirection(boolean var1_1, LayoutTreeNode var2_2) {
        var3_3 = this.getSash().isVertical();
        if (var3_3 == var1_1) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (this == var2_2) {
                return true;
            }
            if (var2_2.children[0].isVisible() && var2_2.children[1].isVisible() && var2_2.getSash().isVertical() != var1_1) {
                return false;
            }
            var2_2 = var2_2.getParent();
lbl9:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl10:
        // 1 sources

        return true;
    }

    @Override
    public int doComputePreferredSize(boolean bl, int n, int n2, int n3) {
        int n4;
        LayoutTreeNode.assertValidSize(n2);
        LayoutTreeNode.assertValidSize(n);
        LayoutTreeNode.assertValidSize(n3);
        if (!this.children[0].isVisible()) {
            return this.children[1].computePreferredSize(bl, n, n2, n3);
        }
        if (!this.children[1].isVisible()) {
            return this.children[0].computePreferredSize(bl, n, n2, n3);
        }
        if (n == 0) {
            return 0;
        }
        if (bl == this.getSash().isVertical()) {
            ChildSizes childSizes = this.computeChildSizes(n, n2, this.getSash().getLeft(), this.getSash().getRight(), n3);
            return LayoutTreeNode.add(childSizes.left, LayoutTreeNode.add(childSizes.right, this.getSashSize()));
        }
        ChildSizes childSizes = this.computeChildSizes(n2, n, this.getSash().getLeft(), this.getSash().getRight(), n2);
        int n5 = this.children[0].computePreferredSize(bl, n, childSizes.left, n3);
        int n6 = n4 = this.children[1].computePreferredSize(bl, n, childSizes.right, n3);
        if (n5 > n4) {
            n6 = n5;
        }
        LayoutTreeNode.assertValidSize(n6);
        return n6;
    }

    ChildSizes computeChildSizes(int n, int n2, int n3, int n4, int n5) {
        Assert.isTrue((boolean)this.children[0].isVisible());
        Assert.isTrue((boolean)this.children[1].isVisible());
        LayoutTreeNode.assertValidSize(n);
        LayoutTreeNode.assertValidSize(n2);
        LayoutTreeNode.assertValidSize(n5);
        Assert.isTrue((n3 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n4 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n5 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n5 <= n ? 1 : 0) != 0);
        boolean bl = this.getSash().isVertical();
        if (n <= this.getSashSize()) {
            return new ChildSizes(0, 0, false);
        }
        if (n == Integer.MAX_VALUE) {
            if (n5 == Integer.MAX_VALUE) {
                return new ChildSizes(this.children[0].computeMaximumSize(bl, n2), this.children[1].computeMaximumSize(bl, n2), false);
            }
            if (n5 == 0) {
                return new ChildSizes(this.children[0].computeMinimumSize(bl, n2), this.children[1].computeMinimumSize(bl, n2), false);
            }
        }
        int n6 = n3 + n4;
        double d = n3;
        double d2 = n4;
        switch (this.getCompressionBias()) {
            case -1: {
                d = 0.0;
                break;
            }
            case 1: {
                d2 = 0.0;
                break;
            }
        }
        double d3 = d + d2;
        n5 = Math.max(0, LayoutTreeNode.subtract(n5, this.getSashSize()));
        n = Math.max(0, LayoutTreeNode.subtract(n, this.getSashSize()));
        int n7 = LayoutTreeNode.subtract(n5, n6);
        int n8 = this.children[0].computeMinimumSize(bl, n2);
        int n9 = this.children[1].computeMinimumSize(bl, n2);
        int n10 = this.children[0].computeMaximumSize(bl, n2);
        int n11 = this.children[1].computeMaximumSize(bl, n2);
        int n12 = Math.min(n10, Math.max(0, LayoutTreeNode.subtract(n, n9)));
        int n13 = Math.min(n11, Math.max(0, LayoutTreeNode.subtract(n, n8)));
        int n14 = Math.max(n8, Math.min(n5, n3 + (int)Math.round((double)n7 * d / d3)));
        n14 = Math.max(n14, n5 - n13);
        n14 = Math.min(n14, n12);
        n14 = this.children[0].computePreferredSize(bl, n12, n2, n14);
        n14 = Math.max(n14, n8);
        n14 = Math.min(n14, n12);
        int n15 = Math.max(n9, n5 - n14);
        n13 = Math.max(0, Math.min(n13, LayoutTreeNode.subtract(n, n14)));
        n15 = Math.min(n15, n13);
        n15 = this.children[1].computePreferredSize(bl, n13, n2, n15);
        n15 = Math.max(n15, n9);
        return new ChildSizes(n14, n15, n10 > n8 && n11 > n9 && n8 + n9 < n);
    }

    @Override
    protected int doGetSizeFlags(boolean bl) {
        if (!this.children[0].isVisible()) {
            return this.children[1].getSizeFlags(bl);
        }
        if (!this.children[1].isVisible()) {
            return this.children[0].getSizeFlags(bl);
        }
        int n = this.children[0].getSizeFlags(bl);
        int n2 = this.children[1].getSizeFlags(bl);
        return (n | n2) & 0xFFFFFBFF | n & n2 & 0x400;
    }

    @Override
    public void doSetBounds(Rectangle rectangle) {
        if (!this.children[0].isVisible()) {
            this.children[1].setBounds(rectangle);
            this.getSash().setVisible(false);
            return;
        }
        if (!this.children[1].isVisible()) {
            this.children[0].setBounds(rectangle);
            this.getSash().setVisible(false);
            return;
        }
        rectangle = Geometry.copy((Rectangle)rectangle);
        boolean bl = this.getSash().isVertical();
        if (!bl) {
            Geometry.flipXY((Rectangle)rectangle);
        }
        ChildSizes childSizes = this.computeChildSizes(rectangle.width, rectangle.height, this.getSash().getLeft(), this.getSash().getRight(), rectangle.width);
        this.getSash().setVisible(true);
        this.getSash().setEnabled(childSizes.resizable);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, childSizes.left, rectangle.height);
        Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle.y, this.getSashSize(), rectangle.height);
        Rectangle rectangle4 = new Rectangle(rectangle3.x + rectangle3.width, rectangle.y, childSizes.right, rectangle.height);
        if (!bl) {
            Geometry.flipXY((Rectangle)rectangle2);
            Geometry.flipXY((Rectangle)rectangle3);
            Geometry.flipXY((Rectangle)rectangle4);
        }
        this.getSash().setBounds(rectangle3);
        this.children[0].setBounds(rectangle2);
        this.children[1].setBounds(rectangle4);
    }

    @Override
    public void createControl(Composite composite) {
        this.children[0].createControl(composite);
        this.children[1].createControl(composite);
        this.getSash().createControl(composite);
        super.createControl(composite);
    }

    @Override
    public boolean isCompressible() {
        return this.children[0].isCompressible() || this.children[1].isCompressible();
    }

    public int getCompressionBias() {
        boolean bl;
        boolean bl2 = this.children[0].isCompressible();
        if (bl2 == (bl = this.children[1].isCompressible())) {
            return 0;
        }
        if (bl) {
            return -1;
        }
        return 1;
    }

    boolean isLeftChild(LayoutTree layoutTree) {
        return this.children[0] == layoutTree;
    }

    LayoutTree getChild(boolean bl) {
        int n = bl ? 0 : 1;
        return this.children[n];
    }

    void setChild(boolean bl, LayoutPart layoutPart) {
        LayoutTree layoutTree = new LayoutTree(layoutPart);
        this.setChild(bl, layoutTree);
        this.flushCache();
    }

    void setChild(boolean bl, LayoutTree layoutTree) {
        int n = bl ? 0 : 1;
        this.children[n] = layoutTree;
        layoutTree.setParent(this);
        this.flushCache();
    }

    @Override
    public String toString() {
        String string = "<null>\n";
        if (this.part.getControl() != null) {
            string = "<@" + this.part.getControl().hashCode() + ">\n";
        }
        String string2 = "[";
        string2 = this.children[0].getParent() != this ? String.valueOf(string2) + "{" + this.children[0] + "}" + string : String.valueOf(string2) + this.children[0] + string;
        string2 = this.children[1].getParent() != this ? String.valueOf(string2) + "{" + this.children[1] + "}]" : String.valueOf(string2) + this.children[1] + "]";
        return string2;
    }

    @Override
    public void describeLayout(StringBuffer stringBuffer) {
        if (!this.children[0].isVisible()) {
            if (!this.children[1].isVisible()) {
                return;
            }
            this.children[1].describeLayout(stringBuffer);
            return;
        }
        if (!this.children[1].isVisible()) {
            this.children[0].describeLayout(stringBuffer);
            return;
        }
        stringBuffer.append("(");
        this.children[0].describeLayout(stringBuffer);
        stringBuffer.append(this.getSash().isVertical() ? "|" : "-");
        this.children[1].describeLayout(stringBuffer);
        stringBuffer.append(")");
    }

    static class ChildSizes {
        int left;
        int right;
        boolean resizable = true;

        public ChildSizes(int n, int n2, boolean bl) {
            this.left = n;
            this.right = n2;
            this.resizable = bl;
        }
    }
}

