/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.presentations.AbstractPresentationFactory;

class LayoutPartSash
extends LayoutPart {
    private Sash sash;
    private boolean enabled = false;
    private PartSashContainer rootContainer;
    private int style;
    private LayoutPartSash preLimit;
    private LayoutPartSash postLimit;
    SelectionListener selectionListener;
    private int left = 300;
    private int right = 300;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private AbstractPresentationFactory presFactory;
    private boolean isVisible;

    LayoutPartSash(PartSashContainer partSashContainer, int n) {
        super(null);
        this.style = n;
        this.rootContainer = partSashContainer;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LayoutPartSash.this.checkDragLimit(selectionEvent);
                if (selectionEvent.detail != 1) {
                    LayoutPartSash.this.widgetSelected(selectionEvent.x, selectionEvent.y, selectionEvent.width, selectionEvent.height);
                }
            }
        };
    }

    private void checkDragLimit(SelectionEvent selectionEvent) {
        boolean bl;
        LayoutTree layoutTree = this.rootContainer.getLayoutTree();
        LayoutTreeNode layoutTreeNode = layoutTree.findSash(this);
        Rectangle rectangle = layoutTreeNode.getBounds();
        Rectangle rectangle2 = new Rectangle(selectionEvent.x, selectionEvent.y, selectionEvent.width, selectionEvent.height);
        boolean bl2 = bl = this.style == 512;
        if (!bl) {
            Geometry.flipXY((Rectangle)rectangle);
            Geometry.flipXY((Rectangle)rectangle2);
        }
        int n = rectangle2.x;
        int n2 = Math.max(0, n - rectangle.x);
        n2 = Math.min(n2, rectangle.width - this.getSashSize());
        int n3 = rectangle.width - n2 - this.getSashSize();
        LayoutTreeNode.ChildSizes childSizes = layoutTreeNode.computeChildSizes(rectangle.width, rectangle.height, n2, n3, rectangle.width);
        rectangle2.x = rectangle.x + childSizes.left;
        if (!bl) {
            Geometry.flipXY((Rectangle)rectangle2);
        }
        selectionEvent.x = rectangle2.x;
        selectionEvent.y = rectangle2.y;
    }

    @Override
    public void createControl(Composite composite) {
        if (this.isVisible) {
            this.doCreateControl();
        }
    }

    private void doCreateControl() {
        if (this.sash == null) {
            AbstractPresentationFactory abstractPresentationFactory = this.getPresentationFactory();
            int n = AbstractPresentationFactory.SASHTYPE_NORMAL | this.style;
            this.sash = abstractPresentationFactory.createSash(this.rootContainer.getParent(), n);
            this.sash.addSelectionListener(this.selectionListener);
            this.sash.setEnabled(this.enabled);
            this.sash.setBounds(this.bounds);
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.bounds = rectangle;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.isVisible) {
            return;
        }
        if (bl) {
            this.doCreateControl();
        } else {
            this.dispose();
        }
        super.setVisible(bl);
        this.isVisible = bl;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void dispose() {
        if (this.sash != null) {
            this.bounds = this.sash.getBounds();
            this.sash.dispose();
        }
        this.sash = null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.sash == null) {
            return this.bounds;
        }
        return this.sash.getBounds();
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    @Override
    public String getID() {
        return null;
    }

    LayoutPartSash getPostLimit() {
        return this.postLimit;
    }

    LayoutPartSash getPreLimit() {
        return this.preLimit;
    }

    int getLeft() {
        return this.left;
    }

    int getRight() {
        return this.right;
    }

    boolean isHorizontal() {
        return (this.style & 0x100) == 256;
    }

    boolean isVertical() {
        return (this.style & 0x200) == 512;
    }

    void setPostLimit(LayoutPartSash layoutPartSash) {
        this.postLimit = layoutPartSash;
    }

    void setPreLimit(LayoutPartSash layoutPartSash) {
        this.preLimit = layoutPartSash;
    }

    void setRatio(float f) {
        int n = this.left + this.right;
        int n2 = (int)((float)n * f);
        this.setSizes(n2, n - n2);
    }

    void setSizes(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n == this.left && n2 == this.right) {
            return;
        }
        this.left = n;
        this.right = n2;
        this.flushCache();
    }

    private void flushCache() {
        LayoutTreeNode layoutTreeNode;
        LayoutTree layoutTree = this.rootContainer.getLayoutTree();
        if (layoutTree != null && (layoutTreeNode = layoutTree.findSash(this)) != null) {
            layoutTreeNode.flushCache();
        }
    }

    private void widgetSelected(int n, int n2, int n3, int n4) {
        if (!this.enabled) {
            return;
        }
        LayoutTree layoutTree = this.rootContainer.getLayoutTree();
        LayoutTreeNode layoutTreeNode = layoutTree.findSash(this);
        Rectangle rectangle = layoutTreeNode.getBounds();
        n -= rectangle.x;
        n2 -= rectangle.y;
        if (this.style == 512) {
            this.setSizes(n, rectangle.width - n - this.getSashSize());
        } else {
            this.setSizes(n2, rectangle.height - n2 - this.getSashSize());
        }
        layoutTreeNode.setBounds(rectangle);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.sash != null) {
            this.sash.setEnabled(this.enabled);
        }
    }

    int getSashSize() {
        AbstractPresentationFactory abstractPresentationFactory = this.getPresentationFactory();
        int n = AbstractPresentationFactory.SASHTYPE_NORMAL | this.style;
        int n2 = abstractPresentationFactory.getSashSize(n);
        return n2;
    }

    private AbstractPresentationFactory getPresentationFactory() {
        if (this.presFactory == null) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.rootContainer.getPage().getWorkbenchWindow();
            WorkbenchWindowConfigurer workbenchWindowConfigurer = workbenchWindow.getWindowConfigurer();
            this.presFactory = workbenchWindowConfigurer.getPresentationFactory();
        }
        return this.presFactory;
    }
}

