/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;

public abstract class LayoutPart
implements ISizeProvider {
    protected ILayoutContainer container;
    protected String id;
    public static final String PROP_VISIBILITY = "PROP_VISIBILITY";
    private int deferCount = 0;

    public LayoutPart(String string) {
        this.id = string;
    }

    public boolean allowsAutoFocus() {
        if (this.container != null) {
            return this.container.allowsAutoFocus();
        }
        return true;
    }

    public abstract void createControl(Composite var1);

    public void dispose() {
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public ILayoutContainer getContainer() {
        return this.container;
    }

    public abstract Control getControl();

    public String getID() {
        return this.id;
    }

    public String getCompoundId() {
        return this.getID();
    }

    public boolean isCompressible() {
        return false;
    }

    public Point getSize() {
        Rectangle rectangle = this.getBounds();
        Point point = new Point(rectangle.width, rectangle.height);
        return point;
    }

    @Override
    public int getSizeFlags(boolean bl) {
        return 128;
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return n3;
    }

    public IDropTarget getDropTarget(Object object, Point point) {
        return null;
    }

    public boolean isDocked() {
        Shell shell = this.getShell();
        if (shell == null) {
            return false;
        }
        return shell.getData() instanceof IWorkbenchWindow;
    }

    public Shell getShell() {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            return control.getShell();
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        Shell shell = this.getShell();
        if (shell == null) {
            return null;
        }
        Object object = shell.getData();
        if (object instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)object;
        }
        if (object instanceof DetachedWindow) {
            return ((DetachedWindow)object).getWorkbenchPage().getWorkbenchWindow();
        }
        return null;
    }

    public void moveAbove(Control control) {
    }

    public void reparent(Composite composite) {
        Control control = this.getControl();
        if (control == null || control.getParent() == composite) {
            return;
        }
        if (control.isReparentable()) {
            boolean bl = control.getEnabled();
            control.setEnabled(false);
            control.setParent(composite);
            control.setEnabled(bl);
            control.moveAbove(null);
        }
    }

    public boolean getVisible() {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            return control.getVisible();
        }
        return false;
    }

    public boolean isVisible() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            return control.isVisible();
        }
        return false;
    }

    public void setVisible(boolean bl) {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            if (bl == control.getVisible()) {
                return;
            }
            if (!bl && this.isFocusAncestor(control)) {
                control.getShell().forceFocus();
            }
            control.setVisible(bl);
        }
    }

    private boolean isFocusAncestor(Control control) {
        Control control2 = control.getDisplay().getFocusControl();
        while (control2 != null && control2 != control) {
            control2 = control2.getParent();
        }
        return control2 == control;
    }

    public void setBounds(Rectangle rectangle) {
        Control control = this.getControl();
        if (!SwtUtil.isDisposed(control)) {
            control.setBounds(rectangle);
        }
    }

    public void setContainer(ILayoutContainer iLayoutContainer) {
        this.container = iLayoutContainer;
        if (iLayoutContainer != null) {
            this.setZoomed(iLayoutContainer.childIsZoomed(this));
        }
    }

    public void setFocus() {
    }

    public void setID(String string) {
        this.id = string;
    }

    public LayoutPart getPart() {
        return this;
    }

    public void childRequestZoomIn(LayoutPart layoutPart) {
    }

    public void childRequestZoomOut() {
    }

    public final void requestZoomOut() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.childRequestZoomOut();
        }
    }

    public final void requestZoomIn() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.childRequestZoomIn(this);
        }
    }

    public final boolean isObscuredByZoom() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            return iLayoutContainer.childObscuredByZoom(this);
        }
        return false;
    }

    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        return false;
    }

    public boolean childIsZoomed(LayoutPart layoutPart) {
        return false;
    }

    public void setZoomed(boolean bl) {
    }

    public final void deferUpdates(boolean bl) {
        if (bl) {
            if (this.deferCount == 0) {
                this.startDeferringEvents();
            }
            ++this.deferCount;
        } else if (this.deferCount > 0) {
            --this.deferCount;
            if (this.deferCount == 0) {
                this.handleDeferredEvents();
            }
        }
    }

    protected void startDeferringEvents() {
    }

    protected void handleDeferredEvents() {
    }

    protected final boolean isDeferred() {
        return this.deferCount > 0;
    }

    public void describeLayout(StringBuffer stringBuffer) {
    }

    public String getPlaceHolderId() {
        return this.getID();
    }

    public void resizeChild(LayoutPart layoutPart) {
    }

    public void flushLayout() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (this.getContainer() != null) {
            iLayoutContainer.resizeChild(this);
        }
    }

    public boolean allowsAdd(LayoutPart layoutPart) {
        return false;
    }

    public void testInvariants() {
    }
}

