/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.IViewDescriptor;

class LayoutHelper {
    private LayoutHelper() {
    }

    public static final void addViewActivator(PageLayout pageLayout, final String string) {
        if (string == null) {
            return;
        }
        ViewFactory viewFactory = pageLayout.getViewFactory();
        final WorkbenchPage workbenchPage = viewFactory.getWorkbenchPage();
        if (workbenchPage == null) {
            return;
        }
        final IPerspectiveDescriptor iPerspectiveDescriptor = pageLayout.getDescriptor();
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IViewDescriptor iViewDescriptor = viewFactory.getViewRegistry().find(string);
        if (!(iViewDescriptor instanceof IPluginContribution)) {
            return;
        }
        IIdentifier iIdentifier = iWorkbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)((Object)iViewDescriptor)));
        iIdentifier.addIdentifierListener(new IIdentifierListener(){

            @Override
            public void identifierChanged(IdentifierEvent identifierEvent) {
                IIdentifier iIdentifier;
                if (identifierEvent.hasEnabledChanged() && (iIdentifier = identifierEvent.getIdentifier()).isEnabled()) {
                    iIdentifier.removeIdentifierListener(this);
                    IWorkbenchPage iWorkbenchPage = workbenchPage.getWorkbenchWindow().getActivePage();
                    if (workbenchPage == iWorkbenchPage && iPerspectiveDescriptor == iWorkbenchPage.getPerspective()) {
                        try {
                            workbenchPage.showView(string);
                        }
                        catch (PartInitException partInitException) {
                            WorkbenchPlugin.log(this.getClass(), "identifierChanged", (Throwable)((Object)partInitException));
                        }
                    } else {
                        workbenchPage.getWorkbenchWindow().addPerspectiveListener(new IPerspectiveListener(){

                            @Override
                            public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor2) {
                                if (iPerspectiveDescriptor == iPerspectiveDescriptor2) {
                                    workbenchPage.getWorkbenchWindow().removePerspectiveListener(this);
                                    try {
                                        iWorkbenchPage.showView(string);
                                    }
                                    catch (PartInitException partInitException) {
                                        WorkbenchPlugin.log(this.getClass(), "perspectiveActivated", (Throwable)((Object)partInitException));
                                    }
                                }
                            }

                            @Override
                            public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor2, String string2) {
                            }
                        });
                    }
                }
            }
        });
    }

    public static final ViewPane createView(ViewFactory viewFactory, String string) throws PartInitException {
        WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((Object)viewFactory.createView(ViewFactory.extractPrimaryId(string), ViewFactory.extractSecondaryId(string)));
        ViewPane viewPane = (ViewPane)workbenchPartReference.getPane();
        return viewPane;
    }
}

