/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.handlers.CommandLegacyActionWrapper;

public final class KeyBindingService
implements INestableKeyBindingService {
    private IKeyBindingService activeService = null;
    private boolean disposed;
    private Set enabledContextIds = Collections.EMPTY_SET;
    private List enabledSubmissions = new ArrayList();
    private Map handlerSubmissionsByCommandId = new HashMap();
    private List nestedEnabledSubmissions = null;
    private List nestedHandlerSubmissions = null;
    private final Map nestedServices = new HashMap();
    private final KeyBindingService parent;
    private IWorkbenchPartSite workbenchPartSite;

    public KeyBindingService(IWorkbenchPartSite iWorkbenchPartSite) {
        this(iWorkbenchPartSite, null);
    }

    KeyBindingService(IWorkbenchPartSite iWorkbenchPartSite, KeyBindingService keyBindingService) {
        this.workbenchPartSite = iWorkbenchPartSite;
        this.parent = keyBindingService;
    }

    @Override
    public boolean activateKeyBindingService(IWorkbenchSite iWorkbenchSite) {
        if (this.disposed) {
            return false;
        }
        if (iWorkbenchSite == null) {
            if (this.activeService == null) {
                return false;
            }
            this.deactivateNestedService();
            return true;
        }
        IKeyBindingService iKeyBindingService = (IKeyBindingService)this.nestedServices.get(iWorkbenchSite);
        if (iKeyBindingService == this.activeService) {
            return false;
        }
        this.deactivateNestedService();
        if (iKeyBindingService != null) {
            this.activateNestedService(iKeyBindingService);
        }
        return true;
    }

    private final void activateNestedService(IKeyBindingService iKeyBindingService) {
        boolean bl;
        if (this.disposed) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = bl = this.parent != null;
        if (bl) {
            boolean bl4 = bl2 = this.parent.activeService == this;
            if (bl2) {
                this.parent.deactivateNestedService();
            }
        }
        this.activeService = iKeyBindingService;
        if (iKeyBindingService == null) {
            return;
        }
        if (bl) {
            if (bl2) {
                this.parent.activateNestedService(this);
            }
        } else if (this.activeService instanceof KeyBindingService) {
            KeyBindingService keyBindingService = (KeyBindingService)this.activeService;
            this.nestedEnabledSubmissions = keyBindingService.getEnabledSubmissions();
            this.normalizeSites(this.nestedEnabledSubmissions);
            PlatformUI.getWorkbench().getContextSupport().addEnabledSubmissions(this.nestedEnabledSubmissions);
            this.nestedHandlerSubmissions = keyBindingService.getHandlerSubmissions();
            this.normalizeSites(this.nestedHandlerSubmissions);
            PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmissions(this.nestedHandlerSubmissions);
        }
    }

    private final void deactivateNestedService() {
        if (this.disposed) {
            return;
        }
        if (this.activeService == null) {
            return;
        }
        boolean bl = false;
        if (this.parent != null) {
            if (this.parent.activeService == this) {
                bl = true;
                this.parent.deactivateNestedService();
            }
        } else if (this.activeService instanceof KeyBindingService) {
            PlatformUI.getWorkbench().getContextSupport().removeEnabledSubmissions(this.nestedEnabledSubmissions);
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmissions(this.nestedHandlerSubmissions);
        }
        this.activeService = null;
        if (bl) {
            this.parent.activateNestedService(this);
        }
    }

    public void dispose() {
        if (!this.disposed) {
            this.deactivateNestedService();
            this.disposed = true;
            PlatformUI.getWorkbench().getContextSupport().removeEnabledSubmissions(new ArrayList(this.enabledSubmissions));
            this.enabledSubmissions.clear();
            ArrayList arrayList = new ArrayList(this.handlerSubmissionsByCommandId.values());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((HandlerSubmission)iterator.next()).getHandler().dispose();
            }
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmissions(arrayList);
            this.handlerSubmissionsByCommandId.clear();
            for (KeyBindingService keyBindingService : this.nestedServices.values()) {
                keyBindingService.dispose();
            }
            this.nestedEnabledSubmissions = null;
            this.nestedHandlerSubmissions = null;
            this.nestedServices.clear();
        }
    }

    private final List getEnabledSubmissions() {
        if (this.disposed) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.enabledSubmissions);
        if (this.activeService instanceof KeyBindingService) {
            KeyBindingService keyBindingService = (KeyBindingService)this.activeService;
            arrayList.addAll(keyBindingService.getEnabledSubmissions());
        }
        return arrayList;
    }

    private final List getHandlerSubmissions() {
        if (this.disposed) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.handlerSubmissionsByCommandId.values());
        if (this.activeService instanceof KeyBindingService) {
            KeyBindingService keyBindingService = (KeyBindingService)this.activeService;
            arrayList.addAll(keyBindingService.getHandlerSubmissions());
        }
        return arrayList;
    }

    @Override
    public IKeyBindingService getKeyBindingService(IWorkbenchSite iWorkbenchSite) {
        if (this.disposed) {
            return null;
        }
        if (iWorkbenchSite == null) {
            return null;
        }
        IKeyBindingService iKeyBindingService = (IKeyBindingService)this.nestedServices.get(iWorkbenchSite);
        if (iKeyBindingService == null) {
            iKeyBindingService = iWorkbenchSite instanceof IWorkbenchPartSite ? new KeyBindingService((IWorkbenchPartSite)iWorkbenchSite, this) : new KeyBindingService(null, this);
            this.nestedServices.put(iWorkbenchSite, iKeyBindingService);
        }
        return iKeyBindingService;
    }

    @Override
    public String[] getScopes() {
        if (this.disposed) {
            return null;
        }
        String[] stringArray = this.activeService == null ? null : this.activeService.getScopes();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.enabledContextIds);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private final void normalizeSites(List list) {
        if (this.disposed) {
            return;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Comparable comparable;
            Object e = list.get(n2);
            Object object = e instanceof EnabledSubmission ? (!this.workbenchPartSite.equals(((EnabledSubmission)(comparable = (EnabledSubmission)e)).getActiveWorkbenchPartSite()) ? new EnabledSubmission(null, ((EnabledSubmission)comparable).getActiveShell(), this.workbenchPartSite, ((EnabledSubmission)comparable).getContextId()) : comparable) : (e instanceof HandlerSubmission ? (!this.workbenchPartSite.equals(((HandlerSubmission)(comparable = (HandlerSubmission)e)).getActiveWorkbenchPartSite()) ? new HandlerSubmission(null, ((HandlerSubmission)comparable).getActiveShell(), this.workbenchPartSite, ((HandlerSubmission)comparable).getCommandId(), ((HandlerSubmission)comparable).getHandler(), ((HandlerSubmission)comparable).getPriority()) : comparable) : e);
            list.set(n2, object);
            ++n2;
        }
    }

    @Override
    public void registerAction(IAction iAction) {
        if (this.disposed) {
            return;
        }
        if (iAction instanceof CommandLegacyActionWrapper) {
            WorkbenchPlugin.log("Cannot register a CommandLegacyActionWrapper back into the system");
            return;
        }
        if (iAction instanceof CommandAction) {
            return;
        }
        this.unregisterAction(iAction);
        String string = iAction.getActionDefinitionId();
        if (string != null) {
            boolean bl = false;
            if (this.parent != null && this.parent.activeService == this) {
                bl = true;
                this.parent.deactivateNestedService();
            }
            ActionHandler actionHandler = new ActionHandler(iAction);
            HandlerSubmission handlerSubmission = new HandlerSubmission(null, this.workbenchPartSite.getShell(), this.workbenchPartSite, string, actionHandler, Priority.MEDIUM);
            this.handlerSubmissionsByCommandId.put(string, handlerSubmission);
            if (this.parent != null) {
                if (bl) {
                    this.parent.activateNestedService(this);
                }
            } else {
                PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(handlerSubmission);
            }
        }
    }

    @Override
    public boolean removeKeyBindingService(IWorkbenchSite iWorkbenchSite) {
        if (this.disposed) {
            return false;
        }
        IKeyBindingService iKeyBindingService = (IKeyBindingService)this.nestedServices.remove(iWorkbenchSite);
        if (iKeyBindingService == null) {
            return false;
        }
        if (iKeyBindingService.equals(this.activeService)) {
            this.deactivateNestedService();
        }
        return true;
    }

    @Override
    public void setScopes(String[] stringArray) {
        if (this.disposed) {
            return;
        }
        boolean bl = false;
        if (this.parent != null && this.parent.activeService == this) {
            bl = true;
            this.parent.deactivateNestedService();
        } else {
            PlatformUI.getWorkbench().getContextSupport().removeEnabledSubmissions(this.enabledSubmissions);
        }
        this.enabledSubmissions.clear();
        this.enabledContextIds = new HashSet<String>(Arrays.asList(stringArray));
        for (String string : this.enabledContextIds) {
            this.enabledSubmissions.add(new EnabledSubmission(null, null, this.workbenchPartSite, string));
        }
        if (this.parent != null) {
            if (bl) {
                this.parent.activateNestedService(this);
            }
        } else {
            PlatformUI.getWorkbench().getContextSupport().addEnabledSubmissions(this.enabledSubmissions);
        }
    }

    @Override
    public void unregisterAction(IAction iAction) {
        if (this.disposed) {
            return;
        }
        if (iAction instanceof CommandLegacyActionWrapper) {
            WorkbenchPlugin.log("Cannot unregister a CommandLegacyActionWrapper out of the system");
            return;
        }
        String string = iAction.getActionDefinitionId();
        if (string != null) {
            boolean bl = false;
            if (this.parent != null && this.parent.activeService == this) {
                bl = true;
                this.parent.deactivateNestedService();
            }
            HandlerSubmission handlerSubmission = (HandlerSubmission)this.handlerSubmissionsByCommandId.remove(string);
            if (this.parent != null) {
                if (bl) {
                    this.parent.activateNestedService(this);
                }
            } else if (handlerSubmission != null) {
                PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(handlerSubmission);
                handlerSubmission.getHandler().dispose();
            }
        }
    }
}

