/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.StatusHandler;
import org.eclipse.ui.internal.PlatformUIPreferenceListener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

final class JFaceUtil {
    private JFaceUtil() {
    }

    public static void initializeJFace() {
        SafeRunnable.setRunner((ISafeRunnableRunner)new ISafeRunnableRunner(){

            public void run(ISafeRunnable iSafeRunnable) {
                SafeRunner.run((ISafeRunnable)iSafeRunnable);
            }
        });
        Policy.setLog((ILogger)new ILogger(){

            public void log(IStatus iStatus) {
                if (iStatus.getSeverity() == 2 || iStatus.getSeverity() == 4) {
                    StatusManager.getManager().handle(iStatus);
                } else {
                    WorkbenchPlugin.log(iStatus);
                }
            }
        });
        Policy.setStatusHandler((StatusHandler)new StatusHandler(){

            public void show(IStatus iStatus, String string) {
                StatusAdapter statusAdapter = new StatusAdapter(iStatus);
                statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, string);
                StatusManager.getManager().handle(statusAdapter, 2);
            }
        });
        if ("true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/debug"))) {
            Policy.DEBUG_DIALOG_NO_PARENT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/debug/dialog/noparent"));
            Policy.TRACE_ACTIONS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/trace/actions"));
            Policy.TRACE_TOOLBAR = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/trace/toolbarDisposal"));
            InternalPolicy.DEBUG_LOG_REENTRANT_VIEWER_CALLS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/debug/viewers/reentrantViewerCalls"));
            InternalPolicy.DEBUG_LOG_EQUAL_VIEWER_ELEMENTS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/debug/viewers/equalElements"));
        }
    }

    public static void initializeJFacePreferences() {
        IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        final String string = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
        iEclipsePreferences.addNodeChangeListener(new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
                if (!nodeChangeEvent.getChild().name().equals(string)) {
                    return;
                }
                ((IEclipsePreferences)nodeChangeEvent.getChild()).addPreferenceChangeListener(PlatformUIPreferenceListener.getSingleton());
            }

            public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            }
        });
        JFacePreferences.setPreferenceStore((IPreferenceStore)WorkbenchPlugin.getDefault().getPreferenceStore());
    }
}

