/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class HeapStatus
extends Composite {
    private boolean armed;
    private Image gcImage;
    private Image disabledGcImage;
    private Color bgCol;
    private Color usedMemCol;
    private Color lowMemCol;
    private Color freeMemCol;
    private Color topLeftCol;
    private Color bottomRightCol;
    private Color sepCol;
    private Color textCol;
    private Color markCol;
    private Color armCol;
    private Canvas button;
    private IPreferenceStore prefStore;
    private int updateInterval;
    private boolean showMax;
    private long totalMem;
    private long prevTotalMem = -1L;
    private long prevUsedMem = -1L;
    private boolean hasChanged;
    private long usedMem;
    private long mark = -1L;
    private Rectangle imgBounds = new Rectangle(0, 0, 12, 12);
    private long maxMem = Long.MAX_VALUE;
    private boolean maxMemKnown;
    private float lowMemThreshold = 0.05f;
    private boolean showLowMemThreshold = true;
    private boolean updateTooltip = false;
    protected volatile boolean isInGC = false;
    private final Runnable timer = new Runnable(){

        @Override
        public void run() {
            if (!HeapStatus.this.isDisposed()) {
                HeapStatus.this.updateStats();
                if (HeapStatus.this.hasChanged) {
                    if (HeapStatus.this.updateTooltip) {
                        HeapStatus.this.updateToolTip();
                    }
                    HeapStatus.this.redraw();
                    HeapStatus.this.hasChanged = false;
                }
                HeapStatus.this.getDisplay().timerExec(HeapStatus.this.updateInterval, (Runnable)this);
            }
        }
    };
    private final IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("HeapStatus.updateInterval".equals(propertyChangeEvent.getProperty())) {
                HeapStatus.this.setUpdateIntervalInMS(HeapStatus.this.prefStore.getInt("HeapStatus.updateInterval"));
            } else if ("HeapStatus.showMax".equals(propertyChangeEvent.getProperty())) {
                HeapStatus.this.showMax = HeapStatus.this.prefStore.getBoolean("HeapStatus.showMax");
            }
        }
    };

    public HeapStatus(Composite composite, IPreferenceStore iPreferenceStore) {
        super(composite, 0);
        this.maxMem = this.getMaxMem();
        this.maxMemKnown = this.maxMem != Long.MAX_VALUE;
        this.prefStore = iPreferenceStore;
        iPreferenceStore.addPropertyChangeListener(this.prefListener);
        this.setUpdateIntervalInMS(iPreferenceStore.getInt("HeapStatus.updateInterval"));
        this.showMax = iPreferenceStore.getBoolean("HeapStatus.showMax");
        this.button = new Canvas((Composite)this, 0);
        this.button.setToolTipText(WorkbenchMessages.HeapStatus_buttonToolTip);
        ImageDescriptor imageDescriptor = WorkbenchImages.getWorkbenchImageDescriptor("elcl16/trash.gif");
        Display display = this.getDisplay();
        this.gcImage = imageDescriptor.createImage();
        if (this.gcImage != null) {
            this.imgBounds = this.gcImage.getBounds();
            this.disabledGcImage = new Image((Device)display, this.gcImage, 1);
        }
        this.usedMemCol = display.getSystemColor(29);
        this.lowMemCol = new Color((Device)display, 255, 70, 70);
        this.freeMemCol = new Color((Device)display, 255, 190, 125);
        this.bgCol = display.getSystemColor(22);
        this.topLeftCol = this.armCol = display.getSystemColor(18);
        this.sepCol = this.armCol;
        this.bottomRightCol = display.getSystemColor(20);
        this.markCol = this.textCol = display.getSystemColor(28);
        this.createContextMenu();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        HeapStatus.this.doDispose();
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = HeapStatus.this.getClientArea();
                        HeapStatus.this.button.setBounds(rectangle.width - ((HeapStatus)HeapStatus.this).imgBounds.width - 1, 1, ((HeapStatus)HeapStatus.this).imgBounds.width, rectangle.height - 2);
                        break;
                    }
                    case 9: {
                        if (event.widget == HeapStatus.this) {
                            HeapStatus.this.paintComposite(event.gc);
                            break;
                        }
                        if (event.widget != HeapStatus.this.button) break;
                        HeapStatus.this.paintButton(event.gc);
                        break;
                    }
                    case 4: {
                        if (event.button != 1 || HeapStatus.this.isInGC) break;
                        HeapStatus.this.arm(false);
                        HeapStatus.this.gc();
                        break;
                    }
                    case 3: {
                        if (event.button != 1) break;
                        if (event.widget == HeapStatus.this) {
                            HeapStatus.this.setMark();
                            break;
                        }
                        if (event.widget != HeapStatus.this.button || HeapStatus.this.isInGC) break;
                        HeapStatus.this.arm(true);
                        break;
                    }
                    case 6: {
                        HeapStatus.this.updateTooltip = true;
                        HeapStatus.this.updateToolTip();
                        break;
                    }
                    case 7: {
                        if (event.widget == HeapStatus.this) {
                            HeapStatus.this.updateTooltip = false;
                            break;
                        }
                        if (event.widget != HeapStatus.this.button) break;
                        HeapStatus.this.arm(false);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.addListener(9, listener);
        this.addListener(11, listener);
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.button.addListener(3, listener);
        this.button.addListener(7, listener);
        this.button.addListener(4, listener);
        this.button.addListener(9, listener);
        this.updateStats();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!HeapStatus.this.isDisposed()) {
                    HeapStatus.this.getDisplay().timerExec(HeapStatus.this.updateInterval, HeapStatus.this.timer);
                }
            }
        });
    }

    private long getMaxMem() {
        long l = Long.MAX_VALUE;
        try {
            Method method = Runtime.class.getMethod("maxMemory", new Class[0]);
            Object object = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
            if (object instanceof Long) {
                l = (Long)object;
            }
        }
        catch (Exception exception) {}
        return l;
    }

    private void setUpdateIntervalInMS(int n) {
        this.updateInterval = Math.max(100, n);
    }

    private void doDispose() {
        this.prefStore.removePropertyChangeListener(this.prefListener);
        if (this.gcImage != null) {
            this.gcImage.dispose();
        }
        if (this.disabledGcImage != null) {
            this.disabledGcImage.dispose();
        }
        if (this.lowMemCol != null) {
            this.lowMemCol.dispose();
        }
        if (this.freeMemCol != null) {
            this.freeMemCol.dispose();
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        GC gC = new GC((Drawable)this);
        Point point = gC.textExtent(WorkbenchMessages.HeapStatus_widthStr);
        int n3 = this.imgBounds.height;
        n3 = Math.max(n3, point.y) + 4;
        n3 = Math.max(TrimUtil.TRIM_DEFAULT_HEIGHT, n3);
        gC.dispose();
        return new Point(point.x + 15, n3);
    }

    private void arm(boolean bl) {
        if (this.armed == bl) {
            return;
        }
        this.armed = bl;
        this.button.redraw();
        this.button.update();
    }

    private void gcRunning(boolean bl) {
        if (this.isInGC == bl) {
            return;
        }
        this.isInGC = bl;
        this.button.redraw();
        this.button.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                HeapStatus.this.fillMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    private void fillMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)new SetMarkAction());
        iMenuManager.add((IAction)new ClearMarkAction());
        iMenuManager.add((IAction)new ShowMaxAction());
        iMenuManager.add((IAction)new CloseHeapStatusAction());
    }

    private void setMark() {
        this.updateStats();
        this.mark = this.usedMem;
        this.hasChanged = true;
        this.redraw();
    }

    private void clearMark() {
        this.mark = -1L;
        this.hasChanged = true;
        this.redraw();
    }

    private void gc() {
        this.gcRunning(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                HeapStatus.this.busyGC();
                HeapStatus.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!HeapStatus.this.isDisposed()) {
                            HeapStatus.this.gcRunning(false);
                        }
                    }
                });
            }
        };
        thread.start();
    }

    private void busyGC() {
        int n = 0;
        while (n < 2) {
            System.gc();
            System.runFinalization();
            ++n;
        }
    }

    private void paintButton(GC gC) {
        Rectangle rectangle = this.button.getClientArea();
        if (this.isInGC) {
            if (this.disabledGcImage != null) {
                int n = (rectangle.height - this.imgBounds.height) / 2 + rectangle.y;
                gC.drawImage(this.disabledGcImage, rectangle.x, n);
            }
            return;
        }
        if (this.armed) {
            gC.setBackground(this.armCol);
            gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.gcImage != null) {
            int n = (rectangle.height - this.imgBounds.height) / 2 + rectangle.y;
            gC.drawImage(this.gcImage, rectangle.x, n);
        }
    }

    private void paintComposite(GC gC) {
        if (this.showMax && this.maxMemKnown) {
            this.paintCompositeMaxKnown(gC);
        } else {
            this.paintCompositeMaxUnknown(gC);
        }
    }

    private void paintCompositeMaxUnknown(GC gC) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.imgBounds.width;
        int n6 = n + n3 - n5 - 2;
        int n7 = n3 - n5 - 3;
        int n8 = (int)((long)n7 * this.usedMem / this.totalMem);
        int n9 = n + 1 + n8;
        gC.setBackground(this.bgCol);
        gC.fillRectangle(rectangle);
        gC.setForeground(this.sepCol);
        gC.drawLine(n6, n2, n6, n2 + n4);
        gC.drawLine(n9, n2, n9, n2 + n4);
        gC.setForeground(this.topLeftCol);
        gC.drawLine(n, n2, n + n3, n2);
        gC.drawLine(n, n2, n, n2 + n4);
        gC.setForeground(this.bottomRightCol);
        gC.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        gC.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        gC.setBackground(this.usedMemCol);
        gC.fillRectangle(n + 1, n2 + 1, n8, n4 - 2);
        String string = NLS.bind((String)WorkbenchMessages.HeapStatus_status, (Object)this.convertToMegString(this.usedMem), (Object)this.convertToMegString(this.totalMem));
        Point point = gC.textExtent(string);
        int n10 = (rectangle.width - 15 - point.x) / 2 + rectangle.x + 1;
        int n11 = (rectangle.height - 2 - point.y) / 2 + rectangle.y + 1;
        gC.setForeground(this.textCol);
        gC.drawString(string, n10, n11, true);
        if (this.mark != -1L) {
            int n12 = (int)((long)n7 * this.mark / this.totalMem) + n + 1;
            this.paintMark(gC, n12, n2, n4);
        }
    }

    private void paintCompositeMaxKnown(GC gC) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.imgBounds.width;
        int n6 = n + n3 - n5 - 2;
        int n7 = n3 - n5 - 3;
        int n8 = (int)((long)n7 * this.usedMem / this.maxMem);
        int n9 = n + 1 + n8;
        int n10 = (int)((long)n7 * this.totalMem / this.maxMem);
        int n11 = n + 1 + n10;
        gC.setBackground(this.bgCol);
        gC.fillRectangle(rectangle);
        gC.setForeground(this.sepCol);
        gC.drawLine(n6, n2, n6, n2 + n4);
        gC.drawLine(n9, n2, n9, n2 + n4);
        gC.drawLine(n11, n2, n11, n2 + n4);
        gC.setForeground(this.topLeftCol);
        gC.drawLine(n, n2, n + n3, n2);
        gC.drawLine(n, n2, n, n2 + n4);
        gC.setForeground(this.bottomRightCol);
        gC.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        gC.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        if (this.lowMemThreshold != 0.0f && (double)(this.maxMem - this.usedMem) / (double)this.maxMem < (double)this.lowMemThreshold) {
            gC.setBackground(this.lowMemCol);
        } else {
            gC.setBackground(this.usedMemCol);
        }
        gC.fillRectangle(n + 1, n2 + 1, n8, n4 - 2);
        gC.setBackground(this.freeMemCol);
        gC.fillRectangle(n9 + 1, n2 + 1, n11 - (n9 + 1), n4 - 2);
        if (this.showLowMemThreshold && this.lowMemThreshold != 0.0f) {
            gC.setForeground(this.lowMemCol);
            int n12 = n + 1 + (int)((double)n7 * (1.0 - (double)this.lowMemThreshold));
            gC.drawLine(n12, n2 + 1, n12, n2 + n4 - 2);
        }
        String string = NLS.bind((String)WorkbenchMessages.HeapStatus_status, (Object)this.convertToMegString(this.usedMem), (Object)this.convertToMegString(this.totalMem));
        Point point = gC.textExtent(string);
        int n13 = (rectangle.width - 15 - point.x) / 2 + rectangle.x + 1;
        int n14 = (rectangle.height - 2 - point.y) / 2 + rectangle.y + 1;
        gC.setForeground(this.textCol);
        gC.drawString(string, n13, n14, true);
        if (this.mark != -1L) {
            int n15 = (int)((long)n7 * this.mark / this.maxMem) + n + 1;
            this.paintMark(gC, n15, n2, n4);
        }
    }

    private void paintMark(GC gC, int n, int n2, int n3) {
        gC.setForeground(this.markCol);
        gC.drawLine(n, n2 + 1, n, n2 + n3 - 2);
        gC.drawLine(n - 1, n2 + 1, n + 1, n2 + 1);
        gC.drawLine(n - 1, n2 + n3 - 2, n + 1, n2 + n3 - 2);
    }

    private void updateStats() {
        Runtime runtime = Runtime.getRuntime();
        this.totalMem = runtime.totalMemory();
        long l = runtime.freeMemory();
        this.usedMem = this.totalMem - l;
        if (this.convertToMeg(this.prevUsedMem) != this.convertToMeg(this.usedMem)) {
            this.prevUsedMem = this.usedMem;
            this.hasChanged = true;
        }
        if (this.prevTotalMem != this.totalMem) {
            this.prevTotalMem = this.totalMem;
            this.hasChanged = true;
        }
    }

    private void updateToolTip() {
        String string;
        String string2;
        String string3;
        String string4 = this.convertToMegString(this.usedMem);
        String string5 = NLS.bind((String)WorkbenchMessages.HeapStatus_memoryToolTip, (Object[])new Object[]{string4, string3 = this.convertToMegString(this.totalMem), string2 = this.maxMemKnown ? this.convertToMegString(this.maxMem) : WorkbenchMessages.HeapStatus_maxUnknown, string = this.mark == -1L ? WorkbenchMessages.HeapStatus_noMark : this.convertToMegString(this.mark)});
        if (!string5.equals(this.getToolTipText())) {
            this.setToolTipText(string5);
        }
    }

    private String convertToMegString(long l) {
        return NLS.bind((String)WorkbenchMessages.HeapStatus_meg, (Object)new Long(this.convertToMeg(l)));
    }

    private long convertToMeg(long l) {
        return (l + 524288L) / 0x100000L;
    }

    class ClearMarkAction
    extends Action {
        ClearMarkAction() {
            super(WorkbenchMessages.ClearMarkAction_text);
        }

        public void run() {
            HeapStatus.this.clearMark();
        }
    }

    class CloseHeapStatusAction
    extends Action {
        CloseHeapStatusAction() {
            super(WorkbenchMessages.WorkbenchWindow_close);
        }

        public void run() {
            HeapStatus.this.dispose();
        }
    }

    class SetMarkAction
    extends Action {
        SetMarkAction() {
            super(WorkbenchMessages.SetMarkAction_text);
        }

        public void run() {
            HeapStatus.this.setMark();
        }
    }

    class ShowMaxAction
    extends Action {
        ShowMaxAction() {
            super(WorkbenchMessages.ShowMaxAction_text, 2);
            this.setEnabled(HeapStatus.this.maxMemKnown);
            this.setChecked(HeapStatus.this.showMax);
        }

        public void run() {
            HeapStatus.this.prefStore.setValue("HeapStatus.showMax", this.isChecked());
            HeapStatus.this.redraw();
        }
    }
}

