/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.LayoutHelper;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.IViewDescriptor;

public class FolderLayout
implements IFolderLayout {
    private ViewStack folder;
    private PageLayout pageLayout;
    private ViewFactory viewFactory;

    public FolderLayout(PageLayout pageLayout, ViewStack viewStack, ViewFactory viewFactory) {
        this.folder = viewStack;
        this.viewFactory = viewFactory;
        this.pageLayout = pageLayout;
    }

    @Override
    public void addPlaceholder(String string) {
        if (!this.pageLayout.checkValidPlaceholderId(string)) {
            return;
        }
        PartPlaceholder partPlaceholder = new PartPlaceholder(string);
        this.linkPartToPageLayout(string, partPlaceholder);
        this.folder.add(partPlaceholder);
    }

    @Override
    public void addView(String string) {
        if (this.pageLayout.checkPartInLayout(string)) {
            return;
        }
        try {
            IViewDescriptor iViewDescriptor = this.viewFactory.getViewRegistry().find(ViewFactory.extractPrimaryId(string));
            if (iViewDescriptor == null) {
                throw new PartInitException("View descriptor not found: " + string);
            }
            if (WorkbenchActivityHelper.filterItem(iViewDescriptor)) {
                this.addPlaceholder(string);
                LayoutHelper.addViewActivator(this.pageLayout, string);
            } else {
                ViewPane viewPane = LayoutHelper.createView(this.pageLayout.getViewFactory(), string);
                this.linkPartToPageLayout(string, viewPane);
                this.folder.add(viewPane);
            }
        }
        catch (PartInitException partInitException) {
            WorkbenchPlugin.log(this.getClass(), "addView(String)", (Throwable)((Object)partInitException));
        }
    }

    private void linkPartToPageLayout(String string, LayoutPart layoutPart) {
        this.pageLayout.setRefPart(string, layoutPart);
        this.pageLayout.setFolderPart(string, this.folder);
        this.pageLayout.getViewLayoutRec(string, true);
    }

    @Override
    public String getProperty(String string) {
        return this.folder.getProperty(string);
    }

    @Override
    public void setProperty(String string, String string2) {
        this.folder.setProperty(string, string2);
    }
}

