/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStackTrimToolBar;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.SystemMenuFastView;
import org.eclipse.ui.internal.presentations.SystemMenuFastViewOrientation;
import org.eclipse.ui.internal.presentations.SystemMenuSizeFastView;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.StackPresentation;

public class FastViewPane {
    private int side = 16384;
    private PresentablePart currentPane;
    private Composite clientComposite;
    private int minSize = 10;
    private int size;
    private Sash sash;
    private AbstractPresentationFactory presFactory;
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b' && FastViewPane.this.currentPane != null) {
                FastViewPane.this.currentPane.getPane().getPage().hideFastView();
            }
        }
    };
    private DefaultStackPresentationSite site = new DefaultStackPresentationSite(){

        @Override
        public void setState(int n) {
            super.setState(n);
            PartPane partPane = FastViewPane.this.currentPane.getPane();
            switch (n) {
                case 0: {
                    partPane.getPage().hideFastView();
                    break;
                }
                case 1: {
                    partPane.setZoomed(true);
                    FastViewPane.this.sash.setVisible(false);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                    break;
                }
                case 2: {
                    partPane.setZoomed(false);
                    FastViewPane.this.sash.setVisible(true);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                }
            }
        }

        @Override
        public void flushLayout() {
        }

        @Override
        public void close(IPresentablePart iPresentablePart) {
            if (!this.isCloseable(iPresentablePart)) {
                return;
            }
            IWorkbenchPartReference iWorkbenchPartReference = FastViewPane.this.currentPane.getPane().getPartReference();
            if (iWorkbenchPartReference instanceof IViewReference) {
                FastViewPane.this.currentPane.getPane().getPage().hideView((IViewReference)iWorkbenchPartReference);
            }
        }

        @Override
        public void close(IPresentablePart[] iPresentablePartArray) {
            int n = 0;
            while (n < iPresentablePartArray.length) {
                this.close(iPresentablePartArray[n]);
                ++n;
            }
        }

        @Override
        public void dragStart(IPresentablePart iPresentablePart, Point point, boolean bl) {
            this.dragStart(point, bl);
        }

        @Override
        public void dragStart(Point point, boolean bl) {
            if (!this.isPartMoveable()) {
                return;
            }
            PartPane partPane = FastViewPane.this.currentPane.getPane();
            Control control = this.getPresentation().getControl();
            Rectangle rectangle = Geometry.toDisplay((Control)FastViewPane.this.clientComposite, (Rectangle)control.getBounds());
            WorkbenchPage workbenchPage = partPane.getPage();
            workbenchPage.hideFastView();
            if (workbenchPage.isZoomed()) {
                workbenchPage.zoomOut();
            }
            DragUtil.performDrag(partPane, rectangle, point, !bl);
        }

        @Override
        public IPresentablePart getSelectedPart() {
            return FastViewPane.this.currentPane;
        }

        @Override
        public void addSystemActions(IMenuManager iMenuManager) {
            ViewStackTrimToolBar viewStackTrimToolBar = this.getTrim();
            FastViewPane.appendToGroupIfPossible(iMenuManager, "misc", new SystemMenuFastViewOrientation(FastViewPane.this.currentPane.getPane(), viewStackTrimToolBar));
            if (viewStackTrimToolBar == null) {
                FastViewPane.appendToGroupIfPossible(iMenuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(FastViewPane.this.fastViewAction));
            }
            FastViewPane.appendToGroupIfPossible(iMenuManager, "size", new SystemMenuSizeFastView(FastViewPane.this));
        }

        private ViewStackTrimToolBar getTrim() {
            if (FastViewPane.this.currentPane == null || FastViewPane.this.currentPane.getPane() == null) {
                return null;
            }
            ViewStackTrimToolBar viewStackTrimToolBar = null;
            PartPane partPane = FastViewPane.this.currentPane.getPane();
            if (partPane instanceof ViewPane) {
                ViewPane viewPane = (ViewPane)partPane;
                Perspective perspective = viewPane.getPage().getActivePerspective();
                IViewReference iViewReference = viewPane.getViewReference();
                FastViewManager fastViewManager = perspective.getFastViewManager();
                String string = null;
                if (fastViewManager != null) {
                    string = fastViewManager.getIdForRef(iViewReference);
                }
                if (string != null && !string.equals(FastViewBar.FASTVIEWBAR_ID)) {
                    viewStackTrimToolBar = fastViewManager.getViewStackTrimToolbar(string);
                }
            }
            return viewStackTrimToolBar;
        }

        @Override
        public boolean isPartMoveable(IPresentablePart iPresentablePart) {
            return this.isPartMoveable();
        }

        @Override
        public boolean isStackMoveable() {
            return this.isPartMoveable();
        }

        private boolean isPartMoveable() {
            if (FastViewPane.this.currentPane == null) {
                return false;
            }
            Perspective perspective = FastViewPane.this.currentPane.getPane().getPage().getActivePerspective();
            if (perspective == null) {
                return false;
            }
            IWorkbenchPartReference iWorkbenchPartReference = FastViewPane.this.currentPane.getPane().getPartReference();
            if (iWorkbenchPartReference instanceof IViewReference) {
                return perspective.isMoveable((IViewReference)iWorkbenchPartReference);
            }
            return true;
        }

        @Override
        public boolean supportsState(int n) {
            if (FastViewPane.this.currentPane == null) {
                return false;
            }
            return !FastViewPane.this.currentPane.getPane().getPage().isFixedLayout();
        }

        @Override
        public IPresentablePart[] getPartList() {
            return new IPresentablePart[]{this.getSelectedPart()};
        }

        @Override
        public String getProperty(String string) {
            return null;
        }
    };
    private SystemMenuFastView fastViewAction = new SystemMenuFastView(this.site);
    private Listener mouseDownListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Control) {
                Point point;
                Rectangle rectangle;
                Control control = (Control)event.widget;
                if (control.getShell() != FastViewPane.this.clientComposite.getShell()) {
                    return;
                }
                if (event.widget instanceof ToolBar && (rectangle = (ToolBar)event.widget).getItem(point = new Point(event.x, event.y)) != null) {
                    return;
                }
                point = DragUtil.getEventLoc(event);
                rectangle = FastViewPane.this.clientComposite.getBounds();
                if (FastViewPane.this.site.getState() != 1) {
                    rectangle = Geometry.getExtrudedEdge((Rectangle)rectangle, (int)(FastViewPane.this.size + FastViewPane.this.getSashSize()), (int)FastViewPane.this.side);
                }
                if (!(rectangle = FastViewPane.this.clientComposite.getDisplay().map((Control)FastViewPane.this.clientComposite, null, rectangle)).contains(point)) {
                    FastViewPane.this.site.setState(0);
                }
            }
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 11 && FastViewPane.this.currentPane != null) {
                FastViewPane.this.setSize(FastViewPane.this.size);
            }
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (FastViewPane.this.currentPane != null) {
                Rectangle rectangle = FastViewPane.this.clientComposite.getClientArea();
                Point point = new Point(selectionEvent.x, selectionEvent.y);
                int n = Geometry.getDistanceFromEdge((Rectangle)rectangle, (Point)point, (int)FastViewPane.this.side);
                if (FastViewPane.this.side != 128 && FastViewPane.this.side != 16384) {
                    n -= FastViewPane.this.getSashSize();
                }
                FastViewPane.this.setSize(n);
                if (selectionEvent.detail != 1) {
                    FastViewPane.this.updateFastViewSashBounds();
                    FastViewPane.this.sash.redraw();
                }
            }
        }
    };

    private static void appendToGroupIfPossible(IMenuManager iMenuManager, String string, ContributionItem contributionItem) {
        try {
            iMenuManager.appendToGroup(string, (IContributionItem)contributionItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iMenuManager.add((IContributionItem)contributionItem);
        }
    }

    public void moveSash() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b' || keyEvent.character == '\r') {
                    FastViewPane.this.currentPane.setFocus();
                }
            }
        };
        this.sash.addFocusListener((FocusListener)new FocusAdapter((KeyListener)keyAdapter){
            private final /* synthetic */ KeyListener val$listener;
            {
                this.val$listener = keyListener;
            }

            public void focusGained(FocusEvent focusEvent) {
                FastViewPane.this.sash.setBackground(FastViewPane.this.sash.getDisplay().getSystemColor(26));
                FastViewPane.this.sash.addKeyListener(this.val$listener);
            }

            public void focusLost(FocusEvent focusEvent) {
                FastViewPane.this.sash.setBackground(null);
                FastViewPane.this.sash.removeKeyListener(this.val$listener);
            }
        });
        this.sash.setFocus();
    }

    private void setSize(int n) {
        if (n < this.minSize) {
            n = this.minSize;
        }
        this.size = n;
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation == null || stackPresentation.getControl().isDisposed()) {
            return;
        }
        this.getPresentation().setBounds(this.getBounds());
        this.updateFastViewSashBounds();
    }

    public float getCurrentRatio() {
        if (this.currentPane == null) {
            return 0.0f;
        }
        boolean bl = !Geometry.isHorizontal((int)this.side);
        Rectangle rectangle = this.clientComposite.getClientArea();
        int n = Geometry.getDimension((Rectangle)rectangle, (boolean)bl);
        return (float)this.size / (float)n;
    }

    private Rectangle getClientArea() {
        return this.clientComposite.getClientArea();
    }

    private Rectangle getBounds() {
        Rectangle rectangle = this.getClientArea();
        if (this.site.getState() == 1) {
            return rectangle;
        }
        boolean bl = Geometry.isHorizontal((int)this.side);
        int n = Geometry.getDimension((Rectangle)rectangle, (!bl ? 1 : 0) != 0);
        return Geometry.getExtrudedEdge((Rectangle)rectangle, (int)Math.min(this.size, n), (int)this.side);
    }

    public void showView(Composite composite, ViewPane viewPane, int n, float f) {
        this.side = n;
        if (this.currentPane != null) {
            this.hideView();
        }
        this.currentPane = new PresentablePart(viewPane, composite);
        this.fastViewAction.setPane(this.currentPane);
        this.clientComposite = composite;
        this.clientComposite.addListener(11, this.resizeListener);
        Control control = viewPane.getControl();
        if (control == null) {
            viewPane.createControl(this.clientComposite);
            control = viewPane.getControl();
        }
        control.addListener(31, this.escapeListener);
        AbstractPresentationFactory abstractPresentationFactory = this.getPresentationFactory();
        StackPresentation stackPresentation = abstractPresentationFactory.createViewPresentation(composite, this.site);
        this.site.setPresentation(stackPresentation);
        this.site.setPresentationState(2);
        stackPresentation.addPart(this.currentPane, null);
        stackPresentation.selectPart(this.currentPane);
        stackPresentation.setActive(1);
        stackPresentation.setVisible(true);
        boolean bl = Geometry.isHorizontal((int)this.side);
        this.minSize = stackPresentation.computePreferredSize(bl, Integer.MAX_VALUE, Geometry.getDimension((Rectangle)this.getClientArea(), (boolean)bl), 0);
        control.setEnabled(true);
        Composite composite2 = control.getParent();
        boolean bl2 = Geometry.isHorizontal((int)this.side);
        int n2 = AbstractPresentationFactory.SASHTYPE_FLOATING;
        n2 = bl2 ? (n2 |= AbstractPresentationFactory.SASHORIENTATION_HORIZONTAL) : (n2 |= AbstractPresentationFactory.SASHORIENTATION_VERTICAL);
        this.sash = abstractPresentationFactory.createSash(composite2, n2);
        this.sash.addSelectionListener((SelectionListener)this.selectionListener);
        Rectangle rectangle = composite.getClientArea();
        this.getPresentation().getControl().moveAbove(null);
        this.currentPane.getPane().moveAbove(null);
        this.sash.moveAbove(null);
        this.setSize((int)((float)Geometry.getDimension((Rectangle)rectangle, (!bl2 ? 1 : 0) != 0) * f));
        Display display = this.sash.getDisplay();
        display.addFilter(3, this.mouseDownListener);
        viewPane.setFocus();
    }

    private void updateFastViewSashBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getBounds();
        int n = Geometry.getOppositeSide((int)this.side);
        Rectangle rectangle3 = Geometry.getExtrudedEdge((Rectangle)rectangle2, (int)(-this.getSashSize()), (int)n);
        if (!rectangle3.equals((Object)(rectangle = this.sash.getBounds()))) {
            this.sash.setBounds(rectangle3);
        }
    }

    public void dispose() {
        this.hideView();
    }

    private StackPresentation getPresentation() {
        return this.site.getPresentation();
    }

    public void hideFastViewSash() {
        if (this.sash != null) {
            this.sash.setVisible(false);
        }
    }

    public void hideView() {
        Display display;
        if (this.clientComposite != null) {
            display = this.clientComposite.getDisplay();
            display.removeFilter(3, this.mouseDownListener);
        }
        if (this.currentPane == null) {
            return;
        }
        this.fastViewAction.setPane(null);
        this.currentPane.getPane().setZoomed(false);
        if (this.sash != null) {
            this.sash.dispose();
            this.sash = null;
        }
        this.clientComposite.removeListener(11, this.resizeListener);
        display = this.currentPane.getControl();
        display.removeListener(31, this.escapeListener);
        this.getPresentation().setVisible(false);
        this.site.dispose();
        display.setEnabled(false);
        this.currentPane.dispose();
        this.currentPane = null;
    }

    public ViewPane getCurrentPane() {
        if (this.currentPane != null && this.currentPane.getPane() instanceof ViewPane) {
            return (ViewPane)this.currentPane.getPane();
        }
        return null;
    }

    public void setState(int n) {
        this.site.setState(n);
    }

    public int getState() {
        return this.site.getState();
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    private int getSashSize() {
        AbstractPresentationFactory abstractPresentationFactory = this.getPresentationFactory();
        int n = AbstractPresentationFactory.SASHTYPE_FLOATING;
        n = Geometry.isHorizontal((int)this.side) ? (n |= AbstractPresentationFactory.SASHORIENTATION_HORIZONTAL) : (n |= AbstractPresentationFactory.SASHORIENTATION_VERTICAL);
        int n2 = abstractPresentationFactory.getSashSize(n);
        return n2;
    }

    private AbstractPresentationFactory getPresentationFactory() {
        if (this.presFactory == null) {
            this.presFactory = ((WorkbenchWindow)this.currentPane.getPane().getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        }
        return this.presFactory;
    }
}

