/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.RectangleAnimationFeedbackBase;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.ViewStackTrimToolBar;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.layout.TrimToolBarBase;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.internal.tweaklets.Animations;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.IPresentablePart;

public class FastViewManager {
    private Perspective perspective;
    private WorkbenchPage page;
    private WorkbenchWindow wbw;
    private TrimLayout tbm;
    private Map idToFastViewsMap = new HashMap();
    private boolean deferringUpdates = false;
    private AnimationEngine batchAnimation = null;
    private AnimationEngine oneShotAnimation = null;
    private IPerspectiveListener2 perspListener = new IPerspectiveListener2(){

        @Override
        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            if (FastViewManager.this.perspective.getDesc() == iPerspectiveDescriptor) {
                FastViewManager.this.handlePerspectiveActivation(iWorkbenchPage, iPerspectiveDescriptor);
            }
        }

        @Override
        public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
            if (FastViewManager.this.perspective.getDesc() == iPerspectiveDescriptor) {
                FastViewManager.this.handlePerspectiveChange(iWorkbenchPage, iPerspectiveDescriptor, iWorkbenchPartReference, string);
            }
        }

        @Override
        public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
            if (FastViewManager.this.perspective.getDesc() == iPerspectiveDescriptor) {
                FastViewManager.this.handlePerspectiveChange(iWorkbenchPage, iPerspectiveDescriptor, string);
            }
        }
    };

    public FastViewManager(Perspective perspective, WorkbenchPage workbenchPage) {
        this.perspective = perspective;
        this.page = workbenchPage;
        this.wbw = (WorkbenchWindow)workbenchPage.getWorkbenchWindow();
        this.tbm = (TrimLayout)this.wbw.getTrimManager();
    }

    protected void handlePerspectiveActivation(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        if (iWorkbenchPage == this.page && this.perspective.getDesc() == iPerspectiveDescriptor) {
            this.updateTrim(FastViewBar.FASTVIEWBAR_ID);
        }
    }

    protected void handlePerspectiveChange(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        ViewReference viewReference;
        if (iWorkbenchPage != this.page && this.perspective.getDesc() != iPerspectiveDescriptor) {
            return;
        }
        if (string.equals("viewHide") && iWorkbenchPartReference instanceof ViewReference && (viewReference = (ViewReference)iWorkbenchPartReference).getPane().getContainer() instanceof ViewStack) {
            int n = 0;
            LayoutPart[] layoutPartArray = viewReference.getPane().getContainer().getChildren();
            int n2 = 0;
            while (n2 < layoutPartArray.length) {
                if (layoutPartArray[n2] instanceof ViewPane && layoutPartArray[n2] != viewReference.getPane()) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                viewReference.getPane().getStack().setState(2);
            }
        }
        if (string.equals("fastViewRemove")) {
            this.removeViewReference((IViewReference)iWorkbenchPartReference, false, true);
        }
    }

    protected void handlePerspectiveChange(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
    }

    public List getFastViews(String string) {
        ArrayList arrayList = new ArrayList();
        for (String string2 : this.idToFastViewsMap.keySet()) {
            if (string != null && !string.equals(string2)) continue;
            List list = (List)this.idToFastViewsMap.get(string2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public void addViewReference(String string, int n, IViewReference iViewReference, boolean bl) {
        String string2;
        if (string == null || iViewReference == null) {
            return;
        }
        ArrayList<IViewReference> arrayList = (ArrayList<IViewReference>)this.idToFastViewsMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IViewReference>();
            this.idToFastViewsMap.put(string, arrayList);
        }
        if (n < 0 || n > arrayList.size()) {
            n = arrayList.size();
        }
        if ((string2 = this.getIdForRef(iViewReference)) != null) {
            if (string.equals(string2)) {
                int n2 = arrayList.indexOf(iViewReference);
                if (n == n2) {
                    return;
                }
                if (n > n2) {
                    --n;
                }
            }
            this.removeViewReference(iViewReference, false, true);
        } else {
            this.makeFast(iViewReference, true, false);
        }
        arrayList.add(n, iViewReference);
        if (bl) {
            this.updateTrim(string);
        }
    }

    private ViewStackTrimToolBar getTrimForViewStack(String string, int n, int n2) {
        ViewStackTrimToolBar viewStackTrimToolBar = (ViewStackTrimToolBar)this.tbm.getTrim(string);
        if (viewStackTrimToolBar == null) {
            int n3 = this.tbm.getPreferredArea(string);
            if (n3 != -1) {
                n = n3;
            }
            IWindowTrim iWindowTrim = this.tbm.getPreferredLocation(string);
            viewStackTrimToolBar = new ViewStackTrimToolBar(string, n, n2, this.wbw);
            this.tbm.addTrim(n, viewStackTrimToolBar, iWindowTrim);
            this.updateTrim(viewStackTrimToolBar.getId());
        }
        return viewStackTrimToolBar;
    }

    public void updateTrim(String string) {
        IWindowTrim iWindowTrim = this.tbm.getTrim(string);
        if (iWindowTrim == null) {
            return;
        }
        List list = (List)this.idToFastViewsMap.get(string);
        boolean bl = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("FVB_HIDE");
        if (!(list != null && list.size() != 0 || FastViewBar.FASTVIEWBAR_ID.equals(string) && !bl)) {
            if (iWindowTrim.getControl().getVisible()) {
                this.tbm.setTrimVisible(iWindowTrim, false);
                this.tbm.forceLayout();
            }
            return;
        }
        if (!iWindowTrim.getControl().getVisible()) {
            this.tbm.setTrimVisible(iWindowTrim, true);
        }
        if (iWindowTrim instanceof FastViewBar) {
            FastViewBar fastViewBar = (FastViewBar)iWindowTrim;
            fastViewBar.update(true);
        } else if (iWindowTrim instanceof ViewStackTrimToolBar) {
            ViewStackTrimToolBar viewStackTrimToolBar = (ViewStackTrimToolBar)iWindowTrim;
            viewStackTrimToolBar.update(true);
            viewStackTrimToolBar.getControl().pack();
            LayoutUtil.resize(iWindowTrim.getControl());
        }
        this.tbm.forceLayout();
    }

    public void removeViewReference(IViewReference iViewReference, boolean bl, boolean bl2) {
        String string = this.getIdForRef(iViewReference);
        if (string != null) {
            List list = (List)this.idToFastViewsMap.get(string);
            list.remove(iViewReference);
            if (bl) {
                this.makeFast(iViewReference, false, false);
            }
            if (bl2) {
                this.updateTrim(string);
            }
        }
    }

    private void makeFast(IViewReference iViewReference, boolean bl, boolean bl2) {
        if (iViewReference == null || this.page == null) {
            return;
        }
        if (bl) {
            this.page.makeFastView(iViewReference);
        } else {
            IWorkbenchPart iWorkbenchPart;
            this.page.removeFastView(iViewReference);
            if (bl2 && (iWorkbenchPart = iViewReference.getPart(true)) != null) {
                this.page.activate(iWorkbenchPart);
            }
        }
    }

    boolean isFastView(IViewReference iViewReference) {
        return this.getIdForRef(iViewReference) != null;
    }

    public String getIdForRef(IViewReference iViewReference) {
        for (String string : this.idToFastViewsMap.keySet()) {
            List list = (List)this.idToFastViewsMap.get(string);
            if (!list.contains(iViewReference)) continue;
            return string;
        }
        return null;
    }

    public int getViewSide(IViewReference iViewReference) {
        IWindowTrim iWindowTrim = this.getTrimForRef(iViewReference);
        if (iWindowTrim == null) {
            return 1024;
        }
        int n = 1024;
        int n2 = 1024;
        if (iWindowTrim instanceof ViewStackTrimToolBar) {
            n = ((ViewStackTrimToolBar)iWindowTrim).getCurrentSide();
            n2 = ((ViewStackTrimToolBar)iWindowTrim).getPaneOrientation();
        } else if (iWindowTrim instanceof FastViewBar) {
            n = ((FastViewBar)iWindowTrim).getSide();
            n2 = ((FastViewBar)iWindowTrim).getOrientation(iViewReference);
        }
        Point point = Geometry.centerPoint((Rectangle)iWindowTrim.getControl().getBounds());
        Point point2 = Geometry.centerPoint((Rectangle)iWindowTrim.getControl().getShell().getClientArea());
        if (n2 == 256) {
            if (n == 128 || n == 1024) {
                return n;
            }
            return point.y < point2.y ? 128 : 1024;
        }
        if (n2 == 512) {
            if (n == 16384 || n == 131072) {
                return n;
            }
            return point.x < point2.x ? 16384 : 131072;
        }
        return 1024;
    }

    private IWindowTrim getTrimForRef(IViewReference iViewReference) {
        String string = this.getIdForRef(iViewReference);
        if (string == null) {
            return null;
        }
        return this.tbm.getTrim(string);
    }

    private List getTrueViewOrder(ViewStack viewStack) {
        Object object;
        ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>();
        IPresentablePart[] iPresentablePartArray = null;
        if (viewStack.getPresentation() instanceof TabbedStackPresentation) {
            object = (TabbedStackPresentation)viewStack.getPresentation();
            iPresentablePartArray = ((TabbedStackPresentation)object).getPartList();
        }
        if (iPresentablePartArray == null || iPresentablePartArray.length == 0) {
            object = viewStack.getPresentableParts();
            iPresentablePartArray = object.toArray(new IPresentablePart[object.size()]);
        }
        int n = 0;
        while (n < iPresentablePartArray.length) {
            PresentablePart presentablePart;
            IWorkbenchPartReference iWorkbenchPartReference;
            if (iPresentablePartArray[n] instanceof PresentablePart && (iWorkbenchPartReference = (presentablePart = (PresentablePart)iPresentablePartArray[n]).getPane().getPartReference()) instanceof IViewReference) {
                arrayList.add(iWorkbenchPartReference);
            }
            ++n;
        }
        return arrayList;
    }

    public void moveToTrim(ViewStack viewStack, boolean bl) {
        Object object3;
        Object object2;
        if (viewStack.getBounds().width == 0) {
            return;
        }
        Rectangle rectangle = this.perspective.getPresentation().getCachedBoundsFor(viewStack.getID());
        if (rectangle == null) {
            rectangle = viewStack.getBounds();
        }
        int n = rectangle.width > rectangle.height ? 256 : 512;
        String string = "";
        PartPane partPane = viewStack.getSelection();
        if (partPane != null) {
            string = partPane.getCompoundId();
        }
        viewStack.deferUpdates(true);
        RectangleAnimationFeedbackBase rectangleAnimationFeedbackBase = (RectangleAnimationFeedbackBase)this.getDeferrableAnimation().getFeedback();
        rectangleAnimationFeedbackBase.addStartRect(viewStack.getControl());
        List list = this.getTrueViewOrder(viewStack);
        if (list.isEmpty()) {
            viewStack.dispose();
            object2 = viewStack.getContainer();
            object3 = new ContainerPlaceholder(viewStack.getID());
            ((ContainerPlaceholder)object3).setRealContainer(viewStack);
            object2.replace(viewStack, (LayoutPart)object3);
        } else {
            for (Object object3 : list) {
                this.addViewReference(viewStack.getID(), -1, (IViewReference)object3, false);
            }
        }
        viewStack.deferUpdates(false);
        object2 = this.getTrimForViewStack(viewStack.getID(), this.perspective.calcStackSide(rectangle), n);
        ((ViewStackTrimToolBar)object2).setRestoreOnUnzoom(bl);
        ((ViewStackTrimToolBar)object2).setSelectedTabId(string);
        if (list.isEmpty()) {
            object3 = object2;
            if (!object3.getControl().getVisible()) {
                this.tbm.setTrimVisible((IWindowTrim)object3, true);
            }
            if (object3 instanceof FastViewBar) {
                FastViewBar fastViewBar = (FastViewBar)object3;
                fastViewBar.update(true);
            } else if (object3 instanceof ViewStackTrimToolBar) {
                ((TrimToolBarBase)object2).update(true);
                ((TrimToolBarBase)object2).getControl().pack();
                LayoutUtil.resize(object3.getControl());
            }
            this.tbm.forceLayout();
        } else {
            this.updateTrim(((TrimToolBarBase)object2).getId());
        }
        if (object2 != null) {
            rectangleAnimationFeedbackBase.addEndRect(((TrimToolBarBase)object2).getControl());
            this.scheduleDeferrableAnimation();
        }
    }

    public void restoreToPresentation(String string) {
        Object object;
        ViewStackTrimToolBar viewStackTrimToolBar = this.getViewStackTrimToolbar(string);
        if (viewStackTrimToolBar == null) {
            return;
        }
        this.page.hideFastView();
        String string2 = viewStackTrimToolBar.getSelectedTabId();
        String[] stringArray = Util.split(string2, ':');
        String string3 = null;
        if (stringArray[0].length() != string2.length()) {
            string3 = stringArray[1];
        }
        List list = this.getFastViews(string);
        boolean bl = false;
        if (this.perspective.getDesc() != null) {
            bl = this.page.window.getWindowAdvisor().isDurableFolder(this.perspective.getDesc().getId(), string);
        }
        if (list.isEmpty() && bl) {
            LayoutPart layoutPart = this.perspective.getPresentation().findPart(string, null);
            if (layoutPart instanceof ContainerPlaceholder) {
                ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)layoutPart;
                ILayoutContainer iLayoutContainer = containerPlaceholder.getContainer();
                ILayoutContainer iLayoutContainer2 = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                if (iLayoutContainer2 instanceof LayoutPart) {
                    iLayoutContainer.replace(containerPlaceholder, (LayoutPart)((Object)iLayoutContainer2));
                }
                containerPlaceholder.setRealContainer(null);
                IWindowTrim iWindowTrim = this.tbm.getTrim(string);
                if (iWindowTrim == null) {
                    return;
                }
                if (iWindowTrim.getControl().getVisible()) {
                    this.tbm.setTrimVisible(iWindowTrim, false);
                    this.tbm.forceLayout();
                }
            }
            return;
        }
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (IViewReference)object2.next();
            this.removeViewReference((IViewReference)object, true, !object2.hasNext());
        }
        object2 = this.perspective.getPresentation().findPart(string, null);
        if (object2 instanceof PartStack && (object = this.perspective.getPresentation().findPart(stringArray[0], string3)) instanceof PartPane && object instanceof ViewPane) {
            ((PartStack)object2).setSelection((LayoutPart)object);
            if (!this.deferringUpdates) {
                ((ViewPane)object).requestActivation();
            }
        }
        this.updateTrim(string);
    }

    public void restoreZoomedViewStacks() {
        for (String string : this.idToFastViewsMap.keySet()) {
            ViewStackTrimToolBar viewStackTrimToolBar;
            IWindowTrim iWindowTrim = this.tbm.getTrim(string);
            if (iWindowTrim == null || !(iWindowTrim instanceof ViewStackTrimToolBar) || !(viewStackTrimToolBar = (ViewStackTrimToolBar)iWindowTrim).restoreOnUnzoom()) continue;
            this.restoreToPresentation(viewStackTrimToolBar.getId());
        }
    }

    public void setFastViewIconSelection(IViewReference iViewReference, boolean bl) {
        String string = this.getIdForRef(iViewReference);
        IWindowTrim iWindowTrim = this.tbm.getTrim(string);
        if (iWindowTrim instanceof ViewStackTrimToolBar) {
            ViewStackTrimToolBar viewStackTrimToolBar = (ViewStackTrimToolBar)iWindowTrim;
            viewStackTrimToolBar.setIconSelection(iViewReference, bl);
        } else if (iWindowTrim instanceof FastViewBar) {
            FastViewBar fastViewBar = (FastViewBar)iWindowTrim;
            if (bl) {
                fastViewBar.setSelection(iViewReference);
            } else if (iViewReference == fastViewBar.getSelection()) {
                fastViewBar.setSelection(null);
            }
        }
    }

    public void activate() {
        this.wbw.addPerspectiveListener(this.perspListener);
        this.setTrimStackVisibility(true);
    }

    public void deActivate() {
        this.wbw.removePerspectiveListener(this.perspListener);
        this.setTrimStackVisibility(false);
    }

    public boolean restoreAllTrimStacks() {
        boolean bl = false;
        for (String string : this.idToFastViewsMap.keySet()) {
            if (string.equals(FastViewBar.FASTVIEWBAR_ID)) continue;
            List list = this.getFastViews(string);
            Object object = list.iterator();
            while (object.hasNext()) {
                IViewReference iViewReference = (IViewReference)object.next();
                this.removeViewReference(iViewReference, true, !object.hasNext());
            }
            object = this.tbm.getTrim(string);
            if (object == null || !(object instanceof ViewStackTrimToolBar)) continue;
            this.tbm.removeTrim((IWindowTrim)object);
            object.getControl().dispose();
            bl = true;
        }
        this.tbm.forceLayout();
        return bl;
    }

    private void setTrimStackVisibility(boolean bl) {
        for (String string : this.idToFastViewsMap.keySet()) {
            IWindowTrim iWindowTrim;
            List list = this.getFastViews(string);
            if (bl && list.size() == 0 || (iWindowTrim = this.tbm.getTrim(string)) == null || !(iWindowTrim instanceof ViewStackTrimToolBar)) continue;
            ((ViewStackTrimToolBar)iWindowTrim).update(true);
            this.tbm.setTrimVisible(iWindowTrim, bl);
        }
    }

    public void saveState(IMemento iMemento) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        FastViewBar fastViewBar = this.wbw.getFastViewBar();
        if (fastViewBar != null && (object4 = this.getFastViews(FastViewBar.FASTVIEWBAR_ID)).size() > 0) {
            IMemento iMemento2 = iMemento.createChild("fastViews");
            Object object5 = object4.iterator();
            while (object5.hasNext()) {
                object3 = (IViewReference)object5.next();
                boolean bl = this.page.getViewFactory().getViewRegistry().find(object3.getId()).isRestorable();
                if (!bl) continue;
                object2 = iMemento2.createChild("view");
                object = ViewFactory.getKey((IViewReference)object3);
                object2.putString("id", (String)object);
                float f = this.perspective.getFastViewWidthRatio((IViewReference)object3);
                object2.putFloat("ratio", f);
            }
        }
        object4 = iMemento.createChild("fastViewBars");
        for (Object object5 : this.idToFastViewsMap.keySet()) {
            if (FastViewBar.FASTVIEWBAR_ID.equals(object5) || (object3 = this.getFastViews((String)object5)).size() <= 0) continue;
            IMemento iMemento3 = object4.createChild("fastViewBar");
            iMemento3.putString("id", (String)object5);
            object2 = (ViewStackTrimToolBar)this.tbm.getTrim((String)object5);
            if (object2 != null) {
                iMemento3.putInteger("fastViewLocation", ((TrimToolBarBase)object2).getCurrentSide());
                iMemento3.putInteger("orientation", ((ViewStackTrimToolBar)object2).getPaneOrientation());
                int n = ((ViewStackTrimToolBar)object2).restoreOnUnzoom() ? 1 : 0;
                iMemento3.putInteger("style", n);
                iMemento3.putString("selectedTabId", ((ViewStackTrimToolBar)object2).getSelectedTabId());
            }
            object = iMemento3.createChild("fastViews");
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                IMemento iMemento4 = object.createChild("view");
                IViewReference iViewReference = (IViewReference)iterator.next();
                String string = ViewFactory.getKey(iViewReference);
                iMemento4.putString("id", string);
                float f = this.perspective.getFastViewWidthRatio(iViewReference);
                iMemento4.putFloat("ratio", f);
            }
        }
    }

    public void restoreState(IMemento iMemento, MultiStatus multiStatus) {
        Object object;
        Object object2;
        IMemento iMemento2 = iMemento.getChild("fastViews");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.idToFastViewsMap.put(FastViewBar.FASTVIEWBAR_ID, arrayList);
        if (iMemento2 != null) {
            object2 = iMemento2.getChildren("view");
            int n = 0;
            while (n < ((Object)object2).length) {
                Object object3 = object2[n];
                object = this.perspective.restoreFastView((IMemento)object3, multiStatus);
                if (object != null) {
                    arrayList.add(object);
                }
                ++n;
            }
        }
        if ((object2 = iMemento.getChild("fastViewBars")) == null) {
            return;
        }
        IMemento[] iMementoArray = object2.getChildren("fastViewBar");
        int n = 0;
        while (n < iMementoArray.length) {
            object = iMementoArray[n].getString("id");
            iMemento2 = iMementoArray[n].getChild("fastViews");
            arrayList = new ArrayList();
            this.idToFastViewsMap.put(object, arrayList);
            if (iMemento2 != null) {
                int n2;
                IMemento[] iMementoArray2 = iMemento2.getChildren("view");
                multiStatus.merge(this.perspective.createReferences(iMementoArray2));
                if (iMementoArray2.length > 0) {
                    n2 = iMementoArray[n].getInteger("fastViewLocation");
                    int n3 = iMementoArray[n].getInteger("orientation");
                    int n4 = iMementoArray[n].getInteger("style");
                    boolean bl = n4 > 0;
                    String string = iMementoArray[n].getString("selectedTabId");
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((String)object, n2, n3, bl, string){
                        private final /* synthetic */ String val$id;
                        private final /* synthetic */ int val$side;
                        private final /* synthetic */ int val$orientation;
                        private final /* synthetic */ boolean val$restoreOnUnzoom;
                        private final /* synthetic */ String val$selId;
                        {
                            this.val$id = string;
                            this.val$side = n;
                            this.val$orientation = n2;
                            this.val$restoreOnUnzoom = bl;
                            this.val$selId = string2;
                        }

                        @Override
                        public void runWithException() throws Throwable {
                            ViewStackTrimToolBar viewStackTrimToolBar = FastViewManager.this.getTrimForViewStack(this.val$id, this.val$side, this.val$orientation);
                            viewStackTrimToolBar.setRestoreOnUnzoom(this.val$restoreOnUnzoom);
                            if (this.val$selId != null) {
                                viewStackTrimToolBar.setSelectedTabId(this.val$selId);
                            }
                        }
                    });
                }
                n2 = 0;
                while (n2 < iMementoArray2.length) {
                    IMemento iMemento3 = iMementoArray2[n2];
                    IViewReference iViewReference = this.perspective.restoreFastView(iMemento3, multiStatus);
                    if (iViewReference != null) {
                        arrayList.add(iViewReference);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public ViewStackTrimToolBar getViewStackTrimToolbar(String string) {
        return (ViewStackTrimToolBar)this.tbm.getTrim(string);
    }

    public void printFVModel() {
        for (String string : this.idToFastViewsMap.keySet()) {
            List list = (List)this.idToFastViewsMap.get(string);
            System.out.println("FastView: " + string + " count = " + list.size());
            for (IViewReference iViewReference : list) {
                System.out.println("  Ref: " + iViewReference.getId());
            }
        }
    }

    public void deferUpdates(boolean bl) {
        if (bl == this.deferringUpdates) {
            return;
        }
        this.deferringUpdates = bl;
        this.deferAnimations(this.deferringUpdates);
    }

    private void deferAnimations(boolean bl) {
        if (bl) {
            RectangleAnimationFeedbackBase rectangleAnimationFeedbackBase = ((Animations)Tweaklets.get(Animations.KEY)).createFeedback(this.wbw.getShell());
            this.batchAnimation = new AnimationEngine(rectangleAnimationFeedbackBase, 400);
            return;
        }
        if (this.batchAnimation != null) {
            this.batchAnimation.schedule();
        }
        this.batchAnimation = null;
    }

    private AnimationEngine getDeferrableAnimation() {
        if (this.deferringUpdates) {
            return this.batchAnimation;
        }
        RectangleAnimationFeedbackBase rectangleAnimationFeedbackBase = ((Animations)Tweaklets.get(Animations.KEY)).createFeedback(this.wbw.getShell());
        this.oneShotAnimation = new AnimationEngine(rectangleAnimationFeedbackBase, 400);
        return this.oneShotAnimation;
    }

    private void scheduleDeferrableAnimation() {
        if (this.deferringUpdates) {
            return;
        }
        if (this.oneShotAnimation != null) {
            this.oneShotAnimation.schedule();
        }
        this.oneShotAnimation = null;
    }

    public ViewStackTrimToolBar getBottomRightTrimStack() {
        ViewStackTrimToolBar viewStackTrimToolBar = null;
        Point point = new Point(0, 0);
        for (String string : this.idToFastViewsMap.keySet()) {
            if (string.equals(FastViewBar.FASTVIEWBAR_ID) || this.getFastViews(string).size() <= 0) continue;
            ViewStackTrimToolBar viewStackTrimToolBar2 = this.getViewStackTrimToolbar(string);
            Point point2 = viewStackTrimToolBar2.getControl().getLocation();
            if (point2.y <= point.y && (point2.y != point.y || point2.x <= point.x)) continue;
            point = point2;
            viewStackTrimToolBar = viewStackTrimToolBar2;
        }
        return viewStackTrimToolBar;
    }
}

