/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.presentations.PresentationUtil;

public class FastViewDnDHandler
implements IDragOverListener {
    private String id;
    private ToolBarManager tbm;
    private WorkbenchWindow wbw;
    private ViewDropTarget dropTarget = null;
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            Point point;
            Point point2 = DragUtil.getEventLoc(event);
            ToolBar toolBar = FastViewDnDHandler.this.tbm.getControl();
            ToolItem toolItem = toolBar.getItem(point = toolBar.toControl(point2));
            IViewReference iViewReference = (IViewReference)toolItem.getData("FastView");
            if (iViewReference != null) {
                FastViewDnDHandler.this.startDraggingFastView(iViewReference, point2, false);
            }
        }
    };

    public FastViewDnDHandler(String string, final ToolBarManager toolBarManager, WorkbenchWindow workbenchWindow) {
        this.id = string;
        this.tbm = toolBarManager;
        this.wbw = workbenchWindow;
        DragUtil.addDragTarget((Control)toolBarManager.getControl(), this);
        PresentationUtil.addDragListener((Control)toolBarManager.getControl(), this.dragListener);
        toolBarManager.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DragUtil.removeDragTarget((Control)disposeEvent.widget, FastViewDnDHandler.this);
                PresentationUtil.removeDragListener((Control)toolBarManager.getControl(), FastViewDnDHandler.this.dragListener);
            }
        });
    }

    private ToolItem getToolItem(Point point) {
        ToolBar toolBar = this.tbm.getControl();
        Point point2 = toolBar.toControl(point);
        return toolBar.getItem(point2);
    }

    @Override
    public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
        if (this.isStandaloneStack()) {
            return null;
        }
        ToolItem toolItem = this.getToolItem(point);
        if (object instanceof ViewPane) {
            ViewPane viewPane = (ViewPane)object;
            if (viewPane.getPage() != this.wbw.getActivePage()) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            return this.createDropTarget(arrayList, toolItem);
        }
        if (object instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)object;
            if (viewStack.getWorkbenchWindow() != this.wbw) {
                return null;
            }
            ArrayList<LayoutPart> arrayList = new ArrayList<LayoutPart>(viewStack.getItemCount());
            LayoutPart[] layoutPartArray = viewStack.getChildren();
            int n = 0;
            while (n < layoutPartArray.length) {
                if (!(layoutPartArray[n] instanceof PartPlaceholder)) {
                    arrayList.add(layoutPartArray[n]);
                }
                ++n;
            }
            return this.createDropTarget(arrayList, toolItem);
        }
        return null;
    }

    private boolean isStandaloneStack() {
        Perspective perspective = this.wbw.getActiveWorkbenchPage().getActivePerspective();
        List list = perspective.getFastViewManager().getFastViews(this.id);
        for (IViewReference iViewReference : list) {
            if (!perspective.isStandaloneView(iViewReference)) continue;
            return true;
        }
        return false;
    }

    private IDropTarget createDropTarget(List list, ToolItem toolItem) {
        if (this.dropTarget == null) {
            this.dropTarget = new ViewDropTarget(list, toolItem);
        } else {
            this.dropTarget.setTarget(list, toolItem);
        }
        return this.dropTarget;
    }

    public Rectangle getLocationOfNextIcon() {
        boolean bl;
        ToolBar toolBar = this.tbm.getControl();
        Rectangle rectangle = toolBar.getBounds();
        Point point = toolBar.computeSize(-1, -1, false);
        rectangle.height = point.y;
        rectangle.width = point.x;
        boolean bl2 = bl = (toolBar.getStyle() & 0x200) == 0;
        if (toolBar.getItemCount() == 0) {
            Geometry.setDimension((Rectangle)rectangle, (boolean)bl, (int)0);
        }
        int n = bl ? 131072 : 1024;
        rectangle = Geometry.getExtrudedEdge((Rectangle)rectangle, (int)(-Geometry.getDimension((Rectangle)rectangle, (!bl ? 1 : 0) != 0)), (int)n);
        return Geometry.toDisplay((Control)toolBar.getParent(), (Rectangle)rectangle);
    }

    private int getIndex(IViewReference iViewReference) {
        ToolItem[] toolItemArray = this.tbm.getControl().getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            if (toolItemArray[n].getData("FastView") == iViewReference) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void startDraggingFastView(IViewReference iViewReference, Point point, boolean bl) {
        int n = this.getIndex(iViewReference);
        if (n == -1) {
            return;
        }
        ToolItem toolItem = this.tbm.getControl().getItem(n);
        Rectangle rectangle = Geometry.toDisplay((Control)this.tbm.getControl(), (Rectangle)toolItem.getBounds());
        this.startDrag(((WorkbenchPartReference)((Object)iViewReference)).getPane(), rectangle, point, bl);
    }

    private void startDrag(Object object, Rectangle rectangle, Point point, boolean bl) {
        boolean bl2;
        Object object2;
        WorkbenchPage workbenchPage = this.wbw.getActiveWorkbenchPage();
        Perspective perspective = workbenchPage.getActivePerspective();
        if (object instanceof ViewPane && !perspective.isMoveable(((ViewPane)(object2 = (ViewPane)object)).getViewReference())) {
            return;
        }
        object2 = null;
        if (perspective != null) {
            object2 = perspective.getActiveFastView();
            if (workbenchPage != null) {
                workbenchPage.hideFastView();
            }
        }
        if (workbenchPage.isPageZoomed()) {
            workbenchPage.zoomOut();
        }
        if (!(bl2 = DragUtil.performDrag(object, rectangle, point, !bl)) && object2 != null && workbenchPage != null) {
            workbenchPage.toggleFastView((IViewReference)object2);
        }
    }

    class ViewDropTarget
    extends AbstractDropTarget {
        List panes;
        ToolItem curItem;

        public ViewDropTarget(List list, ToolItem toolItem) {
            this.setTarget(list, toolItem);
        }

        public void setTarget(List list, ToolItem toolItem) {
            this.panes = list;
            this.curItem = toolItem;
        }

        @Override
        public void drop() {
            if (this.curItem == null) {
                return;
            }
            Perspective perspective = FastViewDnDHandler.this.wbw.getActiveWorkbenchPage().getActivePerspective();
            FastViewManager fastViewManager = perspective.getFastViewManager();
            int n = FastViewDnDHandler.this.tbm.getControl().indexOf(this.curItem);
            Iterator iterator = this.panes.iterator();
            while (iterator.hasNext()) {
                ViewPane viewPane = (ViewPane)iterator.next();
                IViewReference iViewReference = viewPane.getViewReference();
                this.adoptRef(iViewReference);
                fastViewManager.addViewReference(FastViewDnDHandler.this.id, n++, iViewReference, !iterator.hasNext());
            }
        }

        private void adoptRef(IViewReference iViewReference) {
            Perspective perspective = FastViewDnDHandler.this.wbw.getActiveWorkbenchPage().getActivePerspective();
            PerspectiveHelper perspectiveHelper = perspective.getPresentation();
            ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)perspectiveHelper.findPart(FastViewDnDHandler.this.id, null);
            LayoutPart layoutPart = perspectiveHelper.findPart(iViewReference.getId(), iViewReference.getSecondaryId());
            ILayoutContainer iLayoutContainer = layoutPart.container;
            if (iLayoutContainer != containerPlaceholder) {
                LayoutPart layoutPart2;
                if (layoutPart instanceof PartPlaceholder) {
                    if (iLayoutContainer instanceof ContainerPlaceholder) {
                        layoutPart2 = (ViewStack)((ContainerPlaceholder)iLayoutContainer).getRealContainer();
                        layoutPart2.remove(layoutPart);
                    } else if (iLayoutContainer instanceof ViewStack) {
                        iLayoutContainer.remove(layoutPart);
                    }
                } else {
                    perspectiveHelper.derefPart(layoutPart);
                }
                layoutPart2 = new PartPlaceholder(iViewReference.getId());
                containerPlaceholder.add(layoutPart2);
            }
        }

        @Override
        public Cursor getCursor() {
            return DragCursors.getCursor(7);
        }

        @Override
        public Rectangle getSnapRectangle() {
            if (this.curItem == null) {
                if (FastViewDnDHandler.this.tbm.getControl().getItemCount() > 0) {
                    return FastViewDnDHandler.this.getLocationOfNextIcon();
                }
                return DragUtil.getDisplayBounds((Control)FastViewDnDHandler.this.tbm.getControl());
            }
            return Geometry.toDisplay((Control)FastViewDnDHandler.this.tbm.getControl(), (Rectangle)this.curItem.getBounds());
        }
    }
}

