/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class FastViewBarContextMenuContribution
extends ContributionItem {
    private MenuItem orientationItem;
    private MenuItem restoreItem;
    private MenuItem closeItem;
    private FastViewBar bar;
    private RadioMenu radioButtons;
    private IViewReference selectedView;
    private IntModel currentOrientation = new IntModel(512);
    private IChangeListener orientationChangeListener = new IChangeListener(){

        @Override
        public void update(boolean bl) {
            if (bl && FastViewBarContextMenuContribution.this.selectedView != null) {
                FastViewBarContextMenuContribution.this.bar.setOrientation(FastViewBarContextMenuContribution.this.selectedView, FastViewBarContextMenuContribution.this.currentOrientation.get());
            }
        }
    };

    public FastViewBarContextMenuContribution(FastViewBar fastViewBar) {
        this.bar = fastViewBar;
        this.currentOrientation.addChangeListener(this.orientationChangeListener);
    }

    public void fill(Menu menu, int n) {
        super.fill(menu, n);
        this.orientationItem = new MenuItem(menu, 64, n++);
        this.orientationItem.setText(WorkbenchMessages.FastViewBar_view_orientation);
        Object object = new Menu(this.orientationItem);
        RadioMenu radioMenu = new RadioMenu((Menu)object, this.currentOrientation);
        radioMenu.addMenuItem(WorkbenchMessages.FastViewBar_horizontal, new Integer(256));
        radioMenu.addMenuItem(WorkbenchMessages.FastViewBar_vertical, new Integer(512));
        this.orientationItem.setMenu((Menu)object);
        this.restoreItem = new MenuItem(menu, 32, n++);
        this.restoreItem.setText(WorkbenchMessages.ViewPane_fastView);
        this.restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FastViewBarContextMenuContribution.this.bar.restoreView(FastViewBarContextMenuContribution.this.selectedView);
            }
        });
        this.closeItem = new MenuItem(menu, 0, n++);
        this.closeItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        this.closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchPage workbenchPage;
                if (FastViewBarContextMenuContribution.this.selectedView != null && (workbenchPage = FastViewBarContextMenuContribution.this.bar.getWindow().getActiveWorkbenchPage()) != null) {
                    workbenchPage.hideView(FastViewBarContextMenuContribution.this.selectedView);
                }
            }
        });
        object = this.bar.getWindow().getActiveWorkbenchPage();
        if (this.selectedView != null) {
            this.restoreItem.setEnabled(object != null && ((WorkbenchPage)object).isMoveable(this.selectedView));
        } else {
            this.restoreItem.setEnabled(false);
        }
        this.restoreItem.setSelection(true);
        if (this.selectedView != null) {
            this.closeItem.setEnabled(object != null && ((WorkbenchPage)object).isCloseable(this.selectedView));
        } else {
            this.closeItem.setEnabled(false);
        }
        this.orientationItem.setEnabled(this.selectedView != null);
        if (this.selectedView != null) {
            this.currentOrientation.set(this.bar.getOrientation(this.selectedView), this.orientationChangeListener);
        }
    }

    public void setTarget(IViewReference iViewReference) {
        this.selectedView = iViewReference;
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        if (this.radioButtons != null) {
            this.radioButtons.dispose();
        }
        super.dispose();
    }
}

