/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.FastViewBarContextMenuContribution;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.PresentationUtil;
import org.osgi.framework.Bundle;

public class FastViewBar
implements IWindowTrim {
    public static String FASTVIEWBAR_ID = "org.eclise.ui.internal.FastViewBar";
    private ToolBarManager fastViewBar;
    private MenuManager fastViewBarMenuManager;
    private MenuManager showViewMenuMgr;
    private FastViewBarContextMenuContribution contextContributionItem;
    private WorkbenchWindow window;
    private IViewReference selection;
    private MenuManager newFastViewMenuMgr;
    private Composite fvbComposite;
    private ToolBar menuTB;
    private ToolItem menuItem;
    private CellData toolBarData;
    private static final int HIDDEN_WIDTH = 5;
    private int oldLength = 0;
    private ViewDropTarget dropTarget;
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = DragUtil.getEventLoc(event);
            IViewReference iViewReference = FastViewBar.this.getViewAt(point);
            if (iViewReference == null) {
                FastViewBar.this.startDraggingFastViewBar(point, false);
            } else {
                FastViewBar.this.startDraggingFastView(iViewReference, point, false);
            }
        }
    };
    private Map viewOrientation = new HashMap();
    private Listener addMenuListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 35) {
                FastViewBar.this.showAddFastViewPopup(point);
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 35) {
                FastViewBar.this.showFastViewBarPopup(point);
            }
        }
    };
    private int fCurrentSide = -1;
    private boolean hasNewFastViewDisabled = false;

    public FastViewBar(WorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
        this.hasNewFastViewDisabled = PrefUtil.getAPIPreferenceStore().getBoolean("disableNewFastView");
        this.fastViewBarMenuManager = new MenuManager();
        this.contextContributionItem = new FastViewBarContextMenuContribution(this);
        this.fastViewBarMenuManager.add((IContributionItem)this.contextContributionItem);
        if (!this.hasNewFastViewDisabled) {
            this.showViewMenuMgr = new MenuManager(WorkbenchMessages.FastViewBar_show_view, "showView");
            ShowViewMenu showViewMenu = new ShowViewMenu(this.window, ShowViewMenu.class.getName(), true);
            this.showViewMenuMgr.add((IContributionItem)showViewMenu);
            this.fastViewBarMenuManager.add((IContributionItem)this.showViewMenuMgr);
            this.newFastViewMenuMgr = new MenuManager(WorkbenchMessages.FastViewBar_show_view, "showView");
            showViewMenu = new ShowViewMenu(this.window, ShowViewMenu.class.getName(), true);
            this.newFastViewMenuMgr.add((IContributionItem)showViewMenu);
        }
    }

    public static int getInitialSide() {
        String string = PrefUtil.getAPIPreferenceStore().getString("initialFastViewBarLocation");
        if ("bottom".equals(string)) {
            return 1024;
        }
        if ("left".equals(string)) {
            return 16384;
        }
        if ("right".equals(string)) {
            return 131072;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        if (bundle != null) {
            Status status = new Status(2, "org.eclipse.ui", 2, "Invalid value for org.eclipse.ui/initialFastViewBarLocation preference.  Value \"" + string + "\" should be one of \"" + "left" + "\", \"" + "bottom" + "\", or \"" + "right" + "\".", null);
            Platform.getLog((Bundle)bundle).log((IStatus)status);
        }
        return 1024;
    }

    public void setOrientation(IViewReference iViewReference, int n) {
        if (n == this.getOrientation(iViewReference)) {
            return;
        }
        this.viewOrientation.put(iViewReference.getId(), new Integer(n));
        Perspective perspective = this.getPerspective();
        if (perspective != null) {
            IViewReference iViewReference2 = perspective.getActiveFastView();
            if (iViewReference2 != null) {
                perspective.setActiveFastView(null);
            }
            perspective.setActiveFastView(iViewReference);
        }
    }

    private WorkbenchPage getPage() {
        if (this.window == null) {
            return null;
        }
        return this.window.getActiveWorkbenchPage();
    }

    private Perspective getPerspective() {
        WorkbenchPage workbenchPage = this.getPage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActivePerspective();
    }

    public void createControl(Composite composite) {
        this.fvbComposite = new Composite(composite, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                Point point = super.computeSize(n, n2, bl);
                if (Geometry.isHorizontal((int)FastViewBar.this.getSide())) {
                    if (point.y < TrimUtil.TRIM_DEFAULT_HEIGHT) {
                        point.y = TrimUtil.TRIM_DEFAULT_HEIGHT;
                    }
                } else if (point.x < TrimUtil.TRIM_DEFAULT_HEIGHT) {
                    point.x = TrimUtil.TRIM_DEFAULT_HEIGHT;
                }
                return point;
            }
        };
        String string = WorkbenchMessages.FastViewBar_0;
        this.fvbComposite.setToolTipText(string);
        this.fvbComposite.addListener(35, this.menuListener);
        PresentationUtil.addDragListener((Control)this.fvbComposite, this.dragListener);
        this.createChildControls();
    }

    protected void createChildControls() {
        Object object;
        int n = this.getSide();
        int n2 = Geometry.isHorizontal((int)n) ? 256 : 512;
        CellLayout cellLayout = Geometry.isHorizontal((int)n) ? new CellLayout(0).setMargins(0, 0).setDefaultRow(Row.growing()).setDefaultColumn(Row.fixed()).setColumn(1, Row.growing()) : new CellLayout(1).setMargins(0, 3).setDefaultColumn(Row.growing()).setDefaultRow(Row.fixed()).setRow(1, Row.growing());
        this.fvbComposite.setLayout((Layout)cellLayout);
        if (!this.hasNewFastViewDisabled) {
            this.menuTB = new ToolBar(this.fvbComposite, 0x800000 | n2);
            this.menuItem = new ToolItem(this.menuTB, 8, 0);
            object = WorkbenchImages.getImage("IMG_ETOOL_NEW_FASTVIEW");
            this.menuItem.setImage(object);
            final String string = WorkbenchMessages.FastViewBar_0;
            this.menuItem.setToolTipText(string);
            this.menuTB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = string;
                }
            });
            Point point = this.menuTB.computeSize(-1, -1, true);
            this.menuTB.setBounds(0, 0, point.x, point.y);
            this.menuItem.addListener(35, this.addMenuListener);
            this.menuTB.addListener(35, this.addMenuListener);
            this.menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Rectangle rectangle = DragUtil.getDisplayBounds((Control)FastViewBar.this.menuTB);
                    FastViewBar.this.showAddFastViewPopup(new Point(rectangle.x, rectangle.y + rectangle.height));
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            this.toolBarData = new CellData();
            this.toolBarData.align(4, 4);
            this.menuTB.setLayoutData((Object)this.toolBarData);
        }
        this.fastViewBar = new ToolBarManager(0x800040 | n2);
        this.fastViewBar.add((IContributionItem)new ShowFastViewContribution(this.window));
        this.fastViewBar.createControl(this.fvbComposite);
        this.getToolBar().addListener(35, this.menuListener);
        object = new IDragOverListener(){

            @Override
            public IDropTarget drag(Control control, Object object, Point point, Rectangle rectangle) {
                ToolItem toolItem = FastViewBar.this.getToolItem(point);
                if (object instanceof ViewPane) {
                    ViewPane viewPane = (ViewPane)object;
                    if (viewPane.getWorkbenchWindow() != FastViewBar.this.window) {
                        return null;
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(1);
                    arrayList.add(object);
                    return FastViewBar.this.createDropTarget(arrayList, toolItem);
                }
                if (object instanceof ViewStack) {
                    ViewStack viewStack = (ViewStack)object;
                    if (viewStack.getWorkbenchWindow() != FastViewBar.this.window) {
                        return null;
                    }
                    ArrayList<LayoutPart> arrayList = new ArrayList<LayoutPart>(viewStack.getItemCount());
                    LayoutPart[] layoutPartArray = viewStack.getChildren();
                    int n = 0;
                    while (n < layoutPartArray.length) {
                        if (!(layoutPartArray[n] instanceof PartPlaceholder)) {
                            arrayList.add(layoutPartArray[n]);
                        }
                        ++n;
                    }
                    return FastViewBar.this.createDropTarget(arrayList, toolItem);
                }
                return null;
            }
        };
        this.toolBarData = new CellData();
        this.toolBarData.align(4, 4);
        this.getToolBar().setLayoutData((Object)this.toolBarData);
        PresentationUtil.addDragListener((Control)this.getToolBar(), this.dragListener);
        DragUtil.addDragTarget(this.getControl(), (IDragOverListener)object);
        this.update(true);
    }

    private IDropTarget createDropTarget(List list, ToolItem toolItem) {
        if (this.dropTarget == null) {
            this.dropTarget = new ViewDropTarget(list, toolItem);
        } else {
            this.dropTarget.setTarget(list, toolItem);
        }
        return this.dropTarget;
    }

    protected void startDraggingFastView(IViewReference iViewReference, Point point, boolean bl) {
        ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
        ToolItem toolItem = this.itemFor(viewPane.getViewReference());
        Rectangle rectangle = Geometry.toDisplay((Control)this.getToolBar(), (Rectangle)toolItem.getBounds());
        this.startDrag(((WorkbenchPartReference)((Object)iViewReference)).getPane(), rectangle, point, bl);
    }

    private void startDrag(Object object, Rectangle rectangle, Point point, boolean bl) {
        boolean bl2;
        Perspective perspective = this.getPerspective();
        WorkbenchPage workbenchPage = this.getPage();
        IViewReference iViewReference = null;
        if (perspective != null) {
            iViewReference = perspective.getActiveFastView();
            if (workbenchPage != null) {
                workbenchPage.hideFastView();
            }
        }
        if (workbenchPage != null && workbenchPage.isZoomed()) {
            workbenchPage.zoomOut();
        }
        if (!(bl2 = DragUtil.performDrag(object, rectangle, point, !bl)) && iViewReference != null && workbenchPage != null) {
            workbenchPage.toggleFastView(iViewReference);
        }
    }

    protected void startDraggingFastViewBar(Point point, boolean bl) {
        Rectangle rectangle = DragUtil.getDisplayBounds((Control)this.fvbComposite);
        this.startDrag(this, rectangle, point, bl);
    }

    private ToolBar getToolBar() {
        return this.fastViewBar.getControl();
    }

    private IViewReference getViewFor(ToolItem toolItem) {
        if (toolItem == null) {
            return null;
        }
        return (IViewReference)toolItem.getData("FastView");
    }

    private IViewReference getViewAt(Point point) {
        return this.getViewFor(this.getToolItem(point));
    }

    private ToolItem getToolItem(Point point) {
        ToolBar toolBar = this.getToolBar();
        Point point2 = toolBar.toControl(point);
        return toolBar.getItem(point2);
    }

    private void showFastViewBarPopup(Point point) {
        ToolBar toolBar = this.getToolBar();
        Menu menu = this.fastViewBarMenuManager.createContextMenu((Control)toolBar);
        IViewReference iViewReference = this.getViewAt(point);
        this.contextContributionItem.setTarget(iViewReference);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    private void showAddFastViewPopup(Point point) {
        Menu menu = this.newFastViewMenuMgr.createContextMenu((Control)this.menuTB);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    public int getOrientation(IViewReference iViewReference) {
        return this.isHorizontal(iViewReference) ? 256 : 512;
    }

    @Override
    public Control getControl() {
        return this.fvbComposite;
    }

    public void dispose() {
        this.fastViewBarMenuManager.dispose();
        this.disposeChildControls();
    }

    protected void disposeChildControls() {
        this.fastViewBar.dispose();
        this.fastViewBar = null;
        if (this.menuItem != null) {
            this.menuItem.dispose();
            this.menuTB.dispose();
        }
        this.oldLength = 0;
    }

    public void update(boolean bl) {
        this.fastViewBar.update(bl);
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        this.updateLayoutData();
        int n = 0;
        while (n < toolItemArray.length) {
            IViewReference iViewReference = this.getViewFor(toolItemArray[n]);
            this.viewOrientation.put(iViewReference.getId(), new Integer(this.isHorizontal(iViewReference) ? 256 : 512));
            ++n;
        }
        this.fvbComposite.setSize(this.fvbComposite.computeSize(-1, -1));
    }

    private void updateLayoutData() {
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        boolean bl = Geometry.isHorizontal((int)this.getSide());
        boolean bl2 = toolItemArray.length > 0;
        Point point = new Point(32, bl2 ? -1 : 5);
        if (!bl) {
            Geometry.flipXY((Point)point);
        }
        if (bl2) {
            this.toolBarData.setHint(2, point);
        } else {
            this.toolBarData.setHint(1, point);
        }
        if (toolItemArray.length != this.oldLength) {
            LayoutUtil.resize((Control)this.fvbComposite);
            this.oldLength = toolItemArray.length;
        }
    }

    public IViewReference getSelection() {
        return this.selection;
    }

    public void setSelection(IViewReference iViewReference) {
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem;
            toolItem.setSelection(this.getView(toolItem = toolItemArray[n]) == iViewReference);
            ++n;
        }
        this.selection = iViewReference;
    }

    private IViewReference getView(ToolItem toolItem) {
        return (IViewReference)toolItem.getData("FastView");
    }

    private int getIndex(IViewReference iViewReference) {
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            if (toolItemArray[n].getData("FastView") == iViewReference) {
                return n;
            }
            ++n;
        }
        return toolItemArray.length;
    }

    private ToolItem getItem(int n) {
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        if (n >= toolItemArray.length) {
            return null;
        }
        return toolItemArray[n];
    }

    private ToolItem itemFor(IViewReference iViewReference) {
        return this.getItem(this.getIndex(iViewReference));
    }

    @Override
    public int getValidSides() {
        return 148608;
    }

    @Override
    public void dock(int n) {
        this.fCurrentSide = n;
        this.disposeChildControls();
        this.createChildControls();
    }

    public int getSide() {
        if (this.fCurrentSide == -1) {
            this.fCurrentSide = FastViewBar.getInitialSide();
        }
        return this.fCurrentSide;
    }

    private boolean isHorizontal(IViewReference iViewReference) {
        boolean bl;
        Integer n = (Integer)this.viewOrientation.get(iViewReference.getId());
        boolean bl2 = bl = Geometry.isHorizontal((int)this.getSide());
        bl2 = n != null ? n == 256 : false;
        return bl2;
    }

    public int getViewSide(IViewReference iViewReference) {
        boolean bl = this.isHorizontal(iViewReference);
        if (bl) {
            return this.getSide() == 1024 ? 1024 : 128;
        }
        return this.getSide() == 131072 ? 131072 : 16384;
    }

    public void saveState(IMemento iMemento) {
        iMemento.putInteger("fastViewLocation", this.getSide());
        for (String string : this.viewOrientation.keySet()) {
            IMemento iMemento2 = iMemento.createChild("orientation");
            iMemento2.putString("view", string);
            iMemento2.putInteger("position", (Integer)this.viewOrientation.get(string));
        }
    }

    public Rectangle getLocationOfNextIcon() {
        ToolBar toolBar = this.getToolBar();
        Rectangle rectangle = toolBar.getBounds();
        Point point = toolBar.computeSize(-1, -1, false);
        rectangle.height = point.y;
        rectangle.width = point.x;
        boolean bl = Geometry.isHorizontal((int)this.getSide());
        if (toolBar.getItemCount() == 0) {
            Geometry.setDimension((Rectangle)rectangle, (boolean)bl, (int)0);
        }
        int n = bl ? 131072 : 1024;
        rectangle = Geometry.getExtrudedEdge((Rectangle)rectangle, (int)(-Geometry.getDimension((Rectangle)rectangle, (!bl ? 1 : 0) != 0)), (int)n);
        return Geometry.toDisplay((Control)toolBar.getParent(), (Rectangle)rectangle);
    }

    public void restoreState(IMemento iMemento) {
        Integer n = iMemento.getInteger("fastViewLocation");
        if (n != null) {
            this.dock(n);
        }
        IMemento[] iMementoArray = iMemento.getChildren("orientation");
        int n2 = 0;
        while (n2 < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n2];
            this.viewOrientation.put(iMemento2.getString("view"), iMemento2.getInteger("position"));
            ++n2;
        }
    }

    public WorkbenchWindow getWindow() {
        return this.window;
    }

    public void restoreView(IViewReference iViewReference) {
        WorkbenchPage workbenchPage;
        if (iViewReference != null && (workbenchPage = this.window.getActiveWorkbenchPage()) != null) {
            IWorkbenchPart iWorkbenchPart;
            int n = this.getIndex(iViewReference);
            ToolItem toolItem = this.getItem(n);
            Rectangle rectangle = toolItem.getBounds();
            Rectangle rectangle2 = Geometry.toDisplay((Control)toolItem.getParent(), (Rectangle)rectangle);
            Perspective perspective = this.getPerspective();
            if (perspective != null) {
                perspective.getFastViewManager().removeViewReference(iViewReference, true, true);
            }
            if ((iWorkbenchPart = iViewReference.getPart(true)) != null) {
                workbenchPage.activate(iWorkbenchPart);
            }
            ViewPane viewPane = (ViewPane)((WorkbenchPartReference)((Object)iViewReference)).getPane();
            AnimationEngine.createTweakedAnimation(this.window.getShell(), 400, rectangle2, viewPane.getParentBounds());
        }
    }

    public List getViewRefs() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.fastViewBar.getControl().getItemCount());
        ToolItem[] toolItemArray = this.fastViewBar.getControl().getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            Object object = toolItemArray[n].getData("FastView");
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public void handleClose() {
    }

    @Override
    public String getId() {
        return "org.eclise.ui.internal.FastViewBar";
    }

    @Override
    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_FastView_TrimName;
    }

    public FastViewBarContextMenuContribution testContextMenu() {
        return this.contextContributionItem;
    }

    @Override
    public int getWidthHint() {
        return -1;
    }

    @Override
    public int getHeightHint() {
        return -1;
    }

    @Override
    public boolean isResizeable() {
        return false;
    }

    class ViewDropTarget
    extends AbstractDropTarget {
        List panes;
        ToolItem position;

        public ViewDropTarget(List list, ToolItem toolItem) {
            this.setTarget(list, toolItem);
        }

        public void setTarget(List list, ToolItem toolItem) {
            this.panes = list;
            this.position = toolItem;
        }

        @Override
        public void drop() {
            IViewReference iViewReference = FastViewBar.this.getViewFor(this.position);
            for (ViewPane viewPane : this.panes) {
                IViewReference iViewReference2 = viewPane.getViewReference();
                FastViewBar.this.getPerspective().getFastViewManager().addViewReference(FASTVIEWBAR_ID, FastViewBar.this.getIndex(iViewReference), iViewReference2, true);
            }
            FastViewBar.this.update(true);
        }

        @Override
        public Cursor getCursor() {
            return DragCursors.getCursor(7);
        }

        @Override
        public Rectangle getSnapRectangle() {
            if (this.position == null) {
                if (FastViewBar.this.getToolBar().getItemCount() > 0) {
                    return FastViewBar.this.getLocationOfNextIcon();
                }
                return DragUtil.getDisplayBounds(FastViewBar.this.getControl());
            }
            return Geometry.toDisplay((Control)FastViewBar.this.getToolBar(), (Rectangle)this.position.getBounds());
        }
    }
}

