/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;

class ExtensionEventHandler
implements IRegistryChangeListener {
    private Workbench workbench;
    private List changeList = new ArrayList(10);

    public ExtensionEventHandler(Workbench workbench) {
        this.workbench = workbench;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        try {
            IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(WorkbenchPlugin.PI_WORKBENCH);
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                return;
            }
            ArrayList<IExtensionDelta> arrayList = new ArrayList<IExtensionDelta>(5);
            ArrayList<IExtensionDelta> arrayList2 = new ArrayList<IExtensionDelta>(5);
            String string = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < iExtensionDeltaArray.length) {
                string = iExtensionDeltaArray[n3].getExtensionPoint().getSimpleIdentifier();
                if (iExtensionDeltaArray[n3].getKind() == 1) {
                    if (string.equals("actionSets")) {
                        arrayList.add(0, iExtensionDeltaArray[n3]);
                    } else if (!(string.equals("perspectives") || string.equals("views") || string.equals("actionSets"))) {
                        arrayList.add(arrayList.size() - n, iExtensionDeltaArray[n3]);
                    }
                } else if (iExtensionDeltaArray[n3].getKind() == 2) {
                    if (string.equals("actionSetPartAssociations")) {
                        arrayList2.add(0, iExtensionDeltaArray[n3]);
                        ++n2;
                    } else if (string.equals("perspectives")) {
                        arrayList2.add(n2, iExtensionDeltaArray[n3]);
                    } else {
                        arrayList2.add(iExtensionDeltaArray[n3]);
                    }
                }
                ++n3;
            }
            Iterator iterator = arrayList.iterator();
            IExtensionDelta iExtensionDelta = null;
            while (iterator.hasNext()) {
                iExtensionDelta = (IExtensionDelta)iterator.next();
                IExtensionPoint iExtensionPoint = iExtensionDelta.getExtensionPoint();
                IExtension iExtension = iExtensionDelta.getExtension();
                this.asyncAppear(display, iExtensionPoint, iExtension);
            }
            this.resetCurrentPerspective(display);
        }
        finally {
            this.changeList.clear();
        }
    }

    private void asyncAppear(Display display, final IExtensionPoint iExtensionPoint, final IExtension iExtension) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExtensionEventHandler.this.appear(iExtensionPoint, iExtension);
            }
        };
        display.syncExec(runnable);
    }

    private void appear(IExtensionPoint iExtensionPoint, IExtension iExtension) {
        String string = iExtensionPoint.getSimpleIdentifier();
        if (string.equalsIgnoreCase("fontDefinitions")) {
            this.loadFontDefinitions(iExtension);
            return;
        }
        if (string.equalsIgnoreCase("themes")) {
            this.loadThemes(iExtension);
            return;
        }
    }

    private void loadFontDefinitions(IExtension iExtension) {
        ThemeRegistryReader themeRegistryReader = new ThemeRegistryReader();
        themeRegistryReader.setRegistry((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry());
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            themeRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
        Collection collection = themeRegistryReader.getFontDefinitions();
        FontDefinition[] fontDefinitionArray = collection.toArray(new FontDefinition[collection.size()]);
        ThemeElementHelper.populateRegistry(this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), fontDefinitionArray, PrefUtil.getInternalPreferenceStore());
    }

    private void loadThemes(IExtension iExtension) {
        ThemeRegistryReader themeRegistryReader = new ThemeRegistryReader();
        ThemeRegistry themeRegistry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
        themeRegistryReader.setRegistry(themeRegistry);
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            themeRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
        Collection collection = themeRegistryReader.getColorDefinitions();
        ColorDefinition[] colorDefinitionArray = collection.toArray(new ColorDefinition[collection.size()]);
        ITheme iTheme = this.workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
        ThemeElementHelper.populateRegistry(iTheme, colorDefinitionArray, PrefUtil.getInternalPreferenceStore());
        Collection collection2 = themeRegistryReader.getFontDefinitions();
        FontDefinition[] fontDefinitionArray = collection2.toArray(new FontDefinition[collection2.size()]);
        ThemeElementHelper.populateRegistry(iTheme, fontDefinitionArray, PrefUtil.getInternalPreferenceStore());
        Map map = themeRegistryReader.getData();
        themeRegistry.addData(map);
    }

    private void resetCurrentPerspective(Display display) {
        if (this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer stringBuffer = new StringBuffer(ExtensionEventHandlerMessages.ExtensionEventHandler_following_changes);
        Iterator iterator = this.changeList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append(ExtensionEventHandlerMessages.ExtensionEventHandler_need_to_reset);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = null;
                IWorkbenchWindow iWorkbenchWindow = ExtensionEventHandler.this.workbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    if (ExtensionEventHandler.this.workbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    iWorkbenchWindow = ExtensionEventHandler.this.workbench.getWorkbenchWindows()[0];
                }
                if (MessageDialog.openQuestion((Shell)(shell = iWorkbenchWindow.getShell()), (String)ExtensionEventHandlerMessages.ExtensionEventHandler_reset_perspective, (String)stringBuffer.toString())) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPage.resetPerspective();
                }
            }
        });
    }
}

