/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.window.Window;
import org.eclipse.ui.internal.Workbench;

public final class ExceptionHandler
implements Window.IExceptionHandler {
    private static final ExceptionHandler instance = new ExceptionHandler();
    private int exceptionCount = 0;

    public static ExceptionHandler getInstance() {
        return instance;
    }

    private ExceptionHandler() {
    }

    public void handleException(Throwable throwable) {
        try {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            ++this.exceptionCount;
            if (this.exceptionCount > 2) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
            Workbench workbench = Workbench.getInstance();
            if (workbench != null) {
                workbench.getAdvisor().eventLoopException(throwable);
            }
        }
        finally {
            --this.exceptionCount;
        }
    }
}

