/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.SystemMenuPinEditor;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.StackPresentation;

public class EditorStack
extends PartStack {
    private EditorSashContainer editorArea;
    private WorkbenchPage page;
    private SystemMenuSize sizeItem = new SystemMenuSize(null);
    private SystemMenuPinEditor pinEditorItem = new SystemMenuPinEditor(null);

    public EditorStack(EditorSashContainer editorSashContainer, WorkbenchPage workbenchPage) {
        super(1);
        this.editorArea = editorSashContainer;
        this.setID(this.toString());
        this.page = workbenchPage;
    }

    @Override
    protected WorkbenchPage getPage() {
        return this.page;
    }

    @Override
    public void addSystemActions(IMenuManager iMenuManager) {
        this.pinEditorItem = new SystemMenuPinEditor((EditorPane)this.getSelection());
        EditorStack.appendToGroupIfPossible(iMenuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.pinEditorItem));
        this.sizeItem = new SystemMenuSize(this.getSelection());
        EditorStack.appendToGroupIfPossible(iMenuManager, "size", this.sizeItem);
    }

    @Override
    public boolean isMoveable(IPresentablePart iPresentablePart) {
        return true;
    }

    @Override
    public boolean supportsState(int n) {
        return !this.page.isFixedLayout();
    }

    public static EditorStack newEditorWorkbook(EditorSashContainer editorSashContainer, WorkbenchPage workbenchPage) {
        return new EditorStack(editorSashContainer, workbenchPage);
    }

    @Override
    protected void add(LayoutPart layoutPart, Object object) {
        super.add(layoutPart, object);
        ((EditorPane)layoutPart).setWorkbook(this);
    }

    @Override
    public void add(LayoutPart layoutPart) {
        super.add(layoutPart);
        if (layoutPart instanceof EditorPane) {
            ((EditorPane)layoutPart).setWorkbook(this);
        }
    }

    @Override
    protected void updateActions(PresentablePart presentablePart) {
        EditorPane editorPane = null;
        if (presentablePart != null && presentablePart.getPane() instanceof EditorPane) {
            editorPane = (EditorPane)presentablePart.getPane();
        }
        this.sizeItem.setPane(editorPane);
        this.pinEditorItem.setPane(editorPane);
    }

    public Control[] getTabList() {
        return this.getTabList(this.getSelection());
    }

    public void removeAll() {
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            this.remove(layoutPartArray[n]);
            ++n;
        }
    }

    public boolean isActiveWorkbook() {
        EditorSashContainer editorSashContainer = this.getEditorArea();
        if (editorSashContainer != null) {
            return editorSashContainer.isActiveWorkbook(this);
        }
        return false;
    }

    public void becomeActiveWorkbook(boolean bl) {
        EditorSashContainer editorSashContainer = this.getEditorArea();
        if (editorSashContainer != null) {
            editorSashContainer.setActiveWorkbook(this, bl);
        }
    }

    public EditorPane[] getEditors() {
        LayoutPart[] layoutPartArray = this.getChildren();
        EditorPane[] editorPaneArray = new EditorPane[layoutPartArray.length];
        int n = 0;
        while (n < layoutPartArray.length) {
            editorPaneArray[n] = (EditorPane)layoutPartArray[n];
            ++n;
        }
        return editorPaneArray;
    }

    public EditorSashContainer getEditorArea() {
        return this.editorArea;
    }

    @Override
    protected boolean canMoveFolder() {
        return true;
    }

    @Override
    protected void derefPart(LayoutPart layoutPart) {
        EditorAreaHelper.derefPart(layoutPart);
    }

    @Override
    protected boolean allowsDrop(PartPane partPane) {
        return partPane instanceof EditorPane;
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.becomeActiveWorkbook(true);
    }

    @Override
    protected void close(IPresentablePart[] iPresentablePartArray) {
        if (iPresentablePartArray.length == 1) {
            this.close(iPresentablePartArray[0]);
            return;
        }
        IEditorReference[] iEditorReferenceArray = new IEditorReference[iPresentablePartArray.length];
        int n = 0;
        while (n < iPresentablePartArray.length) {
            EditorPane editorPane = (EditorPane)this.getPaneFor(iPresentablePartArray[n]);
            iEditorReferenceArray[n] = editorPane.getEditorReference();
            ++n;
        }
        WorkbenchPage workbenchPage = this.getPage();
        if (workbenchPage != null) {
            workbenchPage.closeEditors(iEditorReferenceArray, true);
        }
    }

    @Override
    public void testInvariants() {
        super.testInvariants();
        int n = this.getActive();
        if (n == 1) {
            Assert.isTrue((boolean)this.isActiveWorkbook());
        } else if (n == 2) {
            Assert.isTrue((boolean)this.isActiveWorkbook());
        } else if (n == 0) {
            Assert.isTrue((!this.isActiveWorkbook() ? 1 : 0) != 0);
        }
    }

    @Override
    public IStatus restoreState(IMemento iMemento) {
        Integer n = iMemento.getInteger("expanded");
        this.setState(n == null || n != 0 ? 2 : 0);
        Integer n2 = iMemento.getInteger("appearance");
        if (n2 != null) {
            this.appearance = n2;
        }
        this.savedPresentationState = null;
        IMemento[] iMementoArray = iMemento.getChildren("presentation");
        int n3 = 0;
        while (n3 < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n3];
            String string = iMemento2.getString("id");
            if (Util.equals(string, this.getFactory().getId())) {
                this.savedPresentationState = iMemento2;
                break;
            }
            ++n3;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    @Override
    public IStatus saveState(IMemento iMemento) {
        iMemento.putInteger("expanded", this.getPresentationSite().getState() == 0 ? 0 : 2);
        iMemento.putInteger("appearance", this.appearance);
        this.savePresentationState();
        if (this.savedPresentationState != null) {
            IMemento iMemento2 = iMemento.createChild("presentation");
            iMemento2.putMemento(this.savedPresentationState);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    @Override
    public void setMinimized(boolean bl) {
        Perspective perspective = this.getPage().getActivePerspective();
        if (Perspective.useNewMinMax(perspective)) {
            if (bl) {
                perspective.setEditorAreaState(0);
            } else {
                int n;
                if (perspective.getPresentation().getMaximizedStack() != null) {
                    PartStack partStack = perspective.getPresentation().getMaximizedStack();
                    if (partStack instanceof ViewStack) {
                        partStack.setState(2);
                    } else if (partStack instanceof EditorStack) {
                        perspective.setEditorAreaState(2);
                    }
                }
                if ((n = perspective.getEditorAreaState()) == 0) {
                    n = 2;
                }
                perspective.setEditorAreaState(n);
            }
            this.refreshPresentationState();
        }
        super.setMinimized(bl);
    }

    public void setStateLocal(int n) {
        if (n == this.getState()) {
            return;
        }
        this.setMinimized(n == 0);
        this.presentationSite.setPresentationState(n);
    }

    public void showMinMax(boolean bl) {
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation == null) {
            return;
        }
        if (stackPresentation instanceof TabbedStackPresentation) {
            ((TabbedStackPresentation)stackPresentation).showMinMax(bl);
        }
    }
}

