/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.services.IDisposable;

public class EditorSiteDragAndDropServiceImpl
implements IDragAndDropService,
IDisposable {
    private static String MDT_KEY = "MDT";
    List addedListeners = new ArrayList();

    @Override
    public void addMergedDropTarget(Control control, int n, Transfer[] transferArray, DropTargetListener dropTargetListener) {
        this.removeMergedDropTarget(control);
        int n2 = 23;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WorkbenchWindowConfigurer workbenchWindowConfigurer = workbenchWindow.getWindowConfigurer();
        Transfer[] transferArray2 = workbenchWindowConfigurer.getTransfers();
        DropTargetListener dropTargetListener2 = workbenchWindowConfigurer.getDropTargetListener();
        MergedDropTarget mergedDropTarget = new MergedDropTarget(control, n, transferArray, dropTargetListener, n2, transferArray2, dropTargetListener2);
        this.addedListeners.add(mergedDropTarget);
        mergedDropTarget.realDropTarget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Object object = disposeEvent.widget.getData(MDT_KEY);
                EditorSiteDragAndDropServiceImpl.this.addedListeners.remove(object);
            }
        });
    }

    private DropTarget getCurrentDropTarget(Control control) {
        if (control == null) {
            return null;
        }
        Object object = control.getData("DropTarget");
        return (DropTarget)object;
    }

    @Override
    public void removeMergedDropTarget(Control control) {
        DropTarget dropTarget = this.getCurrentDropTarget(control);
        if (dropTarget != null) {
            dropTarget.dispose();
            this.addedListeners.remove(dropTarget);
        }
    }

    @Override
    public void dispose() {
        this.addedListeners.clear();
    }

    private static class MergedDropTarget {
        private DropTarget realDropTarget;
        private Transfer[] secondaryTransfers;
        private DropTargetListener secondaryListener;
        private int secondaryOps;
        private Transfer[] primaryTransfers;
        private DropTargetListener primaryListener;
        private int primaryOps;

        public MergedDropTarget(Control control, int n, Transfer[] transferArray, DropTargetListener dropTargetListener, int n2, Transfer[] transferArray2, DropTargetListener dropTargetListener2) {
            this.realDropTarget = new DropTarget(control, n | n2);
            this.realDropTarget.setData(MDT_KEY, (Object)this);
            this.primaryTransfers = transferArray;
            this.primaryListener = dropTargetListener;
            this.primaryOps = n;
            this.secondaryTransfers = transferArray2;
            this.secondaryListener = dropTargetListener2;
            this.secondaryOps = n2;
            Transfer[] transferArray3 = new Transfer[this.secondaryTransfers.length + this.primaryTransfers.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.primaryTransfers.length) {
                transferArray3[n3++] = this.primaryTransfers[n4];
                ++n4;
            }
            n4 = 0;
            while (n4 < this.secondaryTransfers.length) {
                transferArray3[n3++] = this.secondaryTransfers[n4];
                ++n4;
            }
            this.realDropTarget.setTransfer(transferArray3);
            this.realDropTarget.addDropListener(new DropTargetListener(){

                public void dragEnter(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, true).dragEnter(dropTargetEvent);
                }

                public void dragLeave(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, false).dragLeave(dropTargetEvent);
                }

                public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, true).dragOperationChanged(dropTargetEvent);
                }

                public void dragOver(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, true).dragOver(dropTargetEvent);
                }

                public void drop(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, true).drop(dropTargetEvent);
                }

                public void dropAccept(DropTargetEvent dropTargetEvent) {
                    MergedDropTarget.this.getAppropriateListener(dropTargetEvent, true).dropAccept(dropTargetEvent);
                }
            });
        }

        private DropTargetListener getAppropriateListener(DropTargetEvent dropTargetEvent, boolean bl) {
            if (this.isSupportedType(this.primaryTransfers, dropTargetEvent.currentDataType)) {
                if (bl && !this.isSupportedOperation(this.primaryOps, dropTargetEvent.detail)) {
                    dropTargetEvent.detail = 0;
                }
                return this.primaryListener;
            }
            if (bl && !this.isSupportedOperation(this.secondaryOps, dropTargetEvent.detail)) {
                dropTargetEvent.detail = 0;
            }
            return this.secondaryListener;
        }

        private boolean isSupportedType(Transfer[] transferArray, TransferData transferData) {
            int n = 0;
            while (n < transferArray.length) {
                if (transferArray[n].isSupportedType(transferData)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean isSupportedOperation(int n, int n2) {
            return ((n | 0x10) & n2) != 0;
        }
    }
}

