/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorSiteDragAndDropServiceImpl;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class EditorSite
extends PartSite
implements IEditorSite {
    private EditorDescriptor desc;
    private SubActionBars ab = null;

    public EditorSite(IEditorReference iEditorReference, IEditorPart iEditorPart, WorkbenchPage workbenchPage, EditorDescriptor editorDescriptor) {
        super(iEditorReference, iEditorPart, workbenchPage);
        Assert.isNotNull((Object)editorDescriptor);
        this.desc = editorDescriptor;
        if (editorDescriptor.getConfigurationElement() != null) {
            this.setConfigurationElement(editorDescriptor.getConfigurationElement());
        } else {
            this.setId(editorDescriptor.getId());
            this.setRegisteredName(editorDescriptor.getLabel());
        }
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        EditorSiteDragAndDropServiceImpl editorSiteDragAndDropServiceImpl = new EditorSiteDragAndDropServiceImpl();
        this.serviceLocator.registerService(IDragAndDropService.class, editorSiteDragAndDropServiceImpl);
    }

    @Override
    public void setActionBars(SubActionBars subActionBars) {
        super.setActionBars(subActionBars);
        this.ab = subActionBars instanceof IActionBars2 ? new SubActionBars2((IActionBars2)((Object)subActionBars), (IServiceLocator)this) : new SubActionBars(subActionBars, this);
    }

    @Override
    public void activateActionBars(boolean bl) {
        if (this.ab != null) {
            this.ab.activate(bl);
        }
        super.activateActionBars(bl);
    }

    @Override
    public void deactivateActionBars(boolean bl) {
        if (this.ab != null) {
            this.ab.deactivate(bl);
        }
        super.deactivateActionBars(bl);
    }

    @Override
    public IEditorActionBarContributor getActionBarContributor() {
        EditorActionBars editorActionBars = (EditorActionBars)this.getActionBars();
        if (editorActionBars != null) {
            return editorActionBars.getEditorContributor();
        }
        return null;
    }

    public IEditorActionBarContributor getExtensionActionBarContributor() {
        EditorActionBars editorActionBars = (EditorActionBars)this.getActionBars();
        if (editorActionBars != null) {
            return editorActionBars.getExtensionContributor();
        }
        return null;
    }

    public IEditorPart getEditorPart() {
        return (IEditorPart)this.getPart();
    }

    public EditorDescriptor getEditorDescriptor() {
        return this.desc;
    }

    @Override
    protected String getInitialScopeId() {
        return "org.eclipse.ui.textEditorScope";
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.ab != null) {
            this.ab.dispose();
        }
    }

    @Override
    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider iSelectionProvider, boolean bl) {
        this.registerContextMenu(this.getId(), menuManager, iSelectionProvider, bl);
    }

    @Override
    public final void registerContextMenu(String string, MenuManager menuManager, ISelectionProvider iSelectionProvider, boolean bl) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(string, menuManager, iSelectionProvider, bl, this.getPart(), this.menuExtenders);
    }
}

