/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.presentations.PresentationSerializer;

public class EditorSashContainer
extends PartSashContainer {
    static final String DEFAULT_WORKBOOK_ID = "DefaultEditorWorkbook";
    private ArrayList editorWorkbooks = new ArrayList(3);
    private EditorStack activeEditorWorkbook;
    private DropTarget dropTarget;

    public EditorSashContainer(String string, WorkbenchPage workbenchPage, Composite composite) {
        super(string, workbenchPage, composite);
        this.createDefaultWorkbook();
    }

    public void addEditor(EditorPane editorPane, EditorStack editorStack) {
        editorStack.add(editorPane);
    }

    @Override
    protected void addChild(PartSashContainer.RelationshipInfo relationshipInfo) {
        super.addChild(relationshipInfo);
        this.updateStackButtons();
    }

    public void updateStackButtons() {
        Perspective perspective = this.getPage().getActivePerspective();
        if (!Perspective.useNewMinMax(perspective)) {
            return;
        }
        LayoutPart[] layoutPartArray = this.getChildren();
        EditorStack editorStack = this.getUpperRightEditorStack(layoutPartArray);
        int n = 0;
        while (n < layoutPartArray.length) {
            if (layoutPartArray[n] instanceof EditorStack) {
                ((EditorStack)layoutPartArray[n]).showMinMax(layoutPartArray[n] == editorStack);
            }
            ++n;
        }
        perspective.refreshEditorAreaVisibility();
    }

    public EditorStack getUpperRightEditorStack(LayoutPart[] layoutPartArray) {
        if (layoutPartArray == null) {
            layoutPartArray = this.getChildren();
        }
        EditorStack editorStack = null;
        Rectangle rectangle = null;
        int n = 0;
        while (n < layoutPartArray.length) {
            if (layoutPartArray[n] instanceof EditorStack) {
                EditorStack editorStack2 = (EditorStack)layoutPartArray[n];
                Rectangle rectangle2 = editorStack2.getBounds();
                if (rectangle == null || rectangle2.y < rectangle.y || rectangle2.y == rectangle.y && rectangle2.x > rectangle.x) {
                    editorStack = editorStack2;
                    rectangle = rectangle2;
                }
            }
            ++n;
        }
        return editorStack;
    }

    @Override
    protected void childAdded(LayoutPart layoutPart) {
        super.childAdded(layoutPart);
        if (layoutPart instanceof EditorStack) {
            this.editorWorkbooks.add(layoutPart);
        }
    }

    @Override
    protected void childRemoved(LayoutPart layoutPart) {
        super.childRemoved(layoutPart);
        if (layoutPart instanceof EditorStack) {
            this.editorWorkbooks.remove(layoutPart);
            if (this.activeEditorWorkbook == layoutPart) {
                this.setActiveWorkbook(null, false);
            }
            this.updateStackButtons();
        }
    }

    protected EditorStack createDefaultWorkbook() {
        EditorStack editorStack = EditorStack.newEditorWorkbook(this, this.page);
        editorStack.setID(DEFAULT_WORKBOOK_ID);
        this.add(editorStack);
        return editorStack;
    }

    @Override
    protected Composite createParent(Composite composite) {
        return new Composite(composite, 0);
    }

    @Override
    public void dispose() {
        this.editorWorkbooks.clear();
        super.dispose();
    }

    @Override
    protected void disposeParent() {
        this.parent.dispose();
    }

    public EditorStack getActiveWorkbook() {
        if (this.activeEditorWorkbook == null) {
            if (this.editorWorkbooks.size() < 1) {
                this.setActiveWorkbook(this.createDefaultWorkbook(), false);
            } else {
                this.setActiveWorkbook((EditorStack)this.editorWorkbooks.get(0), false);
            }
        }
        return this.activeEditorWorkbook;
    }

    public String getActiveWorkbookID() {
        return this.getActiveWorkbook().getID();
    }

    public ArrayList getEditorWorkbooks() {
        return (ArrayList)this.editorWorkbooks.clone();
    }

    public int getEditorWorkbookCount() {
        return this.editorWorkbooks.size();
    }

    protected boolean isActiveWorkbook(EditorStack editorStack) {
        return this.activeEditorWorkbook == editorStack;
    }

    @Override
    public void findSashes(LayoutPart layoutPart, PartPane.Sashes sashes) {
        super.findSashes(layoutPart, sashes);
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.findSashes(this, sashes);
        }
    }

    public void removeAllEditors() {
        EditorStack editorStack = this.getActiveWorkbook();
        for (EditorStack editorStack2 : (ArrayList)this.editorWorkbooks.clone()) {
            editorStack2.removeAll();
            if (editorStack2 == editorStack) continue;
            this.remove(editorStack2);
            editorStack2.dispose();
        }
    }

    public void removeEditor(EditorPane editorPane) {
        EditorStack editorStack = editorPane.getWorkbook();
        if (editorStack == null) {
            return;
        }
        editorStack.remove(editorPane);
        if (editorStack.getItemCount() < 1) {
            Perspective perspective = this.getPage().getActivePerspective();
            if (Perspective.useNewMinMax(perspective) && perspective.getPresentation().getMaximizedStack() instanceof EditorStack) {
                perspective.getPresentation().getMaximizedStack().setState(2);
            }
            this.remove(editorStack);
            editorStack.dispose();
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.RootLayoutContainer_problemsRestoringPerspective, null);
        if (this.children != null) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    PartStack partStack = null;
                    int n = 0;
                    while (n < EditorSashContainer.this.children.size()) {
                        LayoutPart layoutPart = (LayoutPart)EditorSashContainer.this.children.get(n);
                        if (layoutPart.getID() == EditorSashContainer.DEFAULT_WORKBOOK_ID && (partStack = (EditorStack)layoutPart).getItemCount() > 0) {
                            partStack = null;
                        }
                        ++n;
                    }
                    if (partStack != null) {
                        EditorSashContainer.this.remove(partStack);
                        partStack.dispose();
                    }
                }
            });
        }
        IMemento[] iMementoArray = iMemento.getChildren("info");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(iMementoArray.length);
        int n = 0;
        while (n < iMementoArray.length) {
            Object object;
            Object object2;
            IMemento iMemento2 = iMementoArray[n];
            String string = iMemento2.getString("part");
            final String string2 = iMemento2.getString("relative");
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            float f = 0.5f;
            if (string2 != null) {
                n2 = iMemento2.getInteger("relationship");
                object2 = iMemento2.getFloat("ratio");
                object = iMemento2.getInteger("ratioLeft");
                Integer n5 = iMemento2.getInteger("ratioRight");
                if (object != null && n5 != null) {
                    n3 = (Integer)object;
                    n4 = n5;
                } else if (object2 != null) {
                    f = ((Float)object2).floatValue();
                }
            }
            object2 = new EditorStack[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((EditorStack[])object2, string){
                private final /* synthetic */ EditorStack[] val$workbook;
                private final /* synthetic */ String val$partID;
                {
                    this.val$workbook = editorStackArray;
                    this.val$partID = string;
                }

                @Override
                public void runWithException() throws Throwable {
                    this.val$workbook[0] = EditorStack.newEditorWorkbook(EditorSashContainer.this, EditorSashContainer.this.page);
                    this.val$workbook[0].setID(this.val$partID);
                    this.val$workbook[0].setContainer(EditorSashContainer.this);
                }
            });
            object = iMemento2.getChild("folder");
            if (object != null) {
                multiStatus.add(object2[0].restoreState((IMemento)object));
            }
            int n6 = n3;
            int n7 = n4;
            int n8 = n2;
            float f2 = f;
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable((EditorStack[])object2, hashMap, n6, n7, n8, f2){
                private final /* synthetic */ EditorStack[] val$workbook;
                private final /* synthetic */ Map val$mapIDtoPart;
                private final /* synthetic */ int val$myLeft;
                private final /* synthetic */ int val$myRight;
                private final /* synthetic */ int val$myRelationship;
                private final /* synthetic */ float val$myRatio;
                {
                    this.val$workbook = editorStackArray;
                    this.val$mapIDtoPart = map;
                    this.val$myLeft = n;
                    this.val$myRight = n2;
                    this.val$myRelationship = n3;
                    this.val$myRatio = f;
                }

                @Override
                public void runWithException() throws Throwable {
                    if (string2 == null) {
                        EditorSashContainer.this.add(this.val$workbook[0]);
                    } else {
                        LayoutPart layoutPart = (LayoutPart)this.val$mapIDtoPart.get(string2);
                        if (layoutPart != null) {
                            if (this.val$myLeft == 0 || this.val$myRight == 0) {
                                EditorSashContainer.this.add(this.val$workbook[0], this.val$myRelationship, this.val$myRatio, layoutPart);
                            } else {
                                EditorSashContainer.this.add(this.val$workbook[0], this.val$myRelationship, this.val$myLeft, this.val$myRight, layoutPart);
                            }
                        } else {
                            WorkbenchPlugin.log("Unable to find part for ID: " + string2);
                        }
                    }
                }
            });
            hashMap.put(string, object2[0]);
            ++n;
        }
        return multiStatus;
    }

    public IStatus saveState(IMemento iMemento) {
        PartSashContainer.RelationshipInfo[] relationshipInfoArray = this.computeRelation();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.RootLayoutContainer_problemsSavingPerspective, null);
        int n = 0;
        while (n < relationshipInfoArray.length) {
            PartSashContainer.RelationshipInfo relationshipInfo = relationshipInfoArray[n];
            IMemento iMemento2 = iMemento.createChild("info");
            iMemento2.putString("part", relationshipInfo.part.getID());
            EditorStack editorStack = (EditorStack)relationshipInfo.part;
            if (editorStack != null) {
                IMemento iMemento3 = iMemento2.createChild("folder");
                multiStatus.add(editorStack.saveState(iMemento3));
            }
            if (relationshipInfo.relative != null) {
                iMemento2.putString("relative", relationshipInfo.relative.getID());
                iMemento2.putInteger("relationship", relationshipInfo.relationship);
                iMemento2.putInteger("ratioLeft", relationshipInfo.left);
                iMemento2.putInteger("ratioRight", relationshipInfo.right);
                iMemento2.putFloat("ratio", relationshipInfo.getRatio());
            }
            ++n;
        }
        return multiStatus;
    }

    public void setActiveWorkbook(EditorStack editorStack, boolean bl) {
        if (editorStack != null) {
            if (editorStack.isDisposed()) {
                return;
            }
            if (!this.editorWorkbooks.contains(editorStack)) {
                return;
            }
        }
        EditorStack editorStack2 = this.activeEditorWorkbook;
        this.activeEditorWorkbook = editorStack;
        if (editorStack2 != null && editorStack2 != editorStack) {
            editorStack2.setActive(0);
        }
        if (editorStack != null) {
            if (bl) {
                editorStack.setActive(1);
            } else {
                editorStack.setActive(2);
            }
        }
        this.updateTabList();
    }

    public void setActiveWorkbookFromID(String string) {
        int n = 0;
        while (n < this.editorWorkbooks.size()) {
            EditorStack editorStack = (EditorStack)this.editorWorkbooks.get(n);
            if (editorStack.getID().equals(string)) {
                this.setActiveWorkbook(editorStack, false);
            }
            ++n;
        }
    }

    public EditorStack getWorkbookFromID(String string) {
        int n = 0;
        while (n < this.editorWorkbooks.size()) {
            EditorStack editorStack = (EditorStack)this.editorWorkbooks.get(n);
            if (editorStack.getID().equals(string)) {
                return editorStack;
            }
            ++n;
        }
        return null;
    }

    public void updateTabList() {
        Composite composite = this.getParent();
        if (composite != null) {
            EditorStack editorStack = this.getActiveWorkbook();
            if (editorStack == null) {
                composite.setTabList(new Control[0]);
            } else {
                composite.setTabList(editorStack.getTabList());
            }
        }
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        this.addDropSupport();
    }

    private void addDropSupport() {
        if (this.dropTarget == null) {
            WorkbenchWindowConfigurer workbenchWindowConfigurer = ((WorkbenchWindow)this.page.getWorkbenchWindow()).getWindowConfigurer();
            this.dropTarget = new DropTarget(this.getControl(), 21);
            this.dropTarget.setTransfer(workbenchWindowConfigurer.getTransfers());
            if (workbenchWindowConfigurer.getDropTargetListener() != null) {
                this.dropTarget.addDropListener(workbenchWindowConfigurer.getDropTargetListener());
            }
        }
    }

    DropTarget getDropTarget() {
        return this.dropTarget;
    }

    @Override
    public boolean isCompressible() {
        return true;
    }

    @Override
    public boolean isStackType(LayoutPart layoutPart) {
        return layoutPart instanceof EditorStack;
    }

    @Override
    public boolean isPaneType(LayoutPart layoutPart) {
        return layoutPart instanceof EditorPane;
    }

    @Override
    protected PartStack createStack() {
        EditorStack editorStack = EditorStack.newEditorWorkbook(this, this.page);
        return editorStack;
    }

    @Override
    protected void setVisiblePart(ILayoutContainer iLayoutContainer, LayoutPart layoutPart) {
        EditorStack editorStack = (EditorStack)iLayoutContainer;
        editorStack.becomeActiveWorkbook(true);
        editorStack.setSelection(layoutPart);
    }

    @Override
    protected LayoutPart getVisiblePart(ILayoutContainer iLayoutContainer) {
        EditorStack editorStack = (EditorStack)iLayoutContainer;
        return editorStack.getSelection();
    }

    @Override
    public LayoutPart pickPartToZoom() {
        return this.getActiveWorkbook();
    }

    public IStatus restorePresentationState(IMemento iMemento) {
        for (final EditorStack editorStack : this.getEditorWorkbooks()) {
            final IMemento iMemento2 = editorStack.getSavedPresentationState();
            if (iMemento2 == null) continue;
            final PresentationSerializer presentationSerializer = new PresentationSerializer(editorStack.getPresentableParts());
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    editorStack.getPresentation().restoreState(presentationSerializer, iMemento2);
                }
            });
        }
        return Status.OK_STATUS;
    }
}

