/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartTester;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.testing.ContributionInfo;

public class EditorReference
extends WorkbenchPartReference
implements IEditorReference {
    private final EditorManager manager;
    private IMemento editorMemento;
    private IMemento editorState = null;
    private boolean expectingInputChange = false;
    private boolean reportedMalfunctioningEditor = false;
    String name;
    String factoryId;
    IEditorInput restoredInput;
    private IEditorReference[] multiEditorChildren = null;

    public EditorReference(EditorManager editorManager, IEditorInput iEditorInput, EditorDescriptor editorDescriptor) {
        this(editorManager, iEditorInput, editorDescriptor, null);
    }

    public EditorReference(EditorManager editorManager, IEditorInput iEditorInput, EditorDescriptor editorDescriptor, IMemento iMemento) {
        IPersistableElement iPersistableElement;
        this.manager = editorManager;
        this.initListenersAndHandlers();
        this.restoredInput = iEditorInput;
        this.editorState = iMemento;
        String string = null;
        if (iEditorInput != null) {
            this.name = string = iEditorInput.getName();
        }
        if (string == null) {
            string = editorDescriptor.getLabel();
        }
        String string2 = null;
        if (iEditorInput != null) {
            string2 = iEditorInput.getToolTipText();
        }
        if (string2 == null) {
            string2 = "";
        }
        if (iEditorInput != null && (iPersistableElement = iEditorInput.getPersistable()) != null) {
            this.factoryId = iPersistableElement.getFactoryId();
        }
        this.init(editorDescriptor.getId(), string, string2, editorDescriptor.getImageDescriptor(), string, "");
    }

    EditorReference(EditorManager editorManager, IMemento iMemento) {
        String string;
        Object object;
        this.manager = editorManager;
        this.initListenersAndHandlers();
        this.editorMemento = iMemento;
        this.editorState = EditorManager.useIPersistableEditor() ? this.editorMemento.getChild("editorState") : null;
        String string2 = iMemento.getString("id");
        String string3 = iMemento.getString("title");
        String string4 = Util.safeString(iMemento.getString("tooltip"));
        String string5 = iMemento.getString("partName");
        IMemento iMemento2 = iMemento.getChild("properties");
        if (iMemento2 != null) {
            object = iMemento2.getChildren("property");
            int n = 0;
            while (n < ((IMemento[])object).length) {
                this.propertyCache.put(object[n].getID(), object[n].getTextData());
                ++n;
            }
        }
        if (string5 == null) {
            string5 = string3;
        }
        object = null;
        if (string2 != null) {
            object = this.getDescriptor(string2);
        }
        Path path = (string = iMemento.getString("path")) == null ? null : new Path(string);
        ImageDescriptor imageDescriptor = this.manager.findImage((EditorDescriptor)object, (IPath)path);
        this.name = iMemento.getString("name");
        if (this.name == null) {
            this.name = string3;
        }
        this.setPinned("true".equals(iMemento.getString("pinned")));
        IMemento iMemento3 = iMemento.getChild("input");
        if (iMemento3 != null) {
            this.factoryId = iMemento3.getString("factoryID");
        }
        this.init(string2, string3, string4, imageDescriptor, string5, "");
    }

    public EditorDescriptor getDescriptor() {
        return this.getDescriptor(this.getId());
    }

    private EditorDescriptor getDescriptor(String string) {
        IEditorRegistry iEditorRegistry = WorkbenchPlugin.getDefault().getEditorRegistry();
        EditorDescriptor editorDescriptor = (EditorDescriptor)iEditorRegistry.findEditor(string);
        return editorDescriptor;
    }

    private void initListenersAndHandlers() {
        this.manager.checkCreateEditorPropListener();
        this.manager.checkCreatePinEditorShortcutKeyHandler();
    }

    @Override
    protected PartPane createPane() {
        return new EditorPane(this, this.manager.page, this.manager.editorPresentation.getActiveWorkbook());
    }

    public void pinStatusUpdated() {
        this.firePropertyChange(1);
    }

    @Override
    public String getFactoryId() {
        IEditorPart iEditorPart = this.getEditor(false);
        if (iEditorPart != null) {
            IPersistableElement iPersistableElement = iEditorPart.getEditorInput().getPersistable();
            if (iPersistableElement != null) {
                return iPersistableElement.getFactoryId();
            }
            return null;
        }
        return this.factoryId;
    }

    @Override
    protected String computePartName() {
        if (this.part instanceof IWorkbenchPart2) {
            return super.computePartName();
        }
        return this.getRawTitle();
    }

    @Override
    public String getName() {
        if (this.part != null) {
            return this.getEditor(false).getEditorInput().getName();
        }
        return this.name;
    }

    public String internalGetName() {
        return this.name;
    }

    @Override
    public IEditorPart getEditor(boolean bl) {
        return (IEditorPart)this.getPart(bl);
    }

    @Override
    protected void releaseReferences() {
        super.releaseReferences();
        this.editorMemento = null;
        this.editorState = null;
        this.name = null;
        this.factoryId = null;
        this.restoredInput = null;
    }

    void setName(String string) {
        this.name = string;
    }

    public IMemento getMemento() {
        return this.editorMemento;
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.manager.page;
    }

    @Override
    protected void doDisposeNestedParts() {
        if (this.part instanceof AbstractMultiEditor && !(this.part instanceof MultiEditor)) {
            this.disposeMultiEditorChildren();
        }
    }

    @Override
    protected void doDisposePart() {
        if (this.part instanceof MultiEditor) {
            this.disposeMultiEditorChildren();
        }
        IEditorPart iEditorPart = (IEditorPart)this.part;
        super.doDisposePart();
        if (iEditorPart != null) {
            EditorSite editorSite = (EditorSite)iEditorPart.getEditorSite();
            this.manager.disposeEditorActionBars((EditorActionBars)editorSite.getActionBars());
            editorSite.dispose();
        }
        this.manager.checkDeleteEditorResources();
        this.editorMemento = null;
        this.editorState = null;
        this.restoredInput = new NullEditorInput();
    }

    private void disposeMultiEditorChildren() {
        if (this.multiEditorChildren != null) {
            int n = 0;
            while (n < this.multiEditorChildren.length) {
                EditorReference editorReference = (EditorReference)this.multiEditorChildren[n];
                if (editorReference != null) {
                    editorReference.dispose();
                }
                ++n;
            }
            this.multiEditorChildren = null;
        }
    }

    @Override
    public IEditorInput getEditorInput() throws PartInitException {
        if (this.isDisposed()) {
            if (!(this.restoredInput instanceof NullEditorInput)) {
                this.restoredInput = new NullEditorInput();
            }
            return this.restoredInput;
        }
        IEditorPart iEditorPart = this.getEditor(false);
        if (iEditorPart != null) {
            return iEditorPart.getEditorInput();
        }
        return this.getRestoredInput();
    }

    private IEditorInput getRestoredInput() throws PartInitException {
        if (this.restoredInput != null) {
            return this.restoredInput;
        }
        IMemento iMemento = this.getMemento();
        if (iMemento == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_no_persisted_state, (Object)this.getId(), (Object)this.getName()));
        }
        IMemento iMemento2 = iMemento.getChild("input");
        String string = null;
        if (iMemento2 != null) {
            string = iMemento2.getString("factoryID");
        }
        if (string == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_no_input_factory_ID, (Object)this.getId(), (Object)this.getName()));
        }
        IAdaptable iAdaptable = null;
        String string2 = null;
        if (UIStats.isDebugging(6)) {
            string2 = this.getName() != null ? this.getName() : string;
        }
        try {
            UIStats.start(6, string2);
            IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(string);
            if (iElementFactory == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_bad_element_factory, (Object[])new Object[]{string, this.getId(), this.getName()}));
            }
            iAdaptable = iElementFactory.createElement(iMemento2);
            if (iAdaptable == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_create_element_returned_null, (Object[])new Object[]{string, this.getId(), this.getName()}));
            }
        }
        catch (Throwable throwable) {
            UIStats.end(6, iAdaptable, string2);
            throw throwable;
        }
        UIStats.end(6, iAdaptable, string2);
        if (!(iAdaptable instanceof IEditorInput)) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_wrong_createElement_result, (Object[])new Object[]{string, this.getId(), this.getName()}));
        }
        this.restoredInput = (IEditorInput)iAdaptable;
        return this.restoredInput;
    }

    @Override
    public ImageDescriptor computeImageDescriptor() {
        boolean bl;
        ImageDescriptor imageDescriptor = super.computeImageDescriptor();
        if (!this.isPinned()) {
            return imageDescriptor;
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean bl2 = bl = iPreferenceStore.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN") || ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).alwaysShowPinAction();
        if (!bl) {
            return imageDescriptor;
        }
        ImageDescriptor imageDescriptor2 = this.manager.getEditorPinImageDesc();
        if (imageDescriptor2 == null) {
            return imageDescriptor;
        }
        return new OverlayIcon(imageDescriptor, imageDescriptor2, new Point(16, 16));
    }

    @Override
    protected IWorkbenchPart createPart() {
        if ("org.eclipse.ui.internal.emptyEditorTab".equals(this.getId())) {
            return this.getEmptyEditor(this.getDescriptor());
        }
        PartInitException partInitException = null;
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = this.createPartHelper();
        }
        catch (PartInitException partInitException2) {
            partInitException = partInitException2;
        }
        if (partInitException != null) {
            IStatus iStatus = partInitException.getStatus();
            IStatus iStatus2 = StatusUtil.newStatus(iStatus, NLS.bind((String)"Unable to create editor ID {0}: {1}", (Object)this.getId(), (Object)iStatus.getMessage()));
            IStatus iStatus3 = StatusUtil.newStatus(iStatus, NLS.bind((String)WorkbenchMessages.EditorManager_unableToCreateEditor, (Object)iStatus.getMessage()));
            StatusManager.getManager().handle(iStatus2);
            EditorDescriptor editorDescriptor = this.getDescriptor();
            return this.getEmptyEditor(editorDescriptor, iStatus3);
        }
        return iEditorPart;
    }

    @Override
    protected void partPropertyChanged(Object object, int n) {
        if (n == 258) {
            this.expectingInputChange = false;
        }
        super.partPropertyChanged(object, n);
    }

    public boolean setInput(IEditorInput iEditorInput) {
        if (this.part != null) {
            if (this.part instanceof IReusableEditor) {
                IReusableEditor iReusableEditor = (IReusableEditor)this.part;
                this.expectingInputChange = true;
                iReusableEditor.setInput(iEditorInput);
                if (this.expectingInputChange) {
                    this.reportMalfunction("Editor is not firing a PROP_INPUT event in response to IReusableEditor.setInput(...)");
                    this.firePropertyChange(258);
                }
                return iReusableEditor.getEditorInput() == iEditorInput;
            }
            return false;
        }
        if (iEditorInput != this.restoredInput) {
            this.restoredInput = iEditorInput;
            this.firePropertyChange(258);
        }
        return true;
    }

    private void reportMalfunction(String string) {
        if (!this.reportedMalfunctioningEditor) {
            this.reportedMalfunctioningEditor = true;
            String string2 = "Problem detected with part " + this.getId();
            if (this.part != null) {
                string2 = String.valueOf(string2) + " (class = " + this.part.getClass().getName() + ")";
            }
            string2 = String.valueOf(string2) + ": " + string;
            StatusManager.getManager().handle(StatusUtil.newStatus(this.getDescriptor().getPluginId(), string2, null));
        }
    }

    /*
     * Unable to fully structure code
     */
    private IEditorPart createPartHelper() throws PartInitException {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        try {
            var5_5 = this.getEditorInput();
            var6_7 = this.getId();
            var7_13 = this.getDescriptor();
            if (var7_13 == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_missing_editor_descriptor, (Object)var6_7));
            }
            if (var7_13.isInternal()) {
                try {
                    UIStats.start(0, var6_7);
                    var2_2 = this.manager.createPart(var7_13);
                    if (var2_2 != null && var2_2 instanceof MultiEditor) {
                        this.multiEditorChildren = this.manager.openMultiEditor(this, (AbstractMultiEditor)var2_2, (MultiEditorInput)var5_5);
                    }
                    if (!(var2_2 instanceof IWorkbenchPart3)) ** GOTO lbl29
                    this.createPartProperties((IWorkbenchPart3)var2_2);
                }
                finally {
                    UIStats.end(0, this, var6_7);
                }
            } else if (var7_13.getId().equals("org.eclipse.ui.systemInPlaceEditor")) {
                var2_2 = ComponentSupport.getSystemInPlaceEditor();
                if (var2_2 == null) {
                    throw new PartInitException(WorkbenchMessages.EditorManager_no_in_place_support);
                }
            } else {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_invalid_editor_descriptor, (Object)var6_7));
            }
lbl29:
            // 3 sources

            var8_15 = this.getPane();
            var8_15.createControl(this.getPaneControlContainer());
            var9_16 = 0;
            if (var2_2 instanceof IWorkbenchPartOrientation) {
                var9_16 = ((IWorkbenchPartOrientation)var2_2).getOrientation();
            }
            var4_4 = this.manager.createSite(this, (IEditorPart)var2_2, var7_13, var5_5);
            if (var2_2 instanceof IPersistableEditor && this.editorState != null) {
                ((IPersistableEditor)var2_2).restoreState(this.editorState);
            }
            var3_3 = (EditorActionBars)var4_4.getActionBars();
            var10_17 = (Composite)var8_15.getControl();
            var11_18 = this.getDescriptor();
            if (var11_18 != null && var11_18.getPluginId() != null) {
                var10_17.setData((Object)new ContributionInfo(var11_18.getPluginId(), ContributionInfoMessages.ContributionInfo_Editor, null));
            }
            var1_1 = new Composite(var10_17, var9_16);
            var1_1.setLayout((Layout)new FillLayout());
            try {
                UIStats.start(1, var6_7);
                var2_2.createPartControl(var1_1);
                var10_17.layout(true);
            }
            finally {
                UIStats.end(1, var2_2, var6_7);
            }
            if (var2_2 != null && var2_2 instanceof AbstractMultiEditor && !(var2_2 instanceof MultiEditor)) {
                this.multiEditorChildren = this.manager.openMultiEditor(this, (AbstractMultiEditor)var2_2, (MultiEditorInput)var5_5);
            }
            PartTester.testEditor((IEditorPart)var2_2);
            return var2_2;
        }
        catch (Exception var5_6) {
            if (var1_1 != null) {
                try {
                    var1_1.dispose();
                }
                catch (RuntimeException var6_8) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, var6_8));
                }
            }
            if (var2_2 != null) {
                try {
                    var2_2.dispose();
                }
                catch (RuntimeException var6_9) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, var6_9));
                }
            }
            if (var3_3 != null) {
                try {
                    this.manager.disposeEditorActionBars(var3_3);
                }
                catch (RuntimeException var6_11) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, var6_11));
                }
            }
            if (var4_4 != null) {
                try {
                    var4_4.dispose();
                }
                catch (RuntimeException var6_12) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, var6_12));
                }
            }
            throw new PartInitException(StatusUtil.getLocalizedMessage(var5_6), StatusUtil.getCause(var5_6));
        }
    }

    protected Composite getPaneControlContainer() {
        return (Composite)this.manager.page.getEditorPresentation().getLayoutPart().getControl();
    }

    public boolean isMultiReference() {
        return this.multiEditorChildren != null || this.restoredInput instanceof MultiEditorInput;
    }

    public IEditorReference[] getChildren() {
        return this.multiEditorChildren;
    }

    public IEditorPart getEmptyEditor(EditorDescriptor editorDescriptor) {
        return this.getEmptyEditor(editorDescriptor, null);
    }

    public IEditorPart getEmptyEditor(EditorDescriptor editorDescriptor, IStatus iStatus) {
        IEditorInput iEditorInput;
        if (editorDescriptor == null) {
            editorDescriptor = this.getDescriptor("org.eclipse.ui.internal.emptyEditorTab");
        }
        ErrorEditorPart errorEditorPart = new ErrorEditorPart(iStatus);
        try {
            iEditorInput = this.getEditorInput();
        }
        catch (PartInitException partInitException) {
            iEditorInput = new NullEditorInput(this);
        }
        EditorPane editorPane = (EditorPane)this.getPane();
        editorPane.createControl(this.getPaneControlContainer());
        EditorSite editorSite = new EditorSite(this, errorEditorPart, this.manager.page, editorDescriptor);
        if (editorDescriptor != null) {
            editorSite.setId(this.getId());
        }
        editorSite.setActionBars(new EditorActionBars(this.manager.page, editorSite.getWorkbenchWindow(), this.getId()));
        errorEditorPart.init(editorSite, iEditorInput);
        Composite composite = (Composite)editorPane.getControl();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        try {
            errorEditorPart.createPartControl(composite2);
        }
        catch (Exception exception) {
            composite2.dispose();
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, exception));
            return null;
        }
        this.part = errorEditorPart;
        if (iStatus == null) {
            errorEditorPart.setPartName("(Empty)");
        }
        this.refreshFromPart();
        this.releaseReferences();
        if (((WorkbenchPage)this.getPage()).getActiveEditorReference() != this) {
            this.fireInternalPropertyChange(529);
        }
        return errorEditorPart;
    }
}

