/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.PartPluginAction;

public final class EditorPluginAction
extends PartPluginAction {
    private IEditorPart currentEditor;

    public EditorPluginAction(IConfigurationElement iConfigurationElement, IEditorPart iEditorPart, String string, int n) {
        super(iConfigurationElement, string, n);
        if (iEditorPart != null) {
            this.editorChanged(iEditorPart);
        }
    }

    @Override
    protected IActionDelegate validateDelegate(Object object) throws WorkbenchException {
        if (object instanceof IEditorActionDelegate) {
            return (IEditorActionDelegate)object;
        }
        throw new WorkbenchException("Action must implement IEditorActionDelegate");
    }

    @Override
    protected void initDelegate() {
        super.initDelegate();
        ((IEditorActionDelegate)this.getDelegate()).setActiveEditor((IAction)this, this.currentEditor);
    }

    public void editorChanged(IEditorPart iEditorPart) {
        if (this.currentEditor != null) {
            this.unregisterSelectionListener(this.currentEditor);
        }
        this.currentEditor = iEditorPart;
        if (this.getDelegate() == null && this.isOkToCreateDelegate()) {
            this.createDelegate();
        }
        if (this.getDelegate() != null) {
            ((IEditorActionDelegate)this.getDelegate()).setActiveEditor((IAction)this, iEditorPart);
        }
        if (iEditorPart != null) {
            this.registerSelectionListener(iEditorPart);
        }
    }

    @Override
    public void dispose() {
        if (this.currentEditor != null) {
            this.unregisterSelectionListener(this.currentEditor);
            this.currentEditor = null;
        }
        super.dispose();
    }
}

