/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorMenuManager
extends SubMenuManager {
    private ArrayList wrappers;
    private boolean enabledAllowed = true;
    private Overrides overrides = new Overrides();

    public EditorMenuManager(IMenuManager iMenuManager) {
        super(iMenuManager);
    }

    public IContributionItem[] getItems() {
        return this.getParentMenuManager().getItems();
    }

    public IContributionManagerOverrides getOverrides() {
        return this.overrides;
    }

    public void insertAfter(String string, IContributionItem iContributionItem) {
        IContributionItem iContributionItem2 = PluginActionSetBuilder.findInsertionPoint(string, null, (IContributionManager)this.getParentMenuManager(), false);
        if (iContributionItem2 != null) {
            super.insertAfter(iContributionItem2.getId(), iContributionItem);
        } else {
            WorkbenchPlugin.log("Reference item " + string + " not found for action " + iContributionItem.getId());
        }
    }

    public void prependToGroup(String string, IContributionItem iContributionItem) {
        this.insertAfter(string, iContributionItem);
    }

    public void setVisible(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (!this.enabledAllowed) {
                    this.setEnabledAllowed(true);
                }
            } else if (this.enabledAllowed) {
                this.setEnabledAllowed(false);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (bl2) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
    }

    public void setEnabledAllowed(boolean bl) {
        if (this.enabledAllowed == bl) {
            return;
        }
        this.enabledAllowed = bl;
        this.overrides.updateEnabledAllowed();
    }

    protected SubMenuManager wrapMenu(IMenuManager iMenuManager) {
        if (this.wrappers == null) {
            this.wrappers = new ArrayList();
        }
        EditorMenuManager editorMenuManager = new EditorMenuManager(iMenuManager);
        this.wrappers.add(editorMenuManager);
        return editorMenuManager;
    }

    protected IAction[] getAllContributedActions() {
        HashSet hashSet = new HashSet();
        this.getAllContributedActions(hashSet);
        return hashSet.toArray(new IAction[hashSet.size()]);
    }

    protected void getAllContributedActions(HashSet hashSet) {
        IContributionItem[] iContributionItemArray = super.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            this.getAllContributedActions(hashSet, iContributionItemArray[n]);
            ++n;
        }
        if (this.wrappers == null) {
            return;
        }
        for (EditorMenuManager editorMenuManager : this.wrappers) {
            editorMenuManager.getAllContributedActions(hashSet);
        }
    }

    protected void getAllContributedActions(HashSet hashSet, IContributionItem iContributionItem) {
        if (iContributionItem instanceof MenuManager) {
            IContributionItem[] iContributionItemArray = ((MenuManager)iContributionItem).getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                this.getAllContributedActions(hashSet, iContributionItemArray[n]);
                ++n;
            }
        } else if (iContributionItem instanceof ActionContributionItem) {
            hashSet.add(((ActionContributionItem)iContributionItem).getAction());
        }
    }

    private class Overrides
    implements IContributionManagerOverrides {
        private Overrides() {
        }

        public void updateEnabledAllowed() {
            Object object;
            IContributionItem[] iContributionItemArray = EditorMenuManager.super.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                object = iContributionItemArray[n];
                object.update("enabled");
                ++n;
            }
            if (EditorMenuManager.this.wrappers != null) {
                n = 0;
                while (n < EditorMenuManager.this.wrappers.size()) {
                    object = (EditorMenuManager)((Object)EditorMenuManager.this.wrappers.get(n));
                    ((EditorMenuManager)((Object)object)).setEnabledAllowed(EditorMenuManager.this.enabledAllowed);
                    ++n;
                }
            }
        }

        public Boolean getEnabled(IContributionItem iContributionItem) {
            if (iContributionItem instanceof ActionContributionItem && ((ActionContributionItem)iContributionItem).getAction() instanceof RetargetAction || EditorMenuManager.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public Integer getAccelerator(IContributionItem iContributionItem) {
            if (this.getEnabled(iContributionItem) == null) {
                return EditorMenuManager.this.getParentMenuManager().getOverrides().getAccelerator(iContributionItem);
            }
            return new Integer(0);
        }

        public String getAcceleratorText(IContributionItem iContributionItem) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getAcceleratorText(iContributionItem);
        }

        public String getText(IContributionItem iContributionItem) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getText(iContributionItem);
        }

        public Boolean getVisible(IContributionItem iContributionItem) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getVisible(iContributionItem);
        }
    }
}

