/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.ExternalEditor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;

public class EditorManager
implements IExtensionChangeHandler {
    EditorAreaHelper editorPresentation;
    WorkbenchWindow window;
    WorkbenchPage page;
    private Map actionCache = new HashMap();
    private static final String PIN_EDITOR_KEY = "PIN_EDITOR";
    private static final String PIN_EDITOR = "ovr16/pinned_ovr.gif";
    private IPropertyChangeListener editorPropChangeListnener = null;
    private IHandlerActivation pinEditorHandlerActivation = null;
    private long maxFileSize = 0L;
    private boolean checkDocumentSize;
    static final String RESOURCES_TO_SAVE_MESSAGE = WorkbenchMessages.EditorManager_saveResourcesMessage;
    static final String SAVE_RESOURCES_TITLE = WorkbenchMessages.EditorManager_saveResourcesTitle;

    public EditorManager(WorkbenchWindow workbenchWindow, WorkbenchPage workbenchPage, EditorAreaHelper editorAreaHelper) {
        Assert.isNotNull((Object)workbenchWindow);
        Assert.isNotNull((Object)workbenchPage);
        Assert.isNotNull((Object)editorAreaHelper);
        this.window = workbenchWindow;
        this.page = workbenchPage;
        this.editorPresentation = editorAreaHelper;
        this.initMaxFileSize();
        this.page.getExtensionTracker().registerHandler((IExtensionChangeHandler)this, null);
    }

    private void initMaxFileSize() {
        IPreferenceStore iPreferenceStore = PrefUtil.getInternalPreferenceStore();
        this.maxFileSize = iPreferenceStore.getLong("LARGE_DOC_SIZE_FOR_EDITORS");
        this.checkDocumentSize = this.maxFileSize != 0L;
    }

    void checkDeleteEditorResources() {
        IEditorReference[] iEditorReferenceArray = this.page.getEditorReferences();
        if (iEditorReferenceArray.length == 0) {
            Object object;
            if (this.editorPropChangeListnener != null) {
                object = WorkbenchPlugin.getDefault().getPreferenceStore();
                object.removePropertyChangeListener(this.editorPropChangeListnener);
                this.editorPropChangeListnener = null;
            }
            if (this.pinEditorHandlerActivation != null) {
                object = (IHandlerService)this.window.getWorkbench().getService(IHandlerService.class);
                object.deactivateHandler(this.pinEditorHandlerActivation);
                this.pinEditorHandlerActivation = null;
            }
        }
    }

    void checkCreateEditorPropListener() {
        if (this.editorPropChangeListnener == null) {
            this.editorPropChangeListnener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN")) {
                        IEditorReference[] iEditorReferenceArray = EditorManager.this.getEditors();
                        int n = 0;
                        while (n < iEditorReferenceArray.length) {
                            ((EditorReference)iEditorReferenceArray[n]).pinStatusUpdated();
                            ++n;
                        }
                    }
                }
            };
            WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.editorPropChangeListnener);
        }
    }

    void checkCreatePinEditorShortcutKeyHandler() {
        if (this.pinEditorHandlerActivation == null) {
            Shell shell = this.window.getShell();
            AbstractHandler abstractHandler = new AbstractHandler(){

                public final Object execute(ExecutionEvent executionEvent) {
                    IEditorReference iEditorReference;
                    IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
                    if ((iPreferenceStore.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN") || ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).alwaysShowPinAction()) && (iEditorReference = EditorManager.this.editorPresentation.getVisibleEditor()) instanceof WorkbenchPartReference) {
                        WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)((Object)iEditorReference);
                        workbenchPartReference.setPinned(workbenchPartReference.isPinned());
                    }
                    return null;
                }
            };
            IHandlerService iHandlerService = (IHandlerService)this.window.getWorkbench().getService(IHandlerService.class);
            this.pinEditorHandlerActivation = iHandlerService.activateHandler("org.eclipse.ui.window.pinEditor", (IHandler)abstractHandler, new ActiveShellExpression(shell));
        }
    }

    ImageDescriptor getEditorPinImageDesc() {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(PIN_EDITOR_KEY);
        if (imageDescriptor == null) {
            imageDescriptor = WorkbenchImages.getWorkbenchImageDescriptor(PIN_EDITOR);
            imageRegistry.put(PIN_EDITOR_KEY, imageDescriptor);
        }
        return imageDescriptor;
    }

    private List collectDirtyEditors() {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(3);
        IEditorReference[] iEditorReferenceArray = this.page.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorPart iEditorPart = (IEditorPart)iEditorReferenceArray[n].getPart(false);
            if (iEditorPart != null && iEditorPart.isDirty()) {
                arrayList.add(iEditorPart);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean containsEditor(IEditorReference iEditorReference) {
        IEditorReference[] iEditorReferenceArray = this.page.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (iEditorReference == iEditorReferenceArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private EditorActionBars createEditorActionBars(EditorDescriptor editorDescriptor, IEditorSite iEditorSite) {
        EditorActionBuilder editorActionBuilder;
        String string = editorDescriptor.getId();
        EditorActionBars editorActionBars = (EditorActionBars)this.actionCache.get(string);
        if (editorActionBars != null) {
            editorActionBars.addRef();
            return editorActionBars;
        }
        editorActionBars = new EditorActionBars(this.page, iEditorSite.getWorkbenchWindow(), string);
        editorActionBars.addRef();
        this.actionCache.put(string, editorActionBars);
        IEditorActionBarContributor iEditorActionBarContributor = editorDescriptor.createActionBarContributor();
        if (iEditorActionBarContributor != null) {
            editorActionBars.setEditorContributor(iEditorActionBarContributor);
            iEditorActionBarContributor.init(editorActionBars, this.page);
        }
        if ((iEditorActionBarContributor = (editorActionBuilder = new EditorActionBuilder()).readActionExtensions(editorDescriptor)) != null) {
            editorActionBars.setExtensionContributor(iEditorActionBarContributor);
            iEditorActionBarContributor.init(editorActionBars, this.page);
        }
        return editorActionBars;
    }

    private EditorActionBars createEmptyEditorActionBars(IEditorSite iEditorSite) {
        String string = String.valueOf(System.currentTimeMillis());
        EditorActionBars editorActionBars = new EditorActionBars(this.page, iEditorSite.getWorkbenchWindow(), string);
        editorActionBars.addRef();
        this.actionCache.put(string, editorActionBars);
        return editorActionBars;
    }

    void disposeEditorActionBars(EditorActionBars editorActionBars) {
        editorActionBars.removeRef();
        if (editorActionBars.getRef() <= 0) {
            ICoolBarManager2 iCoolBarManager2;
            String string = editorActionBars.getEditorType();
            Object v = this.actionCache.get(string);
            if (editorActionBars == v) {
                this.actionCache.remove(string);
            }
            if ((iCoolBarManager2 = (ICoolBarManager2)this.window.getCoolBarManager2()) != null) {
                iCoolBarManager2.refresh();
            }
            editorActionBars.dispose();
        }
    }

    public IEditorPart findEditor(IEditorInput iEditorInput) {
        return this.findEditor(null, iEditorInput, 1);
    }

    public IEditorPart findEditor(String string, IEditorInput iEditorInput, int n) {
        IEditorReference[] iEditorReferenceArray = this.findEditors(iEditorInput, string, n);
        if (iEditorReferenceArray.length == 0) {
            return null;
        }
        return iEditorReferenceArray[0].getEditor(true);
    }

    public IEditorReference[] findEditors(IEditorInput iEditorInput, String string, int n) {
        if (n == 0) {
            return new IEditorReference[0];
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<IEditorReference> arrayList2 = new ArrayList<IEditorReference>(Arrays.asList(this.page.getEditorReferences()));
        if (!arrayList2.isEmpty()) {
            IEditorReference iEditorReference = this.page.getActiveEditorReference();
            if (iEditorReference != null) {
                arrayList2.remove(iEditorReference);
                ArrayList<IEditorReference> arrayList3 = new ArrayList<IEditorReference>(1);
                arrayList3.add(iEditorReference);
                this.findEditors(arrayList3, iEditorInput, string, n, arrayList);
            }
            this.findEditors(arrayList2, iEditorInput, string, n, arrayList);
        }
        return arrayList.toArray(new IEditorReference[arrayList.size()]);
    }

    private void findEditors(List list, IEditorInput iEditorInput, String string, int n, List list2) {
        Object object;
        Object object2;
        Object object3;
        if (n == 0) {
            return;
        }
        if ((n & 2) != 0 && string != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (EditorReference)object3.next();
                if (string.equals(((WorkbenchPartReference)object2).getId())) continue;
                object3.remove();
            }
        }
        if ((n & 1) == 0) {
            list2.addAll(list);
            return;
        }
        object3 = list.iterator();
        while (object3.hasNext()) {
            Object object4;
            object2 = (EditorReference)object3.next();
            object = ((EditorReference)object2).getDescriptor();
            if (object == null || (object4 = object.getEditorMatchingStrategy()) == null) continue;
            object3.remove();
            if (!object4.matches((IEditorReference)object2, iEditorInput)) continue;
            list2.add(object2);
        }
        object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (IEditorReference)object3.next();
            object = (IEditorPart)object2.getPart(false);
            if (object == null) continue;
            object3.remove();
            if (object.getEditorInput() == null || !object.getEditorInput().equals(iEditorInput)) continue;
            list2.add(object2);
        }
        object3 = iEditorInput.getName();
        object2 = iEditorInput.getPersistable();
        if (object3 == null || object2 == null) {
            return;
        }
        object = object2.getFactoryId();
        if (object == null) {
            return;
        }
        for (EditorReference editorReference : list) {
            if (!((String)object3).equals(editorReference.getName()) || !((String)object).equals(editorReference.getFactoryId())) continue;
            try {
                IEditorInput iEditorInput2 = editorReference.getEditorInput();
                if (!Util.equals(iEditorInput2, iEditorInput)) continue;
                list2.add(editorReference);
            }
            catch (PartInitException partInitException) {
                WorkbenchPlugin.log((Throwable)((Object)partInitException));
            }
        }
    }

    private Display getDisplay() {
        return this.window.getShell().getDisplay();
    }

    public int getEditorCount() {
        return this.page.getEditorReferences().length;
    }

    private IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    public IEditorPart[] getDirtyEditors() {
        List list = this.collectDirtyEditors();
        return list.toArray(new IEditorPart[list.size()]);
    }

    public IEditorReference[] getEditors() {
        return this.page.getEditorReferences();
    }

    public IEditorPart getVisibleEditor() {
        IEditorReference iEditorReference = this.editorPresentation.getVisibleEditor();
        if (iEditorReference == null) {
            return null;
        }
        return (IEditorPart)iEditorReference.getPart(true);
    }

    public boolean isSaveAllNeeded() {
        IEditorReference[] iEditorReferenceArray = this.page.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            if (iEditorReference.isDirty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private IEditorReference findReusableEditor(EditorDescriptor editorDescriptor) {
        return ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).findReusableEditor(this.page);
    }

    public IEditorReference openEditor(String string, IEditorInput iEditorInput, boolean bl, IMemento iMemento) throws PartInitException {
        if (string == null || iEditorInput == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor iEditorDescriptor = this.getEditorRegistry().findEditor(string);
        if (iEditorDescriptor != null && !iEditorDescriptor.isOpenExternal() && this.isLargeDocument(iEditorInput) && (iEditorDescriptor = EditorManager.getAlternateEditor()) == null) {
            return null;
        }
        if (iEditorDescriptor == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)string));
        }
        IEditorReference iEditorReference = this.openEditorFromDescriptor((EditorDescriptor)iEditorDescriptor, iEditorInput, iMemento);
        return iEditorReference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IEditorReference openEditorFromDescriptor(EditorDescriptor editorDescriptor, IEditorInput iEditorInput, IMemento iMemento) throws PartInitException {
        IAdaptable iAdaptable;
        IEditorReference iEditorReference = null;
        if (editorDescriptor.isInternal()) {
            iEditorReference = this.reuseInternalEditor(editorDescriptor, iEditorInput);
            if (iEditorReference == null) {
                iEditorReference = new EditorReference(this, iEditorInput, editorDescriptor, iMemento);
            }
        } else if (editorDescriptor.getId().equals("org.eclipse.ui.systemInPlaceEditor")) {
            if (ComponentSupport.inPlaceEditorSupported()) {
                iEditorReference = new EditorReference(this, iEditorInput, editorDescriptor);
            }
        } else if (editorDescriptor.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            iAdaptable = this.getPathEditorInput(iEditorInput);
            if (iAdaptable == null) throw new PartInitException(WorkbenchMessages.EditorManager_systemEditorError);
            iEditorReference = this.openSystemExternalEditor(iAdaptable.getPath());
        } else {
            if (!editorDescriptor.isOpenExternal()) throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_invalidDescriptor, (Object)editorDescriptor.getId()));
            iEditorReference = this.openExternalEditor(editorDescriptor, iEditorInput);
        }
        if (iEditorReference != null) {
            this.createEditorTab((EditorReference)iEditorReference, "");
        }
        iAdaptable = (Workbench)this.window.getWorkbench();
        iAdaptable.getEditorHistory().add(iEditorInput, editorDescriptor);
        return iEditorReference;
    }

    private IEditorReference openExternalEditor(final EditorDescriptor editorDescriptor, IEditorInput iEditorInput) throws PartInitException {
        final CoreException[] coreExceptionArray = new CoreException[1];
        final IPathEditorInput iPathEditorInput = this.getPathEditorInput(iEditorInput);
        if (iPathEditorInput == null || iPathEditorInput.getPath() == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)editorDescriptor.getFileName(), (Object)editorDescriptor.getId()));
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (editorDescriptor.getLauncher() != null) {
                        Object object = WorkbenchPlugin.createExtension(editorDescriptor.getConfigurationElement(), "launcher");
                        ((IEditorLauncher)object).open(iPathEditorInput.getPath());
                    } else {
                        ExternalEditor externalEditor = new ExternalEditor(iPathEditorInput.getPath(), editorDescriptor);
                        externalEditor.open();
                    }
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)editorDescriptor.getFileName(), (Object)editorDescriptor.getId()), coreExceptionArray[0]);
        }
        return null;
    }

    IEditorReference[] openMultiEditor(IEditorReference iEditorReference, AbstractMultiEditor abstractMultiEditor, MultiEditorInput multiEditorInput) throws PartInitException {
        String[] stringArray = multiEditorInput.getEditors();
        IEditorInput[] iEditorInputArray = multiEditorInput.getInput();
        EditorDescriptor[] editorDescriptorArray = new EditorDescriptor[stringArray.length];
        IEditorReference[] iEditorReferenceArray = new IEditorReference[stringArray.length];
        IEditorPart[] iEditorPartArray = new IEditorPart[stringArray.length];
        IEditorRegistry iEditorRegistry = this.getEditorRegistry();
        int n = 0;
        while (n < stringArray.length) {
            EditorDescriptor editorDescriptor = (EditorDescriptor)iEditorRegistry.findEditor(stringArray[n]);
            if (editorDescriptor == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)stringArray[n]));
            }
            editorDescriptorArray[n] = editorDescriptor;
            InnerEditor innerEditor = new InnerEditor(iEditorReference, abstractMultiEditor, iEditorInputArray[n], editorDescriptorArray[n]);
            iEditorReferenceArray[n] = innerEditor;
            iEditorPartArray[n] = innerEditor.getEditor(true);
            ++n;
        }
        abstractMultiEditor.setChildren(iEditorPartArray);
        return iEditorReferenceArray;
    }

    private void createEditorTab(EditorReference editorReference, String string) throws PartInitException {
        this.editorPresentation.addEditor(editorReference, string, true);
    }

    EditorSite createSite(IEditorReference iEditorReference, IEditorPart iEditorPart, EditorDescriptor editorDescriptor, IEditorInput iEditorInput) throws PartInitException {
        EditorSite editorSite = new EditorSite(iEditorReference, iEditorPart, this.page, editorDescriptor);
        if (editorDescriptor != null) {
            editorSite.setActionBars(this.createEditorActionBars(editorDescriptor, editorSite));
        } else {
            editorSite.setActionBars(this.createEmptyEditorActionBars(editorSite));
        }
        String string = iEditorPart.getTitle();
        try {
            try {
                UIStats.start(2, string);
                iEditorPart.init(editorSite, iEditorInput);
            }
            finally {
                UIStats.end(2, iEditorPart, string);
            }
            if (iEditorPart.getSite() != editorSite || iEditorPart.getEditorSite() != editorSite) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_siteIncorrect, (Object)editorDescriptor.getId()));
            }
        }
        catch (Exception exception) {
            this.disposeEditorActionBars((EditorActionBars)editorSite.getActionBars());
            editorSite.dispose();
            if (exception instanceof PartInitException) {
                throw (PartInitException)((Object)exception);
            }
            throw new PartInitException(WorkbenchMessages.EditorManager_errorInInit, exception);
        }
        return editorSite;
    }

    private IEditorReference reuseInternalEditor(EditorDescriptor editorDescriptor, IEditorInput iEditorInput) throws PartInitException {
        Assert.isNotNull((Object)editorDescriptor, (String)"descriptor must not be null");
        Assert.isNotNull((Object)iEditorInput, (String)"input must not be null");
        IEditorReference iEditorReference = this.findReusableEditor(editorDescriptor);
        if (iEditorReference != null) {
            return ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).reuseInternalEditor(this.page, this, this.editorPresentation, editorDescriptor, iEditorInput, iEditorReference);
        }
        return null;
    }

    IEditorPart createPart(EditorDescriptor editorDescriptor) throws PartInitException {
        try {
            IEditorPart iEditorPart = editorDescriptor.createEditor();
            IConfigurationElement iConfigurationElement = editorDescriptor.getConfigurationElement();
            if (iConfigurationElement != null) {
                this.page.getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)iEditorPart, 2);
            }
            return iEditorPart;
        }
        catch (CoreException coreException) {
            throw new PartInitException(StatusUtil.newStatus(editorDescriptor.getPluginID(), WorkbenchMessages.EditorManager_instantiationError, (Throwable)coreException));
        }
    }

    private IEditorReference openSystemExternalEditor(final IPath iPath) throws PartInitException {
        if (iPath == null) {
            throw new IllegalArgumentException();
        }
        final boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (iPath != null) {
                    blArray[0] = Program.launch((String)iPath.toOSString());
                }
            }
        });
        if (!blArray[0]) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unableToOpenExternalEditor, (Object)iPath));
        }
        return null;
    }

    ImageDescriptor findImage(EditorDescriptor editorDescriptor, IPath iPath) {
        if (editorDescriptor == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (editorDescriptor.isOpenExternal() && iPath != null) {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(iPath.toOSString());
        }
        return editorDescriptor.getImageDescriptor();
    }

    public IStatus restoreState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.EditorManager_problemsRestoringEditors, null);
        final String[] stringArray = new String[1];
        final ArrayList arrayList = new ArrayList(5);
        final IEditorReference[] iEditorReferenceArray = new IEditorReference[1];
        IMemento iMemento2 = iMemento.getChild("editorArea");
        if (iMemento2 != null) {
            multiStatus.add(this.editorPresentation.restoreState(iMemento2));
            stringArray[0] = iMemento2.getString("activeWorkbook");
        }
        IMemento[] iMementoArray = iMemento.getChildren("editor");
        int n = 0;
        while (n < iMementoArray.length) {
            this.restoreEditorState(iMementoArray[n], arrayList, iEditorReferenceArray, multiStatus);
            ++n;
        }
        if (iMemento2 != null) {
            multiStatus.add(this.editorPresentation.restorePresentationState(iMemento2));
        }
        try {
            StartupThreading.runWithThrowable(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    IWorkbenchPart iWorkbenchPart;
                    int n = 0;
                    while (n < arrayList.size()) {
                        EditorManager.this.setVisibleEditor((IEditorReference)arrayList.get(n), false);
                        ++n;
                    }
                    if (stringArray[0] != null) {
                        EditorManager.this.editorPresentation.setActiveEditorWorkbookFromID(stringArray[0]);
                    }
                    if (iEditorReferenceArray[0] != null && (iWorkbenchPart = iEditorReferenceArray[0].getPart(true)) != null) {
                        EditorManager.this.page.activate(iWorkbenchPart);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.EditorManager_exceptionRestoringEditor, throwable));
        }
        return multiStatus;
    }

    public boolean saveAll(boolean bl, boolean bl2, boolean bl3) {
        ISaveablePart[] iSaveablePartArray = this.page.getDirtyParts();
        if (iSaveablePartArray.length == 0) {
            return true;
        }
        ArrayList<ISaveablePart> arrayList = new ArrayList<ISaveablePart>(iSaveablePartArray.length);
        int n = 0;
        while (n < iSaveablePartArray.length) {
            arrayList.add(iSaveablePartArray[n]);
            ++n;
        }
        return EditorManager.saveAll(arrayList, bl, bl2, bl3, this.window);
    }

    public static boolean saveAll(List list, boolean bl, boolean bl2, boolean bl3, IWorkbenchWindow iWorkbenchWindow) {
        return EditorManager.saveAll(list, bl, bl2, bl3, iWorkbenchWindow, iWorkbenchWindow);
    }

    public static boolean saveAll(List arrayList, final boolean bl, final boolean bl2, boolean bl3, IRunnableContext iRunnableContext, final IShellProvider iShellProvider) {
        ListIterator listIterator;
        List<Object> list;
        block25: {
            block23: {
                int n;
                Object object;
                block24: {
                    String[] stringArray;
                    Object object2;
                    arrayList = new ArrayList(arrayList);
                    if (bl2) {
                        list = arrayList.iterator();
                        while (list.hasNext()) {
                            ISaveablePart iSaveablePart = (ISaveablePart)list.next();
                            if (iSaveablePart.isSaveOnCloseNeeded()) continue;
                            list.remove();
                        }
                    }
                    if (!bl) break block23;
                    boolean bl4 = false;
                    listIterator = arrayList.listIterator();
                    WorkbenchPage workbenchPage = null;
                    Object object3 = null;
                    while (listIterator.hasNext()) {
                        object2 = (IWorkbenchPart)listIterator.next();
                        if (!(object2 instanceof ISaveablePart2)) continue;
                        object = (WorkbenchPage)object2.getSite().getPage();
                        if (!Util.equals(workbenchPage, object)) {
                            if (workbenchPage != null && object3 != null && !object3.equals(workbenchPage.getActivePerspective())) {
                                workbenchPage.setPerspective(((Perspective)object3).getDesc());
                            }
                            workbenchPage = object;
                            object3 = ((WorkbenchPage)object).getActivePerspective();
                        }
                        if (bl) {
                            Object object4;
                            if (object2 instanceof IViewPart && (object4 = ((WorkbenchPage)object).getFirstPerspectiveWithView((IViewPart)object2)) != null) {
                                ((WorkbenchPage)object).setPerspective(((Perspective)object4).getDesc());
                            }
                            if ((object4 = ((WorkbenchPage)object).getWorkbenchWindow()) != object4.getWorkbench().getActiveWorkbenchWindow()) {
                                stringArray = object4.getShell();
                                if (stringArray.getMinimized()) {
                                    stringArray.setMinimized(false);
                                }
                                stringArray.setActive();
                            }
                            ((WorkbenchPage)object).bringToTop((IWorkbenchPart)object2);
                        }
                        if ((n = SaveableHelper.savePart((ISaveablePart2)object2, ((WorkbenchPage)object).getWorkbenchWindow(), bl)) == 2) {
                            return false;
                        }
                        if (n == 3) continue;
                        bl4 = true;
                        listIterator.remove();
                    }
                    if (workbenchPage != null && object3 != null && !object3.equals(workbenchPage.getActivePerspective())) {
                        workbenchPage.setPerspective(((Perspective)object3).getDesc());
                    }
                    if (bl4) {
                        listIterator = arrayList.listIterator();
                        while (listIterator.hasNext()) {
                            object2 = (ISaveablePart)listIterator.next();
                            if (object2.isDirty()) continue;
                            listIterator.remove();
                        }
                    }
                    if ((list = EditorManager.convertToSaveables(arrayList, bl2, bl3)).isEmpty()) {
                        return true;
                    }
                    boolean bl5 = SaveableHelper.waitForBackgroundSaveJobs(list);
                    if (bl5) {
                        return false;
                    }
                    if (list.size() != 1) break block24;
                    object = (Saveable)list.get(0);
                    String string = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)((Saveable)object).getName());
                    stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog messageDialog = new MessageDialog(iShellProvider.getShell(), WorkbenchMessages.Save_Resource, null, string, 3, stringArray, 0){

                        protected int getShellStyle() {
                            return super.getShellStyle() | 0x10000000;
                        }
                    };
                    int n2 = SaveableHelper.testGetAutomatedResponse();
                    if (SaveableHelper.testGetAutomatedResponse() == -1) {
                        n2 = messageDialog.open();
                    }
                    switch (n2) {
                        case 0: {
                            break block25;
                        }
                        case 1: {
                            return true;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                object = new ListSelectionDialog(iShellProvider.getShell(), list, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), RESOURCES_TO_SAVE_MESSAGE){

                    protected int getShellStyle() {
                        return super.getShellStyle() | 0x10000000;
                    }
                };
                ((SelectionDialog)((Object)object)).setInitialSelections(list.toArray());
                ((SelectionDialog)((Object)object)).setTitle(SAVE_RESOURCES_TITLE);
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    n = object.open();
                    if (n == 1) {
                        return false;
                    }
                    list = Arrays.asList(((SelectionDialog)((Object)object)).getResult());
                }
                break block25;
            }
            list = EditorManager.convertToSaveables(arrayList, bl2, bl3);
        }
        if (list.isEmpty()) {
            return true;
        }
        final List<Object> list2 = list;
        listIterator = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                EventLoopProgressMonitor eventLoopProgressMonitor = new EventLoopProgressMonitor(iProgressMonitor);
                eventLoopProgressMonitor.beginTask(WorkbenchMessages.Saving_Modifications, list2.size());
                for (Saveable saveable : list2) {
                    if (!saveable.isDirty()) {
                        iProgressMonitor.worked(1);
                        continue;
                    }
                    SaveableHelper.doSaveModel(saveable, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)eventLoopProgressMonitor, 1), iShellProvider, bl2 || bl);
                    if (eventLoopProgressMonitor.isCanceled()) break;
                }
                eventLoopProgressMonitor.done();
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, listIterator, iRunnableContext, iShellProvider);
    }

    private static List convertToSaveables(List list, boolean bl, boolean bl2) {
        ArrayList<Saveable> arrayList = new ArrayList<Saveable>();
        HashSet<Saveable> hashSet = new HashSet<Saveable>();
        for (ISaveablesSource[] iSaveablesSourceArray : list) {
            Saveable[] saveableArray = EditorManager.getSaveables((IWorkbenchPart)iSaveablesSourceArray);
            int n = 0;
            while (n < saveableArray.length) {
                Saveable saveable = saveableArray[n];
                if (saveable.isDirty() && !hashSet.contains(saveable)) {
                    hashSet.add(saveable);
                    if (!bl || EditorManager.closingLastPartShowingModel(saveable, list, iSaveablesSourceArray.getSite().getPage())) {
                        arrayList.add(saveable);
                    }
                }
                ++n;
            }
        }
        if (bl2) {
            ISaveablesSource[] iSaveablesSourceArray;
            SaveablesList saveablesList = (SaveablesList)PlatformUI.getWorkbench().getService(ISaveablesLifecycleListener.class);
            iSaveablesSourceArray = saveablesList.getNonPartSources();
            int n = 0;
            while (n < iSaveablesSourceArray.length) {
                Saveable[] saveableArray = iSaveablesSourceArray[n].getSaveables();
                int n2 = 0;
                while (n2 < saveableArray.length) {
                    Saveable saveable = saveableArray[n2];
                    if (saveable.isDirty() && !hashSet.contains(saveable)) {
                        hashSet.add(saveable);
                        arrayList.add(saveable);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private static Saveable[] getSaveables(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ISaveablesSource) {
            ISaveablesSource iSaveablesSource = (ISaveablesSource)((Object)iWorkbenchPart);
            return iSaveablesSource.getSaveables();
        }
        return new Saveable[]{new DefaultSaveable(iWorkbenchPart)};
    }

    private static boolean closingLastPartShowingModel(Saveable saveable, List list, IWorkbenchPage iWorkbenchPage) {
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : list) {
            Saveable[] saveableArray = EditorManager.getSaveables((IWorkbenchPart)object2);
            if (!Arrays.asList(saveableArray).contains(saveable)) continue;
            hashSet.add(object2);
        }
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = ((WorkbenchPage)iWorkbenchPage).getAllParts();
        object2 = new HashSet();
        int n = 0;
        while (n < iWorkbenchPartReferenceArray.length) {
            Saveable[] saveableArray;
            Object object3 = iWorkbenchPartReferenceArray[n];
            IWorkbenchPart iWorkbenchPart = object3.getPart(false);
            if (iWorkbenchPart != null && Arrays.asList(saveableArray = EditorManager.getSaveables(iWorkbenchPart)).contains(saveable)) {
                ((HashSet)object2).add(iWorkbenchPart);
            }
            ++n;
        }
        for (Object object3 : hashSet) {
            ((HashSet)object2).remove(object3);
        }
        return ((HashSet)object2).isEmpty();
    }

    public boolean savePart(ISaveablePart iSaveablePart, IWorkbenchPart iWorkbenchPart, boolean bl) {
        return SaveableHelper.savePart(iSaveablePart, iWorkbenchPart, this.window, bl);
    }

    public IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.EditorManager_problemsSavingEditors, null);
        IMemento iMemento2 = iMemento.createChild("editorArea");
        multiStatus.add(this.editorPresentation.saveState(iMemento2));
        iMemento2.putString("activeWorkbook", this.editorPresentation.getActiveEditorWorkbookID());
        ArrayList arrayList = this.editorPresentation.getWorkbooks();
        for (EditorStack editorStack : arrayList) {
            EditorPane[] editorPaneArray = editorStack.getEditors();
            int n = 0;
            while (n < editorPaneArray.length) {
                IEditorReference iEditorReference = editorPaneArray[n].getEditorReference();
                EditorReference editorReference = (EditorReference)iEditorReference;
                IEditorPart iEditorPart = iEditorReference.getEditor(false);
                if (iEditorPart == null) {
                    if (editorReference.getMemento() != null) {
                        IMemento iMemento3 = iMemento.createChild("editor");
                        iMemento3.putMemento(editorReference.getMemento());
                    }
                } else {
                    this.saveEditorState(iMemento, editorReference, multiStatus);
                }
                ++n;
            }
        }
        return multiStatus;
    }

    public boolean setVisibleEditor(IEditorReference iEditorReference, boolean bl) {
        return this.editorPresentation.setVisibleEditor(iEditorReference, bl);
    }

    private IPathEditorInput getPathEditorInput(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IPathEditorInput) {
            return (IPathEditorInput)iEditorInput;
        }
        return (IPathEditorInput)Util.getAdapter(iEditorInput, IPathEditorInput.class);
    }

    public void restoreEditorState(IMemento iMemento, ArrayList arrayList, IEditorReference[] iEditorReferenceArray, MultiStatus multiStatus) {
        String string;
        boolean bl;
        final EditorReference editorReference = new EditorReference(this, iMemento);
        final String string2 = iMemento.getString("workbook");
        try {
            StartupThreading.runWithPartInitExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    EditorManager.this.createEditorTab(editorReference, string2);
                }
            });
        }
        catch (PartInitException partInitException) {
            multiStatus.add(partInitException.getStatus());
        }
        String string3 = iMemento.getString("activePart");
        if ("true".equals(string3)) {
            iEditorReferenceArray[0] = editorReference;
        }
        if (bl = "true".equals(string = iMemento.getString("focus"))) {
            arrayList.add(editorReference);
        }
    }

    protected void saveEditorState(IMemento iMemento, IEditorReference iEditorReference, MultiStatus multiStatus) {
        final EditorReference editorReference = (EditorReference)iEditorReference;
        final IEditorPart iEditorPart = iEditorReference.getEditor(false);
        final IMemento iMemento2 = iMemento;
        final MultiStatus multiStatus2 = multiStatus;
        if (!(iEditorPart.getEditorSite() instanceof EditorSite)) {
            return;
        }
        EditorSite editorSite = (EditorSite)iEditorPart.getEditorSite();
        if (editorSite.getPane() instanceof MultiEditorInnerPane) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IMemento iMemento;
                Object object;
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                if (!iEditorInput.exists()) {
                    return;
                }
                IPersistableElement iPersistableElement = iEditorInput.getPersistable();
                if (iPersistableElement == null) {
                    return;
                }
                IMemento iMemento22 = iMemento2.createChild("editor");
                iMemento22.putString("title", editorReference.getTitle());
                iMemento22.putString("name", editorReference.getName());
                iMemento22.putString("id", editorReference.getId());
                iMemento22.putString("tooltip", editorReference.getTitleToolTip());
                iMemento22.putString("partName", editorReference.getPartName());
                if (iEditorPart instanceof IWorkbenchPart3 && !(object = ((IWorkbenchPart3)((Object)iEditorPart)).getPartProperties()).isEmpty()) {
                    iMemento = iMemento22.createChild("properties");
                    for (Map.Entry entry : object.entrySet()) {
                        IMemento iMemento3 = iMemento.createChild("property", (String)entry.getKey());
                        iMemento3.putTextData((String)entry.getValue());
                    }
                }
                if (editorReference.isPinned()) {
                    iMemento22.putString("pinned", "true");
                }
                object = (EditorPane)((EditorSite)iEditorPart.getEditorSite()).getPane();
                iMemento22.putString("workbook", ((EditorPane)object).getWorkbook().getID());
                if (iEditorPart == EditorManager.this.page.getActiveEditor()) {
                    iMemento22.putString("activePart", "true");
                }
                if (object == ((EditorPane)object).getWorkbook().getSelection()) {
                    iMemento22.putString("focus", "true");
                }
                if (iEditorInput instanceof IPathEditorInput && (iMemento = ((IPathEditorInput)iEditorInput).getPath()) != null) {
                    iMemento22.putString("path", iMemento.toString());
                }
                iMemento = iMemento22.createChild("input");
                iMemento.putString("factoryID", iPersistableElement.getFactoryId());
                iPersistableElement.saveState(iMemento);
                if (iEditorPart instanceof IPersistableEditor) {
                    IMemento iMemento4 = iMemento22.createChild("editorState");
                    ((IPersistableEditor)((Object)iEditorPart)).saveState(iMemento4);
                }
            }

            public void handleException(Throwable throwable) {
                multiStatus2.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.EditorManager_unableToSaveEditor, (Object)editorReference.getTitle()), throwable));
            }
        });
    }

    public IMemento getMemento(IEditorReference iEditorReference) {
        if (iEditorReference instanceof EditorReference) {
            return ((EditorReference)iEditorReference).getMemento();
        }
        return null;
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IEditorPart) {
                IEditorPart iEditorPart = (IEditorPart)objectArray[n];
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                this.page.closeEditor(iEditorPart, true);
                ((Workbench)this.window.getWorkbench()).getEditorHistory().remove(iEditorInput);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }

    IEditorReference openEmptyTab() {
        NullEditorInput nullEditorInput = new NullEditorInput();
        EditorDescriptor editorDescriptor = (EditorDescriptor)((EditorRegistry)this.getEditorRegistry()).findEditor("org.eclipse.ui.internal.emptyEditorTab");
        EditorReference editorReference = new EditorReference(this, nullEditorInput, editorDescriptor);
        try {
            this.createEditorTab(editorReference, "");
            return editorReference;
        }
        catch (PartInitException partInitException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, (Throwable)((Object)partInitException)));
            return null;
        }
    }

    public static boolean useIPersistableEditor() {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("USE_IPERSISTABLE_EDITORS");
    }

    private static IEditorDescriptor getAlternateEditor() {
        Shell shell = ProgressManagerUtil.getDefaultParent();
        EditorSelectionDialog editorSelectionDialog = new EditorSelectionDialog(shell){

            @Override
            protected IDialogSettings getDialogSettings() {
                DialogSettings dialogSettings = new DialogSettings("EditorSelectionDialog");
                dialogSettings.put("EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL", true);
                return dialogSettings;
            }
        };
        editorSelectionDialog.setMessage(WorkbenchMessages.EditorManager_largeDocumentWarning);
        if (editorSelectionDialog.open() == 0) {
            return editorSelectionDialog.getSelectedEditor();
        }
        return null;
    }

    boolean isLargeDocument(IEditorInput iEditorInput) {
        if (!this.checkDocumentSize) {
            return false;
        }
        if (!(iEditorInput instanceof IPathEditorInput)) {
            return false;
        }
        try {
            IPath iPath = ((IPathEditorInput)iEditorInput).getPath();
            File file = new File(iPath.toOSString());
            return file.length() > this.maxFileSize;
        }
        catch (Exception exception) {
            return false;
        }
    }

    class InnerEditor
    extends EditorReference {
        private IEditorReference outerEditor;
        private AbstractMultiEditor outerEditorPart;

        public InnerEditor(IEditorReference iEditorReference, AbstractMultiEditor abstractMultiEditor, IEditorInput iEditorInput, EditorDescriptor editorDescriptor) {
            super(EditorManager.this, iEditorInput, editorDescriptor);
            this.outerEditor = iEditorReference;
            this.outerEditorPart = abstractMultiEditor;
        }

        public IEditorReference getOuterEditor() {
            return this.outerEditor;
        }

        @Override
        protected void doDisposePart() {
            this.outerEditorPart = null;
            super.doDisposePart();
        }

        @Override
        protected PartPane createPane() {
            return new MultiEditorInnerPane((EditorPane)((EditorReference)this.outerEditor).getPane(), this, EditorManager.this.page, EditorManager.this.editorPresentation.getActiveWorkbook(), this.outerEditorPart instanceof MultiEditor);
        }

        @Override
        protected Composite getPaneControlContainer() {
            if (this.outerEditorPart instanceof MultiEditor) {
                return super.getPaneControlContainer();
            }
            return this.outerEditorPart.getInnerEditorContainer(this);
        }
    }
}

