/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorHistoryItem {
    private IEditorInput input;
    private IEditorDescriptor descriptor;
    private IMemento memento;

    public EditorHistoryItem(IEditorInput iEditorInput, IEditorDescriptor iEditorDescriptor) {
        this.input = iEditorInput;
        this.descriptor = iEditorDescriptor;
    }

    public EditorHistoryItem(IMemento iMemento) {
        this.memento = iMemento;
    }

    public IEditorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IEditorInput getInput() {
        return this.input;
    }

    public boolean isRestored() {
        return this.memento == null;
    }

    public String getName() {
        String string;
        if (this.isRestored() && this.getInput() != null) {
            return this.getInput().getName();
        }
        if (this.memento != null && (string = this.memento.getString("name")) != null) {
            return string;
        }
        return "";
    }

    public String getToolTipText() {
        String string;
        if (this.isRestored() && this.getInput() != null) {
            return this.getInput().getToolTipText();
        }
        if (this.memento != null && (string = this.memento.getString("tooltip")) != null) {
            return string;
        }
        return "";
    }

    public boolean matches(IEditorInput iEditorInput) {
        if (this.isRestored()) {
            return iEditorInput.equals(this.getInput());
        }
        if (!this.getName().equals(iEditorInput.getName())) {
            return false;
        }
        if (!this.getToolTipText().equals(iEditorInput.getToolTipText())) {
            return false;
        }
        IPersistableElement iPersistableElement = iEditorInput.getPersistable();
        String string = iPersistableElement == null ? null : iPersistableElement.getFactoryId();
        String string2 = this.getFactoryId();
        return string2 == null ? string == null : string2.equals(string);
    }

    public String getFactoryId() {
        if (this.isRestored()) {
            IPersistableElement iPersistableElement;
            if (this.input != null && (iPersistableElement = this.input.getPersistable()) != null) {
                return iPersistableElement.getFactoryId();
            }
        } else if (this.memento != null) {
            return this.memento.getString("factoryID");
        }
        return null;
    }

    public IStatus restoreState() {
        Assert.isTrue((!this.isRestored() ? 1 : 0) != 0);
        IStatus iStatus = Status.OK_STATUS;
        IMemento iMemento = this.memento;
        this.memento = null;
        String string = iMemento.getString("factoryID");
        if (string == null) {
            WorkbenchPlugin.log("Unable to restore mru list - no input factory ID.");
            return iStatus;
        }
        IElementFactory iElementFactory = PlatformUI.getWorkbench().getElementFactory(string);
        if (iElementFactory == null) {
            return iStatus;
        }
        IMemento iMemento2 = iMemento.getChild("persistable");
        if (iMemento2 == null) {
            WorkbenchPlugin.log("Unable to restore mru list - no input element state: " + string);
            return iStatus;
        }
        IAdaptable iAdaptable = iElementFactory.createElement(iMemento2);
        if (iAdaptable == null || !(iAdaptable instanceof IEditorInput)) {
            return iStatus;
        }
        this.input = (IEditorInput)iAdaptable;
        String string2 = iMemento.getString("id");
        if (string2 != null) {
            IEditorRegistry iEditorRegistry = WorkbenchPlugin.getDefault().getEditorRegistry();
            this.descriptor = iEditorRegistry.findEditor(string2);
        }
        return iStatus;
    }

    public boolean canSave() {
        return !this.isRestored() || this.getInput() != null && this.getInput().getPersistable() != null;
    }

    public IStatus saveState(IMemento iMemento) {
        IPersistableElement iPersistableElement;
        if (!this.isRestored()) {
            iMemento.putMemento(this.memento);
        } else if (this.input != null && (iPersistableElement = this.input.getPersistable()) != null) {
            IMemento iMemento2 = iMemento.createChild("persistable");
            iPersistableElement.saveState(iMemento2);
            iMemento.putString("factoryID", iPersistableElement.getFactoryId());
            if (this.descriptor != null && this.descriptor.getId() != null) {
                iMemento.putString("id", this.descriptor.getId());
            }
            iMemento.putString("name", this.input.getName());
            iMemento.putString("tooltip", this.input.getToolTipText());
        }
        return Status.OK_STATUS;
    }
}

