/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorHistoryItem;

public class EditorHistory {
    public static final int MAX_SIZE = 15;
    private ArrayList fifoList = new ArrayList(15);

    public void add(IEditorInput iEditorInput, IEditorDescriptor iEditorDescriptor) {
        if (iEditorInput != null && iEditorInput.exists()) {
            this.add(new EditorHistoryItem(iEditorInput, iEditorDescriptor), 0);
        }
    }

    private void add(EditorHistoryItem editorHistoryItem, int n) {
        if (editorHistoryItem.isRestored()) {
            this.remove(editorHistoryItem.getInput());
        }
        if (this.fifoList.size() == 15) {
            this.fifoList.remove(14);
        }
        this.fifoList.add(n < 15 ? n : 14, editorHistoryItem);
    }

    public EditorHistoryItem[] getItems() {
        this.refresh();
        EditorHistoryItem[] editorHistoryItemArray = new EditorHistoryItem[this.fifoList.size()];
        this.fifoList.toArray(editorHistoryItemArray);
        return editorHistoryItemArray;
    }

    public void refresh() {
        Iterator iterator = this.fifoList.iterator();
        while (iterator.hasNext()) {
            IEditorInput iEditorInput;
            EditorHistoryItem editorHistoryItem = (EditorHistoryItem)iterator.next();
            if (!editorHistoryItem.isRestored() || (iEditorInput = editorHistoryItem.getInput()) == null || iEditorInput.exists()) continue;
            iterator.remove();
        }
    }

    public void remove(EditorHistoryItem editorHistoryItem) {
        this.fifoList.remove(editorHistoryItem);
    }

    public void remove(IEditorInput iEditorInput) {
        if (iEditorInput == null) {
            return;
        }
        Iterator iterator = this.fifoList.iterator();
        while (iterator.hasNext()) {
            EditorHistoryItem editorHistoryItem = (EditorHistoryItem)iterator.next();
            if (!editorHistoryItem.matches(iEditorInput)) continue;
            iterator.remove();
        }
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("file");
        int n = 0;
        while (n < iMementoArray.length) {
            EditorHistoryItem editorHistoryItem = new EditorHistoryItem(iMementoArray[n]);
            if (!"".equals(editorHistoryItem.getName()) || !"".equals(editorHistoryItem.getToolTipText())) {
                this.add(editorHistoryItem, this.fifoList.size());
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IStatus saveState(IMemento iMemento) {
        for (EditorHistoryItem editorHistoryItem : this.fifoList) {
            if (!editorHistoryItem.canSave()) continue;
            IMemento iMemento2 = iMemento.createChild("file");
            editorHistoryItem.saveState(iMemento2);
        }
        return Status.OK_STATUS;
    }
}

