/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.FastViewDnDHandler;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

public class EditorAreaTrimToolBar
extends TrimToolBarBase {
    private boolean restoreOnUnzoom = false;
    private int paneOrientation;

    public EditorAreaTrimToolBar(WorkbenchWindow workbenchWindow) {
        super("org.eclipse.ui.editorss", 128, workbenchWindow);
        this.dock(128);
    }

    protected void restoreToPresentation() {
        Perspective perspective = this.wbw.getActiveWorkbenchPage().getActivePerspective();
        perspective.setEditorAreaState(2);
    }

    @Override
    public void initToolBarManager(final ToolBarManager toolBarManager) {
        ContributionItem contributionItem = new ContributionItem(){

            public void fill(ToolBar toolBar, int n) {
                ToolItem toolItem = new ToolItem(toolBarManager.getControl(), 8, n);
                Image image = WorkbenchImages.getImage("IMG_ETOOL_RESTORE_TRIMPART");
                toolItem.setImage(image);
                String string = WorkbenchMessages.StandardSystemToolbar_Restore;
                toolItem.setToolTipText(string);
                toolItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }
                });
            }
        };
        toolBarManager.add((IContributionItem)contributionItem);
        ContributionItem contributionItem2 = new ContributionItem(){

            public void fill(ToolBar toolBar, int n) {
                ToolItem toolItem = new ToolItem(toolBarManager.getControl(), 8, n);
                Image image = WorkbenchImages.getImage("IMG_ETOOL_EDITOR_TRIMPART");
                toolItem.setImage(image);
                String string = WorkbenchMessages.EditorArea_Tooltip;
                toolItem.setToolTipText(string);
                toolItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        EditorAreaTrimToolBar.this.restoreToPresentation();
                    }
                });
            }
        };
        toolBarManager.add((IContributionItem)contributionItem2);
    }

    @Override
    public void hookControl(ToolBarManager toolBarManager) {
        new FastViewDnDHandler(this.id, toolBarManager, this.wbw);
    }

    public void setRestoreOnUnzoom(boolean bl) {
        this.restoreOnUnzoom = bl;
    }

    public boolean restoreOnUnzoom() {
        return this.restoreOnUnzoom;
    }

    public void setIconSelection(IViewReference iViewReference, boolean bl) {
        ToolItem toolItem = ShowFastViewContribution.getItem(this.tbMgr.getControl(), iViewReference);
        if (toolItem != null) {
            toolItem.setSelection(bl);
        }
    }

    public int getPaneOrientation() {
        return this.paneOrientation;
    }
}

