/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.MultiEditorInnerPane;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.part.AbstractMultiEditor;

public class EditorAreaHelper {
    private EditorSashContainer editorArea;

    public EditorAreaHelper(WorkbenchPage workbenchPage) {
        this.editorArea = new EditorSashContainer("org.eclipse.ui.editorss", workbenchPage, workbenchPage.getClientComposite());
        this.editorArea.createControl(workbenchPage.getClientComposite());
        this.editorArea.setActive(true);
    }

    public void displayEditorList() {
        EditorStack editorStack = this.editorArea.getActiveWorkbook();
        if (editorStack != null) {
            editorStack.showPartList();
        }
    }

    public void closeEditor(IEditorReference iEditorReference) {
        EditorPane editorPane = (EditorPane)((WorkbenchPartReference)((Object)iEditorReference)).getPane();
        this.closeEditor(editorPane);
    }

    public void closeEditor(IEditorPart iEditorPart) {
        EditorPane editorPane = (EditorPane)((PartSite)((Object)iEditorPart.getEditorSite())).getPane();
        this.closeEditor(editorPane);
    }

    private void closeEditor(EditorPane editorPane) {
        if (editorPane != null && !(editorPane instanceof MultiEditorInnerPane)) {
            this.editorArea.removeEditor(editorPane);
        }
    }

    public static void derefPart(LayoutPart layoutPart) {
        LayoutPart layoutPart2;
        ILayoutContainer iLayoutContainer;
        ILayoutContainer iLayoutContainer2 = layoutPart.getContainer();
        if (iLayoutContainer2 == null) {
            return;
        }
        iLayoutContainer2.remove(layoutPart);
        LayoutPart[] layoutPartArray = iLayoutContainer2.getChildren();
        if ((layoutPartArray == null || layoutPartArray.length == 0) && iLayoutContainer2 instanceof LayoutPart && (iLayoutContainer = (layoutPart2 = (LayoutPart)((Object)iLayoutContainer2)).getContainer()) != null) {
            iLayoutContainer.remove(layoutPart2);
            layoutPart2.dispose();
        }
    }

    public void dispose() {
        if (this.editorArea != null) {
            this.editorArea.setActive(false);
            this.editorArea.dispose();
        }
    }

    public String getActiveEditorWorkbookID() {
        return this.editorArea.getActiveWorkbookID();
    }

    public EditorStack getActiveWorkbook() {
        return this.editorArea.getActiveWorkbook();
    }

    public LayoutPart getLayoutPart() {
        return this.editorArea;
    }

    public IEditorReference getVisibleEditor() {
        EditorStack editorStack = this.editorArea.getActiveWorkbook();
        EditorPane editorPane = (EditorPane)editorStack.getSelection();
        if (editorPane != null) {
            IEditorReference iEditorReference = editorPane.getEditorReference();
            IEditorPart iEditorPart = (IEditorPart)iEditorReference.getPart(false);
            if (iEditorPart != null && iEditorPart instanceof AbstractMultiEditor) {
                iEditorPart = ((AbstractMultiEditor)iEditorPart).getActiveEditor();
                EditorSite editorSite = (EditorSite)iEditorPart.getSite();
                iEditorReference = (IEditorReference)editorSite.getPartReference();
            }
            return iEditorReference;
        }
        return null;
    }

    public void moveEditor(IEditorPart iEditorPart, int n) {
        ((EditorSite)iEditorPart.getSite()).getPane();
    }

    public boolean containsEditor(EditorReference editorReference) {
        IEditorReference[] iEditorReferenceArray = this.editorArea.getPage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (editorReference == iEditorReferenceArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addEditor(EditorReference editorReference, String string, boolean bl) {
        if (this.containsEditor(editorReference)) {
            return;
        }
        if (!(editorReference.getPane() instanceof MultiEditorInnerPane)) {
            EditorStack editorStack = null;
            if (string != null) {
                editorStack = this.getWorkbookFromID(string);
            }
            if (editorStack == null) {
                editorStack = this.getActiveWorkbook();
            }
            this.addToLayout((EditorPane)editorReference.getPane(), editorStack);
        }
        if (bl) {
            this.editorArea.getPage().partAdded(editorReference);
        }
    }

    private void addToLayout(EditorPane editorPane, EditorStack editorStack) {
        editorPane.setWorkbook(editorStack);
        this.editorArea.addEditor(editorPane, editorStack);
    }

    public IStatus restoreState(IMemento iMemento) {
        return this.editorArea.restoreState(iMemento);
    }

    public IStatus restorePresentationState(IMemento iMemento) {
        return this.editorArea.restorePresentationState(iMemento);
    }

    public IStatus saveState(IMemento iMemento) {
        return this.editorArea.saveState(iMemento);
    }

    public void setActiveEditorWorkbookFromID(String string) {
        this.editorArea.setActiveWorkbookFromID(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setVisibleEditor(IEditorReference iEditorReference, boolean bl) {
        IEditorReference iEditorReference2 = this.getVisibleEditor();
        if (iEditorReference == iEditorReference2) return false;
        IEditorPart iEditorPart = (IEditorPart)iEditorReference.getPart(true);
        EditorPane editorPane = null;
        if (iEditorPart != null) {
            editorPane = (EditorPane)((PartSite)((Object)iEditorPart.getEditorSite())).getPane();
        }
        if (editorPane == null) return false;
        if (editorPane instanceof MultiEditorInnerPane) {
            EditorPane editorPane2 = ((MultiEditorInnerPane)editorPane).getParentPane();
            EditorStack editorStack = editorPane2.getWorkbook();
            PartPane partPane = editorStack.getSelection();
            if (partPane == editorPane2) return false;
            editorPane2.getWorkbook().setSelection(editorPane2);
        } else {
            editorPane.getWorkbook().setSelection(editorPane);
        }
        if (!bl) return true;
        iEditorPart.setFocus();
        return true;
    }

    public ArrayList getWorkbooks() {
        return this.editorArea.getEditorWorkbooks();
    }

    public IEditorReference[] getEditors() {
        ArrayList<IWorkbenchPartReference> arrayList = new ArrayList<IWorkbenchPartReference>();
        ArrayList arrayList2 = this.editorArea.getEditorWorkbooks();
        for (PartStack partStack : arrayList2) {
            LayoutPart[] layoutPartArray = partStack.getChildren();
            int n = 0;
            while (n < layoutPartArray.length) {
                LayoutPart layoutPart = layoutPartArray[n];
                arrayList.add(((PartPane)layoutPart).getPartReference());
                ++n;
            }
        }
        return arrayList.toArray(new IEditorReference[arrayList.size()]);
    }

    public EditorStack getWorkbookFromID(String string) {
        return this.editorArea.getWorkbookFromID(string);
    }

    public void updateStackButtons() {
        this.editorArea.updateStackButtons();
    }
}

