/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;

public class EditorActionBuilder
extends PluginActionBuilder {
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";

    @Override
    protected ActionDescriptor createActionDescriptor(IConfigurationElement iConfigurationElement) {
        return new ActionDescriptor(iConfigurationElement, 4);
    }

    @Override
    protected PluginActionBuilder.BasicContribution createContribution() {
        return new EditorContribution();
    }

    public IEditorActionBarContributor readActionExtensions(IEditorDescriptor iEditorDescriptor) {
        ExternalContributor externalContributor = null;
        this.readContributions(iEditorDescriptor.getId(), TAG_CONTRIBUTION_TYPE, "editorActions");
        if (this.cache != null) {
            externalContributor = new ExternalContributor(this.cache);
            this.cache = null;
        }
        return externalContributor;
    }

    private static class EditorContribution
    extends PluginActionBuilder.BasicContribution {
        private EditorContribution() {
        }

        @Override
        public void dispose() {
            this.disposeActions();
            super.dispose();
        }

        public void editorChanged(IEditorPart iEditorPart) {
            if (this.actions != null) {
                int n = 0;
                while (n < this.actions.size()) {
                    ActionDescriptor actionDescriptor = (ActionDescriptor)this.actions.get(n);
                    EditorPluginAction editorPluginAction = (EditorPluginAction)actionDescriptor.getAction();
                    editorPluginAction.editorChanged(iEditorPart);
                    ++n;
                }
            }
        }
    }

    public static class ExternalContributor
    implements IEditorActionBarContributor {
        private ArrayList cache;

        public ExternalContributor(ArrayList arrayList) {
            this.cache = arrayList;
        }

        @Override
        public void dispose() {
            int n = 0;
            while (n < this.cache.size()) {
                ((EditorContribution)this.cache.get(n)).dispose();
                ++n;
            }
        }

        public ActionDescriptor[] getExtendedActions() {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < this.cache.size()) {
                EditorContribution editorContribution = (EditorContribution)this.cache.get(n);
                if (editorContribution.actions != null) {
                    arrayList.addAll(editorContribution.actions);
                }
                ++n;
            }
            return arrayList.toArray(new ActionDescriptor[arrayList.size()]);
        }

        @Override
        public void init(IActionBars iActionBars, IWorkbenchPage iWorkbenchPage) {
            int n = 0;
            while (n < this.cache.size()) {
                ((EditorContribution)this.cache.get(n)).contribute(iActionBars.getMenuManager(), false, iActionBars.getToolBarManager(), true);
                ++n;
            }
        }

        @Override
        public void setActiveEditor(IEditorPart iEditorPart) {
            int n = 0;
            while (n < this.cache.size()) {
                ((EditorContribution)this.cache.get(n)).editorChanged(iEditorPart);
                ++n;
            }
        }
    }
}

