/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.jface.action.SubCoolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.EditorMenuManager;
import org.eclipse.ui.internal.PlaceholderContributionItem;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.expressions.LegacyEditorActionBarExpression;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.services.IServiceLocator;

public class EditorActionBars
extends SubActionBars2 {
    private static final boolean DEBUG_TOOLBAR_DISPOSAL = Policy.DEBUG_TOOLBAR_DISPOSAL;
    private IToolBarManager coolItemToolBarMgr = null;
    private IEditorActionBarContributor editorContributor;
    private boolean enabledAllowed = false;
    private IEditorActionBarContributor extensionContributor;
    private int refCount;
    private IToolBarContributionItem toolBarContributionItem = null;
    private String type;
    private IActionBarPresentationFactory actionBarPresentation;
    private LegacyEditorActionBarExpression editorHandlerExpression = null;

    public EditorActionBars(WorkbenchPage workbenchPage, IServiceLocator iServiceLocator, String string) {
        super((IActionBars2)workbenchPage.getActionBars(), iServiceLocator);
        this.type = string;
        this.actionBarPresentation = ((WorkbenchWindow)workbenchPage.getWorkbenchWindow()).getActionBarPresentationFactory();
    }

    @Override
    public void activate(boolean bl) {
        this.setActive(true, bl);
    }

    public void addRef() {
        ++this.refCount;
    }

    @Override
    protected SubMenuManager createSubMenuManager(IMenuManager iMenuManager) {
        return new EditorMenuManager(iMenuManager);
    }

    @Override
    protected SubToolBarManager createSubToolBarManager(IToolBarManager iToolBarManager) {
        return null;
    }

    @Override
    public void deactivate(boolean bl) {
        this.setActive(false, bl);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.editorContributor != null) {
            this.editorContributor.dispose();
        }
        if (this.extensionContributor != null) {
            this.extensionContributor.dispose();
        }
        if (this.toolBarContributionItem != null) {
            ICoolBarManager iCoolBarManager = this.getCoolBarManager();
            if (iCoolBarManager instanceof SubContributionManager) {
                SubContributionManager subContributionManager = (SubContributionManager)iCoolBarManager;
                IContributionManager iContributionManager = subContributionManager.getParent();
                if (iContributionManager instanceof ContributionManager) {
                    PlaceholderContributionItem placeholderContributionItem = new PlaceholderContributionItem(this.toolBarContributionItem);
                    boolean bl = ((ContributionManager)iContributionManager).replaceItem(placeholderContributionItem.getId(), (IContributionItem)placeholderContributionItem);
                    if (!bl && DEBUG_TOOLBAR_DISPOSAL) {
                        System.out.println("FAILURE WHILE DISPOSING EditorActionBars");
                        System.out.println("Could not replace " + placeholderContributionItem.getId() + " in the contribution manager.");
                    }
                } else if (DEBUG_TOOLBAR_DISPOSAL) {
                    System.out.println("FAILURE WHILE DISPOSING EditorActionBars");
                    System.out.println("The manager was not a ContributionManager.");
                    System.out.println("It was a " + iContributionManager.getClass().getName());
                }
            } else if (DEBUG_TOOLBAR_DISPOSAL) {
                System.out.println("FAILURE WHILE DISPOSING EditorActionBars");
                System.out.println("The coolBarManager was not a SubContributionManager");
                System.out.println("It was a " + iCoolBarManager.getClass().getName());
            }
            this.toolBarContributionItem.dispose();
        }
        this.toolBarContributionItem = null;
        if (this.coolItemToolBarMgr != null) {
            this.coolItemToolBarMgr.removeAll();
        }
        this.coolItemToolBarMgr = null;
        this.editorHandlerExpression = null;
    }

    public IEditorActionBarContributor getEditorContributor() {
        return this.editorContributor;
    }

    public String getEditorType() {
        return this.type;
    }

    public IEditorActionBarContributor getExtensionContributor() {
        return this.extensionContributor;
    }

    public int getRef() {
        return this.refCount;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        ICoolBarManager iCoolBarManager = this.getCastedParent().getCoolBarManager();
        if (iCoolBarManager == null) {
            return null;
        }
        if (iCoolBarManager.find("group.editor") == null) {
            iCoolBarManager.add((IContributionItem)new GroupMarker("group.editor"));
        }
        if (this.toolBarContributionItem == null) {
            IContributionItem iContributionItem = iCoolBarManager.find(this.type);
            if (iContributionItem instanceof IToolBarContributionItem) {
                this.toolBarContributionItem = (IToolBarContributionItem)iContributionItem;
                this.coolItemToolBarMgr = this.toolBarContributionItem.getToolBarManager();
                if (this.coolItemToolBarMgr == null) {
                    this.coolItemToolBarMgr = this.actionBarPresentation.createToolBarManager();
                    this.toolBarContributionItem = this.actionBarPresentation.createToolBarContributionItem(this.coolItemToolBarMgr, this.type);
                    iCoolBarManager.prependToGroup("group.editor", (IContributionItem)this.toolBarContributionItem);
                }
            } else {
                this.coolItemToolBarMgr = this.actionBarPresentation.createToolBarManager();
                if (iCoolBarManager instanceof ContributionManager && iContributionItem instanceof PlaceholderContributionItem) {
                    PlaceholderContributionItem placeholderContributionItem = (PlaceholderContributionItem)iContributionItem;
                    this.toolBarContributionItem = this.createToolBarContributionItem(this.coolItemToolBarMgr, placeholderContributionItem);
                    ((ContributionManager)iCoolBarManager).replaceItem(this.type, (IContributionItem)this.toolBarContributionItem);
                } else {
                    this.toolBarContributionItem = this.actionBarPresentation.createToolBarContributionItem(this.coolItemToolBarMgr, this.type);
                    iCoolBarManager.prependToGroup("group.editor", (IContributionItem)this.toolBarContributionItem);
                }
            }
            ((ContributionManager)this.coolItemToolBarMgr).setOverrides((IContributionManagerOverrides)new Overrides());
            this.toolBarContributionItem.setVisible(this.getActive());
            this.coolItemToolBarMgr.markDirty();
        }
        return this.coolItemToolBarMgr;
    }

    IToolBarContributionItem createToolBarContributionItem(IToolBarManager iToolBarManager, PlaceholderContributionItem placeholderContributionItem) {
        IToolBarContributionItem iToolBarContributionItem = this.actionBarPresentation.createToolBarContributionItem(iToolBarManager, placeholderContributionItem.getId());
        iToolBarContributionItem.setCurrentHeight(placeholderContributionItem.getHeight());
        iToolBarContributionItem.setCurrentWidth(placeholderContributionItem.getWidth());
        iToolBarContributionItem.setMinimumItemsToShow(placeholderContributionItem.getMinimumItemsToShow());
        iToolBarContributionItem.setUseChevron(placeholderContributionItem.getUseChevron());
        return iToolBarContributionItem;
    }

    private boolean isVisible() {
        if (this.toolBarContributionItem != null) {
            return this.toolBarContributionItem.isVisible();
        }
        return false;
    }

    @Override
    public void partChanged(IWorkbenchPart iWorkbenchPart) {
        super.partChanged(iWorkbenchPart);
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
            if (this.editorContributor != null) {
                this.editorContributor.setActiveEditor(iEditorPart);
            }
            if (this.extensionContributor != null) {
                this.extensionContributor.setActiveEditor(iEditorPart);
            }
        }
    }

    public void removeRef() {
        --this.refCount;
    }

    private void setActive(boolean bl, boolean bl2) {
        this.basicSetActive(bl);
        if (this.isSubMenuManagerCreated()) {
            ((EditorMenuManager)this.getMenuManager()).setVisible(bl, bl2);
        }
        if (this.isSubStatusLineManagerCreated()) {
            ((SubStatusLineManager)this.getStatusLineManager()).setVisible(bl);
        }
        this.setVisible(bl, bl2);
    }

    public void setEditorContributor(IEditorActionBarContributor iEditorActionBarContributor) {
        this.editorContributor = iEditorActionBarContributor;
    }

    private void setEnabledAllowed(boolean bl) {
        if (this.enabledAllowed == bl) {
            return;
        }
        this.enabledAllowed = bl;
        if (this.coolItemToolBarMgr != null) {
            IContributionItem[] iContributionItemArray = this.coolItemToolBarMgr.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n];
                iContributionItem.update("enabled");
                ++n;
            }
        }
    }

    public void setExtensionContributor(IEditorActionBarContributor iEditorActionBarContributor) {
        this.extensionContributor = iEditorActionBarContributor;
    }

    private void setVisible(boolean bl) {
        if (this.toolBarContributionItem != null) {
            this.toolBarContributionItem.setVisible(bl);
            if (this.toolBarContributionItem.getParent() != null) {
                this.toolBarContributionItem.getParent().markDirty();
            }
        }
    }

    private void setVisible(boolean bl, boolean bl2) {
        if (bl) {
            this.setEnabledAllowed(true);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (bl2) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
        ICoolBarManager iCoolBarManager = this.getCastedParent().getCoolBarManager();
        if (this.coolItemToolBarMgr != null && iCoolBarManager != null) {
            IContributionItem[] iContributionItemArray = this.coolItemToolBarMgr.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n];
                iContributionItem.setVisible(bl || !bl2);
                this.coolItemToolBarMgr.markDirty();
                if (!iCoolBarManager.isDirty()) {
                    iCoolBarManager.markDirty();
                }
                ++n;
            }
            this.coolItemToolBarMgr.update(false);
            if (this.toolBarContributionItem != null) {
                this.toolBarContributionItem.setVisible(bl || !bl2);
            }
            if (this.getCoolBarManager() != null) {
                ((SubCoolBarManager)this.getCoolBarManager()).setVisible(bl || !bl2);
            }
        }
    }

    public Expression getHandlerExpression() {
        if (this.editorHandlerExpression == null) {
            this.editorHandlerExpression = new LegacyEditorActionBarExpression(this.type);
        }
        return this.editorHandlerExpression;
    }

    private class Overrides
    implements IContributionManagerOverrides {
        private Overrides() {
        }

        public Integer getAccelerator(IContributionItem iContributionItem) {
            return null;
        }

        public String getAcceleratorText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getEnabled(IContributionItem iContributionItem) {
            if (iContributionItem instanceof ActionContributionItem && ((ActionContributionItem)iContributionItem).getAction() instanceof RetargetAction || EditorActionBars.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public String getText(IContributionItem iContributionItem) {
            return null;
        }

        public Boolean getVisible(IContributionItem iContributionItem) {
            return null;
        }
    }
}

