/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;

public class EarlyStartupRunnable
extends SafeRunnable {
    private static final String EXTENSION_CLASS = "org.eclipse.core.runtime.IExtension";
    private static final String GET_PLUGIN_METHOD = "getPlugin";
    private static final String GET_DESC_METHOD = "getDeclaringPluginDescriptor";
    private static final String PI_RUNTIME_COMPATIBILITY = "org.eclipse.core.runtime.compatibility";
    private IExtension extension;

    public EarlyStartupRunnable(IExtension iExtension) {
        this.extension = iExtension;
    }

    public void run() throws Exception {
        IConfigurationElement[] iConfigurationElementArray = this.extension.getConfigurationElements();
        boolean bl = false;
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement != null && iConfigurationElement.getName().equals("startup")) {
                this.runEarlyStartup(this.getExecutableExtension(iConfigurationElement));
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.runEarlyStartup(this.getPluginForCompatibility());
        }
    }

    public void handleException(Throwable throwable) {
        Status status = new Status(4, this.extension.getNamespace(), 0, "Unable to execute early startup code for an extension", throwable);
        WorkbenchPlugin.log("Unhandled Exception", (IStatus)status);
    }

    private void runEarlyStartup(Object object) {
        if (object != null && object instanceof IStartup) {
            ((IStartup)object).earlyStartup();
        } else {
            Status status = new Status(4, this.extension.getNamespace(), 0, "startup class must implement org.eclipse.ui.IStartup", null);
            WorkbenchPlugin.log("Bad extension specification", (IStatus)status);
        }
    }

    private Object getExecutableExtension(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute("class");
        if (string == null || string.length() <= 0) {
            return this.getPluginForCompatibility();
        }
        return WorkbenchPlugin.createExtension(iConfigurationElement, "class");
    }

    private Object getPluginForCompatibility() {
        Object object;
        block7: {
            Bundle bundle = Platform.getBundle((String)PI_RUNTIME_COMPATIBILITY);
            if (bundle == null) {
                return null;
            }
            Class clazz = bundle.loadClass(EXTENSION_CLASS);
            Method method = clazz.getDeclaredMethod(GET_DESC_METHOD, new Class[0]);
            object = method.invoke((Object)this.extension, new Object[0]);
            if (object != null) break block7;
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod(GET_PLUGIN_METHOD, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.handleException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.handleException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.handleException(noSuchMethodException);
        }
        return null;
    }
}

