/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DragHandle
extends Composite
implements PaintListener {
    Cursor dragCursor;
    Image handleImage;
    ImageDescriptor descriptor;
    private boolean isHorizontal;
    private static int margin = 2;

    public DragHandle(Composite composite) {
        super(composite, 0);
        this.dragCursor = new Cursor((Device)composite.getDisplay(), 5);
        this.addPaintListener(this);
        this.descriptor = AbstractUIPlugin.imageDescriptorFromPlugin(WorkbenchPlugin.PI_WORKBENCH, "icons/misc/handle.gif");
        this.handleImage = new Image((Device)composite.getDisplay(), 4, 4);
        GC gC = new GC((Drawable)this.handleImage);
        gC.setForeground(composite.getDisplay().getSystemColor(22));
        gC.drawPoint(0, 0);
        gC.drawPoint(2, 0);
        gC.drawPoint(3, 0);
        gC.drawPoint(3, 1);
        gC.drawPoint(0, 2);
        gC.drawPoint(3, 2);
        gC.drawPoint(0, 3);
        gC.drawPoint(1, 3);
        gC.drawPoint(2, 3);
        gC.drawPoint(3, 3);
        gC.setForeground(composite.getDisplay().getSystemColor(18));
        gC.drawPoint(1, 0);
        gC.drawPoint(0, 1);
        gC.setForeground(composite.getDisplay().getSystemColor(17));
        gC.drawPoint(1, 1);
        gC.setForeground(composite.getDisplay().getSystemColor(20));
        gC.drawPoint(1, 2);
        gC.drawPoint(2, 1);
        gC.drawPoint(2, 2);
        gC.dispose();
        this.setCursor(this.dragCursor);
    }

    public void paintControl(PaintEvent paintEvent) {
        Point point = this.getSize();
        if (this.handleImage != null) {
            Rectangle rectangle = this.handleImage.getBounds();
            int n = (point.x - 2 * margin) % rectangle.width / 2 + margin;
            int n2 = (point.y - 2 * margin) % rectangle.height / 2 + margin;
            do {
                paintEvent.gc.drawImage(this.handleImage, n, n2);
            } while (!(this.isHorizontal ? (n += rectangle.width) + rectangle.width > point.x - margin : (n2 += rectangle.height) + rectangle.height > point.y - margin));
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = new Point(n, n2);
        Rectangle rectangle = this.handleImage.getBounds();
        if (n == -1) {
            point.x = rectangle.width + 2 * margin;
        }
        if (n2 == -1) {
            point.y = rectangle.height + 2 * margin;
        }
        return point;
    }

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        super.dispose();
        this.dragCursor.dispose();
        this.handleImage.dispose();
        JFaceResources.getResources().destroyImage(this.descriptor);
    }
}

